// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"net/http"

	v1 "github.com/loft-sh/api/v4/pkg/apis/storage/v1"
	"github.com/loft-sh/api/v4/pkg/clientset/versioned/scheme"
	rest "k8s.io/client-go/rest"
)

type StorageV1Interface interface {
	RESTClient() rest.Interface
	AccessKeysGetter
	AppsGetter
	ClustersGetter
	ClusterAccessesGetter
	ClusterRoleTemplatesGetter
	DevPodWorkspaceInstancesGetter
	DevPodWorkspaceTemplatesGetter
	NetworkPeersGetter
	ProjectsGetter
	RunnersGetter
	SharedSecretsGetter
	SpaceInstancesGetter
	SpaceTemplatesGetter
	TasksGetter
	TeamsGetter
	UsersGetter
	VirtualClusterInstancesGetter
	VirtualClusterTemplatesGetter
}

// StorageV1Client is used to interact with features provided by the storage.loft.sh group.
type StorageV1Client struct {
	restClient rest.Interface
}

func (c *StorageV1Client) AccessKeys() AccessKeyInterface {
	return newAccessKeys(c)
}

func (c *StorageV1Client) Apps() AppInterface {
	return newApps(c)
}

func (c *StorageV1Client) Clusters() ClusterInterface {
	return newClusters(c)
}

func (c *StorageV1Client) ClusterAccesses() ClusterAccessInterface {
	return newClusterAccesses(c)
}

func (c *StorageV1Client) ClusterRoleTemplates() ClusterRoleTemplateInterface {
	return newClusterRoleTemplates(c)
}

func (c *StorageV1Client) DevPodWorkspaceInstances(namespace string) DevPodWorkspaceInstanceInterface {
	return newDevPodWorkspaceInstances(c, namespace)
}

func (c *StorageV1Client) DevPodWorkspaceTemplates() DevPodWorkspaceTemplateInterface {
	return newDevPodWorkspaceTemplates(c)
}

func (c *StorageV1Client) NetworkPeers() NetworkPeerInterface {
	return newNetworkPeers(c)
}

func (c *StorageV1Client) Projects() ProjectInterface {
	return newProjects(c)
}

func (c *StorageV1Client) Runners() RunnerInterface {
	return newRunners(c)
}

func (c *StorageV1Client) SharedSecrets(namespace string) SharedSecretInterface {
	return newSharedSecrets(c, namespace)
}

func (c *StorageV1Client) SpaceInstances(namespace string) SpaceInstanceInterface {
	return newSpaceInstances(c, namespace)
}

func (c *StorageV1Client) SpaceTemplates() SpaceTemplateInterface {
	return newSpaceTemplates(c)
}

func (c *StorageV1Client) Tasks() TaskInterface {
	return newTasks(c)
}

func (c *StorageV1Client) Teams() TeamInterface {
	return newTeams(c)
}

func (c *StorageV1Client) Users() UserInterface {
	return newUsers(c)
}

func (c *StorageV1Client) VirtualClusterInstances(namespace string) VirtualClusterInstanceInterface {
	return newVirtualClusterInstances(c, namespace)
}

func (c *StorageV1Client) VirtualClusterTemplates() VirtualClusterTemplateInterface {
	return newVirtualClusterTemplates(c)
}

// NewForConfig creates a new StorageV1Client for the given config.
// NewForConfig is equivalent to NewForConfigAndClient(c, httpClient),
// where httpClient was generated with rest.HTTPClientFor(c).
func NewForConfig(c *rest.Config) (*StorageV1Client, error) {
	config := *c
	if err := setConfigDefaults(&config); err != nil {
		return nil, err
	}
	httpClient, err := rest.HTTPClientFor(&config)
	if err != nil {
		return nil, err
	}
	return NewForConfigAndClient(&config, httpClient)
}

// NewForConfigAndClient creates a new StorageV1Client for the given config and http client.
// Note the http client provided takes precedence over the configured transport values.
func NewForConfigAndClient(c *rest.Config, h *http.Client) (*StorageV1Client, error) {
	config := *c
	if err := setConfigDefaults(&config); err != nil {
		return nil, err
	}
	client, err := rest.RESTClientForConfigAndClient(&config, h)
	if err != nil {
		return nil, err
	}
	return &StorageV1Client{client}, nil
}

// NewForConfigOrDie creates a new StorageV1Client for the given config and
// panics if there is an error in the config.
func NewForConfigOrDie(c *rest.Config) *StorageV1Client {
	client, err := NewForConfig(c)
	if err != nil {
		panic(err)
	}
	return client
}

// New creates a new StorageV1Client for the given RESTClient.
func New(c rest.Interface) *StorageV1Client {
	return &StorageV1Client{c}
}

func setConfigDefaults(config *rest.Config) error {
	gv := v1.SchemeGroupVersion
	config.GroupVersion = &gv
	config.APIPath = "/apis"
	config.NegotiatedSerializer = scheme.Codecs.WithoutConversion()

	if config.UserAgent == "" {
		config.UserAgent = rest.DefaultKubernetesUserAgent()
	}

	return nil
}

// RESTClient returns a RESTClient that is used to communicate
// with API server by this client implementation.
func (c *StorageV1Client) RESTClient() rest.Interface {
	if c == nil {
		return nil
	}
	return c.restClient
}
