// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"
	"time"

	v1 "github.com/loft-sh/api/v4/pkg/apis/storage/v1"
	scheme "github.com/loft-sh/api/v4/pkg/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// RunnersGetter has a method to return a RunnerInterface.
// A group's client should implement this interface.
type RunnersGetter interface {
	Runners() RunnerInterface
}

// RunnerInterface has methods to work with Runner resources.
type RunnerInterface interface {
	Create(ctx context.Context, runner *v1.Runner, opts metav1.CreateOptions) (*v1.Runner, error)
	Update(ctx context.Context, runner *v1.Runner, opts metav1.UpdateOptions) (*v1.Runner, error)
	UpdateStatus(ctx context.Context, runner *v1.Runner, opts metav1.UpdateOptions) (*v1.Runner, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.Runner, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.RunnerList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.Runner, err error)
	RunnerExpansion
}

// runners implements RunnerInterface
type runners struct {
	client rest.Interface
}

// newRunners returns a Runners
func newRunners(c *StorageV1Client) *runners {
	return &runners{
		client: c.RESTClient(),
	}
}

// Get takes name of the runner, and returns the corresponding runner object, and an error if there is any.
func (c *runners) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.Runner, err error) {
	result = &v1.Runner{}
	err = c.client.Get().
		Resource("runners").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of Runners that match those selectors.
func (c *runners) List(ctx context.Context, opts metav1.ListOptions) (result *v1.RunnerList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.RunnerList{}
	err = c.client.Get().
		Resource("runners").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested runners.
func (c *runners) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("runners").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a runner and creates it.  Returns the server's representation of the runner, and an error, if there is any.
func (c *runners) Create(ctx context.Context, runner *v1.Runner, opts metav1.CreateOptions) (result *v1.Runner, err error) {
	result = &v1.Runner{}
	err = c.client.Post().
		Resource("runners").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(runner).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a runner and updates it. Returns the server's representation of the runner, and an error, if there is any.
func (c *runners) Update(ctx context.Context, runner *v1.Runner, opts metav1.UpdateOptions) (result *v1.Runner, err error) {
	result = &v1.Runner{}
	err = c.client.Put().
		Resource("runners").
		Name(runner.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(runner).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *runners) UpdateStatus(ctx context.Context, runner *v1.Runner, opts metav1.UpdateOptions) (result *v1.Runner, err error) {
	result = &v1.Runner{}
	err = c.client.Put().
		Resource("runners").
		Name(runner.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(runner).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the runner and deletes it. Returns an error if one occurs.
func (c *runners) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return c.client.Delete().
		Resource("runners").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *runners) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("runners").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched runner.
func (c *runners) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.Runner, err error) {
	result = &v1.Runner{}
	err = c.client.Patch(pt).
		Resource("runners").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
