// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"
	"time"

	v1 "github.com/loft-sh/api/v4/pkg/apis/storage/v1"
	scheme "github.com/loft-sh/api/v4/pkg/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// NetworkPeersGetter has a method to return a NetworkPeerInterface.
// A group's client should implement this interface.
type NetworkPeersGetter interface {
	NetworkPeers() NetworkPeerInterface
}

// NetworkPeerInterface has methods to work with NetworkPeer resources.
type NetworkPeerInterface interface {
	Create(ctx context.Context, networkPeer *v1.NetworkPeer, opts metav1.CreateOptions) (*v1.NetworkPeer, error)
	Update(ctx context.Context, networkPeer *v1.NetworkPeer, opts metav1.UpdateOptions) (*v1.NetworkPeer, error)
	UpdateStatus(ctx context.Context, networkPeer *v1.NetworkPeer, opts metav1.UpdateOptions) (*v1.NetworkPeer, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.NetworkPeer, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.NetworkPeerList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.NetworkPeer, err error)
	NetworkPeerExpansion
}

// networkPeers implements NetworkPeerInterface
type networkPeers struct {
	client rest.Interface
}

// newNetworkPeers returns a NetworkPeers
func newNetworkPeers(c *StorageV1Client) *networkPeers {
	return &networkPeers{
		client: c.RESTClient(),
	}
}

// Get takes name of the networkPeer, and returns the corresponding networkPeer object, and an error if there is any.
func (c *networkPeers) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.NetworkPeer, err error) {
	result = &v1.NetworkPeer{}
	err = c.client.Get().
		Resource("networkpeers").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of NetworkPeers that match those selectors.
func (c *networkPeers) List(ctx context.Context, opts metav1.ListOptions) (result *v1.NetworkPeerList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.NetworkPeerList{}
	err = c.client.Get().
		Resource("networkpeers").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested networkPeers.
func (c *networkPeers) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("networkpeers").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a networkPeer and creates it.  Returns the server's representation of the networkPeer, and an error, if there is any.
func (c *networkPeers) Create(ctx context.Context, networkPeer *v1.NetworkPeer, opts metav1.CreateOptions) (result *v1.NetworkPeer, err error) {
	result = &v1.NetworkPeer{}
	err = c.client.Post().
		Resource("networkpeers").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(networkPeer).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a networkPeer and updates it. Returns the server's representation of the networkPeer, and an error, if there is any.
func (c *networkPeers) Update(ctx context.Context, networkPeer *v1.NetworkPeer, opts metav1.UpdateOptions) (result *v1.NetworkPeer, err error) {
	result = &v1.NetworkPeer{}
	err = c.client.Put().
		Resource("networkpeers").
		Name(networkPeer.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(networkPeer).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *networkPeers) UpdateStatus(ctx context.Context, networkPeer *v1.NetworkPeer, opts metav1.UpdateOptions) (result *v1.NetworkPeer, err error) {
	result = &v1.NetworkPeer{}
	err = c.client.Put().
		Resource("networkpeers").
		Name(networkPeer.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(networkPeer).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the networkPeer and deletes it. Returns an error if one occurs.
func (c *networkPeers) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return c.client.Delete().
		Resource("networkpeers").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *networkPeers) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("networkpeers").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched networkPeer.
func (c *networkPeers) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.NetworkPeer, err error) {
	result = &v1.NetworkPeer{}
	err = c.client.Patch(pt).
		Resource("networkpeers").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
