// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"
	"time"

	v1 "github.com/loft-sh/api/v4/pkg/apis/storage/v1"
	scheme "github.com/loft-sh/api/v4/pkg/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// AccessKeysGetter has a method to return a AccessKeyInterface.
// A group's client should implement this interface.
type AccessKeysGetter interface {
	AccessKeys() AccessKeyInterface
}

// AccessKeyInterface has methods to work with AccessKey resources.
type AccessKeyInterface interface {
	Create(ctx context.Context, accessKey *v1.AccessKey, opts metav1.CreateOptions) (*v1.AccessKey, error)
	Update(ctx context.Context, accessKey *v1.AccessKey, opts metav1.UpdateOptions) (*v1.AccessKey, error)
	UpdateStatus(ctx context.Context, accessKey *v1.AccessKey, opts metav1.UpdateOptions) (*v1.AccessKey, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.AccessKey, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.AccessKeyList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.AccessKey, err error)
	AccessKeyExpansion
}

// accessKeys implements AccessKeyInterface
type accessKeys struct {
	client rest.Interface
}

// newAccessKeys returns a AccessKeys
func newAccessKeys(c *StorageV1Client) *accessKeys {
	return &accessKeys{
		client: c.RESTClient(),
	}
}

// Get takes name of the accessKey, and returns the corresponding accessKey object, and an error if there is any.
func (c *accessKeys) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.AccessKey, err error) {
	result = &v1.AccessKey{}
	err = c.client.Get().
		Resource("accesskeys").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of AccessKeys that match those selectors.
func (c *accessKeys) List(ctx context.Context, opts metav1.ListOptions) (result *v1.AccessKeyList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.AccessKeyList{}
	err = c.client.Get().
		Resource("accesskeys").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested accessKeys.
func (c *accessKeys) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("accesskeys").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a accessKey and creates it.  Returns the server's representation of the accessKey, and an error, if there is any.
func (c *accessKeys) Create(ctx context.Context, accessKey *v1.AccessKey, opts metav1.CreateOptions) (result *v1.AccessKey, err error) {
	result = &v1.AccessKey{}
	err = c.client.Post().
		Resource("accesskeys").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(accessKey).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a accessKey and updates it. Returns the server's representation of the accessKey, and an error, if there is any.
func (c *accessKeys) Update(ctx context.Context, accessKey *v1.AccessKey, opts metav1.UpdateOptions) (result *v1.AccessKey, err error) {
	result = &v1.AccessKey{}
	err = c.client.Put().
		Resource("accesskeys").
		Name(accessKey.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(accessKey).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *accessKeys) UpdateStatus(ctx context.Context, accessKey *v1.AccessKey, opts metav1.UpdateOptions) (result *v1.AccessKey, err error) {
	result = &v1.AccessKey{}
	err = c.client.Put().
		Resource("accesskeys").
		Name(accessKey.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(accessKey).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the accessKey and deletes it. Returns an error if one occurs.
func (c *accessKeys) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return c.client.Delete().
		Resource("accesskeys").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *accessKeys) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("accesskeys").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched accessKey.
func (c *accessKeys) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.AccessKey, err error) {
	result = &v1.AccessKey{}
	err = c.client.Patch(pt).
		Resource("accesskeys").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
