// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"
	"time"

	v1 "github.com/loft-sh/api/v4/pkg/apis/management/v1"
	scheme "github.com/loft-sh/api/v4/pkg/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// SubjectAccessReviewsGetter has a method to return a SubjectAccessReviewInterface.
// A group's client should implement this interface.
type SubjectAccessReviewsGetter interface {
	SubjectAccessReviews() SubjectAccessReviewInterface
}

// SubjectAccessReviewInterface has methods to work with SubjectAccessReview resources.
type SubjectAccessReviewInterface interface {
	Create(ctx context.Context, subjectAccessReview *v1.SubjectAccessReview, opts metav1.CreateOptions) (*v1.SubjectAccessReview, error)
	Update(ctx context.Context, subjectAccessReview *v1.SubjectAccessReview, opts metav1.UpdateOptions) (*v1.SubjectAccessReview, error)
	UpdateStatus(ctx context.Context, subjectAccessReview *v1.SubjectAccessReview, opts metav1.UpdateOptions) (*v1.SubjectAccessReview, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.SubjectAccessReview, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.SubjectAccessReviewList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.SubjectAccessReview, err error)
	SubjectAccessReviewExpansion
}

// subjectAccessReviews implements SubjectAccessReviewInterface
type subjectAccessReviews struct {
	client rest.Interface
}

// newSubjectAccessReviews returns a SubjectAccessReviews
func newSubjectAccessReviews(c *ManagementV1Client) *subjectAccessReviews {
	return &subjectAccessReviews{
		client: c.RESTClient(),
	}
}

// Get takes name of the subjectAccessReview, and returns the corresponding subjectAccessReview object, and an error if there is any.
func (c *subjectAccessReviews) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.SubjectAccessReview, err error) {
	result = &v1.SubjectAccessReview{}
	err = c.client.Get().
		Resource("subjectaccessreviews").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of SubjectAccessReviews that match those selectors.
func (c *subjectAccessReviews) List(ctx context.Context, opts metav1.ListOptions) (result *v1.SubjectAccessReviewList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.SubjectAccessReviewList{}
	err = c.client.Get().
		Resource("subjectaccessreviews").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested subjectAccessReviews.
func (c *subjectAccessReviews) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("subjectaccessreviews").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a subjectAccessReview and creates it.  Returns the server's representation of the subjectAccessReview, and an error, if there is any.
func (c *subjectAccessReviews) Create(ctx context.Context, subjectAccessReview *v1.SubjectAccessReview, opts metav1.CreateOptions) (result *v1.SubjectAccessReview, err error) {
	result = &v1.SubjectAccessReview{}
	err = c.client.Post().
		Resource("subjectaccessreviews").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(subjectAccessReview).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a subjectAccessReview and updates it. Returns the server's representation of the subjectAccessReview, and an error, if there is any.
func (c *subjectAccessReviews) Update(ctx context.Context, subjectAccessReview *v1.SubjectAccessReview, opts metav1.UpdateOptions) (result *v1.SubjectAccessReview, err error) {
	result = &v1.SubjectAccessReview{}
	err = c.client.Put().
		Resource("subjectaccessreviews").
		Name(subjectAccessReview.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(subjectAccessReview).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *subjectAccessReviews) UpdateStatus(ctx context.Context, subjectAccessReview *v1.SubjectAccessReview, opts metav1.UpdateOptions) (result *v1.SubjectAccessReview, err error) {
	result = &v1.SubjectAccessReview{}
	err = c.client.Put().
		Resource("subjectaccessreviews").
		Name(subjectAccessReview.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(subjectAccessReview).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the subjectAccessReview and deletes it. Returns an error if one occurs.
func (c *subjectAccessReviews) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return c.client.Delete().
		Resource("subjectaccessreviews").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *subjectAccessReviews) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("subjectaccessreviews").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched subjectAccessReview.
func (c *subjectAccessReviews) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.SubjectAccessReview, err error) {
	result = &v1.SubjectAccessReview{}
	err = c.client.Patch(pt).
		Resource("subjectaccessreviews").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
