// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"
	"time"

	v1 "github.com/loft-sh/api/v4/pkg/apis/management/v1"
	scheme "github.com/loft-sh/api/v4/pkg/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// ResetAccessKeysGetter has a method to return a ResetAccessKeyInterface.
// A group's client should implement this interface.
type ResetAccessKeysGetter interface {
	ResetAccessKeys() ResetAccessKeyInterface
}

// ResetAccessKeyInterface has methods to work with ResetAccessKey resources.
type ResetAccessKeyInterface interface {
	Create(ctx context.Context, resetAccessKey *v1.ResetAccessKey, opts metav1.CreateOptions) (*v1.ResetAccessKey, error)
	Update(ctx context.Context, resetAccessKey *v1.ResetAccessKey, opts metav1.UpdateOptions) (*v1.ResetAccessKey, error)
	UpdateStatus(ctx context.Context, resetAccessKey *v1.ResetAccessKey, opts metav1.UpdateOptions) (*v1.ResetAccessKey, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.ResetAccessKey, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.ResetAccessKeyList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.ResetAccessKey, err error)
	ResetAccessKeyExpansion
}

// resetAccessKeys implements ResetAccessKeyInterface
type resetAccessKeys struct {
	client rest.Interface
}

// newResetAccessKeys returns a ResetAccessKeys
func newResetAccessKeys(c *ManagementV1Client) *resetAccessKeys {
	return &resetAccessKeys{
		client: c.RESTClient(),
	}
}

// Get takes name of the resetAccessKey, and returns the corresponding resetAccessKey object, and an error if there is any.
func (c *resetAccessKeys) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.ResetAccessKey, err error) {
	result = &v1.ResetAccessKey{}
	err = c.client.Get().
		Resource("resetaccesskeys").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of ResetAccessKeys that match those selectors.
func (c *resetAccessKeys) List(ctx context.Context, opts metav1.ListOptions) (result *v1.ResetAccessKeyList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.ResetAccessKeyList{}
	err = c.client.Get().
		Resource("resetaccesskeys").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested resetAccessKeys.
func (c *resetAccessKeys) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("resetaccesskeys").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a resetAccessKey and creates it.  Returns the server's representation of the resetAccessKey, and an error, if there is any.
func (c *resetAccessKeys) Create(ctx context.Context, resetAccessKey *v1.ResetAccessKey, opts metav1.CreateOptions) (result *v1.ResetAccessKey, err error) {
	result = &v1.ResetAccessKey{}
	err = c.client.Post().
		Resource("resetaccesskeys").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(resetAccessKey).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a resetAccessKey and updates it. Returns the server's representation of the resetAccessKey, and an error, if there is any.
func (c *resetAccessKeys) Update(ctx context.Context, resetAccessKey *v1.ResetAccessKey, opts metav1.UpdateOptions) (result *v1.ResetAccessKey, err error) {
	result = &v1.ResetAccessKey{}
	err = c.client.Put().
		Resource("resetaccesskeys").
		Name(resetAccessKey.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(resetAccessKey).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *resetAccessKeys) UpdateStatus(ctx context.Context, resetAccessKey *v1.ResetAccessKey, opts metav1.UpdateOptions) (result *v1.ResetAccessKey, err error) {
	result = &v1.ResetAccessKey{}
	err = c.client.Put().
		Resource("resetaccesskeys").
		Name(resetAccessKey.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(resetAccessKey).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the resetAccessKey and deletes it. Returns an error if one occurs.
func (c *resetAccessKeys) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return c.client.Delete().
		Resource("resetaccesskeys").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *resetAccessKeys) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("resetaccesskeys").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched resetAccessKey.
func (c *resetAccessKeys) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.ResetAccessKey, err error) {
	result = &v1.ResetAccessKey{}
	err = c.client.Patch(pt).
		Resource("resetaccesskeys").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
