// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"
	"time"

	v1 "github.com/loft-sh/api/v4/pkg/apis/management/v1"
	scheme "github.com/loft-sh/api/v4/pkg/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// RedirectTokensGetter has a method to return a RedirectTokenInterface.
// A group's client should implement this interface.
type RedirectTokensGetter interface {
	RedirectTokens() RedirectTokenInterface
}

// RedirectTokenInterface has methods to work with RedirectToken resources.
type RedirectTokenInterface interface {
	Create(ctx context.Context, redirectToken *v1.RedirectToken, opts metav1.CreateOptions) (*v1.RedirectToken, error)
	Update(ctx context.Context, redirectToken *v1.RedirectToken, opts metav1.UpdateOptions) (*v1.RedirectToken, error)
	UpdateStatus(ctx context.Context, redirectToken *v1.RedirectToken, opts metav1.UpdateOptions) (*v1.RedirectToken, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.RedirectToken, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.RedirectTokenList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.RedirectToken, err error)
	RedirectTokenExpansion
}

// redirectTokens implements RedirectTokenInterface
type redirectTokens struct {
	client rest.Interface
}

// newRedirectTokens returns a RedirectTokens
func newRedirectTokens(c *ManagementV1Client) *redirectTokens {
	return &redirectTokens{
		client: c.RESTClient(),
	}
}

// Get takes name of the redirectToken, and returns the corresponding redirectToken object, and an error if there is any.
func (c *redirectTokens) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.RedirectToken, err error) {
	result = &v1.RedirectToken{}
	err = c.client.Get().
		Resource("redirecttokens").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of RedirectTokens that match those selectors.
func (c *redirectTokens) List(ctx context.Context, opts metav1.ListOptions) (result *v1.RedirectTokenList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.RedirectTokenList{}
	err = c.client.Get().
		Resource("redirecttokens").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested redirectTokens.
func (c *redirectTokens) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("redirecttokens").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a redirectToken and creates it.  Returns the server's representation of the redirectToken, and an error, if there is any.
func (c *redirectTokens) Create(ctx context.Context, redirectToken *v1.RedirectToken, opts metav1.CreateOptions) (result *v1.RedirectToken, err error) {
	result = &v1.RedirectToken{}
	err = c.client.Post().
		Resource("redirecttokens").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(redirectToken).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a redirectToken and updates it. Returns the server's representation of the redirectToken, and an error, if there is any.
func (c *redirectTokens) Update(ctx context.Context, redirectToken *v1.RedirectToken, opts metav1.UpdateOptions) (result *v1.RedirectToken, err error) {
	result = &v1.RedirectToken{}
	err = c.client.Put().
		Resource("redirecttokens").
		Name(redirectToken.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(redirectToken).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *redirectTokens) UpdateStatus(ctx context.Context, redirectToken *v1.RedirectToken, opts metav1.UpdateOptions) (result *v1.RedirectToken, err error) {
	result = &v1.RedirectToken{}
	err = c.client.Put().
		Resource("redirecttokens").
		Name(redirectToken.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(redirectToken).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the redirectToken and deletes it. Returns an error if one occurs.
func (c *redirectTokens) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return c.client.Delete().
		Resource("redirecttokens").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *redirectTokens) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("redirecttokens").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched redirectToken.
func (c *redirectTokens) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.RedirectToken, err error) {
	result = &v1.RedirectToken{}
	err = c.client.Patch(pt).
		Resource("redirecttokens").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
