// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"
	"time"

	v1 "github.com/loft-sh/api/v4/pkg/apis/management/v1"
	scheme "github.com/loft-sh/api/v4/pkg/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// ProjectSecretsGetter has a method to return a ProjectSecretInterface.
// A group's client should implement this interface.
type ProjectSecretsGetter interface {
	ProjectSecrets(namespace string) ProjectSecretInterface
}

// ProjectSecretInterface has methods to work with ProjectSecret resources.
type ProjectSecretInterface interface {
	Create(ctx context.Context, projectSecret *v1.ProjectSecret, opts metav1.CreateOptions) (*v1.ProjectSecret, error)
	Update(ctx context.Context, projectSecret *v1.ProjectSecret, opts metav1.UpdateOptions) (*v1.ProjectSecret, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.ProjectSecret, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.ProjectSecretList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.ProjectSecret, err error)
	ProjectSecretExpansion
}

// projectSecrets implements ProjectSecretInterface
type projectSecrets struct {
	client rest.Interface
	ns     string
}

// newProjectSecrets returns a ProjectSecrets
func newProjectSecrets(c *ManagementV1Client, namespace string) *projectSecrets {
	return &projectSecrets{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the projectSecret, and returns the corresponding projectSecret object, and an error if there is any.
func (c *projectSecrets) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.ProjectSecret, err error) {
	result = &v1.ProjectSecret{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("projectsecrets").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of ProjectSecrets that match those selectors.
func (c *projectSecrets) List(ctx context.Context, opts metav1.ListOptions) (result *v1.ProjectSecretList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.ProjectSecretList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("projectsecrets").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested projectSecrets.
func (c *projectSecrets) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("projectsecrets").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a projectSecret and creates it.  Returns the server's representation of the projectSecret, and an error, if there is any.
func (c *projectSecrets) Create(ctx context.Context, projectSecret *v1.ProjectSecret, opts metav1.CreateOptions) (result *v1.ProjectSecret, err error) {
	result = &v1.ProjectSecret{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("projectsecrets").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(projectSecret).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a projectSecret and updates it. Returns the server's representation of the projectSecret, and an error, if there is any.
func (c *projectSecrets) Update(ctx context.Context, projectSecret *v1.ProjectSecret, opts metav1.UpdateOptions) (result *v1.ProjectSecret, err error) {
	result = &v1.ProjectSecret{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("projectsecrets").
		Name(projectSecret.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(projectSecret).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the projectSecret and deletes it. Returns an error if one occurs.
func (c *projectSecrets) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("projectsecrets").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *projectSecrets) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("projectsecrets").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched projectSecret.
func (c *projectSecrets) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.ProjectSecret, err error) {
	result = &v1.ProjectSecret{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("projectsecrets").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
