// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"
	"time"

	v1 "github.com/loft-sh/api/v4/pkg/apis/management/v1"
	scheme "github.com/loft-sh/api/v4/pkg/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// ProjectsGetter has a method to return a ProjectInterface.
// A group's client should implement this interface.
type ProjectsGetter interface {
	Projects() ProjectInterface
}

// ProjectInterface has methods to work with Project resources.
type ProjectInterface interface {
	Create(ctx context.Context, project *v1.Project, opts metav1.CreateOptions) (*v1.Project, error)
	Update(ctx context.Context, project *v1.Project, opts metav1.UpdateOptions) (*v1.Project, error)
	UpdateStatus(ctx context.Context, project *v1.Project, opts metav1.UpdateOptions) (*v1.Project, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.Project, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.ProjectList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.Project, err error)
	ListMembers(ctx context.Context, projectName string, options metav1.GetOptions) (*v1.ProjectMembers, error)
	ListTemplates(ctx context.Context, projectName string, options metav1.GetOptions) (*v1.ProjectTemplates, error)
	ListClusters(ctx context.Context, projectName string, options metav1.GetOptions) (*v1.ProjectClusters, error)
	MigrateVirtualClusterInstance(ctx context.Context, projectName string, projectMigrateVirtualClusterInstance *v1.ProjectMigrateVirtualClusterInstance, opts metav1.CreateOptions) (*v1.ProjectMigrateVirtualClusterInstance, error)
	ImportSpace(ctx context.Context, projectName string, projectImportSpace *v1.ProjectImportSpace, opts metav1.CreateOptions) (*v1.ProjectImportSpace, error)
	MigrateSpaceInstance(ctx context.Context, projectName string, projectMigrateSpaceInstance *v1.ProjectMigrateSpaceInstance, opts metav1.CreateOptions) (*v1.ProjectMigrateSpaceInstance, error)

	ProjectExpansion
}

// projects implements ProjectInterface
type projects struct {
	client rest.Interface
}

// newProjects returns a Projects
func newProjects(c *ManagementV1Client) *projects {
	return &projects{
		client: c.RESTClient(),
	}
}

// Get takes name of the project, and returns the corresponding project object, and an error if there is any.
func (c *projects) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.Project, err error) {
	result = &v1.Project{}
	err = c.client.Get().
		Resource("projects").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of Projects that match those selectors.
func (c *projects) List(ctx context.Context, opts metav1.ListOptions) (result *v1.ProjectList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.ProjectList{}
	err = c.client.Get().
		Resource("projects").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested projects.
func (c *projects) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("projects").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a project and creates it.  Returns the server's representation of the project, and an error, if there is any.
func (c *projects) Create(ctx context.Context, project *v1.Project, opts metav1.CreateOptions) (result *v1.Project, err error) {
	result = &v1.Project{}
	err = c.client.Post().
		Resource("projects").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(project).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a project and updates it. Returns the server's representation of the project, and an error, if there is any.
func (c *projects) Update(ctx context.Context, project *v1.Project, opts metav1.UpdateOptions) (result *v1.Project, err error) {
	result = &v1.Project{}
	err = c.client.Put().
		Resource("projects").
		Name(project.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(project).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *projects) UpdateStatus(ctx context.Context, project *v1.Project, opts metav1.UpdateOptions) (result *v1.Project, err error) {
	result = &v1.Project{}
	err = c.client.Put().
		Resource("projects").
		Name(project.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(project).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the project and deletes it. Returns an error if one occurs.
func (c *projects) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return c.client.Delete().
		Resource("projects").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *projects) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("projects").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched project.
func (c *projects) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.Project, err error) {
	result = &v1.Project{}
	err = c.client.Patch(pt).
		Resource("projects").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}

// ListMembers takes name of the project, and returns the corresponding v1.ProjectMembers object, and an error if there is any.
func (c *projects) ListMembers(ctx context.Context, projectName string, options metav1.GetOptions) (result *v1.ProjectMembers, err error) {
	result = &v1.ProjectMembers{}
	err = c.client.Get().
		Resource("projects").
		Name(projectName).
		SubResource("members").
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// ListTemplates takes name of the project, and returns the corresponding v1.ProjectTemplates object, and an error if there is any.
func (c *projects) ListTemplates(ctx context.Context, projectName string, options metav1.GetOptions) (result *v1.ProjectTemplates, err error) {
	result = &v1.ProjectTemplates{}
	err = c.client.Get().
		Resource("projects").
		Name(projectName).
		SubResource("templates").
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// ListClusters takes name of the project, and returns the corresponding v1.ProjectClusters object, and an error if there is any.
func (c *projects) ListClusters(ctx context.Context, projectName string, options metav1.GetOptions) (result *v1.ProjectClusters, err error) {
	result = &v1.ProjectClusters{}
	err = c.client.Get().
		Resource("projects").
		Name(projectName).
		SubResource("clusters").
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// MigrateVirtualClusterInstance takes the representation of a projectMigrateVirtualClusterInstance and creates it.  Returns the server's representation of the projectMigrateVirtualClusterInstance, and an error, if there is any.
func (c *projects) MigrateVirtualClusterInstance(ctx context.Context, projectName string, projectMigrateVirtualClusterInstance *v1.ProjectMigrateVirtualClusterInstance, opts metav1.CreateOptions) (result *v1.ProjectMigrateVirtualClusterInstance, err error) {
	result = &v1.ProjectMigrateVirtualClusterInstance{}
	err = c.client.Post().
		Resource("projects").
		Name(projectName).
		SubResource("migratevirtualclusterinstance").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(projectMigrateVirtualClusterInstance).
		Do(ctx).
		Into(result)
	return
}

// ImportSpace takes the representation of a projectImportSpace and creates it.  Returns the server's representation of the projectImportSpace, and an error, if there is any.
func (c *projects) ImportSpace(ctx context.Context, projectName string, projectImportSpace *v1.ProjectImportSpace, opts metav1.CreateOptions) (result *v1.ProjectImportSpace, err error) {
	result = &v1.ProjectImportSpace{}
	err = c.client.Post().
		Resource("projects").
		Name(projectName).
		SubResource("importspace").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(projectImportSpace).
		Do(ctx).
		Into(result)
	return
}

// MigrateSpaceInstance takes the representation of a projectMigrateSpaceInstance and creates it.  Returns the server's representation of the projectMigrateSpaceInstance, and an error, if there is any.
func (c *projects) MigrateSpaceInstance(ctx context.Context, projectName string, projectMigrateSpaceInstance *v1.ProjectMigrateSpaceInstance, opts metav1.CreateOptions) (result *v1.ProjectMigrateSpaceInstance, err error) {
	result = &v1.ProjectMigrateSpaceInstance{}
	err = c.client.Post().
		Resource("projects").
		Name(projectName).
		SubResource("migratespaceinstance").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(projectMigrateSpaceInstance).
		Do(ctx).
		Into(result)
	return
}
