// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"
	"time"

	v1 "github.com/loft-sh/api/v4/pkg/apis/management/v1"
	scheme "github.com/loft-sh/api/v4/pkg/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// OwnedAccessKeysGetter has a method to return a OwnedAccessKeyInterface.
// A group's client should implement this interface.
type OwnedAccessKeysGetter interface {
	OwnedAccessKeys() OwnedAccessKeyInterface
}

// OwnedAccessKeyInterface has methods to work with OwnedAccessKey resources.
type OwnedAccessKeyInterface interface {
	Create(ctx context.Context, ownedAccessKey *v1.OwnedAccessKey, opts metav1.CreateOptions) (*v1.OwnedAccessKey, error)
	Update(ctx context.Context, ownedAccessKey *v1.OwnedAccessKey, opts metav1.UpdateOptions) (*v1.OwnedAccessKey, error)
	UpdateStatus(ctx context.Context, ownedAccessKey *v1.OwnedAccessKey, opts metav1.UpdateOptions) (*v1.OwnedAccessKey, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.OwnedAccessKey, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.OwnedAccessKeyList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.OwnedAccessKey, err error)
	OwnedAccessKeyExpansion
}

// ownedAccessKeys implements OwnedAccessKeyInterface
type ownedAccessKeys struct {
	client rest.Interface
}

// newOwnedAccessKeys returns a OwnedAccessKeys
func newOwnedAccessKeys(c *ManagementV1Client) *ownedAccessKeys {
	return &ownedAccessKeys{
		client: c.RESTClient(),
	}
}

// Get takes name of the ownedAccessKey, and returns the corresponding ownedAccessKey object, and an error if there is any.
func (c *ownedAccessKeys) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.OwnedAccessKey, err error) {
	result = &v1.OwnedAccessKey{}
	err = c.client.Get().
		Resource("ownedaccesskeys").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of OwnedAccessKeys that match those selectors.
func (c *ownedAccessKeys) List(ctx context.Context, opts metav1.ListOptions) (result *v1.OwnedAccessKeyList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.OwnedAccessKeyList{}
	err = c.client.Get().
		Resource("ownedaccesskeys").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested ownedAccessKeys.
func (c *ownedAccessKeys) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("ownedaccesskeys").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a ownedAccessKey and creates it.  Returns the server's representation of the ownedAccessKey, and an error, if there is any.
func (c *ownedAccessKeys) Create(ctx context.Context, ownedAccessKey *v1.OwnedAccessKey, opts metav1.CreateOptions) (result *v1.OwnedAccessKey, err error) {
	result = &v1.OwnedAccessKey{}
	err = c.client.Post().
		Resource("ownedaccesskeys").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(ownedAccessKey).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a ownedAccessKey and updates it. Returns the server's representation of the ownedAccessKey, and an error, if there is any.
func (c *ownedAccessKeys) Update(ctx context.Context, ownedAccessKey *v1.OwnedAccessKey, opts metav1.UpdateOptions) (result *v1.OwnedAccessKey, err error) {
	result = &v1.OwnedAccessKey{}
	err = c.client.Put().
		Resource("ownedaccesskeys").
		Name(ownedAccessKey.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(ownedAccessKey).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *ownedAccessKeys) UpdateStatus(ctx context.Context, ownedAccessKey *v1.OwnedAccessKey, opts metav1.UpdateOptions) (result *v1.OwnedAccessKey, err error) {
	result = &v1.OwnedAccessKey{}
	err = c.client.Put().
		Resource("ownedaccesskeys").
		Name(ownedAccessKey.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(ownedAccessKey).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the ownedAccessKey and deletes it. Returns an error if one occurs.
func (c *ownedAccessKeys) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return c.client.Delete().
		Resource("ownedaccesskeys").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *ownedAccessKeys) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("ownedaccesskeys").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched ownedAccessKey.
func (c *ownedAccessKeys) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.OwnedAccessKey, err error) {
	result = &v1.OwnedAccessKey{}
	err = c.client.Patch(pt).
		Resource("ownedaccesskeys").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
