// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"
	"time"

	v1 "github.com/loft-sh/api/v4/pkg/apis/management/v1"
	scheme "github.com/loft-sh/api/v4/pkg/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// IngressAuthTokensGetter has a method to return a IngressAuthTokenInterface.
// A group's client should implement this interface.
type IngressAuthTokensGetter interface {
	IngressAuthTokens() IngressAuthTokenInterface
}

// IngressAuthTokenInterface has methods to work with IngressAuthToken resources.
type IngressAuthTokenInterface interface {
	Create(ctx context.Context, ingressAuthToken *v1.IngressAuthToken, opts metav1.CreateOptions) (*v1.IngressAuthToken, error)
	Update(ctx context.Context, ingressAuthToken *v1.IngressAuthToken, opts metav1.UpdateOptions) (*v1.IngressAuthToken, error)
	UpdateStatus(ctx context.Context, ingressAuthToken *v1.IngressAuthToken, opts metav1.UpdateOptions) (*v1.IngressAuthToken, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.IngressAuthToken, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.IngressAuthTokenList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.IngressAuthToken, err error)
	IngressAuthTokenExpansion
}

// ingressAuthTokens implements IngressAuthTokenInterface
type ingressAuthTokens struct {
	client rest.Interface
}

// newIngressAuthTokens returns a IngressAuthTokens
func newIngressAuthTokens(c *ManagementV1Client) *ingressAuthTokens {
	return &ingressAuthTokens{
		client: c.RESTClient(),
	}
}

// Get takes name of the ingressAuthToken, and returns the corresponding ingressAuthToken object, and an error if there is any.
func (c *ingressAuthTokens) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.IngressAuthToken, err error) {
	result = &v1.IngressAuthToken{}
	err = c.client.Get().
		Resource("ingressauthtokens").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of IngressAuthTokens that match those selectors.
func (c *ingressAuthTokens) List(ctx context.Context, opts metav1.ListOptions) (result *v1.IngressAuthTokenList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.IngressAuthTokenList{}
	err = c.client.Get().
		Resource("ingressauthtokens").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested ingressAuthTokens.
func (c *ingressAuthTokens) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("ingressauthtokens").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a ingressAuthToken and creates it.  Returns the server's representation of the ingressAuthToken, and an error, if there is any.
func (c *ingressAuthTokens) Create(ctx context.Context, ingressAuthToken *v1.IngressAuthToken, opts metav1.CreateOptions) (result *v1.IngressAuthToken, err error) {
	result = &v1.IngressAuthToken{}
	err = c.client.Post().
		Resource("ingressauthtokens").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(ingressAuthToken).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a ingressAuthToken and updates it. Returns the server's representation of the ingressAuthToken, and an error, if there is any.
func (c *ingressAuthTokens) Update(ctx context.Context, ingressAuthToken *v1.IngressAuthToken, opts metav1.UpdateOptions) (result *v1.IngressAuthToken, err error) {
	result = &v1.IngressAuthToken{}
	err = c.client.Put().
		Resource("ingressauthtokens").
		Name(ingressAuthToken.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(ingressAuthToken).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *ingressAuthTokens) UpdateStatus(ctx context.Context, ingressAuthToken *v1.IngressAuthToken, opts metav1.UpdateOptions) (result *v1.IngressAuthToken, err error) {
	result = &v1.IngressAuthToken{}
	err = c.client.Put().
		Resource("ingressauthtokens").
		Name(ingressAuthToken.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(ingressAuthToken).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the ingressAuthToken and deletes it. Returns an error if one occurs.
func (c *ingressAuthTokens) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return c.client.Delete().
		Resource("ingressauthtokens").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *ingressAuthTokens) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("ingressauthtokens").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched ingressAuthToken.
func (c *ingressAuthTokens) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.IngressAuthToken, err error) {
	result = &v1.IngressAuthToken{}
	err = c.client.Patch(pt).
		Resource("ingressauthtokens").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
