// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"
	"time"

	v1 "github.com/loft-sh/api/v4/pkg/apis/management/v1"
	scheme "github.com/loft-sh/api/v4/pkg/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// DirectClusterEndpointTokensGetter has a method to return a DirectClusterEndpointTokenInterface.
// A group's client should implement this interface.
type DirectClusterEndpointTokensGetter interface {
	DirectClusterEndpointTokens() DirectClusterEndpointTokenInterface
}

// DirectClusterEndpointTokenInterface has methods to work with DirectClusterEndpointToken resources.
type DirectClusterEndpointTokenInterface interface {
	Create(ctx context.Context, directClusterEndpointToken *v1.DirectClusterEndpointToken, opts metav1.CreateOptions) (*v1.DirectClusterEndpointToken, error)
	Update(ctx context.Context, directClusterEndpointToken *v1.DirectClusterEndpointToken, opts metav1.UpdateOptions) (*v1.DirectClusterEndpointToken, error)
	UpdateStatus(ctx context.Context, directClusterEndpointToken *v1.DirectClusterEndpointToken, opts metav1.UpdateOptions) (*v1.DirectClusterEndpointToken, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.DirectClusterEndpointToken, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.DirectClusterEndpointTokenList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.DirectClusterEndpointToken, err error)
	DirectClusterEndpointTokenExpansion
}

// directClusterEndpointTokens implements DirectClusterEndpointTokenInterface
type directClusterEndpointTokens struct {
	client rest.Interface
}

// newDirectClusterEndpointTokens returns a DirectClusterEndpointTokens
func newDirectClusterEndpointTokens(c *ManagementV1Client) *directClusterEndpointTokens {
	return &directClusterEndpointTokens{
		client: c.RESTClient(),
	}
}

// Get takes name of the directClusterEndpointToken, and returns the corresponding directClusterEndpointToken object, and an error if there is any.
func (c *directClusterEndpointTokens) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.DirectClusterEndpointToken, err error) {
	result = &v1.DirectClusterEndpointToken{}
	err = c.client.Get().
		Resource("directclusterendpointtokens").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of DirectClusterEndpointTokens that match those selectors.
func (c *directClusterEndpointTokens) List(ctx context.Context, opts metav1.ListOptions) (result *v1.DirectClusterEndpointTokenList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.DirectClusterEndpointTokenList{}
	err = c.client.Get().
		Resource("directclusterendpointtokens").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested directClusterEndpointTokens.
func (c *directClusterEndpointTokens) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("directclusterendpointtokens").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a directClusterEndpointToken and creates it.  Returns the server's representation of the directClusterEndpointToken, and an error, if there is any.
func (c *directClusterEndpointTokens) Create(ctx context.Context, directClusterEndpointToken *v1.DirectClusterEndpointToken, opts metav1.CreateOptions) (result *v1.DirectClusterEndpointToken, err error) {
	result = &v1.DirectClusterEndpointToken{}
	err = c.client.Post().
		Resource("directclusterendpointtokens").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(directClusterEndpointToken).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a directClusterEndpointToken and updates it. Returns the server's representation of the directClusterEndpointToken, and an error, if there is any.
func (c *directClusterEndpointTokens) Update(ctx context.Context, directClusterEndpointToken *v1.DirectClusterEndpointToken, opts metav1.UpdateOptions) (result *v1.DirectClusterEndpointToken, err error) {
	result = &v1.DirectClusterEndpointToken{}
	err = c.client.Put().
		Resource("directclusterendpointtokens").
		Name(directClusterEndpointToken.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(directClusterEndpointToken).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *directClusterEndpointTokens) UpdateStatus(ctx context.Context, directClusterEndpointToken *v1.DirectClusterEndpointToken, opts metav1.UpdateOptions) (result *v1.DirectClusterEndpointToken, err error) {
	result = &v1.DirectClusterEndpointToken{}
	err = c.client.Put().
		Resource("directclusterendpointtokens").
		Name(directClusterEndpointToken.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(directClusterEndpointToken).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the directClusterEndpointToken and deletes it. Returns an error if one occurs.
func (c *directClusterEndpointTokens) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return c.client.Delete().
		Resource("directclusterendpointtokens").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *directClusterEndpointTokens) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("directclusterendpointtokens").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched directClusterEndpointToken.
func (c *directClusterEndpointTokens) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.DirectClusterEndpointToken, err error) {
	result = &v1.DirectClusterEndpointToken{}
	err = c.client.Patch(pt).
		Resource("directclusterendpointtokens").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
