// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"
	"time"

	v1 "github.com/loft-sh/api/v4/pkg/apis/management/v1"
	scheme "github.com/loft-sh/api/v4/pkg/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// AnnouncementsGetter has a method to return a AnnouncementInterface.
// A group's client should implement this interface.
type AnnouncementsGetter interface {
	Announcements() AnnouncementInterface
}

// AnnouncementInterface has methods to work with Announcement resources.
type AnnouncementInterface interface {
	Create(ctx context.Context, announcement *v1.Announcement, opts metav1.CreateOptions) (*v1.Announcement, error)
	Update(ctx context.Context, announcement *v1.Announcement, opts metav1.UpdateOptions) (*v1.Announcement, error)
	UpdateStatus(ctx context.Context, announcement *v1.Announcement, opts metav1.UpdateOptions) (*v1.Announcement, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.Announcement, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.AnnouncementList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.Announcement, err error)
	AnnouncementExpansion
}

// announcements implements AnnouncementInterface
type announcements struct {
	client rest.Interface
}

// newAnnouncements returns a Announcements
func newAnnouncements(c *ManagementV1Client) *announcements {
	return &announcements{
		client: c.RESTClient(),
	}
}

// Get takes name of the announcement, and returns the corresponding announcement object, and an error if there is any.
func (c *announcements) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.Announcement, err error) {
	result = &v1.Announcement{}
	err = c.client.Get().
		Resource("announcements").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of Announcements that match those selectors.
func (c *announcements) List(ctx context.Context, opts metav1.ListOptions) (result *v1.AnnouncementList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.AnnouncementList{}
	err = c.client.Get().
		Resource("announcements").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested announcements.
func (c *announcements) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("announcements").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a announcement and creates it.  Returns the server's representation of the announcement, and an error, if there is any.
func (c *announcements) Create(ctx context.Context, announcement *v1.Announcement, opts metav1.CreateOptions) (result *v1.Announcement, err error) {
	result = &v1.Announcement{}
	err = c.client.Post().
		Resource("announcements").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(announcement).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a announcement and updates it. Returns the server's representation of the announcement, and an error, if there is any.
func (c *announcements) Update(ctx context.Context, announcement *v1.Announcement, opts metav1.UpdateOptions) (result *v1.Announcement, err error) {
	result = &v1.Announcement{}
	err = c.client.Put().
		Resource("announcements").
		Name(announcement.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(announcement).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *announcements) UpdateStatus(ctx context.Context, announcement *v1.Announcement, opts metav1.UpdateOptions) (result *v1.Announcement, err error) {
	result = &v1.Announcement{}
	err = c.client.Put().
		Resource("announcements").
		Name(announcement.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(announcement).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the announcement and deletes it. Returns an error if one occurs.
func (c *announcements) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return c.client.Delete().
		Resource("announcements").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *announcements) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("announcements").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched announcement.
func (c *announcements) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.Announcement, err error) {
	result = &v1.Announcement{}
	err = c.client.Patch(pt).
		Resource("announcements").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
