// Code generated by generator. DO NOT EDIT.

package cluster

import (
	"context"
	"fmt"

	pkglicenseapi "github.com/loft-sh/admin-apis/pkg/licenseapi"
	"github.com/loft-sh/apiserver/pkg/builders"
	"k8s.io/apimachinery/pkg/apis/meta/internalversion"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/runtime"
	"k8s.io/apimachinery/pkg/runtime/schema"
	"k8s.io/apiserver/pkg/registry/generic"
	"k8s.io/apiserver/pkg/registry/rest"
	configrest "k8s.io/client-go/rest"
	"sigs.k8s.io/controller-runtime/pkg/client"
)

type NewRESTFunc func(config *configrest.Config, cachedClient, uncachedClient, cachedManagementClient, uncachedManagementClient client.Client) rest.Storage

var (
	ClusterChartInfoStorage = builders.NewApiResourceWithStorage( // Resource status endpoint
		InternalChartInfo,
		func() runtime.Object { return &ChartInfo{} },     // Register versioned resource
		func() runtime.Object { return &ChartInfoList{} }, // Register versioned resource list
		NewChartInfoREST,
	)
	NewChartInfoREST = func(getter generic.RESTOptionsGetter) rest.Storage {
		return NewChartInfoRESTFunc(Config, CachedClient, UncachedClient, CachedManagementClient, UncachedManagementClient)
	}
	NewChartInfoRESTFunc  NewRESTFunc
	ClusterFeatureStorage = builders.NewApiResourceWithStorage( // Resource status endpoint
		InternalFeature,
		func() runtime.Object { return &Feature{} },     // Register versioned resource
		func() runtime.Object { return &FeatureList{} }, // Register versioned resource list
		NewFeatureREST,
	)
	NewFeatureREST = func(getter generic.RESTOptionsGetter) rest.Storage {
		return NewFeatureRESTFunc(Config, CachedClient, UncachedClient, CachedManagementClient, UncachedManagementClient)
	}
	NewFeatureRESTFunc        NewRESTFunc
	ClusterHelmReleaseStorage = builders.NewApiResourceWithStorage( // Resource status endpoint
		InternalHelmRelease,
		func() runtime.Object { return &HelmRelease{} },     // Register versioned resource
		func() runtime.Object { return &HelmReleaseList{} }, // Register versioned resource list
		NewHelmReleaseREST,
	)
	NewHelmReleaseREST = func(getter generic.RESTOptionsGetter) rest.Storage {
		return NewHelmReleaseRESTFunc(Config, CachedClient, UncachedClient, CachedManagementClient, UncachedManagementClient)
	}
	NewHelmReleaseRESTFunc NewRESTFunc
	InternalChartInfo      = builders.NewInternalResource(
		"chartinfos",
		"ChartInfo",
		func() runtime.Object { return &ChartInfo{} },
		func() runtime.Object { return &ChartInfoList{} },
	)
	InternalChartInfoStatus = builders.NewInternalResourceStatus(
		"chartinfos",
		"ChartInfoStatus",
		func() runtime.Object { return &ChartInfo{} },
		func() runtime.Object { return &ChartInfoList{} },
	)
	InternalFeature = builders.NewInternalResource(
		"features",
		"Feature",
		func() runtime.Object { return &Feature{} },
		func() runtime.Object { return &FeatureList{} },
	)
	InternalFeatureStatus = builders.NewInternalResourceStatus(
		"features",
		"FeatureStatus",
		func() runtime.Object { return &Feature{} },
		func() runtime.Object { return &FeatureList{} },
	)
	InternalHelmRelease = builders.NewInternalResource(
		"helmreleases",
		"HelmRelease",
		func() runtime.Object { return &HelmRelease{} },
		func() runtime.Object { return &HelmReleaseList{} },
	)
	InternalHelmReleaseStatus = builders.NewInternalResourceStatus(
		"helmreleases",
		"HelmReleaseStatus",
		func() runtime.Object { return &HelmRelease{} },
		func() runtime.Object { return &HelmReleaseList{} },
	)
	// Registered resources and subresources
	ApiVersion = builders.NewApiGroup("cluster.loft.sh").WithKinds(
		InternalChartInfo,
		InternalChartInfoStatus,
		InternalFeature,
		InternalFeatureStatus,
		InternalHelmRelease,
		InternalHelmReleaseStatus,
	)

	// Required by code generated by go2idl
	AddToScheme = (&runtime.SchemeBuilder{
		ApiVersion.SchemeBuilder.AddToScheme,
		RegisterDefaults,
	}).AddToScheme
	SchemeBuilder      = ApiVersion.SchemeBuilder
	localSchemeBuilder = &SchemeBuilder
	SchemeGroupVersion = ApiVersion.GroupVersion
)

// Required by code generated by go2idl
// Kind takes an unqualified kind and returns a Group qualified GroupKind
func Kind(kind string) schema.GroupKind {
	return SchemeGroupVersion.WithKind(kind).GroupKind()
}

// Required by code generated by go2idl
// Resource takes an unqualified resource and returns a Group qualified GroupResource
func Resource(resource string) schema.GroupResource {
	return SchemeGroupVersion.WithResource(resource).GroupResource()
}

type Status string

type Bash struct {
	Script      string `json:"script,omitempty"`
	Image       string `json:"image,omitempty"`
	ClusterRole string `json:"clusterRole,omitempty"`
}

type Chart struct {
	Name                  string          `json:"name,omitempty"`
	Version               string          `json:"version,omitempty"`
	RepoURL               string          `json:"repoURL,omitempty"`
	Username              string          `json:"username,omitempty"`
	UsernameRef           *ChartSecretRef `json:"usernameRef,omitempty"`
	Password              string          `json:"password,omitempty"`
	PasswordRef           *ChartSecretRef `json:"passwordRef,omitempty"`
	InsecureSkipTlsVerify bool            `json:"insecureSkipTlsVerify,omitempty"`
}

// +genclient
// +genclient:nonNamespaced
// +k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object

type ChartInfo struct {
	metav1.TypeMeta   `json:",inline"`
	metav1.ObjectMeta `json:"metadata,omitempty"`
	Spec              ChartInfoSpec   `json:"spec,omitempty"`
	Status            ChartInfoStatus `json:"status,omitempty"`
}

type ChartInfoSpec struct {
	Chart Chart `json:"chart,omitempty"`
}

type ChartInfoStatus struct {
	Metadata *Metadata `json:"metadata,omitempty"`
	Readme   string    `json:"readme,omitempty"`
	Values   string    `json:"values,omitempty"`
}

type ChartSecretRef struct {
	ProjectSecretRef *ProjectSecretRef `json:"projectSecretRef,omitempty"`
}

// +genclient
// +genclient:nonNamespaced
// +k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object

type Feature struct {
	metav1.TypeMeta   `json:",inline"`
	metav1.ObjectMeta `json:"metadata,omitempty"`
	Spec              FeatureSpec   `json:"spec,omitempty"`
	Status            FeatureStatus `json:"status,omitempty"`
}

type FeatureSpec struct {
}

type FeatureStatus struct {
	pkglicenseapi.Feature `json:",inline"`
	Internal              bool `json:"internal,omitempty"`
	Used                  bool `json:"used,omitempty"`
}

// +genclient
// +genclient
// +k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object

type HelmRelease struct {
	metav1.TypeMeta   `json:",inline"`
	metav1.ObjectMeta `json:"metadata,omitempty"`
	Spec              HelmReleaseSpec   `json:"spec,omitempty"`
	Status            HelmReleaseStatus `json:"status,omitempty"`
}

type HelmReleaseConfig struct {
	Chart       Chart             `json:"chart,omitempty"`
	Manifests   string            `json:"manifests,omitempty"`
	Bash        *Bash             `json:"bash,omitempty"`
	Values      string            `json:"values,omitempty"`
	Parameters  string            `json:"parameters,omitempty"`
	Annotations map[string]string `json:"annotations,omitempty"`
}

type HelmReleaseSpec struct {
	HelmReleaseConfig `json:",inline"`
}

type HelmReleaseStatus struct {
	Revision int       `json:"version,omitempty"`
	Info     *Info     `json:"info,omitempty"`
	Metadata *Metadata `json:"metadata,omitempty"`
}

type Info struct {
	FirstDeployed metav1.Time `json:"first_deployed,omitempty"`
	LastDeployed  metav1.Time `json:"last_deployed,omitempty"`
	Deleted       metav1.Time `json:"deleted"`
	Description   string      `json:"description,omitempty"`
	Status        Status      `json:"status,omitempty"`
	Notes         string      `json:"notes,omitempty"`
}

type Maintainer struct {
	Name  string `json:"name,omitempty"`
	Email string `json:"email,omitempty"`
	URL   string `json:"url,omitempty"`
}

type Metadata struct {
	Name        string            `json:"name,omitempty"`
	Home        string            `json:"home,omitempty"`
	Sources     []string          `json:"sources,omitempty"`
	Version     string            `json:"version,omitempty"`
	Description string            `json:"description,omitempty"`
	Keywords    []string          `json:"keywords,omitempty"`
	Maintainers []*Maintainer     `json:"maintainers,omitempty"`
	Icon        string            `json:"icon,omitempty"`
	APIVersion  string            `json:"apiVersion,omitempty"`
	Condition   string            `json:"condition,omitempty"`
	Tags        string            `json:"tags,omitempty"`
	AppVersion  string            `json:"appVersion,omitempty"`
	Deprecated  bool              `json:"deprecated,omitempty"`
	Annotations map[string]string `json:"annotations,omitempty"`
	KubeVersion string            `json:"kubeVersion,omitempty"`
	Type        string            `json:"type,omitempty"`
	Urls        []string          `json:"urls,omitempty"`
}

type ProjectSecretRef struct {
	Project string `json:"project,omitempty"`
	Name    string `json:"name,omitempty"`
	Key     string `json:"key,omitempty"`
}

// ChartInfo Functions and Structs
//
// +k8s:deepcopy-gen=false
type ChartInfoStrategy struct {
	builders.DefaultStorageStrategy
}

// +k8s:deepcopy-gen=false
type ChartInfoStatusStrategy struct {
	builders.DefaultStatusStorageStrategy
}

// +k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object

type ChartInfoList struct {
	metav1.TypeMeta `json:",inline"`
	metav1.ListMeta `json:"metadata,omitempty"`
	Items           []ChartInfo `json:"items"`
}

func (ChartInfo) NewStatus() interface{} {
	return ChartInfoStatus{}
}

func (pc *ChartInfo) GetStatus() interface{} {
	return pc.Status
}

func (pc *ChartInfo) SetStatus(s interface{}) {
	pc.Status = s.(ChartInfoStatus)
}

func (pc *ChartInfo) GetSpec() interface{} {
	return pc.Spec
}

func (pc *ChartInfo) SetSpec(s interface{}) {
	pc.Spec = s.(ChartInfoSpec)
}

func (pc *ChartInfo) GetObjectMeta() *metav1.ObjectMeta {
	return &pc.ObjectMeta
}

func (pc *ChartInfo) SetGeneration(generation int64) {
	pc.ObjectMeta.Generation = generation
}

func (pc ChartInfo) GetGeneration() int64 {
	return pc.ObjectMeta.Generation
}

// Registry is an interface for things that know how to store ChartInfo.
// +k8s:deepcopy-gen=false
type ChartInfoRegistry interface {
	ListChartInfos(ctx context.Context, options *internalversion.ListOptions) (*ChartInfoList, error)
	GetChartInfo(ctx context.Context, id string, options *metav1.GetOptions) (*ChartInfo, error)
	CreateChartInfo(ctx context.Context, id *ChartInfo) (*ChartInfo, error)
	UpdateChartInfo(ctx context.Context, id *ChartInfo) (*ChartInfo, error)
	DeleteChartInfo(ctx context.Context, id string) (bool, error)
}

// NewRegistry returns a new Registry interface for the given Storage. Any mismatched types will panic.
func NewChartInfoRegistry(sp builders.StandardStorageProvider) ChartInfoRegistry {
	return &storageChartInfo{sp}
}

// Implement Registry
// storage puts strong typing around storage calls
// +k8s:deepcopy-gen=false
type storageChartInfo struct {
	builders.StandardStorageProvider
}

func (s *storageChartInfo) ListChartInfos(ctx context.Context, options *internalversion.ListOptions) (*ChartInfoList, error) {
	if options != nil && options.FieldSelector != nil && !options.FieldSelector.Empty() {
		return nil, fmt.Errorf("field selector not supported yet")
	}
	st := s.GetStandardStorage()
	obj, err := st.List(ctx, options)
	if err != nil {
		return nil, err
	}
	return obj.(*ChartInfoList), err
}

func (s *storageChartInfo) GetChartInfo(ctx context.Context, id string, options *metav1.GetOptions) (*ChartInfo, error) {
	st := s.GetStandardStorage()
	obj, err := st.Get(ctx, id, options)
	if err != nil {
		return nil, err
	}
	return obj.(*ChartInfo), nil
}

func (s *storageChartInfo) CreateChartInfo(ctx context.Context, object *ChartInfo) (*ChartInfo, error) {
	st := s.GetStandardStorage()
	obj, err := st.Create(ctx, object, nil, &metav1.CreateOptions{})
	if err != nil {
		return nil, err
	}
	return obj.(*ChartInfo), nil
}

func (s *storageChartInfo) UpdateChartInfo(ctx context.Context, object *ChartInfo) (*ChartInfo, error) {
	st := s.GetStandardStorage()
	obj, _, err := st.Update(ctx, object.Name, rest.DefaultUpdatedObjectInfo(object), nil, nil, false, &metav1.UpdateOptions{})
	if err != nil {
		return nil, err
	}
	return obj.(*ChartInfo), nil
}

func (s *storageChartInfo) DeleteChartInfo(ctx context.Context, id string) (bool, error) {
	st := s.GetStandardStorage()
	_, sync, err := st.Delete(ctx, id, nil, &metav1.DeleteOptions{})
	return sync, err
}

// Feature Functions and Structs
//
// +k8s:deepcopy-gen=false
type FeatureStrategy struct {
	builders.DefaultStorageStrategy
}

// +k8s:deepcopy-gen=false
type FeatureStatusStrategy struct {
	builders.DefaultStatusStorageStrategy
}

// +k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object

type FeatureList struct {
	metav1.TypeMeta `json:",inline"`
	metav1.ListMeta `json:"metadata,omitempty"`
	Items           []Feature `json:"items"`
}

func (Feature) NewStatus() interface{} {
	return FeatureStatus{}
}

func (pc *Feature) GetStatus() interface{} {
	return pc.Status
}

func (pc *Feature) SetStatus(s interface{}) {
	pc.Status = s.(FeatureStatus)
}

func (pc *Feature) GetSpec() interface{} {
	return pc.Spec
}

func (pc *Feature) SetSpec(s interface{}) {
	pc.Spec = s.(FeatureSpec)
}

func (pc *Feature) GetObjectMeta() *metav1.ObjectMeta {
	return &pc.ObjectMeta
}

func (pc *Feature) SetGeneration(generation int64) {
	pc.ObjectMeta.Generation = generation
}

func (pc Feature) GetGeneration() int64 {
	return pc.ObjectMeta.Generation
}

// Registry is an interface for things that know how to store Feature.
// +k8s:deepcopy-gen=false
type FeatureRegistry interface {
	ListFeatures(ctx context.Context, options *internalversion.ListOptions) (*FeatureList, error)
	GetFeature(ctx context.Context, id string, options *metav1.GetOptions) (*Feature, error)
	CreateFeature(ctx context.Context, id *Feature) (*Feature, error)
	UpdateFeature(ctx context.Context, id *Feature) (*Feature, error)
	DeleteFeature(ctx context.Context, id string) (bool, error)
}

// NewRegistry returns a new Registry interface for the given Storage. Any mismatched types will panic.
func NewFeatureRegistry(sp builders.StandardStorageProvider) FeatureRegistry {
	return &storageFeature{sp}
}

// Implement Registry
// storage puts strong typing around storage calls
// +k8s:deepcopy-gen=false
type storageFeature struct {
	builders.StandardStorageProvider
}

func (s *storageFeature) ListFeatures(ctx context.Context, options *internalversion.ListOptions) (*FeatureList, error) {
	if options != nil && options.FieldSelector != nil && !options.FieldSelector.Empty() {
		return nil, fmt.Errorf("field selector not supported yet")
	}
	st := s.GetStandardStorage()
	obj, err := st.List(ctx, options)
	if err != nil {
		return nil, err
	}
	return obj.(*FeatureList), err
}

func (s *storageFeature) GetFeature(ctx context.Context, id string, options *metav1.GetOptions) (*Feature, error) {
	st := s.GetStandardStorage()
	obj, err := st.Get(ctx, id, options)
	if err != nil {
		return nil, err
	}
	return obj.(*Feature), nil
}

func (s *storageFeature) CreateFeature(ctx context.Context, object *Feature) (*Feature, error) {
	st := s.GetStandardStorage()
	obj, err := st.Create(ctx, object, nil, &metav1.CreateOptions{})
	if err != nil {
		return nil, err
	}
	return obj.(*Feature), nil
}

func (s *storageFeature) UpdateFeature(ctx context.Context, object *Feature) (*Feature, error) {
	st := s.GetStandardStorage()
	obj, _, err := st.Update(ctx, object.Name, rest.DefaultUpdatedObjectInfo(object), nil, nil, false, &metav1.UpdateOptions{})
	if err != nil {
		return nil, err
	}
	return obj.(*Feature), nil
}

func (s *storageFeature) DeleteFeature(ctx context.Context, id string) (bool, error) {
	st := s.GetStandardStorage()
	_, sync, err := st.Delete(ctx, id, nil, &metav1.DeleteOptions{})
	return sync, err
}

// HelmRelease Functions and Structs
//
// +k8s:deepcopy-gen=false
type HelmReleaseStrategy struct {
	builders.DefaultStorageStrategy
}

// +k8s:deepcopy-gen=false
type HelmReleaseStatusStrategy struct {
	builders.DefaultStatusStorageStrategy
}

// +k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object

type HelmReleaseList struct {
	metav1.TypeMeta `json:",inline"`
	metav1.ListMeta `json:"metadata,omitempty"`
	Items           []HelmRelease `json:"items"`
}

func (HelmRelease) NewStatus() interface{} {
	return HelmReleaseStatus{}
}

func (pc *HelmRelease) GetStatus() interface{} {
	return pc.Status
}

func (pc *HelmRelease) SetStatus(s interface{}) {
	pc.Status = s.(HelmReleaseStatus)
}

func (pc *HelmRelease) GetSpec() interface{} {
	return pc.Spec
}

func (pc *HelmRelease) SetSpec(s interface{}) {
	pc.Spec = s.(HelmReleaseSpec)
}

func (pc *HelmRelease) GetObjectMeta() *metav1.ObjectMeta {
	return &pc.ObjectMeta
}

func (pc *HelmRelease) SetGeneration(generation int64) {
	pc.ObjectMeta.Generation = generation
}

func (pc HelmRelease) GetGeneration() int64 {
	return pc.ObjectMeta.Generation
}

// Registry is an interface for things that know how to store HelmRelease.
// +k8s:deepcopy-gen=false
type HelmReleaseRegistry interface {
	ListHelmReleases(ctx context.Context, options *internalversion.ListOptions) (*HelmReleaseList, error)
	GetHelmRelease(ctx context.Context, id string, options *metav1.GetOptions) (*HelmRelease, error)
	CreateHelmRelease(ctx context.Context, id *HelmRelease) (*HelmRelease, error)
	UpdateHelmRelease(ctx context.Context, id *HelmRelease) (*HelmRelease, error)
	DeleteHelmRelease(ctx context.Context, id string) (bool, error)
}

// NewRegistry returns a new Registry interface for the given Storage. Any mismatched types will panic.
func NewHelmReleaseRegistry(sp builders.StandardStorageProvider) HelmReleaseRegistry {
	return &storageHelmRelease{sp}
}

// Implement Registry
// storage puts strong typing around storage calls
// +k8s:deepcopy-gen=false
type storageHelmRelease struct {
	builders.StandardStorageProvider
}

func (s *storageHelmRelease) ListHelmReleases(ctx context.Context, options *internalversion.ListOptions) (*HelmReleaseList, error) {
	if options != nil && options.FieldSelector != nil && !options.FieldSelector.Empty() {
		return nil, fmt.Errorf("field selector not supported yet")
	}
	st := s.GetStandardStorage()
	obj, err := st.List(ctx, options)
	if err != nil {
		return nil, err
	}
	return obj.(*HelmReleaseList), err
}

func (s *storageHelmRelease) GetHelmRelease(ctx context.Context, id string, options *metav1.GetOptions) (*HelmRelease, error) {
	st := s.GetStandardStorage()
	obj, err := st.Get(ctx, id, options)
	if err != nil {
		return nil, err
	}
	return obj.(*HelmRelease), nil
}

func (s *storageHelmRelease) CreateHelmRelease(ctx context.Context, object *HelmRelease) (*HelmRelease, error) {
	st := s.GetStandardStorage()
	obj, err := st.Create(ctx, object, nil, &metav1.CreateOptions{})
	if err != nil {
		return nil, err
	}
	return obj.(*HelmRelease), nil
}

func (s *storageHelmRelease) UpdateHelmRelease(ctx context.Context, object *HelmRelease) (*HelmRelease, error) {
	st := s.GetStandardStorage()
	obj, _, err := st.Update(ctx, object.Name, rest.DefaultUpdatedObjectInfo(object), nil, nil, false, &metav1.UpdateOptions{})
	if err != nil {
		return nil, err
	}
	return obj.(*HelmRelease), nil
}

func (s *storageHelmRelease) DeleteHelmRelease(ctx context.Context, id string) (bool, error) {
	st := s.GetStandardStorage()
	_, sync, err := st.Delete(ctx, id, nil, &metav1.DeleteOptions{})
	return sync, err
}
