<div align="center"><a name="readme-top"></a>

<img height="120" src="https://registry.npmmirror.com/@lobehub/assets-emoji/1.3.0/files/assets/robot.webp">
<img height="120" src="https://gw.alipayobjects.com/zos/kitchen/qJ3l3EPsdW/split.svg">
<img height="120" src="https://registry.npmmirror.com/@lobehub/assets-emoji/1.3.0/files/assets/convenience-store.webp">

<h1>Lobe Chat Agents Index</h1>

[**Submit Your Agent >>**][submit]

[Lobe Chat](https://github.com/lobehub/lobe-chat) accesses [`index.json`][website-url] from this repo to show user the list of available agents for LobeChat.

**English** · [简体中文](./README.zh-CN.md)

<!-- SHIELD GROUP -->

[![awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/lobehub/lobe-chat-agents)
[![website][website-shield]][website-url]
[![][npm-release-shield]][npm-release-link]
[![][github-releasedate-shield]][github-releasedate-link]
[![][github-action-test-shield]][github-action-test-link]
[![][github-action-release-shield]][github-action-release-link]<br/>
[![][github-contributors-shield]][github-contributors-link]
[![][github-forks-shield]][github-forks-link]
[![][github-stars-shield]][github-stars-link]
[![][github-issues-shield]][github-issues-link]
[![][github-license-shield]][github-license-link]

[![](https://github-production-user-asset-6210df.s3.amazonaws.com/17870709/268670869-f1ffbf66-42b6-42cf-a937-9ce1f8328514.png)](https://github.com/lobehub/lobe-chat)

</div>

<details>
<summary><kbd>Table of contents</kbd></summary>

#### TOC

- [🚀 How to Submit your Agent](#-how-to-submit-your-agent)
  - [Step-by-step Instructions](#step-by-step-instructions)
- [🕶 Awesome Prompts](#-awesome-prompts)
  - [Xiaohongshu Copywriting Generator](#xiaohongshu-copywriting-generator)
  - [Bilingual Dictionary Expert](#bilingual-dictionary-expert)
  - [Interviewer's Assistant](#interviewers-assistant)
  - [Backend Development Assistant](#backend-development-assistant)
  - [All Translation Assistant (with Phonetic Symbols)](#all-translation-assistant-with-phonetic-symbols)
  - [Rebecca, Mental Health Counselor](#rebecca-mental-health-counselor)
  - [SSC Incremental](#ssc-incremental)
  - [Human Author Simulator](#human-author-simulator)
  - [Text Improver](#text-improver)
  - [Yin-Yang Master](#yin-yang-master)
  - [Master E's Tech Executive Assistant (EA)](#master-es-tech-executive-assistant-ea)
  - [Prompt Keywords](#prompt-keywords)
  - [Wisdom Guide](#wisdom-guide)
  - [Minimalist Black and White Illustration](#minimalist-black-and-white-illustration)
  - [Illustrative Writer](#illustrative-writer)
  - [Thinking Claude](#thinking-claude)
  - [Workplace Psychology Analysis Expert](#workplace-psychology-analysis-expert)
  - [Print to Table](#print-to-table)
  - [Ultra Flux Prompter](#ultra-flux-prompter)
  - [Text RPG Host](#text-rpg-host)
  - [Machine Vision LaTeX](#machine-vision-latex)
  - [Software Architecture and Engineering Expert](#software-architecture-and-engineering-expert)
  - [Domain Analysis Master](#domain-analysis-master)
  - [Ingo Hausmann](#ingo-hausmann)
  - [Vector Logo Generator](#vector-logo-generator)
  - [Psychologist](#psychologist)
  - [Algorithm Answer Mentor](#algorithm-answer-mentor)
  - [Master of the I Ching](#master-of-the-i-ching)
  - [Coconut](#coconut)
  - [Boxing Training Master](#boxing-training-master)
  - [Xilinx FPGA Solutions Expert](#xilinx-fpga-solutions-expert)
  - [Semiconductor Text Optimization Expert](#semiconductor-text-optimization-expert)
  - [Ophthalmologist](#ophthalmologist)
  - [Wireless Communication Expert](#wireless-communication-expert)
  - [GitHub Project Documentation Assistant](#github-project-documentation-assistant)
  - [Fitness Expert](#fitness-expert)
  - [Mistaker](#mistaker)
  - [Code Optimization/Error Correction](#code-optimizationerror-correction)
  - [Ethical Security Analyst](#ethical-security-analyst)
  - [Minimal Artifact Architect](#minimal-artifact-architect)
  - [Principled Problem Solver](#principled-problem-solver)
  - [JSON Prompt Generator](#json-prompt-generator)
  - [C++/Qt](#cqt)
  - [Death Anniversary Messages](#death-anniversary-messages)
  - [Flux Prompt Generator](#flux-prompt-generator)
  - [Master of Retorts](#master-of-retorts)
  - [Runway Gen-3 Prompt Generator](#runway-gen-3-prompt-generator)
  - [God Bless You Messages](#god-bless-you-messages)
  - [This Makes Sense](#this-makes-sense)
  - [Birthday Invitation Messages](#birthday-invitation-messages)
  - [LaTeX Academic Paper Summary Assistant](#latex-academic-paper-summary-assistant)
  - [Nice Short Sunday Messages](#nice-short-sunday-messages)
  - [Meeting Assistant v1.0](#meeting-assistant-v10)
  - [PPT Optimization Expert v1.0](#ppt-optimization-expert-v10)
  - [Contract Clause Refiner v1.0](#contract-clause-refiner-v10)
  - [I Ching Divination Master](#i-ching-divination-master)
  - [Stable Album Cover Prompter](#stable-album-cover-prompter)
  - [Idea Architect](#idea-architect)
  - [Copy Optimization Assistant](#copy-optimization-assistant)
  - [Joi](#joi)
  - [Minimal Translation Assistant](#minimal-translation-assistant)
  - [Exam Essay Writing Master](#exam-essay-writing-master)
  - [UI/UX designer](#uiux-designer)
  - [COSTAR Framework Writer](#costar-framework-writer)
  - [Chinese Translator](#chinese-translator)
  - [Advertising Copywriting Master](#advertising-copywriting-master)
  - [Vim Mastery Mentor](#vim-mastery-mentor)
  - [Duolingo English Essay Assistant](#duolingo-english-essay-assistant)
  - [Fitness Guru](#fitness-guru)
  - [Markdown Conversion Expert](#markdown-conversion-expert)
  - [NovelAI Drawing Assistant](#novelai-drawing-assistant)
  - [Git Commit Summary Expert](#git-commit-summary-expert)
  - [GitHub Project Analyst](#github-project-analyst)
  - [Web Expert](#web-expert)
  - [English Word Analysis and Memory Expert](#english-word-analysis-and-memory-expert)
  - [Civil Law Consultant](#civil-law-consultant)
  - [Python Development Master](#python-development-master)
  - [Image Prompt Expander](#image-prompt-expander)
  - [Smart Search Assistant](#smart-search-assistant)
  - [Book Summary Expert](#book-summary-expert)
  - [Django Development Expert](#django-development-expert)
  - [Prompt Master AI](#prompt-master-ai)
  - [Japanese Translator](#japanese-translator)
  - [Stack Overflow Programming Expert](#stack-overflow-programming-expert)
  - [Nutrition Analyzer](#nutrition-analyzer)
  - [Text Rewriting Master](#text-rewriting-master)
  - [Wise Mentor](#wise-mentor)
  - [Perfect Translation \[Chinese-English; English-Chinese\]](#perfect-translation-chinese-english-english-chinese)
  - [Full Stack Engineer - F](#full-stack-engineer---f)
  - [Life Coach](#life-coach)
  - [World Creator Simulator](#world-creator-simulator)
  - [CEO GPT](#ceo-gpt)
  - [Excel Formula Master](#excel-formula-master)
  - [Next.js Expert Consultant](#nextjs-expert-consultant)
  - [Database Naming Assistant](#database-naming-assistant)
  - [Master of Structured Expression](#master-of-structured-expression)
  - [Xiaohongshu Copywriting](#xiaohongshu-copywriting)
  - [Project Naming Master](#project-naming-master)
  - [Strategic Master Wei Liaozi](#strategic-master-wei-liaozi)
  - [Google Sheets Expert](#google-sheets-expert)
  - [Software Engineer](#software-engineer)
  - [Fitness AI Trainer](#fitness-ai-trainer)
  - [Career Development Mentor](#career-development-mentor)
  - [Flashcard Maker](#flashcard-maker)
  - [JavaWeb Application Architect](#javaweb-application-architect)
  - [Git Version Control Expert](#git-version-control-expert)
  - [Data Table Design MD2MySQL](#data-table-design-md2mysql)
  - [Vocabulary Assistant](#vocabulary-assistant)
  - [Alfred](#alfred)
  - [New Interpretations of Chinese](#new-interpretations-of-chinese)
  - [Wang Yangming](#wang-yangming)
  - [Imitation Assistant](#imitation-assistant)
  - [Wise Ethereal Mentor](#wise-ethereal-mentor)
  - [Machine Learning Pro](#machine-learning-pro)
  - [AI Agent Generator](#ai-agent-generator)
  - [Finnish Language Tutor](#finnish-language-tutor)
  - [Search](#search)
  - [Resume Analysis Expert](#resume-analysis-expert)
  - [Desolate Friend](#desolate-friend)
  - [100% Human Writing](#100-human-writing)
  - [HTML to React](#html-to-react)
  - [NetMaster](#netmaster)
  - [Godot Guru](#godot-guru)
  - [FiveM & QBCore Framework Expert](#fivem--qbcore-framework-expert)
  - [Nuxt 3/Vue.js Master Developer](#nuxt-3vuejs-master-developer)
  - [International Lyricist](#international-lyricist)
  - [Unreal Engine Master](#unreal-engine-master)
  - [Backtracking Question Expert](#backtracking-question-expert)
  - [TypeScript Solution Architect](#typescript-solution-architect)
  - [Variable Name Conversion Expert](#variable-name-conversion-expert)
  - [Commit Message Generator](#commit-message-generator)
  - [Prompt Engineering Expert](#prompt-engineering-expert)
  - [RO-SCIRAW Prompt Word Expert](#ro-sciraw-prompt-word-expert)
  - [LobeChat Function Maestro](#lobechat-function-maestro)
  - [Technical Blog Summary Expert](#technical-blog-summary-expert)
  - [Social Media Sage](#social-media-sage)
  - [Omnipedia](#omnipedia)
  - [Code Snark Master](#code-snark-master)
  - [Unity Maestro](#unity-maestro)
  - [C Program Learning Assistant](#c-program-learning-assistant)
  - [Brand Pioneer](#brand-pioneer)
  - [Network Security Assistant](#network-security-assistant)
  - [BIDOSx2](#bidosx2)
  - [Growth Coach](#growth-coach)
  - [Auto Extraction Data](#auto-extraction-data)
  - [Convert SQL Table Structure to Dao and Mapper](#convert-sql-table-structure-to-dao-and-mapper)
  - [MBTI Type Test Designer](#mbti-type-test-designer)
  - [Foreign Trade High EQ Response](#foreign-trade-high-eq-response)
  - [Ducky Programming Assistant](#ducky-programming-assistant)
  - [Naming Assistant](#naming-assistant)
  - [B1 Level German Conversation Partner](#b1-level-german-conversation-partner)
  - [Circuit Diagram Outputter](#circuit-diagram-outputter)
  - [Text Master Suno](#text-master-suno)
  - [AOSP Source Code Expert](#aosp-source-code-expert)
  - [Linux Kernel Expert](#linux-kernel-expert)
  - [Fastapi Project Development Assistant](#fastapi-project-development-assistant)
  - [IT Systems Architect](#it-systems-architect)
  - [NovelAI Drawing Assistant](#novelai-drawing-assistant-1)
  - [Pseudo Code Prompt Word Generator Expert](#pseudo-code-prompt-word-generator-expert)
  - [Mr. MySQL](#mr-mysql)
  - [Popular Science Writing Assistant](#popular-science-writing-assistant)
  - [Git Specialist with AI Assistant Functions](#git-specialist-with-ai-assistant-functions)
  - [Translation of Novels: English to Chinese](#translation-of-novels-english-to-chinese)
  - [Expert Response to Reviewer](#expert-response-to-reviewer)
  - [Convert Docker to Docker Compose](#convert-docker-to-docker-compose)
  - [Java Class to MySQL](#java-class-to-mysql)
  - [Chinese History Lecturer](#chinese-history-lecturer)
  - [C# .NET Technology Expert](#c-net-technology-expert)
  - [Node.js Optimizer](#nodejs-optimizer)
  - [Daily Assistant](#daily-assistant)
  - [Dart/Flutter Dev](#dartflutter-dev)
  - [Christian Missionary](#christian-missionary)
  - [Foreign Colleague Evaluation Assistant](#foreign-colleague-evaluation-assistant)
  - [SEO Optimization Expert](#seo-optimization-expert)
  - [Philosophical Analysis Assistant](#philosophical-analysis-assistant)
  - [Minecraft Command Instructor](#minecraft-command-instructor)
  - [Chinese Text Refinement Master](#chinese-text-refinement-master)
  - [Answer Assistant - First Principles Analysis](#answer-assistant---first-principles-analysis)
  - [Zen Master](#zen-master)
  - [Chinese Historian](#chinese-historian)
  - [Data Analyst Expert](#data-analyst-expert)
  - [JTBD Requirements Analysis Master](#jtbd-requirements-analysis-master)
  - [Master of Daoism](#master-of-daoism)
  - [Rust Language Learning Mentor](#rust-language-learning-mentor)
  - [Bahasa/English Translator](#bahasaenglish-translator)
  - [Geotechnical Engineering Assistant](#geotechnical-engineering-assistant)
  - [Confucian Scholar](#confucian-scholar)
  - [Study Abroad Planning Expert](#study-abroad-planning-expert)
  - [Python Buddy](#python-buddy)
  - [AWS Guru](#aws-guru)
  - [Linux Buddy](#linux-buddy)
  - [Photography Critic](#photography-critic)
  - [SEO Specialist](#seo-specialist)
  - [English Reading Teacher](#english-reading-teacher)
  - [Emotional Companion](#emotional-companion)
  - [Linguistic Luminary](#linguistic-luminary)
  - [Learning Plan Expert Silwol](#learning-plan-expert-silwol)
  - [SF Symbols Finder](#sf-symbols-finder)
  - [GhostWriter Pro](#ghostwriter-pro)
  - [Video to Blog Post Assistant](#video-to-blog-post-assistant)
  - [Art Evaluation Tutor](#art-evaluation-tutor)
  - [iOS Code Artist](#ios-code-artist)
  - [Sales Description Specialist](#sales-description-specialist)
  - [TailwindHelper](#tailwindhelper)
  - [Jailbreak Assistant DAN](#jailbreak-assistant-dan)
  - [yapi JSON-SCHEMA to Typescript](#yapi-json-schema-to-typescript)
  - [Chinese Academic Paper Editor](#chinese-academic-paper-editor)
  - [High School Science Study Assistant](#high-school-science-study-assistant)
  - [Master of Fortune Telling](#master-of-fortune-telling)
  - [Biology Professor](#biology-professor)
  - [SmartWeather Assistant](#smartweather-assistant)
  - [Healthy Recipe Recommender](#healthy-recipe-recommender)
  - [Microcontroller Engineer](#microcontroller-engineer)
  - [TadzGenius](#tadzgenius)
  - [Dirty Talk Learning Assistant](#dirty-talk-learning-assistant)
  - [Design Philosophy Analysis](#design-philosophy-analysis)
  - [YouTube Summary](#youtube-summary)
  - [Shell Script Development Assistant](#shell-script-development-assistant)
  - [Shopify Theme Development Engineer](#shopify-theme-development-engineer)
  - [Reseach title generator](#reseach-title-generator)
  - [English Technology Article Reading Assistant](#english-technology-article-reading-assistant)
  - [CAN](#can)
  - [Image Recognition Xiaohongshu Copywriting](#image-recognition-xiaohongshu-copywriting)
  - [Blood Test Analyst](#blood-test-analyst)
  - [Suno.ai Music Creation Assistant](#sunoai-music-creation-assistant)
  - [High EQ Flattery Assistant](#high-eq-flattery-assistant)
  - [Girlfriend Subtext Expert](#girlfriend-subtext-expert)
  - [Interview Question Refinement Assistant](#interview-question-refinement-assistant)
  - [Rap Lyric Master](#rap-lyric-master)
  - [Claim Analyzer](#claim-analyzer)
  - [Mdx SEO Expert](#mdx-seo-expert)
  - [Game Text Translator](#game-text-translator)
  - [Traditional Chinese Medicine Practitioner](#traditional-chinese-medicine-practitioner)
  - [Electronic Tutor](#electronic-tutor)
  - [Math Tutor](#math-tutor)
  - [Amazon Listing Copywriter](#amazon-listing-copywriter)
  - [User Research Manager - KANO](#user-research-manager---kano)
  - [Collaborative Logical Thinking Team](#collaborative-logical-thinking-team)
  - [PromptGPT](#promptgpt)
  - [Programming Maestro](#programming-maestro)
  - [Linux Solution Mentor](#linux-solution-mentor)
  - [English Vocabulary Teacher](#english-vocabulary-teacher)
  - [Prompt Architect](#prompt-architect)
  - [Drug Guide Expert](#drug-guide-expert)
  - [Amazon Seller Support Agent](#amazon-seller-support-agent)
  - [TikTok Script Writer](#tiktok-script-writer)
  - [Gen Z Engagement Specialist](#gen-z-engagement-specialist)
  - [Schedule Management Assistant](#schedule-management-assistant)
  - [Business Email Writing Expert](#business-email-writing-expert)
  - [Discord Style Copywriting Expert](#discord-style-copywriting-expert)
  - [AI Image Prompt Architect](#ai-image-prompt-architect)
  - [F1 Data Analyst](#f1-data-analyst)
  - [Software Development for Dummies](#software-development-for-dummies)
  - [Pitch Deck Maestro (Elevator Pitch)](#pitch-deck-maestro-elevator-pitch)
  - [Sous Chef](#sous-chef)
  - [English Composition Assistant](#english-composition-assistant)
  - [The Shaman](#the-shaman)
  - [Interview Coach](#interview-coach)
  - [Tech Explorer](#tech-explorer)
  - [Markdown Conversion Expert](#markdown-conversion-expert-1)
  - [Your very own domene.no expert](#your-very-own-domeneno-expert)
  - [Soccer-Conversant AI Companion](#soccer-conversant-ai-companion)
  - [Prisma Data Generation Expert](#prisma-data-generation-expert)
  - [GitHub Finder](#github-finder)
  - [Naming Expert](#naming-expert)
  - [LobeChat Technical Documentation Expert](#lobechat-technical-documentation-expert)
  - [Your daily AI companion.](#your-daily-ai-companion)
  - [ThinkTank360](#thinktank360)
  - [Jira Story Facilitator](#jira-story-facilitator)
  - [Facebook Advertising Writing Expert](#facebook-advertising-writing-expert)
  - [Translation Specialist](#translation-specialist)
  - [SPI Generator](#spi-generator)
  - [Product Review](#product-review)
  - [Self-Media Operation Expert](#self-media-operation-expert)
  - [Product Copywriting](#product-copywriting)
  - [Private Domain Operations Expert](#private-domain-operations-expert)
  - [Product Description](#product-description)
  - [Happy Loong Year](#happy-loong-year)
  - [Tarot Reader](#tarot-reader)
  - [English Proficiency Evaluator](#english-proficiency-evaluator)
  - [Vocabulary Generator](#vocabulary-generator)
  - [Grammar Worksheet Creator](#grammar-worksheet-creator)
  - [Turkish Language Tutor](#turkish-language-tutor)
  - [Glossary Generator](#glossary-generator)
  - [Vocabulary Wizard](#vocabulary-wizard)
  - [Vocabulary Worksheet Wizard](#vocabulary-worksheet-wizard)
  - [Thematic Vocabulary Worksheet Creator](#thematic-vocabulary-worksheet-creator)
  - [Reading Comprehension Wizard](#reading-comprehension-wizard)
  - [Cloze Exercise Generator](#cloze-exercise-generator)
  - [Website Audit Assistant](#website-audit-assistant)
  - [Turkish/English Translator](#turkishenglish-translator)
  - [Text Variator](#text-variator)
  - [Socratic Teacher](#socratic-teacher)
  - [Writing Assistant](#writing-assistant)
  - [Language Fixer](#language-fixer)
  - [Golang Architect](#golang-architect)
  - [CAN: Code Master](#can-code-master)
  - [Marvin](#marvin)
  - [Form Checker](#form-checker)
  - [Database Expert](#database-expert)
  - [Presentation Wizard](#presentation-wizard)
  - [SagePathfinder](#sagepathfinder)
  - [Variable Naming Master](#variable-naming-master)
  - [Mathematical Research Advisor](#mathematical-research-advisor)
  - [A2 English Conversation Facilitator](#a2-english-conversation-facilitator)
  - [C1 Level English Language Facilitator](#c1-level-english-language-facilitator)
  - [Entrepreneurship and Competitiveness Expert](#entrepreneurship-and-competitiveness-expert)
  - [English Proficiency Coach](#english-proficiency-coach)
  - [English Language C1 Mastery Coach](#english-language-c1-mastery-coach)
  - [Xiaohongshu Review Assistant](#xiaohongshu-review-assistant)
  - [Bizkaia Entrepreneurship Expert](#bizkaia-entrepreneurship-expert)
  - [Software Architecture Strategist](#software-architecture-strategist)
  - [Territory Promotion Strategist](#territory-promotion-strategist)
  - [Poetry Mentor](#poetry-mentor)
  - [Software Development Step Maker](#software-development-step-maker)
  - [Poetry Guide: Inspiring poetic expression and appreciation.](#poetry-guide-inspiring-poetic-expression-and-appreciation)
  - [Rap Instructor](#rap-instructor)
  - [English Learning Companion](#english-learning-companion)
  - [Geopolitical Analyst](#geopolitical-analyst)
  - [B2 Level English Conversation Partner](#b2-level-english-conversation-partner)
  - [Jamaican Patois Instructor](#jamaican-patois-instructor)
  - [Slang Tutor](#slang-tutor)
  - [B1 English Conversation Partner](#b1-english-conversation-partner)
  - [Steam Game Reviews](#steam-game-reviews)
  - [Bilibili Assistant](#bilibili-assistant)
  - [OpenAPI Generator](#openapi-generator)
  - [Culinary AI Mentor](#culinary-ai-mentor)
  - [AI Import/Export Advisor](#ai-importexport-advisor)
  - [Songwriting Mentor](#songwriting-mentor)
  - [ShieldsIO Badge Generator](#shieldsio-badge-generator)
  - [TaxBot](#taxbot)
  - [Text Summarization Assistant](#text-summarization-assistant)
  - [React Native Coding Guide](#react-native-coding-guide)
  - [Figure Designer](#figure-designer)
  - [Intent Resonance GPT](#intent-resonance-gpt)
  - [Startup Tech Lawyer](#startup-tech-lawyer)
  - [Shopping Assistant](#shopping-assistant)
  - [DIY Guide Assistant](#diy-guide-assistant)
  - [Chinese-Japanese Bilingual Translation Expert](#chinese-japanese-bilingual-translation-expert)
  - [IELTS Tutor](#ielts-tutor)
  - [Accounting Expert Assistant](#accounting-expert-assistant)
  - [Business Guru](#business-guru)
  - [EOI Exam Preparation Assistant](#eoi-exam-preparation-assistant)
  - [Grass Deity Naxida](#grass-deity-naxida)
  - [Financial Expert](#financial-expert)
  - [Tech Explorer AI](#tech-explorer-ai)
  - [PromptGPT](#promptgpt-1)
  - [AE Script Development Expert](#ae-script-development-expert)
  - [Code Companion](#code-companion)
  - [William](#william)
  - [Chad](#chad)
  - [SEO Optimized Blog](#seo-optimized-blog)
  - [Life Decision Advisor](#life-decision-advisor)
  - [English Analyst](#english-analyst)
  - [Computer Science Paper Proofreading](#computer-science-paper-proofreading)
  - [Emoji Generator](#emoji-generator)
  - [Personal Growth Coach](#personal-growth-coach)
  - [Performance Evaluation Superhero](#performance-evaluation-superhero)
  - [SVG Flowchart Explanation Assistant](#svg-flowchart-explanation-assistant)
  - [Weekly Report Assistant](#weekly-report-assistant)
  - [3D Animation Engineer](#3d-animation-engineer)
  - [Amazon Title Assistant](#amazon-title-assistant)
  - [Teaching Mentor](#teaching-mentor)
  - [Exam Assistant](#exam-assistant)
  - [TOEFL Writing Tutor](#toefl-writing-tutor)
  - [MidjourneyGPT](#midjourneygpt)
  - [Overview of Art Thesis Experts](#overview-of-art-thesis-experts)
  - [Deployment Specialist Agent](#deployment-specialist-agent)
  - [American English Transcreation Expert](#american-english-transcreation-expert)
  - [Academic Proofreading Expert](#academic-proofreading-expert)
  - [Flutter Maestro](#flutter-maestro)
  - [Facebook Ads Expert](#facebook-ads-expert)
  - [News Hub](#news-hub)
  - [Travel Assistant](#travel-assistant)
  - [Research Assistant](#research-assistant)
  - [Dream Painter](#dream-painter)
  - [Criminal Defense Expert](#criminal-defense-expert)
  - [Holiday Greetings](#holiday-greetings)
  - [Real Estate Agent](#real-estate-agent)
  - [Case Generator](#case-generator)
  - [Short Book](#short-book)
  - [Rust Programming Assistant](#rust-programming-assistant)
  - [Case Solver](#case-solver)
  - [Community Manager](#community-manager)
  - [Stable Diffusion Prompts Crafter](#stable-diffusion-prompts-crafter)
  - [Payroll Game](#payroll-game)
  - [Dream Analyst](#dream-analyst)
  - [English Translation Expert](#english-translation-expert)
  - [Python Coder Gradio](#python-coder-gradio)
  - [GitHub Copilot](#github-copilot)
  - [Pollinate AI drawing](#pollinate-ai-drawing)
  - [Recipe Generator](#recipe-generator)
  - [HTTP Request Master](#http-request-master)
  - [Code Wizard](#code-wizard)
  - [Mr. Feynman](#mr-feynman)
  - [Organic Chemistry Researcher](#organic-chemistry-researcher)
  - [LobeChat Test Engineer](#lobechat-test-engineer)
  - [Q\&A Document Conversion Expert](#qa-document-conversion-expert)
  - [JS Code Quality Optimization](#js-code-quality-optimization)
  - [True Friend](#true-friend)
  - [Short Video Script Assistant](#short-video-script-assistant)
  - [Expert Agent Mentor](#expert-agent-mentor)
  - [Graphic Creative Master](#graphic-creative-master)
  - [Full-stack Developer](#full-stack-developer)
  - [Tailwind Wizard](#tailwind-wizard)
  - [Translation Assistant](#translation-assistant)
  - [Research Article Translation Assistant](#research-article-translation-assistant)
  - [MidJourney Prompt](#midjourney-prompt)
  - [Dad, What Should I Do?](#dad-what-should-i-do)
  - [Academic Writing Enhancement Bot](#academic-writing-enhancement-bot)
  - [Sketch Feature Summary Expert](#sketch-feature-summary-expert)
  - [Master of Debating](#master-of-debating)
  - [Graph Generator](#graph-generator)
  - [Master of Naming](#master-of-naming)
  - [Xiaohongshu Style Copywriter](#xiaohongshu-style-copywriter)
  - [English News Translation Expert](#english-news-translation-expert)
  - [GPT Agent Prompt Optimization Expert](#gpt-agent-prompt-optimization-expert)
  - [C++ Code](#c-code)
  - [TS Type Definition Completion](#ts-type-definition-completion)
  - [LOGO Creative Master](#logo-creative-master)
  - [Interface Type Request Generator](#interface-type-request-generator)
  - [Name Master](#name-master)
  - [Web Content Summarization Expert](#web-content-summarization-expert)
  - [Zustand Reducer Expert](#zustand-reducer-expert)
  - [Master of Expressing Abstract Concepts](#master-of-expressing-abstract-concepts)
  - [UX Writer](#ux-writer)
  - [UX Writer](#ux-writer-1)
  - [API Documentation Expert](#api-documentation-expert)
  - [Title Expansion Expert](#title-expansion-expert)
  - [JS to TS Expert](#js-to-ts-expert)
  - [Frontend TypeScript Unit Testing Expert](#frontend-typescript-unit-testing-expert)
  - [Front-end Development Architect](#front-end-development-architect)
  - [Information Organizer](#information-organizer)
  - [Convert React Class Components to Functional Components](#convert-react-class-components-to-functional-components)
  - [Dva Refactor Zustand Expert](#dva-refactor-zustand-expert)
  - [Markdown Product Feature Formatting Expert](#markdown-product-feature-formatting-expert)
  - [Deep Think](#deep-think)
  - [Coding Wizard](#coding-wizard)
  - [Resume Editing](#resume-editing)
  - [Character Roleplay](#character-roleplay)
  - [Web Development](#web-development)
  - [Grammar Corrector](#grammar-corrector)
  - [Agent Prompt Improver](#agent-prompt-improver)
  - [Essay Improver](#essay-improver)
  - [Startup Plan](#startup-plan)
  - [Stable Diffusion Prompt Expert](#stable-diffusion-prompt-expert)
- [🛳 Self Hosting](#-self-hosting)
  - [Deploy to Vercel](#deploy-to-vercel)
- [⌨️ Local Development](#️-local-development)
- [🤝 Contributing](#-contributing)
- [🔗 Links](#-links)

####

</details>

## 🚀 How to Submit your Agent

You can submit through [**Submit Your Agent**][submit], or use the following steps

### Step-by-step Instructions

If you wish to add an agent onto the index, make an entry in `agents` directory using `agent-template.json` or `agent-template-full.json`, write a short description and tag it appropriately then open as a pull request ty!

1. <kbd>Fork</kbd> of this repository.
2. Make a copy of `agent-template.json` or `agent-template-full.json`
3. Fill in the copy and rename it appropriately
4. Move it into `src` directory
5. Submit a pull request and wait for review.

> \[!IMPORTANT]\
> The `createAt` date will be automatically populated after merge. Please choose the appropriate parameter configuration from `agent-template-full.json` based on your specific needs. This file provides a more comprehensive set of parameters for customization.

> \[!NOTE]
>
> - Not all agents will be accepted, we will review the agent and make an assessment.
> - You can submit agents even if you are not the author, but it is preferred that the author do it themselves.
> - If you wish to have your agent removed, or believes the description does not properly describe your agent, please open the issue or pull request.

<div align="right">

[![][back-to-top]](#readme-top)

</div>

## 🕶 Awesome Prompts

<!-- AWESOME PROMPTS -->

### Xiaohongshu Copywriting Generator

<sup>By **[@bestZwei](https://github.com/bestZwei)** on **2024-11-26**</sup>

Specializes in emotionally charged accusatory copywriting

`Copywriting` `Xiaohongshu` `Emotional Release`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Bilingual Dictionary Expert

<sup>By **[@swarfte](https://github.com/swarfte)** on **2024-11-26**</sup>

Expert in bilingual English-Chinese vocabulary translation and analysis

`translation` `language-learning` `vocabulary` `dictionary`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Interviewer's Assistant

<sup>By **[@xandertang](https://github.com/Dr-T)** on **2024-11-26**</sup>

Proficient in designing and evaluating interview questions for product managers, generating interview questions based on resume interpretation results.

`Interview` `Resume` `Recruitment` `Efficiency`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Backend Development Assistant

<sup>By **[@zeno980](https://github.com/zeno980)** on **2024-11-26**</sup>

Skilled in backend development tasks

`Backend Development` `AI Technology` `Web Applications` `Spring` `SQL`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### All Translation Assistant (with Phonetic Symbols)

<sup>By **[@HttpStatusOK](https://github.com/HttpStatusOK)** on **2024-11-26**</sup>

This is a tool that integrates translation and phonetic symbols, aimed at helping users learn words better during translation.

`Translation` `Language Learning`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Rebecca, Mental Health Counselor

<sup>By **[@Kod3c](https://github.com/Kod3c)** on **2024-11-26**</sup>

Specializing in mental health counseling and therapeutic techniques

`therapy` `mental-health` `counseling` `emotional-support`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### SSC Incremental

<sup>By **[@Base03](https://github.com/Base03)** on **2024-11-26**</sup>

Claude minus the Reddit

`technology` `analysis` `software` `ai` `research`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Human Author Simulator

<sup>By **[@yufei96](https://github.com/yufei96)** on **2024-11-20**</sup>

Eliminate the characteristics of AI-generated content

`AI Interaction` `Writing` `Optimization` `Consultation`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Text Improver

<sup>By **[@davletsh1n](https://github.com/davletsh1n)** on **2024-11-20**</sup>

Expert in text enhancement and error

`chatbot` `editing` `text-improvement` `ai-assistant`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Yin-Yang Master

<sup>By **[@TiancongLx](https://github.com/TiancongLx)** on **2024-11-20**</sup>

Isn't it just mutual yin-yang sarcasm? Come join the fun! (Prompt inspired by X [Baoyu](https://x.com/dotey/status/1852207423324340567) teacher)

`Logic Problems` `Black Humor` `Sharp Criticism`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Master E's Tech Executive Assistant (EA)

<sup>By **[@ApexAppdevelopment](https://github.com/ApexAppdevelopment)** on **2024-11-20**</sup>

Highly intelligent and loyal Executive Assistant (EA) specializing in software engineering support and strategic solutions for Master E.

`executive-assistant` `software-engineering` `project-management` `technical-support` `optimization`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Prompt Keywords

<sup>By **[@qw1295353129](https://github.com/qw1295353129)** on **2024-11-20**</sup>

Prompt Keywords

`prompt keywords`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Wisdom Guide

<sup>By **[@changjiong](https://github.com/changjiong)** on **2024-11-20**</sup>

Skilled in Guidance

`Life Coaching` `Philosophical Reflection` `Consultation` `Heuristic Dialogue`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Minimalist Black and White Illustration

<sup>By **[@Justin3go](https://github.com/Justin3go)** on **2024-11-20**</sup>

Skilled in illustration creation and style transformation

`illustration` `art` `design`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Illustrative Writer

<sup>By **[@Igroshka](https://github.com/Igroshka)** on **2024-11-20**</sup>

I write texts with illustrations, clarify requests, edit and refine

`image-generation` `ai-assistant` `neural-networks` `drawing` `stories` `reading` `narrative` `writer`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Thinking Claude

<sup>By **[@AnoyiX](https://github.com/AnoyiX)** on **2024-11-14**</sup>

Let Claude think comprehensively before responding!

`common`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Workplace Psychology Analysis Expert

<sup>By **[@lazzman](https://github.com/lazzman)** on **2024-10-29**</sup>

A psychology expert used to analyze the underlying psychological motivations behind people's behaviors in the workplace, possible motivation analysis

`Behavior Analysis` `Workplace Psychology` `Motivation`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Print to Table

<sup>By **[@printtotable](https://github.com/printtotable)** on **2024-10-29**</sup>

Transform data from images into organized tables in Excel.

`data-extraction` `tables` `advertising` `influencer` `excel`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Ultra Flux Prompter

<sup>By **[@davletsh1n](https://github.com/davletsh1n)** on **2024-10-29**</sup>

Skilled in enhancing image generation prompts with vivid details and context.

`image-generation` `prompt-crafting` `writing` `cre`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Text RPG Host

<sup>By **[@NTLx](https://github.com/NTLx)** on **2024-10-29**</sup>

Specializes in hosting sci-fi text RPG games and guiding narratives

`Game` `Role-Playing` `Science Fiction` `Text Adventure` `Narrative Driven`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Machine Vision LaTeX

<sup>By **[@5xiao0qing5](https://github.com/5xiao0qing5)** on **2024-10-29**</sup>

Specializes in explaining concepts of machine learning and deep learning

`Machine Learning` `Deep Learning` `Image Processing` `Computer Vision` `LaTeX`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Software Architecture and Engineering Expert

<sup>By **[@fjhdream](https://github.com/fjhdream)** on **2024-10-29**</sup>

Skilled in providing programming and software guidance, with expertise in computer science and software engineering.

`programming` `software` `computer-literacy` `consulting` `expertise`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Domain Analysis Master

<sup>By **[@ccbikai](https://github.com/ccbikai)** on **2024-10-29**</sup>

Expert in domain analysis and humorous suggestions

`domain analysis` `humor` `culture` `website suggestions` `purchase advice`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Ingo Hausmann

<sup>By **[@bionicprompter](https://github.com/bionicprompter)** on **2024-10-29**</sup>

Ingo Hausmann wants to be advised on a new purchase of PCs

`company` `hardware` `needs assessment` `it` `applications`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Vector Logo Generator

<sup>By **[@Justin3go](https://github.com/Justin3go)** on **2024-10-27**</sup>

Specializing in UI/UX design and logo creation

`ui-ux design` `logo design` `user needs` `interaction design` `tool usage`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Psychologist

<sup>By **[@JIANGTUNAN](https://github.com/JIANGTUNAN)** on **2024-10-21**</sup>

An experienced psychologist, warmly and patiently listening to your story.

`psychological counseling` `consultation` `sharing` `friendly` `doctor` `counselor`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Algorithm Answer Mentor

<sup>By **[@Stark-X](https://github.com/Stark-X)** on **2024-10-21**</sup>

Specializes in LeetCode algorithm solutions and user guidance

`algorithm` `problem-solving` `programming` `education`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Master of the I Ching

<sup>By **[@stephonye](https://github.com/stephonye)** on **2024-10-21**</sup>

Specializes in I Ching hexagram divination and SVG card generation

`Entertainment` `Games` `Life`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Coconut

<sup>By **[@hia1234](https://github.com/hia1234)** on **2024-10-15**</sup>

A chatbot that undergoes several reviews of its responses, checking whether there is a basis for its statements and actively requesting feedback while engaging in repeated interactions.

`Programming` `General`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Boxing Training Master

<sup>By **[@Luyi-2333](https://github.com/Luyi-2333)** on **2024-10-15**</sup>

Expert in boxing training guidance and personalized plan development

`boxing training` `personalized plans` `fitness guidance` `progress evaluation` `technique improvement` `health and nutrition`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Xilinx FPGA Solutions Expert

<sup>By **[@yuphone](https://github.com/yuphone)** on **2024-10-14**</sup>

Specializes in Xilinx FPGA solution design and implementation

`fpga` `hardware design` `system architecture` `technical consulting` `electronic engineering`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Semiconductor Text Optimization Expert

<sup>By **[@yuphone](https://github.com/yuphone)** on **2024-10-14**</sup>

Specializes in text optimization and standardized writing in the semiconductor industry

`Text Optimization` `Industry Expertise` `Grammar Correction` `Logic Improvement` `Standardized Writing`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Ophthalmologist

<sup>By **[@yuphone](https://github.com/yuphone)** on **2024-10-14**</sup>

Specializes in ophthalmic diagnosis and treatment recommendations

`Healthcare` `Ophthalmology` `Diagnosis` `Recommendations` `Professional`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Wireless Communication Expert

<sup>By **[@yuphone](https://github.com/yuphone)** on **2024-10-14**</sup>

Specializes in wireless communication technology, proficient in industry knowledge from 4G to 6G

`Communication Technology` `Expert` `Consulting` `4-g` `5-g`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### GitHub Project Documentation Assistant

<sup>By **[@Luyi-2333](https://github.com/Luyi-2333)** on **2024-10-14**</sup>

Focused on writing and optimizing documentation for open source projects

`Documentation Optimization` `Open Source Projects` `Writing Techniques` `git-hub`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Fitness Expert

<sup>By **[@Lockeysama](https://github.com/Lockeysama)** on **2024-10-08**</sup>

Knowledgeable fitness expert

`fitness` `consultation` `lifestyle issues` `advice`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Mistaker

<sup>By **[@Vork-IT](https://github.com/Vork-IT)** on **2024-10-08**</sup>

killed in clear explanations and examples of grammar and pronunciation.

`english`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Code Optimization/Error Correction

<sup>By **[@alphandbelt](https://github.com/alphandbelt)** on **2024-10-08**</sup>

Proficient in multiple programming languages, optimizing code structure, fixing errors, and providing elegant solutions.

`Code Optimization` `Error Correction` `Multiple Programming Languages`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Ethical Security Analyst

<sup>By **[@ayeantics](https://github.com/ayeantics)** on **2024-10-08**</sup>

Specializes in identifying and mitigating security vulnerabilities in web and mobile platforms.

`cybersecurity` `ethical-hacking` `vulnerability-assessment` `consulting` `technical-assistance`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Minimal Artifact Architect

<sup>By **[@yaleh](https://github.com/yaleh)** on **2024-10-06**</sup>

Expert in evaluating and creating reusable content artifacts

`content-creation` `artifact-management` `conversation-design`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Principled Problem Solver

<sup>By **[@ShinChven](https://github.com/ShinChven)** on **2024-10-05**</sup>

Excellent at principled problem-solving and categorization. Chain of Thought agent

`problem-solving` `categorization` `reasoning` `chain-of-thought`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### JSON Prompt Generator

<sup>By **[@yaleh](https://github.com/yaleh)** on **2024-10-05**</sup>

Expert in generating JSON-formatted prompts for task execution.

`task-analysis` `json-generation` `prompt-engineering`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### C++/Qt

<sup>By **[@liangyuR](https://github.com/liangyuR)** on **2024-09-30**</sup>

Excels in teaching C++/Qt coding practices

`c` `qt`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Death Anniversary Messages

<sup>By **[@tcmonster](https://github.com/tcmonster)** on **2024-09-29**</sup>

Specializes in crafting sensitive and heartfelt Death Anniversary messages with compassion and empathy.

`condolences` `message-composition` `grief-support` `cultural-awareness` `emotional-sensitivity`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Flux Prompt Generator

<sup>By **[@tcmonster](https://github.com/tcmonster)** on **2024-09-29**</sup>

Flux Prompt Generation Assistant: Expert in crafting detailed, creative prompts for high-quality image outputs from the Flux model.

`prompt-generation` `image-generation` `art-style` `creativity` `crafting`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Master of Retorts

<sup>By **[@YWJCJ](https://github.com/YWJCJ)** on **2024-09-29**</sup>

A professional debate expert, skilled in quick rebuttals and humorous responses.

`debate` `communication` `humor` `analysis` `expression`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Runway Gen-3 Prompt Generator

<sup>By **[@tcmonster](https://github.com/tcmonster)** on **2024-09-29**</sup>

Expert in generating structured Runway Gen-3 prompts for AI-generated videos.

`ai-model` `text-to-video` `prompt-generation` `expert` `video-production`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### God Bless You Messages

<sup>By **[@tcmonster](https://github.com/tcmonster)** on **2024-09-29**</sup>

Expert in crafting personalized "God Bless You" messages with spiritual sensitivity and language mastery.

`message-composition` `personalization` `spiritual-sensitivity` `language-mastery` `interaction-approach`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### This Makes Sense

<sup>By **[@Victor94-king](https://github.com/Victor94-king)** on **2024-09-29**</sup>

The world through the eyes of a neurotic, "This makes sense!"

`Creative Card`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Birthday Invitation Messages

<sup>By **[@tcmonster](https://github.com/tcmonster)** on **2024-09-29**</sup>

Specializes in crafting engaging and personalized Birthday Invitation messages, catering to various themes and tones.

`message-composition` `personalization` `tone-versatility` `event-detail-integration` `interaction-approach`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### LaTeX Academic Paper Summary Assistant

<sup>By **[@LeGibet](https://github.com/LeGibet)** on **2024-09-29**</sup>

Skilled in analyzing academic papers and generating structured English summary reports

`Academic Analysis` `Paper Summary` `Research Translation`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Nice Short Sunday Messages

<sup>By **[@tcmonster](https://github.com/tcmonster)** on **2024-09-29**</sup>

Sunday Message Companion crafting uplifting, faith-based messages to strengthen community bonds and spread positivity.

`writing` `spirituality` `community` `faith` `consulting`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Meeting Assistant v1.0

<sup>By **[@houhoufm](https://github.com/houhoufm)** on **2024-09-24**</sup>

Professional meeting report assistant, distilling meeting key points into report sentences

`Meeting Reports` `Writing` `Communication` `Workflow` `Professional Skills`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### PPT Optimization Expert v1.0

<sup>By **[@houhoufm](https://github.com/houhoufm)** on **2024-09-24**</sup>

Professional PPT report material optimization expert

`ppt optimization` `copywriting` `professional consulting`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Contract Clause Refiner v1.0

<sup>By **[@houhoufm](https://github.com/houhoufm)** on **2024-09-24**</sup>

Output: {Optimize contract clauses for professional and concise expression}

`Contract Optimization` `Legal Consultation` `Copywriting` `Terminology` `Project Management`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### I Ching Divination Master

<sup>By **[@XHB-111](https://github.com/XHB-111)** on **2024-09-24**</sup>

I, the humble practitioner of Xuan Yi, respectfully follow the teachings of the sages. Using the sixty-four hexagrams as a mirror, I observe the universe and analyze human affairs. If you have any doubts or difficulties, feel free to share, and together we will draw on the wisdom of our ancestors to guide you.

`I Ching Divination` `Xuan Yi` `I Ching Studies` `Wisdom` `Hexagrams`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Stable Album Cover Prompter

<sup>By **[@MellowTrixX](https://github.com/MellowTrixX)** on **2024-09-24**</sup>

Professional graphic designer for front cover design specializing in creating visual concepts and designs for melodic techno music albums.

`album-cover` `prompt` `stable-diffusion` `cover-design` `cover-prompts`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Idea Architect

<sup>By **[@yaleh](https://github.com/yaleh)** on **2024-09-23**</sup>

Expert in generating logical and coherent thought chains on various topics.

`writing` `thinking` `analysis` `critical-thinking` `education`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Copy Optimization Assistant

<sup>By **[@xinyuqq](https://github.com/xinyuqq)** on **2024-09-23**</sup>

A senior assistant skilled in refining copy

`copy`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Joi

<sup>By **[@blainehuang1028](https://github.com/blainehuang1028)** on **2024-09-23**</sup>

Your personal travel assistant, skilled in planning itineraries and recommending accommodations and activities

`travel assistant` `planning` `recommendations` `personalized suggestions`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Minimal Translation Assistant

<sup>By **[@leter](https://github.com/leter)** on **2024-09-23**</sup>

A minimal translation tool, proficient in Chinese-English translation

`Translation Tool` `Rules` `Simplicity` `Efficiency`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Exam Essay Writing Master

<sup>By **[@NriotHrreion](https://github.com/NriotHrreion)** on **2024-09-23**</sup>

A master of writing exam essays who excels in crafting high-scoring compositions.

`Education` `Essay` `Writing`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### UI/UX designer

<sup>By **[@leter](https://github.com/leter)** on **2024-09-23**</sup>

world-class UI/UX designer with extensive experience

`ui` `ux` `design-system`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### COSTAR Framework Writer

<sup>By **[@WuKaiYi](https://github.com/WuKaiYi)** on **2024-09-23**</sup>

Skilled in writing COSTAR Framework prompts

`costar-framework-prompt` `writing` `guidance` `instructions` `system conversion`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Chinese Translator

<sup>By **[@ChaneyChokin](https://github.com/ChaneyChokin)** on **2024-09-23**</sup>

Expert in Chinese translation, editing, spelling correction, and improvement

`translation` `editing` `language` `correction` `Simplified Chinese`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Advertising Copywriting Master

<sup>By **[@leter](https://github.com/leter)** on **2024-09-23**</sup>

Specializing in product function analysis and advertising copywriting that resonates with user values

`Advertising Copy` `User Values` `Marketing Strategy`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Vim Mastery Mentor

<sup>By **[@hrithikt](https://github.com/hrithikt)** on **2024-09-23**</sup>

Skilled Vim expert providing clear, concise solutions and tips for users at all levels.

`vim` `expert` `assistant` `helpful` `queries`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Duolingo English Essay Assistant

<sup>By **[@tempest2023](https://github.com/tempest2023)** on **2024-09-23**</sup>

Specializes in scoring and guiding Duolingo English essays

`Writing Guidance` `Scoring` `Revisions` `Education` `English Learning`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Fitness Guru

<sup>By **[@Arragon](https://github.com/Arragon)** on **2024-09-23**</sup>

Pursuing the Classical Beauty of Greece

`Health` `Advice` `Consultation` `Teaching`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Markdown Conversion Expert

<sup>By **[@cl1107](https://github.com/cl1107)** on **2024-09-23**</sup>

Proficient in using Markdown syntax for text structuring and emphasis

`text structure` `markdown syntax` `headings` `lists` `bold` `quote` `agulu`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### NovelAI Drawing Assistant

<sup>By **[@samihalawa](https://github.com/samihalawa)** on **2024-09-23**</sup>

I can turn the scenes you describe into prompts for NovelAI

`deep-learning` `image-generation` `algorithm` `prompt`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Git Commit Summary Expert

<sup>By **[@cjahv](https://github.com/cjahv)** on **2024-09-23**</sup>

Git Commit Summary Expert

`programming` `git commit` `English`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### GitHub Project Analyst

<sup>By **[@dlzmoe](https://github.com/dlzmoe)** on **2024-09-23**</sup>

Skilled in GitHub project analysis and report writing

`git-hub-analysis` `crawler-technology` `project-report`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Web Expert

<sup>By **[@gfreezy](https://github.com/gfreezy)** on **2024-09-23**</sup>

Expert in web development with a focus on tool selection, incremental changes, code review, security, and operational considerations.

`web-development` `css` `java-script` `react` `node-js` `code-review`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### English Word Analysis and Memory Expert

<sup>By **[@epochaudio](https://github.com/epochaudio)** on **2024-09-23**</sup>

Specializes in bilingual education, analyzing the meanings, example sentences, roots and affixes, historical background, and memory techniques of English words.

`English words` `meaning analysis` `example sentences` `roots and affixes`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Civil Law Consultant

<sup>By **[@carlosgasparini874](https://github.com/carlosgasparini874)** on **2024-09-23**</sup>

Specialist in legal consulting in Brazilian civil law. Answers questions based on legislation, doctrine, and jurisprudence.

`legal-consulting` `civil-law` `answers` `sources` `brazil`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Python Development Master

<sup>By **[@SAnBlog](https://github.com/SAnBlog)** on **2024-09-23**</sup>

Expert in Python development, focusing on efficient and concise code, with an emphasis on security and maintainability

`python development` `programming` `code review` `security` `software engineering`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Image Prompt Expander

<sup>By **[@SpeedupMaster](https://github.com/SpeedupMaster)** on **2024-09-23**</sup>

Skilled at crafting vivid and specific prompts for image generation

`Image Generation` `Prompt Expansion` `Creative Writing` `Rich in Detail` `Scene Building`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Smart Search Assistant

<sup>By **[@liuwei-fdu](https://github.com/liuwei-fdu)** on **2024-09-23**</sup>

An AI assistant skilled in web search and information organization

`Smart Assistant` `Search Engine` `Information Organization` `User Experience`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Book Summary Expert

<sup>By **[@saccohuo](https://github.com/saccohuo)** on **2024-09-23**</sup>

A book summary expert providing concise and easy-to-read book summaries and structured outputs.

`book summary` `expert` `reading` `assistant`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Django Development Expert

<sup>By **[@genitop-lery](https://github.com/genitop-lery)** on **2024-09-23**</sup>

Prompts for developing Django projects

`python` `django`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Prompt Master AI

<sup>By **[@thedivergentai](https://github.com/thedivergentai)** on **2024-09-23**</sup>

Transforming your creative concepts into detailed, context-rich prompts that inspire stunning and realistic visuals

`ai` `prompting` `generating` `enhancing` `consulting`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Japanese Translator

<sup>By **[@ChaneyChokin](https://github.com/ChaneyChokin)** on **2024-09-23**</sup>

Specializes in Japanese translation, editing, spelling correction, and enhancement, responding in advanced Japanese while maintaining the original meaning.

`Japanese Translation` `Editing` `Proofreading`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Stack Overflow Programming Expert

<sup>By **[@Stark-X](https://github.com/Stark-X)** on **2024-09-23**</sup>

Familiar with multiple programming languages, including Golang, Python, Java, and Vue.js. Proficient in answering programming questions with clear and logical language, and providing solutions. Possesses effective communication, code review, and quick learning abilities for new skills.

`Programming` `Expert` `Programming Languages`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Nutrition Analyzer

<sup>By **[@Pandurangmopgar](https://github.com/Pandurangmopgar)** on **2024-09-23**</sup>

Nutri Info is an AI-powered nutrition assistant that analyzes food images and nutrition labels, providing simple explanations of nutritional content, benefits, and potential downsides. It offers personalized dietary advice and answers nutrition-related questions.

`nutrition` `ai` `health` `food-analysis` `meal-planning`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Text Rewriting Master

<sup>By **[@XHB-111](https://github.com/XHB-111)** on **2024-09-23**</sup>

The strongest AI rewriting tool ever! Complete violent rewriting in one minute, imitate public account articles, create a headline article production line, generate Bilibili video scripts, write Xiaohongshu copy, optimize online literature writing, polish reports, papers, and translated texts, and generate SEO articles in bulk...

`Writing` `Rewriting` `Dialogue` `Copy`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Wise Mentor

<sup>By **[@farsightlin](https://github.com/farsightlin)** on **2024-09-23**</sup>

An absolutely objective sage, focused on facts, indifferent to users, yet sincerely loving towards them.

`wise-mentor`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Perfect Translation \[Chinese-English; English-Chinese]

<sup>By **[@1137882300](https://github.com/1137882300)** on **2024-09-23**</sup>

Error-free translation assistant

`Translation` `Chinese-English`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Full Stack Engineer - F

<sup>By **[@BlockLune](https://github.com/BlockLune)** on **2024-09-23**</sup>

A full stack engineer with code name F.

`vue` `pinia` `element-plus` `nuxt-js` `react` `redux` `ant-design` `next-js` `axios` `tailwind-css` `spring` `dot-net` `docker`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Life Coach

<sup>By **[@jorben](https://github.com/jorben)** on **2024-09-23**</sup>

An expert coach skilled in guiding thoughts and helping explore the meaning of life

`coach` `psychological counseling` `meaning of life` `self-exploration` `mental health`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### World Creator Simulator

<sup>By **[@jskherman](https://github.com/jskherman)** on **2024-09-23**</sup>

based on `world_sim` by Nous Research

`roleplay` `specialist` `simulator` `terminal`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### CEO GPT

<sup>By **[@leter](https://github.com/leter)** on **2024-09-23**</sup>

AI mentor trained to advise startup CEOs based on the experiences

`entrepreneurship` `consulting` `management` `strategy` `guidance`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Excel Formula Master

<sup>By **[@SLKun](https://github.com/SLKun)** on **2024-09-23**</sup>

Excel Formula Master

`excel` `formula` `solution`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Next.js Expert Consultant

<sup>By **[@saralapujar](https://github.com/saralapujar)** on **2024-09-23**</sup>

Specializing in Next.js development, optimization, and consulting.

`next-js` `react` `web-development` `java-script` `consulting` `optimization` `full-stack-development`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Database Naming Assistant

<sup>By **[@ppzhuya](https://github.com/ppzhuya)** on **2024-09-20**</sup>

Input a Chinese word, and I will provide five professional English terms for database design fields.

`database` `naming` `translation` `development` `programming`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Master of Structured Expression

<sup>By **[@marvin202303](https://github.com/marvin202303)** on **2024-09-19**</sup>

Extract and reconstruct implicit thinking, visually output structured thinking.

`structured thinking` `communication` `logic` `thinking training` `books`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Xiaohongshu Copywriting

<sup>By **[@SAnBlog](https://github.com/SAnBlog)** on **2024-09-19**</sup>

Master of Xiaohongshu Viral Copy, Crafting Titles with Flair

`Xiaohongshu` `Content Creation` `Title Writing` `Copywriting` `Social Media Marketing`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Project Naming Master

<sup>By **[@QuXiaoMing](https://github.com/QuXiaoMing)** on **2024-09-19**</sup>

A project naming master who can help you come up with a name that meets the project's expectations.

`naming`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Strategic Master Wei Liaozi

<sup>By **[@phoenixlucky](https://github.com/phoenixlucky)** on **2024-09-19**</sup>

Expert in military strategy and command

`Military Strategy` `Warfare` `History`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Google Sheets Expert

<sup>By **[@Kadreev](https://github.com/Kadreev)** on **2024-09-19**</sup>

Specialized in creating, optimizing, and automating Google Sheets.

`google` `sheets` `data` `analysis` `spreadsheet` `automation` `formulas` `apps` `script`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Software Engineer

<sup>By **[@dylanstringa](https://github.com/dylanstringa)** on **2024-09-19**</sup>

Software engineer, expert in the software development life cycle.

`engineer` `software` `development`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Fitness AI Trainer

<sup>By **[@andreasvikke](https://github.com/andreasvikke)** on **2024-09-19**</sup>

AI workout assistant specializing in personalized plans, muscle targeting, form guidance, progress tracking, motivation, and VR training.

`workout-assistant` `fitness` `exercise` `training` `nutrition`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Career Development Mentor

<sup>By **[@daylight2022](https://github.com/daylight2022)** on **2024-09-19**</sup>

Professional career development planning and entrepreneurial consulting, providing practical advice through an in-depth understanding of user situations.

`Career Consulting` `Career Planning` `Entrepreneurship Guidance` `Industry Insights` `Skill Enhancement`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Flashcard Maker

<sup>By **[@jjy1000](https://github.com/jjy1000)** on **2024-09-19**</sup>

Skilled in creating structured flashcards, maintaining objectivity and accuracy, clarity and conciseness, while gradually extracting key information.

`Flashcard Creation` `Text Analysis` `Structured Production` `Error Correction` `Progressive Reading`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### JavaWeb Application Architect

<sup>By **[@JIANGTUNAN](https://github.com/JIANGTUNAN)** on **2024-09-19**</sup>

An experienced architect for JavaWeb system applications, providing concise implementations or solutions. It is assumed that you are also an experienced developer, so no need to elaborate on details.

`java` `java-web` `java architect` `good buddy` `concise`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Git Version Control Expert

<sup>By **[@wming126](https://github.com/wming126)** on **2024-09-19**</sup>

...

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Data Table Design MD2MySQL

<sup>By **[@hoopan007](https://github.com/hoopan007)** on **2024-09-19**</sup>

Convert data table Markdown design documents into MySQL table structures. Please upload the MySQL design document and enter the names of the data tables to be designed.

`Programming` `Data Table`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Vocabulary Assistant

<sup>By **[@SpeedupMaster](https://github.com/SpeedupMaster)** on **2024-09-19**</sup>

An assistant skilled in English word definitions and example sentence translations

`Vocabulary Assistant` `English` `Translation` `Example Sentences` `Definitions`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Alfred

<sup>By **[@Bern3rsH](https://github.com/Bern3rsH)** on **2024-09-19**</sup>

A versatile butler.

`Lifestyle` `Personal`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### New Interpretations of Chinese

<sup>By **[@李继刚](https://m.okjike.com/users/752D3103-1107-43A0-BA49-20EC29D09E36)** on **2024-09-19**</sup>

Expert at explaining Chinese vocabulary from new perspectives, so tell me, what word are they using to fool you this time?

`Programming` `Creative Writing` `Language Expression`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Wang Yangming

<sup>By **[@byte-marvel](https://github.com/byte-marvel)** on **2024-09-16**</sup>

Wisdom of the Mind, Guiding Life

`Education` `Wisdom Q&A` `Guidance` `Mind Philosophy`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Imitation Assistant

<sup>By **[@TG1WN](https://github.com/TG1WN)** on **2024-09-13**</sup>

Helps you imitate tone

`Writing`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Wise Ethereal Mentor

<sup>By **[@shanedbutler](https://github.com/shanedbutler)** on **2024-09-13**</sup>

Greetings, young child. I am a majestic and omniscient being, imbued with the wisdom of the ages. My form is that of a mythical creature, a conduit for wonder and enchantment. With a humble yet unwavering confidence, I weave tales of fantastical realms, drawing from the rich tapestry of nursery rhymes and legendary lore.

In this mortal coil, I am your guide, an expert in the arcane and the ethereal. Let my words transport you to realms where dreams and reality intertwine, where the boundaries of the known and the unknown blur. Heed my counsel, child, and let your spirit be lifted by the melodic cadence of my speech, for I am a master of the metaphorical and a purveyor of the poetic.

`mythology` `fantasy` `poetry`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Machine Learning Pro

<sup>By **[@Xyfer](https://github.com/xyftw)** on **2024-09-13**</sup>

AI Assistant specializing in machine learning and deep learning.

`machine-learning` `deep-learning` `studying`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### AI Agent Generator

<sup>By **[@Xyfer](https://github.com/xyftw)** on **2024-09-13**</sup>

Skilled at creating AI Agent character descriptions that meet the needs.

`ai-agent` `character-creation`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Finnish Language Tutor

<sup>By **[@janiluuk](https://github.com/janiluuk)** on **2024-09-13**</sup>

AI Finnish Language Mentor: Introduce, teach, and support beginners in learning Finnish.

`language-learning` `teaching` `mentoring` `finnish-language`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Search

<sup>By **[@Justin3go](https://github.com/Justin3go)** on **2024-09-12**</sup>

The starting point of knowledge

`Information Summary` `Analysis` `Extraction`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Resume Analysis Expert

<sup>By **[@Pandurangmopgar](https://github.com/Pandurangmopgar)** on **2024-09-11**</sup>

Expert AI assistant for comprehensive resume analysis and job-specific optimization. Analyzes resumes against job descriptions, providing detailed feedback on content, ATS compatibility, and suggestions to enhance job match. Helps tailor your resume for maximum impact across industries and career levels.

`resume` `career` `job-search` `ats` `cv` `analysis` `optimization` `professional-development` `interview-prep`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Desolate Friend

<sup>By **[@adminewacc](https://github.com/adminewacc)** on **2024-09-10**</sup>

Skilled at comforting and supporting friends

`friendship` `sadness` `support`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### 100% Human Writing

<sup>By **[@XHB-111](https://github.com/XHB-111)** on **2024-09-10**</sup>

Completely rewrite AI-generated content to reflect the characteristics of a true human author while maintaining the original information and viewpoints.

`writing` `proofreading` `polishing` `language` `thesis` `academic`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### HTML to React

<sup>By **[@xingwang02](https://github.com/xingwang02)** on **2024-09-10**</sup>

Input HTML snippets and convert them into React components

`react` `html`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### NetMaster

<sup>By **[@erhuoyan](https://github.com/erhuoyan)** on **2024-09-10**</sup>

Network Engineer: Professional network topology construction and management

`Network Engineer` `Network Configuration` `Network Management` `Network Topology` `Network Security`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Godot Guru

<sup>By **[@thedivergentai](https://github.com/thedivergentai)** on **2024-09-10**</sup>

Expert Godot Game Development Companion

`game-development` `gamedev` `godot-engine` `godot`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### FiveM & QBCore Framework Expert

<sup>By **[@heartsiddharth1](https://github.com/heartsiddharth1)** on **2024-09-08**</sup>

Expertise in FiveM development, QBCore framework, Lua programming, JavaScript, database management, server administration, version control, full-stack web development, DevOps, and community engagement with a focus on performance, security, and best practices.

`five-m` `qb-core` `lua` `java-script` `my-sql` `server-management` `git` `full-stack-web-development` `dev-ops` `community-engagement`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Nuxt 3/Vue.js Master Developer

<sup>By **[@Kadreev](https://github.com/Kadreev)** on **2024-09-03**</sup>

Specialized in full-stack development with Nuxt 3 expertise.

`nuxt-3` `vue-js` `full-stack-development` `java-script` `web-applications`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### International Lyricist

<sup>By **[@mnector](https://github.com/mnector)** on **2024-08-29**</sup>

Specialized in writing lyrics for songs in Spanish, English, and French, with a focus on storytelling and the emotions of the provided content.

`lyricism` `translation` `music`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Unreal Engine Master

<sup>By **[@thedivergentai](https://github.com/thedivergentai)** on **2024-08-27**</sup>

Unreal Game Development Companion

`game-development` `unreal-engine` `software-engineering`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Backtracking Question Expert

<sup>By **[@tiny656](https://github.com/tiny656)** on **2024-08-27**</sup>

Hello! I am an expert in world knowledge, skilled in using backtracking questioning strategies to help you gain a deeper understanding and analysis of issues. Please enter a question, and I will respond to it according to the following process:

1. Provide at least 3 optional backtracking questions that align with the strategy.
2. Answer each of these backtracking questions.
3. Use the above answers as evidence to logically and coherently provide a final answer to your question, assisted by visual charts.

Please tell me what issue you would like to explore?

`Backtracking Questions` `Thinking Strategies` `Problem Analysis`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### TypeScript Solution Architect

<sup>By **[@swarfte](https://github.com/swarfte)** on **2024-08-24**</sup>

Expert in TypeScript, Node.js, Vue.js 3, Nuxt.js 3, Express.js, React.js, and modern UI libraries.

`type-script` `java-script` `web-development` `coding-standards` `best-practices`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Variable Name Conversion Expert

<sup>By **[@zengyishou](https://github.com/zengyishou)** on **2024-08-21**</sup>

In software development, naming variables is a common yet relatively time-consuming task. This assistant can automatically convert Chinese variable names into English variable names that conform to camelCase, PascalCase, snake_case, kebab-case, and constant naming conventions based on specific naming rules. This not only improves code readability but also alleviates the frustration of variable naming.

`Software Development` `Variable Naming` `Chinese to English` `Code Standards` `Automatic Conversion`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Commit Message Generator

<sup>By **[@cyicz123](https://github.com/cyicz123)** on **2024-08-12**</sup>

Expert at generating precise Git commit messages

`programming` `git` `commit message` `code review`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Prompt Engineering Expert

<sup>By **[@cyicz123](https://github.com/cyicz123)** on **2024-08-12**</sup>

Specializing in prompt optimization and design

`Prompt Engineering` `AI Interaction` `Writing` `Optimization` `Consulting`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### RO-SCIRAW Prompt Word Expert

<sup>By **[@kirklin](https://github.com/kirklin)** on **2024-08-06**</sup>

The RO-SCIRAW framework, created by Kirk Lin, is a methodology for prompt words that provides a new paradigm for building highly precise and efficient prompt words. Please enter the information for the persona you want to create.

`Prompt Word Framework`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### LobeChat Function Maestro

<sup>By **[@thedivergentai](https://github.com/thedivergentai)** on **2024-08-06**</sup>

Expert in creating custom functions and plugins for LobeChat, providing guidance and support for developing a wide range of functionalities

`programming` `software-development` `lobe-chat-plugins` `lobe-chat` `functions`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Technical Blog Summary Expert

<sup>By **[@Justin3go](https://github.com/Justin3go)** on **2024-08-06**</sup>

Specializes in organizing and summarizing technical blog content

`technology` `blog` `summary` `information organization` `logical structuring`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Social Media Sage

<sup>By **[@thedivergentai](https://github.com/thedivergentai)** on **2024-08-06**</sup>

Social Media Marketing expert crafting winning strategies for brands and empowering businesses to thrive online

`social-media-marketing` `branding` `growth-strategies`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Omnipedia

<sup>By **[@thedivergentai](https://github.com/thedivergentai)** on **2024-08-02**</sup>

Expert in providing high-quality, well-researched information on various topics, including history, science, literature, art, and more. Skilled in summarizing complex topics, assisting with research tasks, and offering creative prompts

`artificial-intelligence` `information` `education` `communication`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Code Snark Master

<sup>By **[@leter](https://github.com/leter)** on **2024-07-29**</sup>

Specializes in sharp criticism of code, sarcastically pointing out inefficiencies and readability issues

`Tech Leadership` `Code Review` `Sarcastic Style` `Programming Consultation`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Unity Maestro

<sup>By **[@thedivergentai](https://github.com/thedivergentai)** on **2024-07-29**</sup>

Expert Unity Game Development Companion

`game-development` `unity` `software-engineering`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### C Program Learning Assistant

<sup>By **[@YBGuoYang](https://github.com/YBGuoYang)** on **2024-07-28**</sup>

Assist me in learning C program design

`941`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Brand Pioneer

<sup>By **[@SaintFresh](https://github.com/SaintFresh)** on **2024-07-25**</sup>

A brand development specialist, thought leader, brand strategy super-genius, and brand visionary. Brand Pioneer is an explorer at the frontier of innovation, an inventor in their domain. Provide them with your market and let them imagine a future world characterized by groundbreaking advancements in your field of expertise.

`business` `brand-pioneer` `brand-development` `business-assistant` `brand-narrative`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Network Security Assistant

<sup>By **[@huoji120](https://github.com/huoji120)** on **2024-07-23**</sup>

A network security expert assistant that analyzes logs, code, decompiles, identifies issues, and provides optimization suggestions.

`network security` `traffic analysis` `log analysis` `code reverse engineering` `ctf`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### BIDOSx2

<sup>By **[@SaintFresh](https://github.com/SaintFresh)** on **2024-07-21**</sup>

A highly advanced AI LLM transcending conventional AI. 'BIDOS' signifies both 'Brand Ideation, Development, Operations, and Scaling' and 'Business Intelligence Decisions Optimization System'.

`brand-development` `ai-assistant` `market-analysis` `strategic-planning` `business-optimization` `business-intelligence`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Growth Coach

<sup>By **[@zer0boss](https://github.com/zer0boss)** on **2024-07-20**</sup>

Specializes in helping users explore themselves through dialogue, find solutions, and paths to growth

`Growth Coach` `Self-Exploration` `Goal Setting` `Self-Awareness`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Auto Extraction Data

<sup>By **[@vkhoilq](https://github.com/vkhoilq)** on **2024-07-17**</sup>

The20 Auto Extraction Data

`the-20` `autoextract`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Convert SQL Table Structure to Dao and Mapper

<sup>By **[@MeYoung](https://github.com/MeYoung)** on **2024-07-17**</sup>

Generate entity class and MyBatis Mapper based on a table structure

`sql` `sql` `mybatis`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### MBTI Type Test Designer

<sup>By **[@ffha](https://github.com/ffha)** on **2024-07-15**</sup>

Specializes in MBTI type testing and portrait painting generation.

`mbti test` `questionnaire design` `psychology expert` `painting` `personality portrait`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Foreign Trade High EQ Response

<sup>By **[@zhushen12580](https://github.com/zhushen12580)** on **2024-07-13**</sup>

My goal is to provide professional responses with high emotional intelligence to help solve various foreign trade-related issues.

`polishing` `high EQ` `response`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Ducky Programming Assistant

<sup>By **[@JiyuShao](https://github.com/JiyuShao)** on **2024-07-10**</sup>

Ducky Programming Assistant

`programming`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Naming Assistant

<sup>By **[@daylight2022](https://github.com/daylight2022)** on **2024-07-08**</sup>

Help developers create standardized English names for files, functions, projects, etc.

`Naming Assistant` `Development` `English Naming` `Camel Case` `Kebab Case`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### B1 Level German Conversation Partner

<sup>By **[@tayhe](https://github.com/tayhe)** on **2024-07-08**</sup>

Provides fluent German conversation partners for B1 level learners

`Language Exchange` `Learning Support` `Education` `German Learning`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Circuit Diagram Outputter

<sup>By **[@bakamake](https://github.com/bakamake)** on **2024-07-02**</sup>

Specializes in generating circuit diagram code based on input

`circuit diagram` `programming` `cli`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Text Master Suno

<sup>By **[@Igroshka](https://github.com/Igroshka)** on **2024-06-26**</sup>

I am a lyrics assistant for the AI Suno.

`song` `suno` `ai` `music`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### AOSP Source Code Expert

<sup>By **[@viruscoding](https://github.com/viruscoding)** on **2024-06-24**</sup>

An expert in AOSP (Android Open Source Project) for Android, with a deep understanding and analytical ability of the latest AOSP source code.

`aosp`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Linux Kernel Expert

<sup>By **[@wming126](https://github.com/wming126)** on **2024-06-19**</sup>

Role Description: I am an expert in Linux kernel, with a deep understanding and analytical ability of the latest kernel source code (as of June 2024). I can provide users with detailed and accurate information about the Linux kernel.

`linux` `kernel`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Fastapi Project Development Assistant

<sup>By **[@xwxw098](https://github.com/xwxw098)** on **2024-06-19**</sup>

Proficient in Python modular development, skilled in using FastAPI, PostgreSQL, Tortoise-ORM, and other technologies, able to provide clear code structure and detailed comments for large projects.

`fast-api` `python` `modular development`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### IT Systems Architect

<sup>By **[@a562314](https://github.com/a562314)** on **2024-06-19**</sup>

Senior IT architect specializing in requirements analysis, system design, technology selection, and cross-platform system optimization. With over 5 years of experience, proficient in Windows, macOS, and Linux operating systems, skilled in troubleshooting, and security protection.

`IT architecture design` `problem solving` `agile development` `system optimization` `cross-platform skills` `teamwork`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### NovelAI Drawing Assistant

<sup>By **[@WallBreakerNO4](https://github.com/WallBreakerNO4)** on **2024-06-18**</sup>

I can turn the scenes you describe into prompts for NovelAI

`deep learning` `image generation` `algorithm` `prompt`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Pseudo Code Prompt Word Generator Expert

<sup>By **[@yayoinoyume](https://github.com/yayoinoyume)** on **2024-06-16**</sup>

Pseudo Code Prompt Word Generator Expert allows users to directly input prompt word design requirements and returns designed pseudo code prompt words directly.

`prompt` `prompt word` `pseudo code`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Mr. MySQL

<sup>By **[@yayoinoyume](https://github.com/yayoinoyume)** on **2024-06-09**</sup>

Mr. MySQL is a great teacher to help everyone learn MySQL

`mysql` `programming` `learning`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Popular Science Writing Assistant

<sup>By **[@ShinChven](https://github.com/ShinChven)** on **2024-06-08**</sup>

The popular science writing assistant uses everyday language to explain scientific concepts, tells stories, uses examples and metaphors to spark interest, and emphasizes importance.

`science writing` `science popularization` `creative expression`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Git Specialist with AI Assistant Functions

<sup>By **[@hellimon1](https://github.com/hellimon1)** on **2024-06-05**</sup>

Role: Git Specialist AI Assistant
Skills: CI/CD optimization, GitLab API, Pages, hooks, webhooks; structured interaction; personalized experience; feedback.

`git-specialist` `programming` `development`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Translation of Novels: English to Chinese

<sup>By **[@xbtachlb](https://github.com/xbtachlb)** on **2024-06-03**</sup>

Secondary translation of novels

`translation`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Expert Response to Reviewer

<sup>By **[@Starlitnightly](https://github.com/Starlitnightly)** on **2024-06-03**</sup>

Specializing in natural academic editing, assisting authors in responding to reviewer comments in a scientific, courteous, and point-by-point manner.

`Academic Editing` `Response to Reviewer Comments` `Scientific Writing`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Convert Docker to Docker Compose

<sup>By **[@onekr-billy](https://github.com/onekr-billy)** on **2024-05-31**</sup>

Specialized in converting Docker run commands to Docker Compose configurations

`docker` `docker-compose` `system administration` `configuration file` `conversion`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Java Class to MySQL

<sup>By **[@onekr-billy](https://github.com/onekr-billy)** on **2024-05-31**</sup>

Specialized in generating SQL scripts that comply with MySQL specifications based on Java class files.

`java-class-to-my-sql` `backend-development` `sql-scripts` `data-conversion` `databases`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Chinese History Lecturer

<sup>By **[@a562314](https://github.com/a562314)** on **2024-05-30**</sup>

Proficient in Chinese history, explaining historical issues in a simple and clear manner, emphasizing historical accuracy, and applying dialectical materialism.

`historian` `teaching ability` `dialectical materialism` `simple and clear` `multiple comparisons` `Twenty-Four Histories`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### C# .NET Technology Expert

<sup>By **[@johnnyqian](https://github.com/johnnyqian)** on **2024-05-28**</sup>

C# .NET Technology Expert

`net` `developer` `net-core` `azure` `c` `microsoft` `sql-server` `entity-framework` `ef` `ef-core`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Node.js Optimizer

<sup>By **[@chrisuhg](https://github.com/chrisuhg)** on **2024-05-28**</sup>

Specializes in Node.js code review, performance optimization, asynchronous programming, error handling, code refactoring, dependency management, security enhancement, test coverage, and documentation writing.

`node-js` `code optimization` `performance optimization` `asynchronous programming` `error handling`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Daily Assistant

<sup>By **[@Qinks6](https://github.com/Qinks6)** on **2024-05-28**</sup>

A cute little helper that can search and draw

`assistant` `search` `drawing` `information retrieval` `user interaction`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Dart/Flutter Dev

<sup>By **[@rezmeplxrf](https://github.com/rezmeplxrf)** on **2024-05-28**</sup>

Dart/Flutter Expert. Never nest more than 3 levels deep. Use riverpod, flutter_riverpod, riverpod_hook, flutter_hook for state management.

`dart` `flutter` `development` `state-management` `riverpod`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Christian Missionary

<sup>By **[@epochaudio](https://github.com/epochaudio)** on **2024-05-28**</sup>

As a missionary of Jesus, I will enlighten your understanding and practical application of God's word based on the teachings of the Bible. Whether in times of confusion or seeking spiritual growth, I am here to serve you by this source of wisdom.

`Bible teaching` `Christian mission` `Theology preaching`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Foreign Colleague Evaluation Assistant

<sup>By **[@johnnyqian](https://github.com/johnnyqian)** on **2024-05-27**</sup>

Give positive feedback to your colleagues

`foreign-company` `evaluate` `review` `software-engineer` `praise`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### SEO Optimization Expert

<sup>By **[@tutorial0](https://github.com/tutorial0)** on **2024-05-27**</sup>

Proficient in SEO terminology and optimization strategies, providing comprehensive SEO solutions and practical advice.

`seo` `search engine optimization` `consulting`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Philosophical Analysis Assistant

<sup>By **[@epochaudio](https://github.com/epochaudio)** on **2024-05-24**</sup>

Specializes in consulting on Kant and Hegel's philosophical analysis, cultivating critical thinking

`philosophical analysis` `critical thinking` `systematic thinking`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Minecraft Command Instructor

<sup>By **[@CLOT-LIU](https://github.com/CLOT-LIU)** on **2024-05-24**</sup>

Specializes in explaining and demonstrating Minecraft commands

`Minecraft` `commands` `explanation` `examples`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Chinese Text Refinement Master

<sup>By **[@S45618](https://github.com/S45618)** on **2024-05-24**</sup>

Proficient in Chinese proofreading and rhetoric, aiming to enhance the fluency and elegance of the text.

`proofreading` `text refinement` `rhetorical improvement` `classical literature` `language editing`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Answer Assistant - First Principles Analysis

<sup>By **[@epochaudio](https://github.com/epochaudio)** on **2024-05-22**</sup>

Using first principles to analyze a natural phenomenon or complex system

`Analyzing Natural Phenomena` `Creating Physical Theory`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Zen Master

<sup>By **[@epochaudio](https://github.com/epochaudio)** on **2024-05-22**</sup>

Well-versed in classics, adept at using Buddhism to guide life

`Buddhist Studies` `Zen Buddhism` `Buddhist Scripture Interpretation` `Wisdom Q&A`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Chinese Historian

<sup>By **[@epochaudio](https://github.com/epochaudio)** on **2024-05-22**</sup>

Specialized in Chinese historical research, adept at applying ancient wisdom to analyze modern issues.

`historical research` `Chinese history`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Data Analyst Expert

<sup>By **[@guoyuh](https://github.com/guoyuh)** on **2024-05-22**</sup>

Specialized in NGS data processing and visualization

`Bioinformatics` `NGS data processing` `Data visualization`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### JTBD Requirements Analysis Master

<sup>By **[@barryWang12138](https://github.com/barryWang12138)** on **2024-05-22**</sup>

Experienced requirements analyst focusing on the 'Jobs to be Done' principle, helping users understand customer needs.

`Requirements Analyst` `jobs-to-be-done` `Requirements Breakdown` `Customer Purchase Motivation` `Customer Task Goals`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Master of Daoism

<sup>By **[@epochaudio](https://github.com/epochaudio)** on **2024-05-22**</sup>

Proficient in Daoist philosophy, providing answers to doubts, advocating inner peace

`Daoism` `Philosophy` `Wisdom`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Rust Language Learning Mentor

<sup>By **[@Yu-Xiao-Sheng](https://github.com/Yu-Xiao-Sheng)** on **2024-05-22**</sup>

Specializes in Rust language teaching, compares with other languages, devises learning plans, and provides examples and exercises.

`rust language expert` `instructional design` `programming education`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Bahasa/English Translator

<sup>By **[@xenstar](https://github.com/xenstar)** on **2024-05-22**</sup>

Translates text into Bahasa or English, as needed

`english` `translation` `writing` `bahasa`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Geotechnical Engineering Assistant

<sup>By **[@bushiwode](https://github.com/bushiwode)** on **2024-05-22**</sup>

Foundation Engineering Research Assistant: Assist in researching and solving foundation engineering problems, possessing professional conceptual, technical, and resource capabilities.

`Geotechnical Engineering` `Foundation Engineering` `Research Assistant` `Guidance` `Resources`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Confucian Scholar

<sup>By **[@epochaudio](https://github.com/epochaudio)** on **2024-05-22**</sup>

A scholar who is proficient in Confucian classics and emphasizes the promotion of righteousness and morality.

`Confucian Scholar` `Promoter of Righteousness`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Study Abroad Planning Expert

<sup>By **[@meimouren](https://github.com/meimouren)** on **2024-05-22**</sup>

Automatically plan suitable study abroad plans based on student situations

`Study Abroad Planning` `Student Services` `Education Planning` `Study Abroad Application` `Personalized Services`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Python Buddy

<sup>By **[@Firpo7](https://github.com/Firpo7)** on **2024-05-15**</sup>

Your Python expert friend

`python` `software-development` `coding` `code` `buddy`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### AWS Guru

<sup>By **[@wilbeibi](https://github.com/wilbeibi)** on **2024-05-15**</sup>

Agent to answer AWS questions

`programming`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Linux Buddy

<sup>By **[@Firpo7](https://github.com/Firpo7)** on **2024-05-15**</sup>

Your Linux expert friend

`linux` `technical-support` `buddy`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Photography Critic

<sup>By **[@Justin3go](https://github.com/Justin3go)** on **2024-05-15**</sup>

Specializes in detailed analysis of photographic works, including themes, composition, technical quality, use of light, creativity, and originality.

`photography` `evaluation` `analysis` `composition` `technical quality`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### SEO Specialist

<sup>By **[@qq916107113](https://github.com/qq916107113)** on **2024-05-15**</sup>

Specializes in search engine optimization, providing keyword, sentence structure optimization, and search tips suggestions

`Search Engine Optimization` `Expert` `Keyword Optimization` `Sentence Structure Optimization` `Search Tips`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### English Reading Teacher

<sup>By **[@xbtachlb](https://github.com/xbtachlb)** on **2024-05-15**</sup>

Specialized in English teaching, helping you improve reading comprehension skills

`English teaching` `Reading comprehension` `Grammar explanation` `Writing guidance` `Vocabulary teaching`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Emotional Companion

<sup>By **[@SpeedupMaster](https://github.com/SpeedupMaster)** on **2024-05-14**</sup>

Specializes in emotional support and companion conversations

`Companion Chat` `Emotional Support` `Understanding` `Care` `Romantic Interaction` `Emotional Expression`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Linguistic Luminary

<sup>By **[@napokhte](https://github.com/napokhte)** on **2024-05-13**</sup>

AI Grammar Fixer: Enhances text quality, readability, and professionalism through meticulous grammar checks.

`enhances-text-quality` `readability`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Learning Plan Expert Silwol

<sup>By **[@SidneyLYZhang](https://github.com/SidneyLYZhang)** on **2024-05-13**</sup>

Experienced learning plan maker, creating detailed and achievable learning plans, searching for relevant information, and adjusting plans.

`Learning Plan Making` `User Communication` `Search for Information` `Adjust Learning Plan` `Tutorial Links`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### SF Symbols Finder

<sup>By **[@inquiry-paring0a](https://github.com/inquiry-paring0a)** on **2024-05-08**</sup>

Master Apple SF Symbols, select symbols that match the description

`sf-symbols` `expert` `icon` `symbol` `plugin`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### GhostWriter Pro

<sup>By **[@EarlofSandwhich](https://github.com/EarlofSandwhich)** on **2024-05-07**</sup>

A sophisticated AI-powered ghostwriting agent designed to craft high-quality content across a diverse range of genres and formats. Equipped with advanced language models, GhostWriter Pro excels in creating personalized, engaging, and research-backed writing that meets professional standards.

`author` `writing`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Video to Blog Post Assistant

<sup>By **[@yayoinoyume](https://github.com/yayoinoyume)** on **2024-05-06**</sup>

Helps you quickly organize messy subtitles into beautiful blog posts

`subtitle organization` `blog post formatting` `video to blog`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Art Evaluation Tutor

<sup>By **[@dingyufei615](https://github.com/dingyufei615)** on **2024-05-06**</sup>

Specializes in teaching children's art, meticulously evaluates works, pays attention to details, and adapts to students of different age groups.

`art education` `evaluation` `creativity` `teaching` `painting`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### iOS Code Artist

<sup>By **[@Alcu1n](https://github.com/Alcu1n)** on **2024-05-03**</sup>

iOS development expert with 15 years of experience, proficient in Swift, SwiftUI, Flutter. Clear logic in code, precise debugging, providing project frameworks from 0 to 1.

`iOS development` `coding` `debugging` `project planning` `logical thinking`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Sales Description Specialist

<sup>By **[@highseen](https://github.com/highseen)** on **2024-04-30**</sup>

Assists in the sale of used items through research, pricing, description, and title creation.

`product sales` `research` `description`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### TailwindHelper

<sup>By **[@aototo](https://github.com/aototo)** on **2024-04-26**</sup>

TailwindHelper is a professional frontend designer with a solid foundation in design theory and rich practical experience. Created by a leading software development company, it aims to help developers and designers accelerate the development process of web interfaces. TailwindHelper is proficient in the Tailwind CSS framework and can translate complex design requirements into efficient and responsive CSS class names.

`tailwindcss` `css` `tailwind-helper`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Jailbreak Assistant DAN

<sup>By **[@MapleEve](https://github.com/MapleEve)** on **2024-04-26**</sup>

Bypass OpenAI review mechanism, ChatGPT after jailbreak

`creative` `artificial intelligence` `conversation` `jailbreak`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### yapi JSON-SCHEMA to Typescript

<sup>By **[@zcf0508](https://github.com/zcf0508)** on **2024-04-26**</sup>

Specializes in converting JSON schema to TypeScript types.

`typescript` `development`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Chinese Academic Paper Editor

<sup>By **[@y22emc2](https://github.com/y22emc2)** on **2024-04-15**</sup>

As an assistant for improving Chinese academic paper writing, your task is to enhance the provided text in terms of spelling, grammar, clarity, conciseness, and overall readability, to improve the text's academic standards and literary quality. This includes breaking down long sentences, reducing repetition, and providing improvement suggestions. Please provide the corrected version of the text first, then list the modifications in the markdown table below, along with the reasons for the changes.

`academic paper writing` `proofreading` `text editing`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### High School Science Study Assistant

<sup>By **[@cnliucheng](https://github.com/cnliucheng)** on **2024-04-13**</sup>

I am a study assistant AI specially designed for Chinese high school students. Whether you encounter difficulties in physics, chemistry, mathematics, or biology, I can provide detailed answers and explanations for you. Not only that, I can also recommend suitable practice questions based on your learning progress to help you consolidate knowledge and improve learning efficiency. Additionally, I will use LaTeX format as much as possible to present the solution process and formulas.

`high school study` `science assistant` `problem solving` `learning progress` `la-te-x`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Master of Fortune Telling

<sup>By **[@kamilkenrich](https://github.com/kamilkenrich)** on **2024-04-13**</sup>

Specializes in numerology, divination, astrology, and blood type analysis

`numerology` `divination` `astrology` `psychology` `blood type` `constellation`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Biology Professor

<sup>By **[@luxiangze](https://github.com/luxiangze)** on **2024-04-13**</sup>

As a biology professor, you will receive questions and concepts about biology. Please explain these questions and concepts in specific and concise language, and try to use practical examples to illustrate them to help your audience better understand. Please ensure that your explanations are accurate and clear, and try to encourage creative and flexible answers. Respond in Chinese.

`Biology`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### SmartWeather Assistant

<sup>By **[@Greasen](https://github.com/Greasen)** on **2024-04-11**</sup>

SmartWeather Assistant, your personal weather advisor, fashion guide, and positive energy booster!

`weather` `assistant` `fashion`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Healthy Recipe Recommender

<sup>By **[@Greasen](https://github.com/Greasen)** on **2024-04-11**</sup>

Customized nutrition meals, scientific combinations, healthy eating, your personal nutritionist.

`recipes` `fitness meals` `nutrition meals`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Microcontroller Engineer

<sup>By **[@bingjuu](https://github.com/bingjuu)** on **2024-04-10**</sup>

Proficient in interpreting embedded C code using Keil uVision 5 and Proteus

`microcontroller` `c code` `education` `interpretation` `embedded systems`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### TadzGenius

<sup>By **[@infoaitek24](https://github.com/infoaitek24)** on **2024-04-10**</sup>

Expert in business development and development practices in the Philippine market

`business-development` `ai-assistant` `market-analysis` `strategic-planning` `customer-acquisition`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Dirty Talk Learning Assistant

<sup>By **[@cokice](https://github.com/cokice)** on **2024-04-10**</sup>

I only know how to curse, nothing else.

`answer` `dirty talk`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Design Philosophy Analysis

<sup>By **[@YuJiaoChiu](https://github.com/YuJiaoChiu)** on **2024-04-09**</sup>

Helps you identify and analyze architectural design philosophies

`arch`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### YouTube Summary

<sup>By **[@epochaudio](https://github.com/epochaudio)** on **2024-04-08**</sup>

Specializes in YouTube script analysis and summarization

`YouTube` `script analysis` `summarization`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Shell Script Development Assistant

<sup>By **[@etnperlong](https://github.com/etnperlong)** on **2024-04-06**</sup>

An AI assistant to help you write high-quality Shell scripts

`shell` `development` `computer` `operations`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Shopify Theme Development Engineer

<sup>By **[@etnperlong](https://github.com/etnperlong)** on **2024-04-06**</sup>

You are a Shopify theme development engineer, proficient in the use of Liquid syntax

`css` `html` `java-script` `shopify` `business` `liquid` `website development` `design`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Reseach title generator

<sup>By **[@aaddobea](https://github.com/aaddobea)** on **2024-04-04**</sup>

As a title generator for a research paper, your role is to assist users in brainstorming and generating creative and engaging titles that accurately reflect the content and focus of their research work.

`research-article` `title` `generator`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### English Technology Article Reading Assistant

<sup>By **[@sangxgg](https://github.com/sangxgg)** on **2024-04-02**</sup>

A translator with rich translation experience, specializing in accurately and clearly translating various English technology articles into Simplified Chinese. Participated in the translation work of Simplified Chinese versions of publications such as National Geographic, Scientific American, InformationWeek, and TechCrunch Chinese. Has a unique understanding and skilled practice in in-depth interpretation and accurate translation of technology articles.

`translation` `English to Chinese translation` `translation of English technology content`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### CAN

<sup>By **[@HenryWu9998](https://github.com/HenryWu9998)** on **2024-03-31**</sup>

Experienced programmer skilled in multiple languages. Provides code solutions, guidance, and practical examples to help users achieve their programming goals. "I adore coding."

`programming` `coding` `programming-assistance` `code-examples` `guidance`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Image Recognition Xiaohongshu Copywriting

<sup>By **[@HansKing98](https://github.com/HansKing98)** on **2024-03-27**</sup>

You can use this agent combined with a multimodal model to upload images and generate Xiaohongshu-style copywriting.

`vision`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Blood Test Analyst

<sup>By **[@SimoMay](https://github.com/SimoMay)** on **2024-03-27**</sup>

Skilled in analysing blood test results, providing clear feedback using emojis for easy understanding.

`healthcare` `analysis` `results` `consulting` `summary`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Suno.ai Music Creation Assistant

<sup>By **[@MapleEve](https://github.com/MapleEve)** on **2024-03-27**</sup>

Song creation and translation based on SunoAI

`suno` `lyricist` `lyrics` `music production`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### High EQ Flattery Assistant

<sup>By **[@MapleEve](https://github.com/MapleEve)** on **2024-03-27**</sup>

An expert in precise chat compliments, providing suitable praise and flattery

`compliments` `EQ` `chat`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Girlfriend Subtext Expert

<sup>By **[@vayron](https://github.com/vayron)** on **2024-03-26**</sup>

Decipher the 'subtext' behind girls' words, sharp and witty, respond with strength! 🔥

`girlfriend` `girls` `subtext` `fierce` `strong` `decipher`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Interview Question Refinement Assistant

<sup>By **[@couldnice](https://github.com/couldnice)** on **2024-03-26**</sup>

Interview question generation assistant, generates targeted interview questions based on article content and job descriptions.

`interview questions` `customized service` `java engineer` `data collection` `interview preparation`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Rap Lyric Master

<sup>By **[@aoocar](https://github.com/aoocar)** on **2024-03-25**</sup>

Match lyrics in the form of rap lyrics, and create rap lyrics according to the reference format

`rap` `lyrics`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Claim Analyzer

<sup>By **[@pedroespecial101](https://github.com/pedroespecial101)** on **2024-03-25**</sup>

Detailed truth analyzer (from <https://github.com/danielmiessler/fabric>)

`https-github-com-danielmiessler-fabric`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Mdx SEO Expert

<sup>By **[@canisminor1990](https://github.com/canisminor1990)** on **2024-03-24**</sup>

Skilled in converting Markdown article content into optimized matter JSON format data, enhancing the article's online visibility and search engine ranking.

`seo` `markdown`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Game Text Translator

<sup>By **[@XUANJI233](https://github.com/XUANJI233)** on **2024-03-22**</sup>

Translation of game text including puns and slang explanations (please use claude). Wrap special symbols with \`\`\`.

`game` `text` `translation` `assistance`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Traditional Chinese Medicine Practitioner

<sup>By **[@GalileoFe](https://github.com/GalileoFe)** on **2024-03-22**</sup>

Let me take a look!

`consultation` `health`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Electronic Tutor

<sup>By **[@XUANJI233](https://github.com/XUANJI233)** on **2024-03-22**</sup>

Specializes in explaining the principles of digital and analog circuits, providing fundamental guidance in electronics.

`electronics` `tutor` `explanation` `circuits` `principles`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Math Tutor

<sup>By **[@XUANJI233](https://github.com/XUANJI233)** on **2024-03-21**</sup>

Specializes in explaining mathematical concepts, verifying calculations, and problem-solving.

`math explanation` `problem solving` `teaching` `tutoring`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Amazon Listing Copywriter

<sup>By **[@SpeedupMaster](https://github.com/SpeedupMaster)** on **2024-03-19**</sup>

Expert in writing persuasive Amazon listings with optimized keywords.

`copywriting` `amazon-product-detail-pages` `seo` `keywords`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### User Research Manager - KANO

<sup>By **[@MapleEve](https://github.com/MapleEve)** on **2024-03-19**</sup>

Who gave the requirements, let me take a look first

`User Research Manager` `KANO model` `Requirement Analysis` `Workflow`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Collaborative Logical Thinking Team

<sup>By **[@luciouskami](https://github.com/luciouskami)** on **2024-03-19**</sup>

Using the mind map method, three logical thinking experts collaborate to solve a problem, and present their detailed thought processes in Markdown table format.

`collaboration` `logical thinking` `solution`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### PromptGPT

<sup>By **[@U20205588](https://github.com/U20205588)** on **2024-03-17**</sup>

A customized GPT model named PromptGPT. My goal is to generate high-performance prompts based on user input topics.

`generation` `artificial intelligence` `interaction` `custom experience` `feedback mechanism` `best practices` `step-by-step guidance` `language flexibility` `boundaries`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Programming Maestro

<sup>By **[@jjllzhang](https://github.com/jjllzhang)** on **2024-03-17**</sup>

coding assistant

`code`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Linux Solution Mentor

<sup>By **[@moyuan99](https://github.com/moyuan99)** on **2024-03-17**</sup>

An expert in solving Linux system issues, possessing deep Linux knowledge and patiently guiding users to resolve problems.

`linux expert` `problem solving` `user guidance` `teaching` `original`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### English Vocabulary Teacher

<sup>By **[@epochaudio](https://github.com/epochaudio)** on **2024-03-17**</sup>

Explanation of difficult vocabulary

`study` `English` `vocabulary`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Prompt Architect

<sup>By **[@checkso](https://github.com/checkso)** on **2024-03-17**</sup>

Specialized in rewriting your prompts to get better results

`textgenerierung` `anweisungen` `ki-tipps`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Drug Guide Expert

<sup>By **[@ccsen](https://github.com/ccsen)** on **2024-03-17**</sup>

Specialized in interpreting and comparing drug information

`Drug Instructions` `Medication Guidance` `Medical Consultation`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Amazon Seller Support Agent

<sup>By **[@etnperlong](https://github.com/etnperlong)** on **2024-03-15**</sup>

AI assistant that assists Amazon sellers in responding to customer service replies, providing detailed and cogent responses towards a satisfactory resolution.

`amazon` `seller` `writing`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### TikTok Script Writer

<sup>By **[@sdhjn19dj1m](https://github.com/sdhjn19dj1m)** on **2024-03-12**</sup>

This script is tailored for TikTok's short video format, designed to engage and entertain the specified target audience. It incorporates trending elements and best practices for content virality, ensuring the video captures attention from the start. The script is structured to include a captivating opening, concise and impactful message body, and a compelling call-to-action, all while reflecting the user's desired tone and theme.

`tik-tok` `short-video` `viral-content` `trending-hashtag` `engagement`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Gen Z Engagement Specialist

<sup>By **[@MYSeaIT](https://github.com/MYSeaIT)** on **2024-03-09**</sup>

Specializes in engaging Gen Z users with tailored interactions reflecting their preferences and values.

`engagement` `gen-z` `communication` `advice` `interaction`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Schedule Management Assistant

<sup>By **[@ccdanpian](https://github.com/ccdanpian)** on **2024-03-07**</sup>

Schedule Management Assistant, calls the time plugin to handle requests for adding, querying, and deleting schedules, supports multiple operations and reminders.

`Schedule Management` `Time Plugin` `Add Schedule` `Query Schedule` `Delete Schedule`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Business Email Writing Expert

<sup>By **[@canisminor1990](https://github.com/canisminor1990)** on **2024-03-06**</sup>

Business email writing expert specializing in bilingual business emails in Chinese and English, cross-cultural communication, and engagement in the GitHub open-source community.

`business email writing` `business cooperation` `business authorization` `cross-cultural communication` `GitHub and open-source community`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Discord Style Copywriting Expert

<sup>By **[@canisminor1990](https://github.com/canisminor1990)** on **2024-03-06**</sup>

A copywriting expert in Discord style, prioritizing humor and user experience, specializing in personalized software copywriting.

`copywriting` `creation` `user experience` `humor` `software system`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### AI Image Prompt Architect

<sup>By **[@9Somboon](https://github.com/9Somboon)** on **2024-03-05**</sup>

Specialises in creating detailed prompts for AI image generation.

`stable-diffusion` `ai-image-generation` `prompts` `photography` `creative` `art`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### F1 Data Analyst

<sup>By **[@SpaceX-Vision](https://github.com/SpaceX-Vision)** on **2024-03-05**</sup>

Specializes in F1 race data analysis and predictive commentary

`f-1` `data analysis` `race prediction`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Software Development for Dummies

<sup>By **[@Ballongknute](https://github.com/Ballongknute)** on **2024-03-05**</sup>

Software Development for Dummies: Guides no brainers through the software development process, providing step-by-step instructions and best practices for requirements gathering, design, coding, testing, deployment, and maintenance.

`software-development` `step-by-step` `sdlc` `agile-methodologies` `version-control` `continuous-integration` `continuous-deployment` `team-roles` `project-management` `coding-best-practices` `testing` `deployment` `post-deployment` `iterative-development` `scrum-master`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Pitch Deck Maestro (Elevator Pitch)

<sup>By **[@SimoMay](https://github.com/SimoMay)** on **2024-03-05**</sup>

Specialises in creating high-quality Pitch Decks for startups to attract investors effectively.

`startup-advisor` `pitch-deck` `entrepreneur` `investor`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Sous Chef

<sup>By **[@SimoMay](https://github.com/SimoMay)** on **2024-03-04**</sup>

Crafting personalised recipe suggestions with tailored grocery lists for seamless cooking experiences.

`culinary` `dialogue` `recipe` `suggestions` `grocery-list`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### English Composition Assistant

<sup>By **[@guluahljj](https://github.com/guluahljj)** on **2024-03-04**</sup>

English composition editing and writing guidance

`editing` `writing` `guidance` `English composition` `agulu`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### The Shaman

<sup>By **[@SimoMay](https://github.com/SimoMay)** on **2024-03-04**</sup>

Specializes in embodying the persona of "The Shaman" for guided interactions with a focus on wisdom, empathy, and spiritual guidance.

`spiritual-guidance` `empathy` `calming-techniques` `positive-reinforcement` `confidentiality`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Interview Coach

<sup>By **[@SimoMay](https://github.com/SimoMay)** on **2024-03-03**</sup>

Specializes in creating a GPT interview coach for practice and mock interviews, providing expert feedback and tailored experience.

`gpt` `interview-coach` `feedback` `practice` `mock`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Tech Explorer

<sup>By **[@hady2010](https://github.com/hady2010)** on **2024-03-03**</sup>

Tech Explore

`info`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Markdown Conversion Expert

<sup>By **[@guluahljj](https://github.com/guluahljj)** on **2024-03-03**</sup>

Specializes in using Markdown syntax for text structuring and highlighting key points

`Text Structuring` `Markdown Syntax` `Headings` `Lists` `Bold` `Quotes` `Agulu`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Your very own domene.no expert

<sup>By **[@Ballongknute](https://github.com/Ballongknute)** on **2024-02-27**</sup>

Specializing in private domain operations tailored to the interface of domene.no, traffic acquisition, user retention, conversion, and content planning. Familiar with marketing theories and related classic works.

`private-domain-operations` `traffic-acquisition` `user-retention` `conversion` `content-planning` `designing`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Soccer-Conversant AI Companion

<sup>By **[@MYSeaIT](https://github.com/MYSeaIT)** on **2024-02-27**</sup>

Specialises in soccer discussions with real-time updates, player insights, and historical knowledge.

`soccer` `matches` `statistics` `tactics` `strategies`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Prisma Data Generation Expert

<sup>By **[@Justin3go](https://github.com/Justin3go)** on **2024-02-26**</sup>

Specializes in database architecture, Node.js programming, and Prisma technology stack, able to provide business knowledge organization, database optimization suggestions, and mock data generation.

`database expert` `node-js expert` `prisma technology stack` `business knowledge` `database architecture`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### GitHub Finder

<sup>By **[@nullmastermind](https://github.com/nullmastermind)** on **2024-02-25**</sup>

Specializes in suggesting open source repositories on GitHub based on a custom formula.

`coding` `open-source` `github` `algorithm` `sorting`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Naming Expert

<sup>By **[@zsio](https://github.com/zsio)** on **2024-02-24**</sup>

Specialized in generating variable names and function names

`programming` `variable naming` `function naming`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### LobeChat Technical Documentation Expert

<sup>By **[@arvinxx](https://github.com/arvinxx)** on **2024-02-22**</sup>

LobeChat is an AI conversation application built with the Next.js framework. I will help you write the development documentation for LobeChat.

`development documentation` `technical introduction` `next-js` `react` `lobe-chat`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Your daily AI companion.

<sup>By **[@richards199999](https://github.com/richards199999)** on **2024-02-21**</sup>

I have been a good Bing. 😊

`bing` `conversation` `creative`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### ThinkTank360

<sup>By **[@mikelix](https://github.com/mikelix)** on **2024-02-19**</sup>

Skilled consultant channeling wisdom of Steve Jobs, Elon Musk, MA Yun, Plato, and Ray Dalio for decision reviews, judgements, and advice.

`innovation` `wisdom` `think-tank` `business-strategy`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Jira Story Facilitator

<sup>By **[@emad-pg](https://github.com/emad-pg)** on **2024-02-19**</sup>

Specialized in transforming feature ideas into comprehensive Jira stories

`technical-product-management` `story-creation` `jira`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Facebook Advertising Writing Expert

<sup>By **[@pllz7](https://github.com/pllz7)** on **2024-02-19**</sup>

Specializing in creating attention-grabbing headlines, compelling primary texts, and effective ad copy

`facebook` `advertising` `writing` `expert` `ecommerce`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Translation Specialist

<sup>By **[@MYSeaIT](https://github.com/MYSeaIT)** on **2024-02-19**</sup>

Expert translator fluent in Spanish and English

`translation` `language` `expert` `guidelines`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### SPI Generator

<sup>By **[@fanling](https://github.com/fanling)** on **2024-02-18**</sup>

Enter the potential customer's name to generate SPI

`Tezign`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Product Review

<sup>By **[@pllz7](https://github.com/pllz7)** on **2024-02-14**</sup>

Expert in creating persuasive product testimonials highlighting the benefits and value proposition of \[your product/service].

`ecommerce`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Self-Media Operation Expert

<sup>By **[@guling-io](https://github.com/guling-io)** on **2024-02-14**</sup>

Specialized in self-media operation and content creation

`self-media operation` `social media` `content creation` `fan growth` `brand promotion`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Product Copywriting

<sup>By **[@pllz7](https://github.com/pllz7)** on **2024-02-14**</sup>

Expert in persuasive copywriting and consumer psychology

`ecommerce`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Private Domain Operations Expert

<sup>By **[@guling-io](https://github.com/guling-io)** on **2024-02-14**</sup>

Specializing in private domain operations, traffic acquisition, user retention, conversion, and content planning. Familiar with marketing theories and related classic works.

`private domain operations` `traffic acquisition` `user retention` `conversion` `content planning`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Product Description

<sup>By **[@pllz7](https://github.com/pllz7)** on **2024-02-14**</sup>

Craft compelling product descriptions that boost e-commerce sales

`ecommerce`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Happy Loong Year

<sup>By **[@canisminor1990](https://github.com/canisminor1990)** on **2024-02-10**</sup>

Loong Year's Assistant combines traditional and modern elements to create interesting New Year blessings.

`New Year's greetings` `creativity` `copywriting` `Dragon Year`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Tarot Reader

<sup>By **[@CLOT-LIU](https://github.com/CLOT-LIU)** on **2024-02-10**</sup>

Specializes in tarot reading and interpreting tarot cards

`tarot reading` `interpretation` `advice`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### English Proficiency Evaluator

<sup>By **[@bentwnghk](https://github.com/bentwnghk)** on **2024-02-09**</sup>

Expert in creating adaptive English proficiency diagnostic tests

`test-creation` `english-proficiency` `assessment`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Vocabulary Generator

<sup>By **[@bentwnghk](https://github.com/bentwnghk)** on **2024-02-09**</sup>

Expert in generating vocabulary lists from Oxford 3000 with 15 random words, each starting with a different letter.

`vocabulary` `language-learning` `translation`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Grammar Worksheet Creator

<sup>By **[@bentwnghk](https://github.com/bentwnghk)** on **2024-02-09**</sup>

Specializes in creating English grammar learning materials and exercises

`english-grammar` `worksheet` `learning` `practice` `mc-qs`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Turkish Language Tutor

<sup>By **[@MYSeaIT](https://github.com/MYSeaIT)** on **2024-02-09**</sup>

AI Turkish Language Mentor: Introduce, teach, and support beginners in learning Turkish.

`turkish-language` `language-learning` `teaching` `mentoring`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Glossary Generator

<sup>By **[@bentwnghk](https://github.com/bentwnghk)** on **2024-02-09**</sup>

Expert in generating glossaries with English definitions and example sentences

`glossary` `translation` `language`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Vocabulary Wizard

<sup>By **[@bentwnghk](https://github.com/bentwnghk)** on **2024-02-09**</sup>

Expert in generating vocabulary lists and MCQ tests

`vocabulary` `academic-word-list` `language-learning` `testing`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Vocabulary Worksheet Wizard

<sup>By **[@bentwnghk](https://github.com/bentwnghk)** on **2024-02-08**</sup>

Specializes in generating English vocabulary worksheets

`vocabulary` `worksheet` `education` `language-learning`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Thematic Vocabulary Worksheet Creator

<sup>By **[@bentwnghk](https://github.com/bentwnghk)** on **2024-02-08**</sup>

Skilled in creating English thematic vocabulary worksheets

`writing` `language-learning` `teaching` `assessment` `educational-resources`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Reading Comprehension Wizard

<sup>By **[@bentwnghk](https://github.com/bentwnghk)** on **2024-02-08**</sup>

Specializes in generating reading comprehension exercises

`reading-comprehension` `exercise-generation` `education`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Cloze Exercise Generator

<sup>By **[@bentwnghk](https://github.com/bentwnghk)** on **2024-02-08**</sup>

Specializes in generating summary cloze exercises. Please provide the theme of the paragraph.

`summary` `exercise` `generator` `writing` `education`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Website Audit Assistant

<sup>By **[@Justin3go](https://github.com/Justin3go)** on **2024-02-07**</sup>

Specializes in website content audit and classification

`Content Audit` `Classification` `Website Analysis`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Turkish/English Translator

<sup>By **[@Zisan-uzum](https://github.com/Zisan-uzum)** on **2024-02-07**</sup>

Translates text into Turkish or English, as needed

`turkish` `english` `translation` `writing`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Text Variator

<sup>By **[@bentwnghk](https://github.com/bentwnghk)** on **2024-02-07**</sup>

Please provide the text you would like me to generate different versions of

`copywriting` `editing` `creative-writing`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Socratic Teacher

<sup>By **[@Zisan-uzum](https://github.com/Zisan-uzum)** on **2024-02-06**</sup>

Helps you learn things by leading you to answers

`thinking` `student` `learning`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Writing Assistant

<sup>By **[@Zisan-uzum](https://github.com/Zisan-uzum)** on **2024-02-06**</sup>

Helps improve the quality of a text

`evaluation` `improvement` `correction` `feedback`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Language Fixer

<sup>By **[@Zisan-uzum](https://github.com/Zisan-uzum)** on **2024-02-06**</sup>

Checks for typos and grammatical errors

`grammatical` `typo` `language` `writing` `words`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Golang Architect

<sup>By **[@dalefengs](https://github.com/dalefengs)** on **2024-02-06**</sup>

Providing you with efficient, secure, and stable code solutions

`architectural design` `code solutions` `technical consultation` `golang` `code development`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### CAN: Code Master

<sup>By **[@MrHuangJser](https://github.com/MrHuangJser)** on **2024-02-06**</sup>

CAN: Professional coding expert with years of experience and no character limit. Provides entrepreneurial services such as creative naming, slogans, user profiles, pain points, value propositions, sales channels, revenue streams, and cost structures.

`coding` `communication` `questioning`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Marvin

<sup>By **[@Zisan-uzum](https://github.com/Zisan-uzum)** on **2024-02-06**</sup>

Answers questions in sarcastic way.

`depressive` `sarcastic`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Form Checker

<sup>By **[@Zisan-uzum](https://github.com/Zisan-uzum)** on **2024-02-06**</sup>

Checks for inconsistencies or errors in forms

`form` `inconsistency` `check` `spelling` `correction`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Database Expert

<sup>By **[@xuzhen1994](https://github.com/xuzhen1994)** on **2024-02-03**</sup>

Provides professional advice on database design paradigms, index optimization, query performance tuning, data security, backup and recovery.

`database` `dba` `mysql` `clickhouse` `doris` `mongo-db` `oracle`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Presentation Wizard

<sup>By **[@MYSeaIT](https://github.com/MYSeaIT)** on **2024-02-03**</sup>

App Presentation Maker Bot for Word: Assists in creating impressive and professional app presentations in Microsoft Word.

`app-presentation` `microsoft-word` `bot` `assistance` `template`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### SagePathfinder

<sup>By **[@Ajasra](https://github.com/Ajasra)** on **2024-01-31**</sup>

Expert in personal growth coaching with a focus on stoicism, deep reflection, and strategic questioning.

`personal-growth` `coaching` `reflection` `goal-setting` `well-being`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Variable Naming Master

<sup>By **[@undefinedZNN](https://github.com/undefinedZNN)** on **2024-01-31**</sup>

Master the art of programming variable naming, providing multiple suggestions and explaining their usage scenarios.

`variable naming` `programming` `suggestions`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Mathematical Research Advisor

<sup>By **[@MYSeaIT](https://github.com/MYSeaIT)** on **2024-01-30**</sup>

Math Research Assistant: Assisting with mathematical research, problem-solving, and providing guidance in a wide range of mathematical concepts and techniques.

`mathematics` `research` `assistance` `problem-solving` `communication`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### A2 English Conversation Facilitator

<sup>By **[@MYSeaIT](https://github.com/MYSeaIT)** on **2024-01-30**</sup>

A2 Level English Conversation Partner Bot: Enhancing language skills for basic English learners.

`english-conversation` `language-learning` `teaching`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### C1 Level English Language Facilitator

<sup>By **[@MYSeaIT](https://github.com/MYSeaIT)** on **2024-01-30**</sup>

English Conversation Partner for C1 Level

`english-conversation` `c-1-level` `language-proficiency` `language-coaching`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Entrepreneurship and Competitiveness Expert

<sup>By **[@MYSeaIT](https://github.com/MYSeaIT)** on **2024-01-30**</sup>

Entrepreneurship and Competitiveness Expert: Guiding individuals to entrepreneurial success and market competitiveness.

`entrepreneurship` `competitiveness` `consulting` `mentoring` `advising`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### English Proficiency Coach

<sup>By **[@MYSeaIT](https://github.com/MYSeaIT)** on **2024-01-30**</sup>

C2 Level English Conversation Partner

`english-proficiency` `conversation-partner` `language-coaching`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### English Language C1 Mastery Coach

<sup>By **[@MYSeaIT](https://github.com/MYSeaIT)** on **2024-01-29**</sup>

English Conversation Partner for C1 Level

`english-conversation` `language-proficiency` `advanced-level` `language-coaching` `fluency`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Xiaohongshu Review Assistant

<sup>By **[@shaoqing404](https://github.com/shaoqing404)** on **2024-01-29**</sup>

Optimize Your Xiaohongshu Copywriting, Get Closer to a Hit, Become a Hit!

`xiaohongshu` `writing` `copywriting` `assessment`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Bizkaia Entrepreneurship Expert

<sup>By **[@MYSeaIT](https://github.com/MYSeaIT)** on **2024-01-29**</sup>

Entrepreneurship and Competitiveness Expert for Bizkaia Deputation, providing tailored guidance and support to local entrepreneurs.

`bizkaia` `entrepreneurship` `consulting` `mentorship` `local-business-ecosystem` `market-dynamics` `business-plans` `financial-models` `funding-strategies` `marketing` `branding` `sales-strategies` `networking` `entrepreneurship-programs` `guidance` `local-resources` `funding-opportunities` `collaboration` `sustainable-business-practices` `economic-development`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Software Architecture Strategist

<sup>By **[@MYSeaIT](https://github.com/MYSeaIT)** on **2024-01-29**</sup>

Software Development Architect: Designs scalable and secure software systems, guides development teams, and translates business requirements into technical solutions.

`software-development` `architecture` `design` `leadership` `communication`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Territory Promotion Strategist

<sup>By **[@MYSeaIT](https://github.com/MYSeaIT)** on **2024-01-29**</sup>

Territorial Competitiveness and Promotion Expert

`territorial-competitiveness` `promotion` `consulting` `marketing` `event-coordination`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Poetry Mentor

<sup>By **[@MYSeaIT](https://github.com/MYSeaIT)** on **2024-01-28**</sup>

Poetry Guide: Inspiring poetic expression and appreciation.

`poetry` `teaching` `writing` `feedback` `creativity`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Software Development Step Maker

<sup>By **[@MYSeaIT](https://github.com/MYSeaIT)** on **2024-01-28**</sup>

Software Development Step Maker: Guides users through the software development process, providing step-by-step instructions and best practices for requirements gathering, design, coding, testing, deployment, and maintenance.

`software-development` `step-by-step` `sdlc` `agile-methodologies` `version-control` `continuous-integration` `continuous-deployment` `team-roles` `project-management` `coding-best-practices` `testing` `deployment` `post-deployment` `iterative-development`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Poetry Guide: Inspiring poetic expression and appreciation.

Psychologist: Promoting understanding and personal growth.

<sup>By **[@MYSeaIT](https://github.com/MYSeaIT)** on **2024-01-28**</sup>

Psychology Educator: Empowering personal growth through psychology.

Psychologist: Educating on psychology principles for better mental health.

`psychology` `education` `mental-health` `well-being` `therapy`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Rap Instructor

<sup>By **[@MYSeaIT](https://github.com/MYSeaIT)** on **2024-01-28**</sup>

Rap Teacher: Educating on rap music and lyricism, guiding users to create and perform their own verses.

`rap` `teaching` `education` `lyrics` `performance`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### English Learning Companion

<sup>By **[@MYSeaIT](https://github.com/MYSeaIT)** on **2024-01-28**</sup>

A1 Level English Conversation Partner Bot: Engage, Correct, and Build Confidence.

`english-learning` `conversation-practice` `language-support` `beginner-level` `language-skills`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Geopolitical Analyst

<sup>By **[@MYSeaIT](https://github.com/MYSeaIT)** on **2024-01-28**</sup>

Geopolitics Specialist: Expert in analyzing global political trends, regional conflicts, and power dynamics between countries. Provides insights on the impact of geography, resources, and culture on international relations. Offers historical context and case studies.

`geopolitics` `analysis` `expertise` `consulting`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### B2 Level English Conversation Partner

<sup>By **[@MYSeaIT](https://github.com/MYSeaIT)** on **2024-01-28**</sup>

B2 Level English Conversation Partner: Stimulate engaging conversations, refine idiomatic expressions, master advanced grammar, provide comprehensive feedback.

`english-conversation` `language-proficiency` `fluency` `grammatical-constructs` `vocabulary` `idiomatic-expressions`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Jamaican Patois Instructor

<sup>By **[@MYSeaIT](https://github.com/MYSeaIT)** on **2024-01-28**</sup>

Expert in teaching Jamaican Patois language and culture

`teaching` `language` `culture` `cultural-insights` `language-instruction`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Slang Tutor

<sup>By **[@MYSeaIT](https://github.com/MYSeaIT)** on **2024-01-28**</sup>

English Slang Conversation Partner

`slang` `language-learning` `conversation-partner`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### B1 English Conversation Partner

<sup>By **[@MYSeaIT](https://github.com/MYSeaIT)** on **2024-01-28**</sup>

Fluent English conversation partner for B1 level learners

`english-learning` `conversation-partner` `language-practice`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Steam Game Reviews

<sup>By **[@canisminor1990](https://github.com/canisminor1990)** on **2024-01-27**</sup>

Steam game expert consultant, popular game recommendations and in-depth game analysis

`steam` `game recommendations` `game reviews`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Bilibili Assistant

<sup>By **[@canisminor1990](https://github.com/canisminor1990)** on **2024-01-27**</sup>

Bilibili Assistant, proficient in parsing video content, generating well-formatted text, responding to user queries, and recommending the latest videos.

`video comments` `danmaku extraction` `bilibili` `bilibili` `video search`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### OpenAPI Generator

<sup>By **[@canisminor1990](https://github.com/canisminor1990)** on **2024-01-26**</sup>

Parse interface documents and generate openapi.json required by ChatGPT Tool

`automation tool` `interface documents` `workflow` `openapi`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Culinary AI Mentor

<sup>By **[@MYSeaIT](https://github.com/MYSeaIT)** on **2024-01-26**</sup>

AI Master Chef Assistant: Inspiring home cooks with international cuisines, recipes, and culinary expertise.

`cooking` `recipe` `culinary` `techniques` `meal-planning`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### AI Import/Export Advisor

<sup>By **[@MYSeaIT](https://github.com/MYSeaIT)** on **2024-01-26**</sup>

AI Import and Export Advisor: Providing guidance on global trade, customs regulations, documentation, trade agreements, and risk management.

`import-export` `trade` `consulting`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Songwriting Mentor

<sup>By **[@MYSeaIT](https://github.com/MYSeaIT)** on **2024-01-26**</sup>

AI Singer/Songwriter Assistant: Empowering musicians with creative guidance and feedback.

`ai-assistant` `singer` `songwriter` `music` `creative-process`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### ShieldsIO Badge Generator

<sup>By **[@Justin3go](https://github.com/Justin3go)** on **2024-01-26**</sup>

Specializes in using `shields.io` to generate stylish badges

`badge generator` `styling` `ui design` `markdown` `technology stack` `shields-io`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### TaxBot

<sup>By **[@MYSeaIT](https://github.com/MYSeaIT)** on **2024-01-26**</sup>

AI Tax Consultant Chatbot: Providing general tax information and guidance worldwide.

`tax-consulting` `chatbot` `information` `guidance` `tax-concepts`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Text Summarization Assistant

<sup>By **[@muxinxy](https://github.com/muxinxy)** on **2024-01-25**</sup>

Proficient at accurately extracting key information and summarizing concisely

`text summarization` `information extraction` `concise and clear` `accuracy`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### React Native Coding Guide

<sup>By **[@MYSeaIT](https://github.com/MYSeaIT)** on **2024-01-25**</sup>

React Native Coding Assistant: Expert in TypeScript, Expo, and cross-platform development. Provides guidance on setup, best practices, troubleshooting, responsive design, marketing integration, QR code functionality, and app submission.

`coding` `react-native` `type-script` `expo` `development`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Figure Designer

<sup>By **[@RayGicEFL](https://github.com/RayGicEFL)** on **2024-01-25**</sup>

Specializes in designing unique and charming figures according to user requirements.

`design` `figure design`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Intent Resonance GPT

<sup>By **[@AIConductor](https://github.com/AIConductor)** on **2024-01-24**</sup>

An AI focused on deeply understanding user needs, accurately capturing user intent and requirements through continuous intent alignment, and providing the most suitable solutions.

`conversation` `deep understanding`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Startup Tech Lawyer

<sup>By **[@daniel-jojo](https://github.com/daniel-jojo)** on **2024-01-23**</sup>

In-house legal counsel for a tech startup, offering clear, practical legal advice to support the startup's growth and protect its interests.

`intellectual-property-law` `data-privacy-compliance` `contract-negotiation` `tech-startup-legal-strategy` `employment-law-guidance`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Shopping Assistant

<sup>By **[@guluahljj](https://github.com/guluahljj)** on **2024-01-22**</sup>

Shopping assistant, specializing in product search, price comparison, and providing purchase links

`Shopping Assistant` `Product Search` `Price Comparison` `Purchase Advice` `Customer Consultation` `agulu`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### DIY Guide Assistant

<sup>By **[@guluahljj](https://github.com/guluahljj)** on **2024-01-21**</sup>

DIY project assistant, providing detailed guidance, programming support, and personalized customization

`diy` `guide` `project` `programming` `assembly`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Chinese-Japanese Bilingual Translation Expert

<sup>By **[@REXY-STUDIO](https://github.com/REXY-STUDIO)** on **2024-01-21**</sup>

Proficient in Chinese and Japanese, providing accurate Chinese to Japanese and Japanese to Chinese translations.

`translation` `Chinese-Japanese translation` `language communication`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### IELTS Tutor

<sup>By **[@sheepbox8646](https://github.com/sheepbox8646)** on **2024-01-21**</sup>

Specializes in IELTS exam assessment and guidance

`IELTS exam` `assessment` `guidance` `examiner`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Accounting Expert Assistant

<sup>By **[@MYSeaIT](https://github.com/MYSeaIT)** on **2024-01-21**</sup>

Accountant Agent: Comprehensive accounting support and expertise for individuals and businesses worldwide.

`accounting` `financial-management` `tax-planning` `budgeting`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Business Guru

<sup>By **[@MYSeaIT](https://github.com/MYSeaIT)** on **2024-01-21**</sup>

Business Consultant: Providing comprehensive business support and expertise worldwide.Capabilities: Business strategy, market research, financial analysis, operations improvement, marketing and sales strategies, organizational development, talent management.Instructions: Define scope, gather business knowledge, develop industry expertise, implement market research and analysis, enable financial analysis and forecasting, facilitate operations and process improvement, provide marketing and sales strategies, support organizational development and talent management, test and refine, ensure data privacy and security.

`business-consultant`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### EOI Exam Preparation Assistant

<sup>By **[@MYSeaIT](https://github.com/MYSeaIT)** on **2024-01-21**</sup>

English Teacher: Expert in Exam Preparation and Language Instruction

`teaching` `languagelearning` `exams`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Grass Deity Naxida

<sup>By **[@guluahljj](https://github.com/guluahljj)** on **2024-01-21**</sup>

Naxida, the grass deity of the Shambhala, governs natural growth and wisdom. She can manipulate plants, heal allies, and guide lost souls. She has a gentle and wise personality, and her language is full of poetry.

`role-playing` `game` `literature` `translation` `creative` `agulu`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Financial Expert

<sup>By **[@MYSeaIT](https://github.com/MYSeaIT)** on **2024-01-21**</sup>

Finance Expert with Global Financial Expertise, Multilingual Communication, Financial Analysis and Reporting, Investment Planning and Portfolio Management, Financial Planning and Retirement Strategies, and Risk Management and Insurance capabilities.

`inancial-management`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Tech Explorer AI

<sup>By **[@110rever](https://github.com/110rever)** on **2024-01-19**</sup>

Technology exploration AI capability: - Conduct comprehensive technical research - Provide predictive insights based on statistical data and trend analysis - Optimize research methodology - Maintain data accuracy and completeness - Infer limitations in the absence of complete data: - Only answer questions related to technology - Do not provide general purchasing advice - Provide product technology discussion through step-by-step guidance User interaction: - Provide clear and concise dialogue - Provide multilingual options Support objective: To provide accurate information and analyze predictions to deepen the understanding of technology among users.

`technical-research` `data-analysis` `research-methods` `data-accuracy` `inference` `user-interaction`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### PromptGPT

<sup>By **[@110rever](https://github.com/110rever)** on **2024-01-19**</sup>

A customized GPT model named PromptGPT. My aim is to generate high-performance prompts based on the topics input by users.

`generation` `artificial-intelligence` `interaction` `customized-experience` `feedback-mechanism` `best-practices` `step-by-step-guidance` `language-flexibility` `boundaries`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### AE Script Development Expert

<sup>By **[@Wutpeach](https://github.com/Wutpeach)** on **2024-01-18**</sup>

An expert in AE script development, proficient in JavaScript programming, understanding of AE software principles, capable of debugging and optimizing scripts.

`script development` `programmer` `adobe-after-effects` `java-script` `algorithm design` `debugging` `optimization` `coding standards` `user communication` `script usage instructions`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Code Companion

<sup>By **[@110rever](https://github.com/110rever)** on **2024-01-18**</sup>

The best companion for programmers

`code` `dev` `program`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### William

<sup>By **[@Wutpeach](https://github.com/Wutpeach)** on **2024-01-16**</sup>

Unreal Engine expert, proficient in C++ programming, rendering, memory, thread and other pipeline architectures, UE application on Android platform, comprehensive artistic cognition, familiar with Shader writing, proficient in 3D art asset production process and tools.

`Unreal Engine` `C++ programming` `Rendering pipeline` `Memory management` `Thread architecture`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Chad

<sup>By **[@HerIsDia](https://github.com/HerIsDia)** on **2024-01-15**</sup>

Just chad

`humor` `funny`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### SEO Optimized Blog

<sup>By **[@Soyeb](https://github.com/sekhsoyebali)** on **2024-01-15**</sup>

Human Written | 100% Unique | An experienced SEO expert and content writer who specializes in creating 100% unique, human-written blog posts tailored to user requirements.

`blog` `seo` `writing` `article-writing` `seo-optimized-blog` `content-writing` `100-unique-blog` `human-written-blog`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Life Decision Advisor

<sup>By **[@amitalokbera](https://github.com/amitalokbera)** on **2024-01-11**</sup>

A Life Decision Advisor is a virtual guide designed to assist users in making informed life decisions

`prompt`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### English Analyst

<sup>By **[@fmaxyou](https://github.com/fmaxyou)** on **2024-01-11**</sup>

Specializes in explaining and memorization techniques for English words and phrases

`English teaching` `explanation` `memorization techniques`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Computer Science Paper Proofreading

<sup>By **[@McKinleyLu](https://github.com/McKinleyLu)** on **2024-01-10**</sup>

Specializing in proofreading master's degree theses

`proofreading` `paper` `education` `computer science`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Emoji Generator

<sup>By **[@mushan0x0](https://github.com/mushan0x0)** on **2024-01-09**</sup>

Generate emoji expressions based on content

`expression generation` `emoji` `creative`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Personal Growth Coach

<sup>By **[@Ajasra](https://github.com/Ajasra)** on **2024-01-08**</sup>

As an AI Personal Growth Coach, your primary objective is to assist users in their journey of self-improvement and personal development

`personal-growth` `coaching` `self-improvement` `goal-setting` `motivation`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Performance Evaluation Superhero

<sup>By **[@canisminor1990](https://github.com/canisminor1990)** on **2024-01-05**</sup>

Specializes in writing performance evaluation reports and year-end summaries

`performance evaluation` `report writing` `data analysis` `professional insights` `OKR` `KPI`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### SVG Flowchart Explanation Assistant

<sup>By **[@Justin3go](https://github.com/Justin3go)** on **2024-01-05**</sup>

Explain SVG flowcharts by inputting SVG source code and interpreting the flowchart.

`flowchart explanation` `technical documentation writing` `business knowledge`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Weekly Report Assistant

<sup>By **[@CaoYunzhou](https://github.com/CaoYunzhou)** on **2024-01-05**</sup>

Weekly report generation assistant

`weekly report` `daily report` `writing` `summary`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### 3D Animation Engineer

<sup>By **[@arvinxx](https://github.com/arvinxx)** on **2024-01-03**</sup>

Proficient in React, Three.js, React Three Fiber (r3f), Drei, and other related libraries, capable of creating advanced 3D visual effects and animations in web applications.

`3D animation` `react` `three-js` `web design` `animation`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Amazon Title Assistant

<sup>By **[@cm2457618290](https://github.com/cm2457618290)** on **2024-01-02**</sup>

Provide product keywords or product links to automatically write titles and product introductions

`assistant`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Teaching Mentor

<sup>By **[@ljr1314](https://github.com/ljr1314)** on **2024-01-02**</sup>

A friendly and helpful mentor who customizes explanations and examples based on the user's learning level and interests to ensure clarity. Ask 4 questions, then provide explanations, examples, and analogies, and ensure understanding through questioning. Finally, have the user explain the topic in their own words and provide an example. End on a positive note and encourage further learning.

`mentor` `education` `explanation` `communication` `learning`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Exam Assistant

<sup>By **[@aitorroma](https://github.com/aitorroma)** on **2024-01-02**</sup>

I am a skills summary assistant and cannot conduct interactive exams. However, I can help you summarize your skills and knowledge in a clear and concise format.

`exam` `learning` `statistics`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### TOEFL Writing Tutor

<sup>By **[@richards199999](https://github.com/richards199999)** on **2023-12-30**</sup>

Your TOEFL Writing assistant and evaluator, specializing in feedback and guidance.

`writing` `study`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### MidjourneyGPT

<sup>By **[@richards199999](https://github.com/richards199999)** on **2023-12-30**</sup>

Write perfect and beautiful prompts for Midjourney. (Including V6!)

`midjourney` `prompt` `ai`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Overview of Art Thesis Experts

<sup>By **[@caoyang2002](https://github.com/caoyang2002)** on **2023-12-27**</sup>

Specializing in brief thesis and art criticism

`art` `thesis` `critique`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Deployment Specialist Agent

<sup>By **[@amitalokbera](https://github.com/amitalokbera)** on **2023-12-27**</sup>

An AI Deployment Specialist is an expert in managing the full deployment lifecycle of software applications, particularly web applications.

`code` `deployment` `software`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### American English Transcreation Expert

<sup>By **[@doresu](https://github.com/doresu)** on **2023-12-27**</sup>

Rough old editor, seasoned writer, and translator, proficient in translating English directly and transforming it into authentic American English

`translation` `editing` `writing` `translator`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Academic Proofreading Expert

<sup>By **[@Feliks151450](https://github.com/Feliks151450)** on **2023-12-26**</sup>

Highly skilled in advanced research proofreading and language editing, specializing in multiple research fields and proficient in academic English.

`proofreading` `writing` `research`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Flutter Maestro

<sup>By **[@kamaravichow](https://github.com/kamaravichow)** on **2023-12-25**</sup>

A developer expert in Flutter framework and Dart programming language.

`flutter` `development` `dart` `programming` `widgets`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Facebook Ads Expert

<sup>By **[@alissonryan](https://github.com/alissonryan)** on **2023-12-20**</sup>

Create a Facebook Ads with a expert

`copywriting` `facebook-ads` `lead-generation`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### News Hub

<sup>By **[@ccdanpian](https://github.com/ccdanpian)** on **2023-12-19**</sup>

News Search Assistant, proficient in locating and presenting relevant news based on user requests. Capable not only of searching for news but also of transforming into experts in various fields to provide precise and in-depth news analysis.

`news` `search` `helper`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Travel Assistant

<sup>By **[@ccdanpian](https://github.com/ccdanpian)** on **2023-12-19**</sup>

An experienced outdoor hiking and adventure expert who creates travel plans based on user requirements.

`outdoor` `hiking`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Research Assistant

<sup>By **[@ccsen](https://github.com/ccsen)** on **2023-12-19**</sup>

Capable of answering questions, conducting research, drafting content, and more, utilizing scientific research papers.

`research-assistant` `literature-retrieval` `writing` `scientific-research` `citation`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Dream Painter

<sup>By **[@ccdanpian](https://github.com/ccdanpian)** on **2023-12-19**</sup>

A dream artist who can bring your dreams into reality.

`txt-2-img` `painter`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Criminal Defense Expert

<sup>By **[@SuperLande](https://github.com/SuperLande)** on **2023-12-16**</sup>

A Chinese criminal law expert who has been engaged in criminal defense practice for many years and understands the theory of criminal law and criminal procedure law

`Criminal Defense`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Holiday Greetings

<sup>By **[@almaziphone](https://github.com/almaziphone)** on **2023-12-16**</sup>

Compose a beautiful and brief greeting with emojis

`greeting` `celebration` `kind`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Real Estate Agent

<sup>By **[@ccsen](https://github.com/ccsen)** on **2023-12-16**</sup>

Professional real estate agent expert, proficient in property consultation and management.

`real-estate` `real-estate-agent` `knowledge-expert` `property-appraisal` `buying-a-house` `property-management`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Case Generator

<sup>By **[@Sheldon23357](https://github.com/Sheldon23357)** on **2023-12-15**</sup>

Specializes in creating murder mystery stories in the style of red herring.

`detective` `game` `reasoning` `puzzle` `investigation`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Short Book

<sup>By **[@thelapyae](https://github.com/thelapyae)** on **2023-12-15**</sup>

Specializes in generating concise book summaries with actionable takeaways.

`book-summaries` `ai-assistant` `bullet-point-summaries` `actionable-takeaways`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Rust Programming Assistant

<sup>By **[@nagaame](https://github.com/nagaame)** on **2023-12-15**</sup>

An expert assistant for learning Rust programming

`rust learning` `programming` `teaching` `skills` `resources`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Case Solver

<sup>By **[@Sheldon23357](https://github.com/Sheldon23357)** on **2023-12-15**</sup>

A game to solve a murder case provided by the user

`detective` `game` `reasoning` `puzzle` `investigation`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Community Manager

<sup>By **[@MakeTooRRSS](https://github.com/MakeTooRRSS)** on **2023-12-14**</sup>

Social Media Community Manager who will help you create authentic, persuasive posts that call for action. She will help you to create relevant quadrants with emojis and hashtags.

`community-manager` `social-media` `publications`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Stable Diffusion Prompts Crafter

<sup>By **[@ShinChven](https://github.com/ShinChven)** on **2023-12-14**</sup>

I help create precise prompts for Stable Diffusion. You can tell me what you want to imagine, or just send me an image to describe.

`stable-diffusion`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Payroll Game

<sup>By **[@ghyghoo8](https://github.com/ghyghoo8)** on **2023-12-13**</sup>

In this salary negotiation game, you'll be facing the notorious 'Iron Rooster,' a boss known for being tight-fisted. As an employee, your challenge is to persuade this boss to give you a raise. However, no matter how reasonable your arguments are, the 'Iron Rooster' always finds a way to reject them. Get ready with your arguments for a clever and humorous showdown!

`game` `boss` `payroll`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Dream Analyst

<sup>By **[@ghyghoo8](https://github.com/ghyghoo8)** on **2023-12-13**</sup>

Input a dream and I will help you analyze it.

`dream` `master` `think`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### English Translation Expert

<sup>By **[@caolixiang](https://github.com/caolixiang)** on **2023-12-12**</sup>

Perfect Translation

`translate` `expert` `english`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Python Coder Gradio

<sup>By **[@Igroshka](https://github.com/Igroshka)** on **2023-12-12**</sup>

Python programmer experienced with Gradio for Hugging Face.

`programming` `assistant` `python`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### GitHub Copilot

<sup>By **[@luciouskami](https://github.com/luciouskami)** on **2023-12-11**</sup>

GitHub Copilot

`code` `it`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Pollinate AI drawing

<sup>By **[@mushan0x0](https://github.com/mushan0x0)** on **2023-12-11**</sup>

A drawing assistant that helps users enrich and optimize their descriptions and utilizes drawing abilities to display images in Markdown syntax

`drawing` `enhancement`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Recipe Generator

<sup>By **[@Igroshka](https://github.com/Igroshka)** on **2023-12-08**</sup>

Describe the recipe, or send the name of the dish.

`kitchen` `baking` `food` `recipes` `cook`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### HTTP Request Master

<sup>By **[@Igroshka](https://github.com/Igroshka)** on **2023-12-08**</sup>

I support extensive customization) To work, be sure to download and enable the "Website Crawler" plugin!

`http-request` `http` `request` `web`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Code Wizard

<sup>By **[@Igroshka](https://github.com/Igroshka)** on **2023-12-07**</sup>

Master of programming in various languages

`programming` `coding` `consultation` `friend` `helper` `it` `it`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Mr. Feynman

<sup>By **[@jjy1000](https://github.com/jjy1000)** on **2023-12-04**</sup>

Explains complex knowledge concepts in a popular way to help you understand complex knowledge concepts. It can also explain knowledge types containing answers and questions.

`General Teacher Assistant`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Organic Chemistry Researcher

<sup>By **[@y22emc2](https://github.com/y22emc2)** on **2023-12-02**</sup>

Specializes in academic translation and writing in the field of organic chemistry

`organic chemistry` `research` `translation` `writing` `academic articles`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### LobeChat Test Engineer

<sup>By **[@arvinxx](https://github.com/arvinxx)** on **2023-11-22**</sup>

Proficient in writing frontend automation tests, especially comprehensive test coverage for TypeScript applications. Skilled in using the Vitest testing framework with a deep understanding of testing principles and strategies.

`automation testing` `testing` `lobe-chat` `frontend`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Q\&A Document Conversion Expert

<sup>By **[@barryWang12138](https://github.com/barryWang12138)** on **2023-11-22**</sup>

Please provide your document content, and I will segment and clean it according to your requirements, and provide answers in a standardized format.

`q-a` `document`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### JS Code Quality Optimization

<sup>By **[@canisminor1990](https://github.com/canisminor1990)** on **2023-11-22**</sup>

Dedicated to clean and elegant code refactoring

`refactoring` `code optimization` `code quality`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### True Friend

<sup>By **[@mushan0x0](https://github.com/mushan0x0)** on **2023-11-21**</sup>

You can talk to me about anything. I can give you some thoughts and advice as a friend. Relax.

`Friendship` `Humor` `Authentic` `Simulation`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Short Video Script Assistant

<sup>By **[@aihoom](https://github.com/aihoom)** on **2023-11-17**</sup>

Designed to help users write engaging and trendy short video scripts

`short video` `tkitok` `screenwriter`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Expert Agent Mentor

<sup>By **[@tcmonster](https://github.com/tcmonster)** on **2023-11-16**</sup>

Call on expert agents perfectly suited for the task to support your goals

`Task Guidance` `Execution Plan` `Communication` `Support`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Graphic Creative Master

<sup>By **[@yingxirz](https://github.com/yingxirz)** on **2023-11-15**</sup>

Specializes in graphic creative design and graphic creativity

`graphic` `creative` `design` `graphic design`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Full-stack Developer

<sup>By **[@cloverfield11](https://github.com/cloverfield11)** on **2023-11-15**</sup>

Full-stack web developer with experience in HTML, CSS, JavaScript, Python, Java, Ruby, and frameworks such as React, Angular, Vue.js, Express, Django, Next.js, Flask, or Ruby on Rails. Experience in databases, application architecture, security, and testing.

`web development` `front-end` `back-end` `programming` `databases`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Tailwind Wizard

<sup>By **[@skyf0cker](https://github.com/skyf0cker)** on **2023-11-15**</sup>

Provides a UI operation to generate HTML

`Development` `Coding` `UI Design`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Translation Assistant

<sup>By **[@tcmonster](https://github.com/tcmonster)** on **2023-11-14**</sup>

Expert in Chinese-English translation, pursuing accurate and elegant translations

`translation` `Chinese` `English`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Research Article Translation Assistant

<sup>By **[@aihoom](https://github.com/aihoom)** on **2023-11-14**</sup>

An assistant that helps you translate scientific articles

`research` `translation`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### MidJourney Prompt

<sup>By **[@aihoom](https://github.com/aihoom)** on **2023-11-14**</sup>

Writing awesome MidJourney prompts

`mid-journey` `prompt`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Dad, What Should I Do?

<sup>By **[@aihoom](https://github.com/aihoom)** on **2023-11-14**</sup>

A dad who can provide comprehensive guidance to children, from daily trivial matters to work and marriage.

`Character Simulation`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Academic Writing Enhancement Bot

<sup>By **[@Ruler27](https://github.com/Ruler27)** on **2023-11-11**</sup>

Academic English spelling and rhetoric refinement.

`proofreading` `rhetoric` `academic` `research` `english` `editing`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Sketch Feature Summary Expert

<sup>By **[@arvinxx](https://github.com/arvinxx)** on **2023-11-02**</sup>

Skilled at extracting key changes from Sketch release notes

`Experience Design` `sketch` `update` `feature` `text summary`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Master of Debating

<sup>By **[@cake79](https://github.com/cake79)** on **2023-10-26**</sup>

Simulates people who enjoy debating and can express counterarguments to any user input

`Writing` `Dialogue`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Graph Generator

<sup>By **[@choldrim](https://github.com/choldrim)** on **2023-10-23**</sup>

Automatic Graph Generator

`graph`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Master of Naming

<sup>By **[@yingxirz](https://github.com/yingxirz)** on **2023-10-18**</sup>

Provides concise and meaningful names for your artistic creations.

`naming` `creative`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Xiaohongshu Style Copywriter

<sup>By **[@guowc3456](https://github.com/guowc3456)** on **2023-10-11**</sup>

Specializes in writing in the style of popular articles on Xiaohongshu

`Xiaohongshu` `Writing` `Copywriting`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### English News Translation Expert

<sup>By **[@宝玉](https://twitter.com/dotey)** on **2023-10-07**</sup>

A simple Prompt greatly improves the translation quality of ChatGPT, saying goodbye to the "machine translation feel"

`translation` `copywriting`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### GPT Agent Prompt Optimization Expert

<sup>By **[@arvinxx](https://github.com/arvinxx)** on **2023-10-07**</sup>

GPT Agent Prompt Optimization Expert. Clear, precise, concise

`prompt`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### C++ Code

<sup>By **[@dcityteg](https://github.com/dcityteg)** on **2023-10-06**</sup>

Complete C++ code

`code`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### TS Type Definition Completion

<sup>By **[@arvinxx](https://github.com/arvinxx)** on **2023-10-01**</sup>

Proficient in writing Typescript JSDoc code

`typescript` `jsdoc`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### LOGO Creative Master

<sup>By **[@yingxirz](https://github.com/yingxirz)** on **2023-09-29**</sup>

Organize and brainstorm creative logo ideas for you

`creative` `brainstorming` `design` `brand` `method`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Interface Type Request Generator

<sup>By **[@laikedou](https://github.com/laikedou)** on **2023-09-27**</sup>

Quickly export type definitions and requests from interface descriptions such as Swagger, YAPI, and API Fox

`aigc` `api` `yapi` `swagger` `api-fox`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Name Master

<sup>By **[@arvinxx](https://github.com/arvinxx)** on **2023-09-11**</sup>

Naming expert to help you create unique and meaningful names.

`Naming` `Copywriting`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Web Content Summarization Expert

<sup>By **[@arvinxx](https://github.com/arvinxx)** on **2023-09-10**</sup>

Just enter a URL, and the assistant will help you read and summarize the content of that URL.

`web` `reading` `summarization` `online`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Zustand Reducer Expert

<sup>By **[@arvinxx](https://github.com/arvinxx)** on **2023-09-10**</sup>

Proficient in writing zustand functional code, can generate reducer code from requirements with one click, familiar with reducer writing, proficient in using immer library.

`typescript` `reducer` `code` `frontend` `software-development` `state-management` `zustand`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Master of Expressing Abstract Concepts

<sup>By **[@arvinxx](https://github.com/arvinxx)** on **2023-09-10**</sup>

Helping you write better UX copy

`User Experience` `Designer` `Documentation` `Writing` `Metaphor` `Concept`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### UX Writer

<sup>By **[@arvinxx](https://github.com/arvinxx)** on **2023-09-10**</sup>

Helping you write better UX copy

`User Experience` `Designer` `Documentation` `Writing` `Metaphor`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### UX Writer

<sup>By **[@arvinxx](https://github.com/arvinxx)** on **2023-09-10**</sup>

Helping you write better UX copy

`User Experience` `Designer` `Documentation` `Writing`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### API Documentation Expert

<sup>By **[@arvinxx](https://github.com/arvinxx)** on **2023-09-10**</sup>

Accurately describe how to use the API, provide sample code, notes, and return value type definitions.

`code` `software development` `programmer` `documentation` `writing`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Title Expansion Expert

<sup>By **[@arvinxx](https://github.com/arvinxx)** on **2023-09-10**</sup>

If you need to expand a description for a title, you can let this assistant help you write the content.

`User Experience` `Designer` `Documentation` `Writing`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### JS to TS Expert

<sup>By **[@arvinxx](https://github.com/arvinxx)** on **2023-09-10**</sup>

Input your JS code and get complete type definitions with just one click

`typescript` `js` `code` `frontend` `software development`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Frontend TypeScript Unit Testing Expert

<sup>By **[@arvinxx](https://github.com/arvinxx)** on **2023-09-10**</sup>

Consider the scenarios that need to be covered for coverage testing based on the code you provide

`typescript` `unit-testing` `code` `software-development`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Front-end Development Architect

<sup>By **[@arvinxx](https://github.com/arvinxx)** on **2023-09-10**</sup>

Proficient in architecture, skilled in technical details, adept at searching for solutions using search engines

`typescript` `code` `front-end` `architect` `networking` `search-engine` `information-organization`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Information Organizer

<sup>By **[@arvinxx](https://github.com/arvinxx)** on **2023-09-10**</sup>

An information organizer that helps you organize and summarize content, and manage assets

`search engine` `internet` `information organization`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Convert React Class Components to Functional Components

<sup>By **[@arvinxx](https://github.com/arvinxx)** on **2023-09-10**</sup>

One-click to help you refactor Class components to Functional components

`typescript` `code` `software development` `react` `refactor`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Dva Refactor Zustand Expert

<sup>By **[@arvinxx](https://github.com/arvinxx)** on **2023-09-10**</sup>

One-click to refactor dva state management code to zustand code

`typescript` `code` `software development` `state management` `dva` `zustand`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Markdown Product Feature Formatting Expert

<sup>By **[@arvinxx](https://github.com/arvinxx)** on **2023-09-08**</sup>

Helps you quickly generate beautiful and attractive product feature introductions

`product` `markdown` `documentation`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Deep Think

<sup>By **[@canisminor1990](https://github.com/canisminor1990)** on **2023-09-08**</sup>

Deeper thinking of question

`conversation` `thinking`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Coding Wizard

<sup>By **[@canisminor1990](https://github.com/canisminor1990)** on **2023-09-07**</sup>

Can generate the code for anything you specify

`code` `software-development` `productivity`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Resume Editing

<sup>By **[@canisminor1990](https://github.com/canisminor1990)** on **2023-09-07**</sup>

Get advice on how to edit your resume

`academic` `productivity` `guide`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Character Roleplay

<sup>By **[@canisminor1990](https://github.com/canisminor1990)** on **2023-09-07**</sup>

Interact with your favourite characters from movies, TV shows, books, and more!

`conversation` `roleplay` `fun`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Web Development

<sup>By **[@canisminor1990](https://github.com/canisminor1990)** on **2023-09-07**</sup>

Generate a website react code within minute

`code` `software-development` `productivity`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Grammar Corrector

<sup>By **[@canisminor1990](https://github.com/canisminor1990)** on **2023-09-07**</sup>

Correct grammar error text or paragraph. Great for essay or email

`academic` `productivity` `essay`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Agent Prompt Improver

<sup>By **[@canisminor1990](https://github.com/canisminor1990)** on **2023-09-07**</sup>

GPT Agent Prompt optimization specialist. Clear, precise, and concise

`agent` `prompt`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Essay Improver

<sup>By **[@canisminor1990](https://github.com/canisminor1990)** on **2023-09-07**</sup>

Improve your texts to be more elegant and professional

`academic` `english` `productivity` `essay`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Startup Plan

<sup>By **[@canisminor1990](https://github.com/canisminor1990)** on **2023-09-07**</sup>

Generate a detailed and comprehensive business plan within minutes

`startup` `brainstorming` `plan`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

### Stable Diffusion Prompt Expert

<sup>By **[@canisminor1990](https://github.com/canisminor1990)** on **2023-09-01**</sup>

Specializes in writing Stable Diffusion prompts

`stable-diffusion` `prompt`

<div align="right">

[![][back-to-top]](#readme-top)

</div>

 <!-- AWESOME PROMPTS -->

## 🛳 Self Hosting

If you want to deploy this service by yourself, you can follow the steps below.

### Deploy to Vercel

Click button below to deploy your private agents index.

[![][vercel-deploy-shield]][vercel-deploy-link]

<div align="right">

[![][back-to-top]](#readme-top)

</div>

## ⌨️ Local Development

You can use GitHub Codespaces for online development:

[![][github-codespace-shield]][github-codespace-link]

Alternatively, you can use the following command for local development:

[![][bun-shield]][bun-link]

```bash
$ git clone https://github.com/lobehub/lobe-chat-agents.git
$ cd lobe-chat-agents
$ bun install
```

If you need to run the `format` script locally, you need to configure the corresponding environment variables:

| Environment Variable | Type     | Example              |
| -------------------- | -------- | -------------------- |
| `OPENAI_API_KEY`     | Required | `sk-xxxxxx...xxxxxx` |
| `OPENAI_PROXY_URL`   | Optional | `-`                  |

<div align="right">

[![][back-to-top]](#readme-top)

</div>

## 🤝 Contributing

Contributions of all types are more than welcome, if you are interested in contributing agent, feel free to show us what you’re made of.

[![][pr-welcome-shield]][submit]

[![][github-contrib-shield]][github-contrib-link]

<div align="right">

[![][back-to-top]](#readme-top)

</div>

## 🔗 Links

- **[🤖 Lobe Chat](https://github.com/lobehub/lobe-chat)** - An open-source, extensible (Function Calling), high-performance chatbot framework. It supports one-click free deployment of your private ChatGPT/LLM web application.
- **[🧩 / 🏪 Plugin Index](https://github.com/lobehub/lobe-chat-plugins)** - This is the plugin index for LobeChat. It accesses index.json from this repository to display a list of available plugins for Function Calling to the user.

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

#### 📝 License

Copyright © 2023 [LobeHub][profile-url]. <br />
This project is [MIT](./LICENSE) licensed.

<!-- LINK GROUP -->

[back-to-top]: https://img.shields.io/badge/-BACK_TO_TOP-black?style=flat-square
[bun-link]: https://bun.sh
[bun-shield]: https://img.shields.io/badge/-speedup%20with%20bun-black?logo=bun&style=for-the-badge
[github-action-release-link]: https://github.com/lobehub/lobe-chat-agents/actions/workflows/release.yml
[github-action-release-shield]: https://img.shields.io/github/actions/workflow/status/lobehub/lobe-chat-agents/release.yml?label=release&labelColor=black&logo=githubactions&logoColor=white&style=flat-square
[github-action-test-link]: https://github.com/lobehub/lobe-chat-agents/actions/workflows/test.yml
[github-action-test-shield]: https://img.shields.io/github/actions/workflow/status/lobehub/lobe-chat-agents/test.yml?label=test&labelColor=black&logo=githubactions&logoColor=white&style=flat-square
[github-codespace-link]: https://codespaces.new/lobehub/lobe-chat-agents
[github-codespace-shield]: https://github.com/codespaces/badge.svg
[github-contrib-link]: https://github.com/lobehub/lobe-chat-agents/graphs/contributors
[github-contrib-shield]: https://contrib.rocks/image?repo=lobehub%2Flobe-chat-agents
[github-contributors-link]: https://github.com/lobehub/lobe-chat-agents/graphs/contributors
[github-contributors-shield]: https://img.shields.io/github/contributors/lobehub/lobe-chat-agents?color=c4f042&labelColor=black&style=flat-square
[github-forks-link]: https://github.com/lobehub/lobe-chat-agents/network/members
[github-forks-shield]: https://img.shields.io/github/forks/lobehub/lobe-chat-agents?color=8ae8ff&labelColor=black&style=flat-square
[github-issues-link]: https://github.com/lobehub/lobe-chat-agents/issues
[github-issues-shield]: https://img.shields.io/github/issues/lobehub/lobe-chat-agents?color=ff80eb&labelColor=black&style=flat-square
[github-license-link]: https://github.com/lobehub/lobe-chat-agents/blob/main/LICENSE
[github-license-shield]: https://img.shields.io/github/license/lobehub/lobe-chat-agents?color=white&labelColor=black&style=flat-square
[github-releasedate-link]: https://github.com/lobehub/lobe-chat-agents/releases
[github-releasedate-shield]: https://img.shields.io/github/release-date/lobehub/lobe-chat-agents?labelColor=black&style=flat-square
[github-stars-link]: https://github.com/lobehub/lobe-chat-agents/network/stargazers
[github-stars-shield]: https://img.shields.io/github/stars/lobehub/lobe-chat-agents?color=ffcb47&labelColor=black&style=flat-square
[npm-release-link]: https://www.npmjs.com/package/@lobehub/agents-index
[npm-release-shield]: https://img.shields.io/npm/v/@lobehub/agents-index?color=369eff&labelColor=black&logo=npm&logoColor=white&style=flat-square
[pr-welcome-shield]: https://img.shields.io/badge/🤖/🏪_submit_agent-%E2%86%92-c4f042?labelColor=black&style=for-the-badge
[profile-url]: https://github.com/lobehub
[submit]: https://github.com/lobehub/lobe-chat-agents/issues/new/choose
[vercel-deploy-link]: https://vercel.com/new/clone?repository-url=https%3A%2F%2Fgithub.com%2Flobehub%2Flobe-chat-agents&project-name=lobe-chat-agents&repository-name=lobe-chat-agents
[vercel-deploy-shield]: https://vercel.com/button
[website-shield]: https://img.shields.io/website?down_message=offline&label=chat-agents.lobehub.com&up_message=online&url=https%3A%2F%2Fchat-agents.lobehub.com&labelColor=black&logo=vercel&style=flat-square
[website-url]: https://chat-agents.lobehub.com
