# v2.10

This release brings a few minor improvements and bug fixes rather than big new headline features.

### Breaking Changes:

* None

### Features:

* Added support for ranges to be used as variables. eg
  ```
  f: +f -> set v
  echo: @v[2..]
  ```

* Complete re-write of `f`. It is now the tool I had always intended when I first created that builtin

* `g` now supports being run as a method (eg to filter items from a file list)

* `rx` now supports being run as a method (eg to filter items from a file list)

* Updated autocompletes for `git`

* Updated autocompletes for `terraform`

### Minor Changes:

* Added support for profiling

* Removed unused data types

* Dropped `profile/` prefix from the module string for modules and profiles (as seen in `FileRef`)

### Bug Fixes:

* Lots of improvements to how `||` and `&&` are used in other `runmode`'s, `try`, and `trypipe`

* autoglob prompt now has a mutex wrapped around it to prevent concurrent processes sending the prompt haywire

* Spellchecker no longer underlines partial words

* Better removal of \\x16 and other non-printable characters leaking into readline

<hr>

Published: 01.08.2022 at 20:10

## See Also

* [FileRef](../user-guide/fileref.md):
  How to track what code was loaded and from where
* [Filter By Range `[ ..Range ]`](../parser/range.md):
  Outputs a ranged subset of data from stdin
* [Function / Module Defaults (`runmode`)](../commands/runmode.md):
  Alter the scheduler's behaviour at higher scoping level
* [Globbing (`g`)](../commands/g.md):
  Glob pattern matching for file system objects (eg `*.txt`)
* [List Filesystem Objects (`f`)](../commands/f.md):
  Lists or filters file system objects (eg files)
* [Modules And Packages](../user-guide/modules.md):
  An introduction to Murex modules and packages
* [Pipe Fail (`trypipe`)](../commands/trypipe.md):
  Checks for non-zero exits of each function in a pipeline
* [Profile Files](../user-guide/profile.md):
  A breakdown of the different files loaded on start up
* [Regex Matches (`rx`)](../commands/rx.md):
  Regexp pattern matching for file system objects (eg `.*\\.txt`)
* [Schedulers](../user-guide/schedulers.md):
  Overview of the different schedulers (or 'run modes') in Murex
* [Spellcheck](../integrations/spellcheck.md):
  How to enable inline spellchecking
* [Tab Autocompletion (`autocomplete`)](../commands/autocomplete.md):
  Set definitions for tab-completion in the command line
* [Try Block (`try`)](../commands/try.md):
  Handles non-zero exits inside a block of code
* [`&&` And Logical Operator](../parser/logical-and.md):
  Continues next operation if previous operation passes
* [`||` Or Logical Operator](../parser/logical-or.md):
  Continues next operation only if previous operation fails

<hr/>

This document was generated from [gen/changelog/v2.10_doc.yaml](https://github.com/lmorg/murex/blob/master/gen/changelog/v2.10_doc.yaml).