//===- torch-mlir-lsp-server.cpp - MLIR Language Server ---------*- C++ -*-===//
//
// This file is licensed under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// Also available under a BSD-style license. See LICENSE.
//
//===----------------------------------------------------------------------===//

#include "mlir/IR/Dialect.h"
#include "mlir/IR/MLIRContext.h"
#include "mlir/Tools/mlir-lsp-server/MlirLspServerMain.h"
#include "torch-mlir/InitAll.h"

using namespace mlir;

int main(int argc, char **argv) {
  DialectRegistry registry;
  mlir::torch::registerAllDialects(registry);
  mlir::torch::registerOptionalInputDialects(registry);
  return failed(MlirLspServerMain(argc, argv, registry));
}
