import type { MarketingConfig } from "@/types";
import { siteConfig } from "./site";

export const marketingConfig: MarketingConfig = {
  mainNav: [
    {
      title: "Docs",
      href: "/docs",
      isDesktopOnly: true,
    },
    {
      title: "Demo",
      href: `/chat`,
    },

    {
      title: "Contact",
      href: "/contact",
      subLinks: [
        {
          title: "Email us",
          description: "richard@llm-ui.com",
          href: `mailto:richard@llm-ui.com`,
        },
        {
          title: "Open a Github issue",
          description: "For a bug or feature request",
          href: `${siteConfig.links.github}/issues/new`,
        },
        {
          title: "Get help on Discord",
          description: "Ask questions on Discord",
          href: siteConfig.links.discord,
        },
      ],
    },
    {
      title: "About",
      href: "/about",
    },
  ],
  models: [
    {
      title: "ChatGPT",
      logo: (
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 320 320">
          <path
            fill="currentColor"
            d="M297.06 130.97a79.712 79.712 0 00-6.85-65.48c-17.46-30.4-52.56-46.04-86.84-38.68A79.747 79.747 0 00143.24 0C108.2-.08 77.11 22.48 66.33 55.82a79.754 79.754 0 00-53.31 38.67c-17.59 30.32-13.58 68.54 9.92 94.54a79.712 79.712 0 006.85 65.48c17.46 30.4 52.56 46.04 86.84 38.68a79.687 79.687 0 0060.13 26.8c35.06.09 66.16-22.49 76.94-55.86a79.754 79.754 0 0053.31-38.67c17.57-30.32 13.55-68.51-9.94-94.51zM176.78 299.08a59.77 59.77 0 01-38.39-13.88c.49-.26 1.34-.73 1.89-1.07l63.72-36.8a10.36 10.36 0 005.24-9.07v-89.83l26.93 15.55c.29.14.48.42.52.74v74.39c-.04 33.08-26.83 59.9-59.91 59.97zM47.94 244.05a59.71 59.71 0 01-7.15-40.18c.47.28 1.3.79 1.89 1.13l63.72 36.8c3.23 1.89 7.23 1.89 10.47 0l77.79-44.92v31.1c.02.32-.13.63-.38.83L129.87 266c-28.69 16.52-65.33 6.7-81.92-21.95zM31.17 104.96c7-12.16 18.05-21.46 31.21-26.29 0 .55-.03 1.52-.03 2.2v73.61c-.02 3.74 1.98 7.21 5.23 9.06l77.79 44.91L118.44 224c-.27.18-.61.21-.91.08l-64.42-37.22c-28.63-16.58-38.45-53.21-21.95-81.89zm221.26 51.49l-77.79-44.92 26.93-15.54c.27-.18.61-.21.91-.08l64.42 37.19c28.68 16.57 38.51 53.26 21.94 81.94a59.94 59.94 0 01-31.2 26.28v-75.81c.03-3.74-1.96-7.2-5.2-9.06zm26.8-40.34c-.47-.29-1.3-.79-1.89-1.13l-63.72-36.8a10.375 10.375 0 00-10.47 0l-77.79 44.92V92c-.02-.32.13-.63.38-.83l64.41-37.16c28.69-16.55 65.37-6.7 81.91 22a59.95 59.95 0 017.15 40.1zm-168.51 55.43l-26.94-15.55a.943.943 0 01-.52-.74V80.86c.02-33.12 26.89-59.96 60.01-59.94 14.01 0 27.57 4.92 38.34 13.88-.49.26-1.33.73-1.89 1.07L116 72.67a10.344 10.344 0 00-5.24 9.06l-.04 89.79zM125.35 140L160 119.99l34.65 20V180L160 200l-34.65-20z"
          ></path>
        </svg>
      ),
    },
    {
      title: "Claude",
      logo: (
        <svg
          xmlns="http://www.w3.org/2000/svg"
          width="25"
          height="16"
          viewBox="0 0 25 16"
        >
          <g clipPath="url(#__lottie_element_2)">
            <g clipPath="url(#__lottie_element_4)">
              <g clipPath="url(#__lottie_element_12)" display="block">
                <g clipPath="url(#__lottie_element_26)" display="block">
                  <path
                    fill="currentColor"
                    d="M0 0l6.168 15.47H9.55L3.382 0H0z"
                    display="block"
                    transform="translate(12.98 .27)"
                  ></path>
                </g>
                <g clipPath="url(#__lottie_element_17)" display="block">
                  <path
                    fill="currentColor"
                    d="M5.825 9.348l2.11-5.436 2.11 5.436h-4.22zM6.167 0L0 15.47h3.448l1.261-3.249h6.452l1.26 3.249h3.449L9.703 0H6.167z"
                    display="block"
                    transform="translate(0 .27)"
                  ></path>
                </g>
              </g>
            </g>
          </g>
        </svg>
      ),
    },
    {
      title: "Ollama",
      logo: (
        <svg
          xmlns="http://www.w3.org/2000/svg"
          width="646"
          height="854"
          fill="none"
          viewBox="0 0 646 854"
        >
          <path
            fill="currentColor"
            d="M140.629.24c-7.969 1.287-17.532 5.456-24.275 10.605-20.413 15.51-36.229 48.428-42.91 89.438-2.514 15.509-4.23 37.026-4.23 53.455 0 19.371 2.268 44.136 5.517 61.239.736 3.801 1.103 7.173.797 7.418-.245.245-3.25 2.697-6.62 5.394-11.525 9.195-24.705 23.356-33.778 36.291-17.41 24.704-28.688 52.78-33.409 83.185-1.839 12.015-2.33 36.29-.858 48.305 3.25 27.708 11.586 51.125 25.87 72.581l4.658 6.927-1.349 2.268c-9.563 16.061-17.716 39.294-21.516 61.607-3.004 17.655-3.372 22.375-3.372 46.037 0 23.847.307 28.567 3.127 45.057 3.371 19.739 10.237 40.642 17.9 54.558 2.513 4.536 8.643 13.976 9.378 14.467.246.122-.49 2.39-1.655 5.026-8.827 19.31-16.367 44.995-19.493 66.635-2.207 14.834-2.514 19.616-2.514 35.248 0 19.922 1.104 29.608 5.272 45.485l.613 2.329h52.535l-1.716-3.249c-10.605-19.616-11.586-56.029-2.452-92.38 4.168-16.797 8.888-29.118 17.716-46.099l5.272-10.298v-6.314c0-5.885-.123-6.559-2.023-10.421-1.472-2.943-3.433-5.456-6.927-8.889-5.947-5.762-10.238-11.831-13.67-19.31-15.08-32.735-18.023-81.346-7.418-122.786 4.414-17.287 11.709-32.673 19.371-41.071 5.21-5.763 7.908-12.199 7.908-18.881 0-6.927-2.452-12.628-7.97-18.574-15.815-16.919-25.562-37.517-29.056-61.485-4.965-34.145 4.046-71.355 24.52-100.84 20.046-28.935 48.183-47.509 79.631-52.474 7.049-1.165 20.229-.981 27.585.368 8.031 1.41 13.057.98 18.207-1.472 6.375-3.003 9.563-6.743 13.302-15.325 3.31-7.662 5.885-11.831 12.812-20.474 8.337-10.36 16.367-17.41 29.24-25.931 14.713-9.624 31.448-16.612 48.122-19.984 6.068-1.226 8.888-1.41 20.229-1.41s14.161.184 20.229 1.41c24.459 4.966 48.735 17.594 68.106 35.493 4.168 3.862 14.16 16.245 17.348 21.395 1.226 2.022 3.372 6.314 4.72 9.501 3.739 8.582 6.927 12.322 13.302 15.325 4.966 2.391 10.176 2.882 17.9 1.594 12.199-2.084 21.578-1.9 33.532.552 40.704 8.214 76.136 41.746 91.829 86.68 13.67 39.416 9.808 80.672-10.544 112.18-3.433 5.334-6.866 9.625-11.831 14.897-10.728 11.463-10.728 25.685-.061 37.455 17.532 19.187 28.505 66.389 25.194 108.012-2.206 27.463-9.256 52.045-18.942 65.96-1.716 2.452-5.271 6.62-7.969 9.195-3.494 3.433-5.455 5.946-6.927 8.889-1.9 3.862-2.023 4.536-2.023 10.421v6.314l5.272 10.298c8.828 16.981 13.548 29.302 17.716 46.099 9.012 35.861 8.215 71.538-2.084 91.829-.858 1.716-1.594 3.31-1.594 3.494 0 .184 11.709.306 26.053.306h25.992l.674-2.636c.368-1.409.981-3.555 1.287-4.781.675-2.697 2.023-10.666 3.127-18.329 1.042-7.724 1.042-36.168 0-44.75-3.923-31.141-10.483-55.845-21.21-79.201-1.165-2.636-1.901-4.904-1.656-5.026.307-.184 2.023-2.636 3.862-5.395 13.364-20.229 21.578-45.669 25.747-79.262 1.103-9.257 1.103-49.041 0-57.93-2.943-22.926-6.498-38.497-12.383-54.251-2.452-6.559-8.95-20.413-11.708-24.888l-1.349-2.268 4.659-6.927c14.283-21.456 22.62-44.873 25.869-72.581 1.471-12.015.981-36.29-.858-48.305-4.782-30.467-16-58.42-33.409-83.185-9.073-12.935-22.253-27.096-33.777-36.291-3.372-2.697-6.376-5.149-6.621-5.394-.306-.245.062-3.617.797-7.418 7.418-38.681 7.172-86.924-.613-124.625-6.743-32.857-19.003-58.971-34.819-74.051C523.209 4.286 510.336-.864 494.888.117c-35.432 2.085-63.998 42.85-75.278 107.093-1.839 10.36-3.432 22.498-3.432 25.808 0 1.287-.246 2.329-.552 2.329-.307 0-2.697-1.226-5.272-2.758-27.34-16.184-57.746-24.827-87.354-24.827-29.608 0-60.014 8.643-87.354 24.827-2.575 1.532-4.965 2.758-5.272 2.758-.306 0-.552-1.042-.552-2.329 0-3.433-1.655-15.938-3.432-25.808-10.238-57.684-33.716-95.875-64.918-105.499C157.181.424 144.982-.434 140.629.24zm10.422 49.899c8.827 6.988 18.635 26.972 24.275 49.347 1.042 4.046 2.145 8.705 2.452 10.421.245 1.656.919 5.395 1.471 8.276 2.391 12.996 3.494 27.034 3.617 44.137l.061 16.858-4.23 6.252-4.229 6.314h-9.87c-11.524 0-22.988 1.472-33.961 4.414-3.923.981-7.724 1.962-8.459 2.146-1.165.245-1.349-.123-2.023-5.15-3.617-27.279-3.433-57.5.552-82.634 4.413-28.014 14.712-53.393 24.765-60.871 2.391-1.778 2.82-1.717 5.579.49zm349.538-.43c6.069 4.476 12.751 16.368 17.716 31.57 9.992 30.406 12.812 72.152 7.54 111.875-.674 5.027-.858 5.395-2.023 5.15-.735-.184-4.536-1.165-8.459-2.146-10.973-2.942-22.437-4.414-33.961-4.414h-9.87l-4.229-6.314-4.23-6.252.061-16.858c.123-23.785 2.33-42.359 7.601-63.018 5.579-22.19 15.448-42.175 24.214-49.163 2.759-2.207 3.188-2.268 5.64-.43z"
          ></path>
          <path
            fill="currentColor"
            d="M313.498 358.237c-13.303 1.288-16.919 1.778-23.295 3.066-10.36 2.145-24.214 6.927-33.838 11.647-33.47 16.367-56.519 43.646-63.569 75.216-1.41 6.253-1.594 8.337-1.594 18.881 0 10.421.184 12.689 1.533 18.635 9.379 41.256 47.385 71.723 96.549 77.301 10.666 1.165 56.765 1.165 67.431 0 39.478-4.475 73.439-25.869 88.703-55.907 4.045-8.03 6.007-13.241 7.846-21.394 1.349-5.946 1.533-8.214 1.533-18.635 0-10.544-.184-12.628-1.594-18.881-10.238-45.853-54.742-81.959-109.3-88.825-7.111-.858-25.746-1.594-30.405-1.104zm22.926 33.348c18.207 1.962 36.536 8.46 51.248 18.268 7.908 5.272 19.065 16.306 23.846 23.54 5.885 8.949 9.256 18.083 10.789 29.179.674 5.088.307 8.95-1.533 17.164-2.881 12.26-11.831 25.072-23.907 34.022-5.64 4.107-17.348 10.054-24.52 12.383-13.609 4.352-22.498 5.149-54.252 4.904-20.719-.184-24.398-.368-30.344-1.471-20.29-3.801-36.351-11.893-47.998-24.214-9.441-9.931-13.732-19.003-16.061-33.654-1.042-6.805.919-18.084 4.904-27.586 4.843-11.586 17.348-25.991 29.731-34.267 14.344-9.563 33.225-16.367 50.573-18.206 6.682-.736 20.842-.736 27.524-.062z"
          ></path>
          <path
            fill="currentColor"
            d="M299.584 436.336c-4.659 2.513-7.908 8.888-6.927 13.608 1.103 5.088 5.578 10.238 12.566 14.468 3.74 2.268 3.985 2.574 4.169 4.842.122 1.349-.368 5.211-1.042 8.644-.736 3.371-1.288 6.927-1.288 7.908.062 2.636 2.514 6.927 5.088 9.011 2.269 1.839 2.698 1.9 9.073 2.084 5.824.184 7.05.061 9.379-1.042 6.008-2.943 7.54-8.337 5.333-18.697-1.839-8.643-1.471-9.992 3.127-12.628 4.842-2.82 9.992-7.785 11.524-11.157 2.943-6.436.245-13.731-6.253-17.103-1.593-.797-3.555-1.164-6.436-1.164-4.475 0-7.356 1.042-12.628 4.413l-3.004 1.901-1.9-1.165c-7.785-4.598-9.195-5.149-13.916-5.088-3.371 0-5.21.306-6.865 1.165zM150.744 365.165c-10.85 3.433-18.942 11.402-23.11 22.743-2.023 5.395-3.004 13.916-2.146 18.513 2.023 10.973 11.034 20.965 21.272 23.724 12.873 3.371 22.497 1.164 31.018-7.295 4.965-4.843 7.663-9.073 10.36-15.939 1.961-4.842 2.084-5.7 2.084-12.566l.061-7.356-2.574-5.272c-4.108-8.337-11.525-14.529-20.107-16.797-4.843-1.226-12.628-1.164-16.858.245zM478.153 364.982c-8.398 2.268-15.877 8.52-19.862 16.735l-2.574 5.272.061 7.356c0 6.866.123 7.724 2.084 12.566 2.698 6.866 5.395 11.096 10.36 15.939 8.521 8.459 18.145 10.666 31.019 7.295 7.417-1.962 14.834-8.215 18.39-15.51 3.065-6.191 3.8-10.666 2.82-17.716-2.268-16.122-11.709-27.83-25.747-31.937-4.107-1.226-12.076-1.226-16.551 0z"
          ></path>
        </svg>
      ),
    },
    {
      title: "Mistral",
      logo: (
        <svg
          xmlns="http://www.w3.org/2000/svg"
          width="256"
          height="233"
          preserveAspectRatio="xMidYMid"
          viewBox="0 0 256 233"
          style={{ filter: "grayscale(100%)" }}
        >
          <path d="M186.182 0H232.72699999999998V46.545H186.182z"></path>
          <path fill="#F7D046" d="M209.455 0H256V46.545H209.455z"></path>
          <path d="M0 0H46.545V46.545H0z"></path>
          <path d="M0 46.545H46.545V93.09H0z"></path>
          <path d="M0 93.091H46.545V139.636H0z"></path>
          <path d="M0 139.636H46.545V186.18099999999998H0z"></path>
          <path d="M0 186.182H46.545V232.72699999999998H0z"></path>
          <path fill="#F7D046" d="M23.273 0H69.818V46.545H23.273z"></path>
          <path fill="#F2A73B" d="M209.455 46.545H256V93.09H209.455z"></path>
          <path fill="#F2A73B" d="M23.273 46.545H69.818V93.09H23.273z"></path>
          <path d="M139.636 46.545H186.18099999999998V93.09H139.636z"></path>
          <path
            fill="#F2A73B"
            d="M162.909 46.545H209.454V93.09H162.909z"
          ></path>
          <path fill="#F2A73B" d="M69.818 46.545H116.363V93.09H69.818z"></path>
          <path
            fill="#EE792F"
            d="M116.364 93.091H162.909V139.636H116.364z"
          ></path>
          <path
            fill="#EE792F"
            d="M162.909 93.091H209.454V139.636H162.909z"
          ></path>
          <path
            fill="#EE792F"
            d="M69.818 93.091H116.363V139.636H69.818z"
          ></path>
          <path d="M93.091 139.636H139.636V186.18099999999998H93.091z"></path>
          <path
            fill="#EB5829"
            d="M116.364 139.636H162.909V186.18099999999998H116.364z"
          ></path>
          <path fill="#EE792F" d="M209.455 93.091H256V139.636H209.455z"></path>
          <path fill="#EE792F" d="M23.273 93.091H69.818V139.636H23.273z"></path>
          <path d="M186.182 139.636H232.72699999999998V186.18099999999998H186.182z"></path>
          <path
            fill="#EB5829"
            d="M209.455 139.636H256V186.18099999999998H209.455z"
          ></path>
          <path d="M186.182 186.182H232.72699999999998V232.72699999999998H186.182z"></path>
          <path
            fill="#EB5829"
            d="M23.273 139.636H69.818V186.18099999999998H23.273z"
          ></path>
          <path
            fill="#EA3326"
            d="M209.455 186.182H256V232.72699999999998H209.455z"
          ></path>
          <path
            fill="#EA3326"
            d="M23.273 186.182H69.818V232.72699999999998H23.273z"
          ></path>
        </svg>
      ),
    },
    {
      title: "Hugging Face",
      logo: (
        <svg
          xmlns="http://www.w3.org/2000/svg"
          width="500"
          height="463"
          fill="none"
          viewBox="0 0 500 463"
        >
          <path
            fill="#fff"
            d="M496.592 369.699c3.971 11.394 3.018 23.528-2.277 34.079-3.812 7.702-9.265 13.663-15.936 18.991-8.048 6.33-18.055 11.711-30.126 16.881-14.401 6.12-31.979 11.87-40.027 13.98-20.596 5.328-40.397 8.704-60.464 8.863-28.696.263-53.422-6.489-71-23.74-9.106 1.108-18.319 1.741-27.584 1.741a214.69 214.69 0 01-26.102-1.582c-17.631 17.145-42.251 23.844-70.842 23.581-20.066-.159-39.868-3.535-60.516-8.863-7.995-2.11-25.573-7.86-39.974-13.98-12.072-5.17-22.078-10.551-30.073-16.881-6.724-5.328-12.178-11.289-15.99-18.991-5.241-10.551-6.247-22.685-2.223-34.079-3.707-8.705-4.66-18.675-1.748-29.701 1.324-5.011 3.495-9.654 6.248-13.769a51.529 51.529 0 01-1.377-6.805C4.57 304.97 9.6 291.781 19.076 281.547c4.66-5.117 9.69-8.652 14.931-10.92a218.565 218.565 0 01-5.877-50.38C28.13 98.597 127.085 0 249.178 0c41.933 0 81.165 11.606 114.627 31.863 6.035 3.693 11.965 7.65 17.631 11.87 2.806 2.11 5.612 4.273 8.312 6.541a168.222 168.222 0 018.048 6.911c7.836 7.122 15.195 14.771 21.919 22.948 2.277 2.69 4.448 5.486 6.565 8.335a196.93 196.93 0 0111.913 17.567c5.559 9.074 10.43 18.569 14.666 28.434 2.806 6.595 5.242 13.347 7.412 20.258a219.29 219.29 0 017.413 31.969c.529 3.64 1.006 7.332 1.376 11.025.742 7.386 1.165 14.877 1.165 22.526 0 16.987-2.012 33.657-5.771 49.747 5.824 2.268 11.33 5.961 16.466 11.553 9.477 10.234 14.507 23.475 12.495 37.93a52.452 52.452 0 01-1.376 6.752c2.753 4.115 4.924 8.758 6.247 13.769 2.912 11.026 1.959 20.996-1.694 29.701z"
          ></path>
          <path
            fill="#000"
            d="M433.839 221.75c0-100.912-82.308-182.718-183.839-182.718-101.531 0-183.839 81.806-183.839 182.718 0 100.912 82.308 182.718 183.839 182.718 101.531 0 183.839-81.806 183.839-182.718zM45 221.75C45 109.222 136.782 18 250 18s205 91.222 205 203.75S363.218 425.5 250 425.5 45 334.278 45 221.75z"
          ></path>
          <path
            fill="#fff"
            d="M250 405.5c102.173 0 185-82.268 185-183.75S352.173 38 250 38 65 120.268 65 221.75 147.827 405.5 250 405.5z"
          ></path>
          <path
            fill="#fff"
            d="M202.198 404.174c14.591-21.056 13.557-36.858-6.463-56.547-20.02-19.684-31.673-48.482-31.673-48.482s-4.353-16.726-14.268-15.187c-9.914 1.539-17.194 26.534 3.574 41.825 20.767 15.286-4.136 25.673-12.126 11.316-7.99-14.358-29.807-51.268-41.121-58.327-11.31-7.059-19.273-3.104-16.606 11.446 2.667 14.551 49.965 49.818 45.363 57.45-4.602 7.628-20.82-8.968-20.82-8.968s-50.75-45.445-61.8-33.603c-11.048 11.843 8.383 21.766 36.075 38.262 27.697 16.491 29.844 20.847 25.915 27.087-3.934 6.239-65.064-44.475-70.806-22.976-5.737 21.499 62.387 27.739 58.183 42.581-4.205 14.848-47.988-28.093-56.943-11.362-8.96 16.736 61.783 36.399 62.356 36.545 22.851 5.833 80.886 18.192 101.16-11.06z"
          ></path>
          <path
            fill="#000"
            d="M90.993 255c-8.519 0-16.133 3.477-21.442 9.784-3.284 3.906-6.714 10.202-6.993 19.63-3.573-1.02-7.01-1.59-10.219-1.59-8.156 0-15.523 3.106-20.732 8.749-6.693 7.242-9.666 16.142-8.372 25.047.616 4.241 2.042 8.043 4.173 11.562-4.494 3.613-7.804 8.644-9.403 14.694-1.253 4.743-2.536 14.621 4.167 24.797a28.46 28.46 0 00-1.2 2.06c-4.03 7.603-4.288 16.194-.73 24.195 5.393 12.126 18.795 21.68 44.82 31.935 16.192 6.379 31.004 10.458 31.136 10.494 21.405 5.517 40.764 8.32 57.523 8.32 30.804 0 52.857-9.376 65.549-27.866 20.427-29.775 17.506-57.008-8.924-83.259-14.629-14.526-24.353-35.945-26.379-40.646-4.083-13.92-14.881-29.393-32.829-29.393h-.005c-1.511 0-3.037.12-4.541.356-7.862 1.228-14.734 5.726-19.643 12.492-5.299-6.547-10.445-11.755-15.102-14.694-7.02-4.424-14.034-6.667-20.853-6.667zm0 20.917c2.684 0 5.962 1.134 9.577 3.414 11.224 7.075 32.882 44.072 40.812 58.462 2.657 4.821 7.199 6.861 11.287 6.861 8.114 0 14.449-8.016.742-18.203-20.611-15.327-13.381-40.379-3.541-41.922a8.151 8.151 0 011.268-.099c8.945 0 12.892 15.321 12.892 15.321s11.565 28.865 31.435 48.595c19.869 19.734 20.895 35.573 6.414 56.678-9.877 14.391-28.783 16.268-48.158 16.268-20.095 0-40.731-3.52-52.276-6.496-.568-.146-70.743-18.541-61.85-35.316 1.494-2.819 3.957-3.948 7.056-3.948 12.523 0 35.303 18.522 45.095 18.522 2.189 0 3.82-1.683 4.452-3.942 4.357-15.59-63.533-20.374-57.835-41.923 1.005-3.812 3.731-5.36 7.562-5.355 16.549 0 53.677 28.922 61.46 28.922.594 0 1.02-.172 1.252-.538 3.899-6.254 2.103-11.346-25.38-27.875-27.483-16.535-47.114-25.755-36.143-37.625 1.263-1.371 3.052-1.977 5.225-1.977 16.686.005 56.108 35.657 56.108 35.657s10.64 10.997 17.076 10.997c1.478 0 2.736-.58 3.588-2.013 4.562-7.645-42.374-42.994-45.021-57.578-1.794-9.883 1.257-14.887 6.903-14.887z"
          ></path>
          <path
            fill="#fff"
            d="M296.9 404.174c-14.59-21.056-13.557-36.858 6.463-56.547 20.02-19.684 31.674-48.482 31.674-48.482s4.353-16.726 14.267-15.187c9.915 1.539 17.194 26.534-3.573 41.825-20.768 15.286 4.135 25.673 12.125 11.316 7.99-14.358 29.807-51.268 41.122-58.327 11.309-7.059 19.272-3.104 16.605 11.446-2.667 14.551-49.965 49.818-45.363 57.45 4.602 7.628 20.821-8.968 20.821-8.968s50.75-45.445 61.799-33.603c11.049 11.843-8.383 21.766-36.074 38.262-27.698 16.491-29.845 20.847-25.916 27.087 3.934 6.239 65.065-44.475 70.807-22.976 5.736 21.499-62.388 27.739-58.183 42.581 4.204 14.848 47.987-28.093 56.942-11.362 8.96 16.736-61.783 36.399-62.356 36.545-22.851 5.833-80.885 18.192-101.16-11.06z"
          ></path>
          <path
            fill="#000"
            d="M408.105 255c8.519 0 16.133 3.477 21.442 9.784 3.284 3.906 6.715 10.202 6.994 19.63 3.572-1.02 7.008-1.59 10.218-1.59 8.156 0 15.523 3.106 20.732 8.749 6.694 7.242 9.667 16.142 8.372 25.047-.615 4.241-2.041 8.043-4.173 11.562 4.494 3.613 7.804 8.644 9.404 14.694 1.252 4.743 2.536 14.621-4.168 24.797.426.664.826 1.354 1.2 2.06 4.031 7.603 4.288 16.194.731 24.195-5.393 12.126-18.795 21.68-44.821 31.935-16.191 6.379-31.004 10.458-31.135 10.494-21.406 5.517-40.765 8.32-57.524 8.32-30.804 0-52.857-9.376-65.548-27.866-20.427-29.775-17.507-57.008 8.924-83.259 14.628-14.526 24.352-35.945 26.378-40.646 4.083-13.92 14.881-29.393 32.83-29.393h.005c1.51 0 3.036.12 4.541.356 7.861 1.228 14.733 5.726 19.643 12.492 5.299-6.547 10.445-11.755 15.102-14.694 7.019-4.424 14.033-6.667 20.853-6.667zm0 20.917c-2.684 0-5.962 1.134-9.577 3.414-11.224 7.075-32.882 44.072-40.812 58.462-2.657 4.821-7.198 6.861-11.287 6.861-8.114 0-14.449-8.016-.742-18.203 20.612-15.327 13.382-40.379 3.542-41.922a8.17 8.17 0 00-1.268-.099c-8.946 0-12.892 15.321-12.892 15.321s-11.566 28.865-31.435 48.595c-19.87 19.734-20.896 35.573-6.415 56.678 9.877 14.391 28.783 16.268 48.158 16.268 20.095 0 40.731-3.52 52.276-6.496.568-.146 70.744-18.541 61.851-35.316-1.495-2.819-3.957-3.948-7.057-3.948-12.523 0-35.302 18.522-45.095 18.522-2.189 0-3.82-1.683-4.451-3.942-4.358-15.59 63.533-20.374 57.834-41.923-1.005-3.812-3.731-5.36-7.561-5.355-16.549 0-53.678 28.922-61.46 28.922-.595 0-1.021-.172-1.253-.538-3.899-6.254-2.103-11.346 25.38-27.875 27.484-16.535 47.115-25.755 36.143-37.625-1.262-1.371-3.052-1.977-5.225-1.977-16.685.005-56.108 35.657-56.108 35.657s-10.64 10.997-17.075 10.997c-1.479 0-2.736-.58-3.589-2.013-4.562-7.645 42.375-42.994 45.022-57.578 1.794-9.883-1.258-14.887-6.904-14.887z"
          ></path>
          <path
            fill="#0E1116"
            d="M319.277 228.901c0-23.665-30.692 12.403-68.64 12.564-37.945-.159-68.637-36.227-68.637-12.564 0 15.69 7.507 41.208 27.669 56.69 4.012-13.804 26.057-24.862 29.208-23.274 4.487 2.261 4.235 8.527 11.76 14.048 7.526-5.521 7.274-11.785 11.761-14.048 3.153-1.588 25.196 9.47 29.207 23.274 20.162-15.482 27.67-41 27.67-56.688l.002-.002z"
          ></path>
          <path
            fill="#FF323D"
            d="M262.4 262.315c-4.487 2.261-4.235 8.527-11.761 14.048-7.525-5.521-7.273-11.785-11.76-14.048-3.153-1.588-25.196 9.47-29.207 23.274 10.194 7.828 23.625 13.089 40.955 13.217H250.656c17.33-.126 30.761-5.389 40.955-13.217-4.011-13.804-26.056-24.862-29.207-23.274h-.004z"
          ></path>
          <path
            fill="#000"
            d="M373 196c9.389 0 17-7.611 17-17s-7.611-17-17-17-17 7.611-17 17 7.611 17 17 17zM128 196c9.389 0 17-7.611 17-17s-7.611-17-17-17-17 7.611-17 17 7.611 17 17 17z"
          ></path>
          <path
            fill="#0E1116"
            d="M313.06 171.596c6.736 2.372 9.416 16.183 16.221 12.575 12.886-6.834 17.779-22.794 10.927-35.647-6.852-12.853-22.854-17.732-35.741-10.898s-17.779 22.793-10.927 35.646c3.234 6.067 13.499-3.797 19.52-1.676zM188.554 171.596c-6.736 2.372-9.416 16.183-16.22 12.575-12.887-6.834-17.779-22.794-10.927-35.647 6.852-12.853 22.853-17.732 35.74-10.898s17.779 22.793 10.927 35.646c-3.234 6.067-13.499-3.797-19.52-1.676z"
          ></path>
        </svg>
      ),
    },
    {
      title: "LangChain",
      logo: (
        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 80 41">
          <path
            fill="CurrentColor"
            d="M61.514 11.157a3.943 3.943 0 00-2.806 1.158l-3.018 3.01a3.951 3.951 0 00-1.147 3.095l.019.191a3.894 3.894 0 001.128 2.314c.435.434.914.709 1.496.9.03.175.047.352.047.53 0 .797-.31 1.546-.874 2.107l-.186.186c-1.008-.344-1.848-.847-2.607-1.604a6.888 6.888 0 01-1.927-3.67l-.034-.193-.153.124a3.675 3.675 0 00-.294.265l-3.018 3.01a3.957 3.957 0 002.807 6.757 3.959 3.959 0 002.806-1.158l3.019-3.01a3.958 3.958 0 000-5.599 3.926 3.926 0 00-1.462-.92 3.252 3.252 0 01.924-2.855 6.883 6.883 0 012.664 1.656 6.906 6.906 0 011.926 3.67l.035.193.153-.124c.104-.083.202-.173.296-.267l3.018-3.01a3.956 3.956 0 00-2.808-6.756h-.004z"
          ></path>
          <path
            fill="CurrentColor"
            d="M59.897.149h-39.49C9.153.149 0 9.279 0 20.5c0 11.222 9.154 20.351 20.406 20.351h39.49c11.253 0 20.407-9.13 20.407-20.35C80.303 9.277 71.149.148 59.897.148zM40.419 32.056c-.651.134-1.384.158-1.882-.36-.183.42-.612.199-.943.144-.03.085-.057.16-.085.246-1.1.073-1.925-1.046-2.449-1.89-1.04-.562-2.222-.904-3.285-1.492-.062.968.15 2.17-.774 2.794-.047 1.862 2.824.22 3.088 1.608-.204.022-.43-.033-.594.124-.749.726-1.608-.55-2.471-.023-1.16.582-1.276 1.059-2.71 1.179-.08-.12-.047-.2.02-.273.404-.468.433-1.02 1.122-1.22-.71-.111-1.303.28-1.901.59-.778.317-.772-.717-1.968.054-.132-.108-.069-.206.007-.289.304-.37.704-.425 1.155-.405-2.219-1.233-3.263 1.508-4.288.145-.308.081-.424.358-.618.553-.167-.183-.04-.405-.033-.62-.2-.094-.453-.139-.394-.459-.391-.132-.665.1-.957.32-.263-.203.178-.5.26-.712.234-.407.769-.084 1.04-.377.772-.437 1.847.273 2.729.153.68.085 1.52-.61 1.179-1.305-.726-.926-.598-2.137-.614-3.244-.09-.645-1.643-1.467-2.092-2.163-.555-.627-.987-1.353-1.42-2.068-1.561-3.014-1.07-6.886-3.037-9.685-.89.49-2.048.259-2.816-.399-.414.377-.432.87-.465 1.392-.994-.99-.87-2.863-.075-3.966a5.276 5.276 0 011.144-1.11c.098-.07.131-.14.129-.25.786-3.524 6.144-2.845 7.838-.348 1.229 1.537 1.6 3.57 2.994 4.997 1.875 2.047 4.012 3.85 5.742 6.03 1.637 1.992 2.806 4.328 3.826 6.683.416.782.42 1.74 1.037 2.408.304.403 1.79 1.5 1.467 1.888.186.403 1.573.959 1.092 1.35h.002zm26.026-12.024l-3.018 3.01a6.955 6.955 0 01-2.875 1.728l-.056.016-.02.053a6.865 6.865 0 01-1.585 2.446l-3.019 3.01a6.936 6.936 0 01-4.932 2.035 6.936 6.936 0 01-4.932-2.035 6.95 6.95 0 010-9.838l3.018-3.01a6.882 6.882 0 012.871-1.721l.055-.017.02-.053a6.932 6.932 0 011.59-2.454l3.019-3.01a6.936 6.936 0 014.932-2.035c1.865 0 3.616.723 4.932 2.035a6.898 6.898 0 012.04 4.92c0 1.86-.724 3.607-2.04 4.918v.002z"
          ></path>
          <path
            fill="CurrentColor"
            d="M28.142 28.413c-.265 1.03-.35 2.782-1.694 2.832-.11.595.413.819.89.627.472-.215.696.171.855.556.729.106 1.806-.242 1.847-1.103-1.088-.625-1.424-1.813-1.896-2.914l-.002.002z"
          ></path>
        </svg>
      ),
    },
  ],
};
