# Contribution Guidelines - awesome-japanese-llm

Thank you for considering contributing to awesome-japanese-llm. These guidelines are meant to provide a framework for participation in our project.

## About Models

- We do not include models specialized for specific tasks (such as BERT fine-tuned on QA datasets).
- Basically we do not consider language models with parameter sizes smaller than BERT (base), which is approximately 110 million. Thus, models such as Word2Vec and ELMo are not included.

## About Datasets/Leaderboards

- As a general rule, we only include datasets or leaderboards used for evaluation by organizations that have developed large scale Japanese language models.
- However, if a dataset or leaderboard has a certain level of recognition or is deemed beneficial by contributors, we might consider listing it.

## About Translation 

- We greatly appreciate translations of this repository's contents into any language other than Japanese and English.

# 貢献ガイドライン - awesome-japanese-llm

awesome-japanese-llmへの貢献に関心を持って頂きありがとうございます。このガイドラインは、プロジェクトに対する貢献の参考枠組を提供するものです。

## モデルについて

- 特定のタスクに特化したモデル（例：BERTをQAデータセットに fine-tuning させたもの）は原則として掲載しません。
- 原則として、パラメータサイズがBERT (base) 程度（すなわち約110百万）より小さな言語モデルは扱いません。したがって、Word2VecやELMoなどのモデルは含めません。

## データセット/リーダーボードについて

- 原則として、LLMを構築した企業や研究機関が評価に使用したデータセットやリーダーボードのみを掲載します。
- しかし、一定の知名度がある、または貢献者が有益と判断したデータセットやリーダーボードについては掲載を考えます。

## 翻訳について

- 日本語、英語以外の任意の言語へのこのリポジトリの内容の翻訳を大いに歓迎します。