import LanguageSelector from '@components/LanguageSelector';
import ThemeSwitcher from '@components/Menu/MenuOptions/ThemeSwitcher';
import PopupModal from '@components/PopupModal';
import PromptLibraryMenu from '@components/PromptLibraryMenu';
import SettingIcon from '@icon/SettingIcon';
import useStore from '@store/store';
import { useEffect, useState } from 'react';
import { useTranslation } from 'react-i18next';
import AutoTitleToggle from './AutoTitleToggle';

const SettingsMenu = () => {
  const { t } = useTranslation();

  const theme = useStore.getState().theme;
  const [isModalOpen, setIsModalOpen] = useState<boolean>(false);

  useEffect(() => {
    document.documentElement.className = theme;
  }, [theme]);
  return (
    <>
      <a
        className='flex py-3 px-3 items-center gap-3 rounded-md hover:bg-gray-500/10 transition-colors duration-200 text-white cursor-pointer text-sm'
        onClick={() => {
          setIsModalOpen(true);
        }}
      >
        <SettingIcon className='w-4 h-4' /> {t('setting') as string}
      </a>
      {isModalOpen && (
        <PopupModal
          setIsModalOpen={setIsModalOpen}
          title={t('setting') as string}
          cancelButton={false}
        >
          <div className='p-6 border-b border-gray-200 dark:border-gray-600 flex flex-col items-center gap-4'>
            <LanguageSelector />
            <ThemeSwitcher />
            <AutoTitleToggle />
            <PromptLibraryMenu />
          </div>
        </PopupModal>
      )}
    </>
  );
};

export default SettingsMenu;
