/**
 * 热门标签
 * @type {string[]}
 * @author https://yuyuanweb.feishu.cn/wiki/Abldw5WkjidySxkKxU2cQdAtnah yupi
 */
const hotTags = [
  'java',
  '前端',
  '后端',
  '数据结构',
  '算法',
  '操作系统',
  '数据库',
  '网络',
  'cpp',
  'golang',
  'linux',
  '嵌入式',
  'ios',
  '人工智能',
  '系统设计',
];

/**
 * 零散的标签
 * @type {string[]}
 */
const otherTags = ['正则表达式'];

/**
 * 分组标签
 * @type {{name: string, tags: []}[]}
 */
const groupTags = [
  {
    name: '热门',
    tags: hotTags,
  },
  {
    name: '语言',
    tags: [
      'java',
      'csharp',
      'php',
      'cpp',
      'c',
      'html',
      'css',
      'javascript',
      'golang',
      'python',
      'rust',
      'ruby',
      'swift',
      'scala',
      'lua',
      'bash',
      'kotlin',
      'rust',
    ],
  },
  {
    name: '知识',
    tags: [
      '数据结构',
      '算法',
      '软件工程',
      '数据库',
      '操作系统',
      'linux',
      '设计模式',
      '分布式',
      '网络',
      '系统设计',
    ],
  },
  {
    name: '方向',
    tags: [
      '前端',
      '后端',
      '人工智能',
      '数据分析',
      '图像处理',
      '计算机视觉',
      '爬虫',
      'nlp',
      '项目管理',
      '嵌入式',
      '物联网',
      '数据库',
      '大数据',
      '搜索',
      '数学',
      '游戏',
      '音视频',
      '产品',
      '设计',
      '运营',
      '测试',
      '区块链',
      '安全',
      '移动开发',
      '小程序',
      '云计算',
      '云原生',
      '运维',
      '网络',
    ],
  },
  {
    name: '公司',
    tags: [
      '腾讯',
      '阿里巴巴',
      '字节跳动',
      '微软',
      '华为',
      '携程',
      '美团',
      '百度',
      '网易',
      'B站',
      '快手',
      '京东',
      '小米',
      '英特尔',
      '商汤科技',
      'google',
      '雅虎',
      'IBM',
      '亚马逊',
      'vivo',
      'Shopee',
      'ThoughtWorks',
      '猿辅导',
      '滴滴',
      '蘑菇街',
      '金山',
      '迅雷',
      '赶集网',
      '艺龙网',
      '盛大游戏',
      '欢聚集团',
      '搜狐',
      '当当网',
      '巨人网络',
      '完美世界',
      '360',
      '平安科技',
      '唯品会',
      '去哪儿',
      '优酷',
      '乐视网',
      '爱奇艺',
      '人人网',
    ],
  },
  {
    name: '目标',
    tags: ['实习', '校招', '社招', '比赛', '考试', '考研', '考证'],
  },
];

/**
 * 标签 => 推荐标签映射
 */
const categoryTagsMap = {
  python: {
    tags: ['django', 'scrapy', 'tornado', 'flask'],
  },
  编程语言: {
    tags: [
      'java',
      'csharp',
      'php',
      'cpp',
      'c',
      'html',
      'css',
      'javascript',
      'golang',
      'python',
      'rust',
      'ruby',
      'swift',
      'scala',
      'lua',
      'bash',
      'kotlin',
      'objective-c',
      'rust',
    ],
  },
  后端: {
    tags: [
      'java',
      'python',
      'spring',
      'springboot',
      '数据库',
      '框架',
      '爬虫',
      '接口',
      '架构',
      '高并发',
      '高可用',
      '分布式',
      'docker',
      'kubernetes',
      'django',
      'flask',
      'php',
      'cpp',
    ],
  },
  java: {
    tags: [
      'mybatis',
      'spring',
      'springboot',
      'springmvc',
      'springcloud',
      'tomcat',
      'hibernate',
      '多线程',
    ],
  },
  cpp: {
    tags: ['指针', '模板', '运算符重载', '标准库', '异常', '面向对象', '继承'],
  },
  移动开发: {
    tags: [
      'android',
      'ios',
      'swift',
      'objective-c',
      'kotlin',
      'java',
    ],
  },
  php: {
    tags: ['apache', 'swoole', 'symfony', 'laravel', 'composer'],
  },
  前端: {
    tags: [
      'html',
      'css',
      'javascript',
      'typescript',
      'nodejs',
      'vue',
      'angular',
      'react',
      'json',
      '响应式',
      '浏览器',
      'jquery',
      'ajax',
      'bootstrap',
      'less',
      'stylus',
    ],
  },
  ios: {
    tags: ['swift', 'objective-c', 'safari', 'xcode'],
  },
  云原生: {
    tags: [
      'golang',
      'docker',
      'zookeeper',
      'kafka',
      'eureka',
      'etcd',
      'consul',
      'springboot',
      '分布式',
      '中间件',
      '容器',
    ],
  },
  运维: {
    tags: [
      'docker',
      '容器',
      '运维',
      'devops',
      'kubernetes',
    ],
  },
  测试: {
    tags: [
      'postman',
      '单元测试',
      'selenium',
      'jira',
      '测试工具',
      '压力测试',
      '测试用例',
      'ab测试',
      '集成测试',
    ],
  },
  操作系统: {
    tags: [
      '进程',
      '线程',
      '死锁',
      '内存管理',
      '存储管理',
      '文件系统',
      '输入输出',
      'macos',
      'windows',
      'harmonyos',
      'linux',
    ],
  },
  数据结构: {
    tags: [
      '链表',
      '散列表',
      '树',
      '图',
      '堆',
      '数组',
      '字符串',
    ],
  },
  算法: {
    tags: [
      '贪心',
      '动态规划',
      '排序',
      '二分查找',
      '递归',
      '广度优先',
      '深度优先',
      '线性回归',
      'kmeans',
      '决策树',
      '最小二乘法',
      '模拟退火算法',
      '随机森林',
    ],
  },
  数据库: {
    tags: ['索引', '性能优化', '备份', 'B树', '数据库引擎'],
  },
  大数据: {
    tags: [
      '数据库',
      'mysql',
      'redis',
      'sql',
      'mongodb',
      'hdfs',
      'mapreduce',
      'sqlite',
      'oracle',
      'database',
      'hbase',
      'hadoop',
      'hive',
      'postgresql',
      'nosql',
      'storm',
      'zookeeper',
      'spark',
      'memcached',
      'flume',
      'elasticsearch',
      'rabbitmq',
      'kafka',
      'memcached',
      'eureka',
      'etcd',
    ],
  },
  搜索: {
    tags: ['elasticsearch', 'lucene', 'solr', 'sphinx', '搜索引擎', '全文检索', '分词'],
  },
  android: {
    tags: ['android', 'webview', 'xml', 'gradle', 'rxjava', 'native', 'hybrid'],
  },
  人工智能: {
    tags: [
      'opencv',
      '数据挖掘',
      '语音识别',
      '计算机视觉',
      '目标检测',
      '机器学习',
      '人工智能',
      'caffe',
      '深度学习',
      '神经网络',
      'sklearn',
      'cnn',
      'mllib',
      'word2vec',
      'tensorflow',
      '目标跟踪',
      'keras',
      '知识图谱',
      'rnn',
      'lstm',
      '自动驾驶',
      'dnn',
      '生成对抗网络',
      'mxnet',
      'pytorch',
      '机器翻译',
      '语言模型',
      'oneflow',
      'mlnet',
      'paddlepaddle',
      'gru',
      'mnn',
      'boosting',
      'transformer',
      'xlnet',
      'bert',
      'openvino',
      '边缘计算',
    ],
  },
  网络: {
    tags: [
      '网络协议',
      '网络安全',
      'http',
      'p2p',
      'tcp',
      'udp',
    ],
  },
  嵌入式: {
    tags: ['arm', '单片机', 'stm32', '51单片机', 'proteus', 'mcu', '物联网', 'iot', 'rtdbs'],
  },
  硬件: {
    tags: [
      '硬件工程',
      '驱动开发',
      'fpga开发',
      'dsp开发',
      'arm开发',
      '材料工程',
    ],
  },
  服务器: {
    tags: ['linux', 'ubuntu', 'centos', 'debian', 'unix'],
  },
  产品: {
    tags: ['axure'],
  },
  运营: {
    tags: ['新媒体运营', '内容运营', '用户运营', '产品运营', '流量运营'],
  },
  设计: {
    tags: ['交互', 'axure', 'ux', 'ui', 'illustrator', '平面', 'photoshop', 'sketch', '3d'],
  },
  安全: {
    tags: ['系统安全', '网络安全', '网站安全'],
  },
  区块链: {
    tags: [
      '虚拟货币',
      '以太坊',
      '区块链',
      '比特币',
      '智能合约',
      '信任链',
    ],
  },
  软件工程: {
    tags: [
      '敏捷开发',
      '接口文档',
    ],
  },
  游戏: {
    tags: [
      'cocos2d',
      '动画',
      'ogre',
      'unity',
      'pygame',
      '游戏引擎',
      'ar',
      '3dsmax',
      'maya',
      '贴图',
      'uv',
      'vr',
      'ue4',
      'houdini',
      '着色器',
      '材质',
      '游戏程序',
      '游戏美术',
      '游戏策划',
      'cascadeur',
    ],
  },
  设计模式: {
    tags: [
      'uml',
      '单例模式',
      '命令模式',
      '代理模式',
      '备忘录模式',
      '解释器模式',
    ],
  },
};

const allTagsSet = new Set(otherTags);

hotTags.forEach((tag) => allTagsSet.add(tag));
groupTags.forEach((groupTag) => {
  groupTag.tags.forEach((tag) => {
    allTagsSet.add(tag);
  });
});
Object.keys(categoryTagsMap).forEach((parentTag) => {
  categoryTagsMap[parentTag].tags.forEach((tag: string) => {
    allTagsSet.add(tag);
  });
});

export default  {
  hotTags,
  otherTags,
  groupTags,
  categoryTagsMap,
  allTags: Array.from(allTagsSet),
};
