﻿using CoreHome.Data.DatabaseContext;
using Microsoft.EntityFrameworkCore;

namespace CoreHome.Admin
{
    public static class Program
    {
        public static void Main(string[] args)
        {
            IHost host = CreateHostBuilder(args).Build();
            using IServiceScope scope = host.Services.CreateScope();
            {
                scope.ServiceProvider.GetService<ArticleDbContext>().Database.Migrate();
            }
            host.Run();
        }

        public static IHostBuilder CreateHostBuilder(string[] args)
        {
            return Host.CreateDefaultBuilder(args)
                .ConfigureWebHostDefaults(webBuilder =>
                {
                    webBuilder
                        .UseSetting("STARTUP_TIME", DateTime.Now.ToString())
                        .UseStartup<Startup>();
                });
        }
    }
}
