/* Copyright (C) 2003-2015 LiveCode Ltd.

This file is part of LiveCode.

LiveCode is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License v3 as published by the Free
Software Foundation.

LiveCode is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with LiveCode.  If not see <http://www.gnu.org/licenses/>.  */

typedef struct
{
	const char *name;
	uint2 port;
}
MCPORT;

static MCPORT port_table[] =
    {
        {"tcpmux", 1},
        {"echo", 7},
        {"discard", 9},
        {"sink", 9},
        {"null", 9},
        {"systat", 11},
        {"users", 11},
        {"daytime", 13},
        {"netstat", 15},
        {"qotd", 17},
        {"quote", 17},
        {"msp", 18},
        {"chargen", 19},
        {"ftp-data", 20},
        {"ftp", 21},
        {"fsp", 21},
        {"fspd", 21},
        {"ssh", 22},
        {"telnet", 23},
        {"private", 24},
        {"smtp", 25},
        {"mail", 25},
        {"unassigned", 26},
        {"timserver", 37},
        {"time", 37},
        {"rlp", 39},
        {"nameserver", 42},
        {"name", 42},
        {"whois", 43},
        {"re-mail-ck", 50},
        {"domain", 53},
        {"mtp", 57},
        {"bootps", 67},
        {"bootpc", 68},
        {"tftp", 69},
        {"gopher", 70},
        {"rje", 77},
        {"finger", 79},
        {"http", 80},
        {"www", 80},
        {"link", 87},
        {"ttylink", 87},
        {"kerberos", 88},
        {"kerberos5", 88},
        {"krb5", 88},
        {"supdup", 95},
        {"reserved", 100},
        {"hostnames", 101},
        {"hostname", 101},
        {"iso-tsap", 102},
        {"tsap", 102},
        {"csnet-ns", 105},
        {"3com-tsmux", 106},
        {"poppassd", 106},
        {"rtelnet", 107},
        {"pop-2", 109},
        {"postoffice", 109},
        {"pop-3", 110},
        {"portmapper", 111},
        {"sunrpc", 111},
        {"authentication", 113},
        {"auth", 113},
        {"tap", 113},
        {"sftp", 115},
        {"uucp-path", 117},
        {"nntp", 119},
        {"readnews", 119},
        {"ntp", 123},
        {"netbios-ns", 137},
        {"netbios-dgm", 138},
        {"netbios-ssn", 139},
        {"imap", 143},
        {"imap2", 143},
        {"snmp", 161},
        {"snmp-trap", 162},
        {"snmptrap", 162},
        {"cmip-man", 163},
        {"cmip-agent", 164},
        {"xdmcp", 177},
        {"nextstep", 178},
        {"bgp", 179},
        {"prospero", 191},
        {"irc", 194},
        {"smux", 199},
        {"at-rtmp", 201},
        {"at-nbp", 202},
        {"at-echo", 204},
        {"at-zis", 206},
        {"qmtp", 209},
        {"wais", 210},
        {"z3950", 210},
        {"ipx", 213},
        {"imap3", 220},
        {"rpc2portmap", 369},
        {"codaauth2", 370},
        {"ulistserv", 372},
        {"https", 443},
        {"snpp", 444},
        {"saft", 487},
        {"npmp-local", 610},
        {"npmp-gui", 611},
        {"hmmp-ind", 612},
        {"exec", 512},
        {"biff", 512},
        {"login", 513},
        {"who", 513},
        {"shell", 514},
        {"syslog", 514},
        {"printer", 515},
        {"talk", 517},
        {"ntalk", 518},
        {"route", 520},
        {"router", 520},
        {"routerd", 520},
        {"timed", 525},
        {"timeserver", 525},
        {"tempo", 526},
        {"newdate", 526},
        {"courier", 530},
        {"rpc", 530},
        {"conference", 531},
        {"chat", 531},
        {"netnews", 532},
        {"netwall", 533},
        {"uucp", 540},
        {"uucpd", 540},
        {"afpovertcp", 548},
        {"remotefs", 556},
        {"klogin", 543},
        {"kshell", 544},
        {"krcmd", 544},
        {"kerberos-adm", 749},
        {"webster", 765},
        {"ingreslock", 1524},
        {"prospero-np", 1525},
        {"datametrics", 1645},
        {"sa-msg-port", 1646},
        {"radius", 1812},
        {"radacct", 1813},
        {"cvspserver", 2401},
        {"venus", 2430},
        {"venus-se", 2431},
        {"codasrv", 2432},
        {"codasrv-se", 2433},
        {"mysql", 3306},
        {"rfe", 5002},
        {"cfengine", 5308},
        {"bbs", 7000},
        {"kerberos4", 750},
        {"kerberos_master", 751},
        {"passwd_server", 752},
        {"krb_prop", 754},
        {"krbupdate", 760},
        {"kpasswd", 761},
        {"kpop", 1109},
        {"knetd", 2053},
        {"zephyr-srv", 2102},
        {"zephyr-clt", 2103},
        {"zephyr-hm", 2104},
        {"eklogin", 2105},
        {"supfilesrv", 871},
        {"supfiledbg", 1127},
        {"rtmp", 1},
        {"nbp", 2},
        {"echo", 4},
        {"zip", 6},
        {"mailq", 174},
        {"ssmtp", 465},
        {"gdomap", 538},
        {"snews", 563},
        {"ssl-ldap", 636},
        {"omirr", 808},
        {"rsync", 873},
        {"simap", 993},
        {"spop3", 995},
        {"socks", 1080},
        {"rmtcfg", 1236},
        {"xtel", 1313},
        {"support", 1529},
        {"cfinger", 2003},
        {"ninstall", 2150},
        {"afbackup", 2988},
        {"icp", 3130},
        {"postgres", 5432},
        {"fax", 4557},
        {"hylafax", 4559},
        {"noclog", 5354},
        {"hostmon", 5355},
        {"ircd", 6667},
        {"webcache", 8080},
        {"tproxy", 8081},
        {"mandelspawn", 9359},
        {"amanda", 10080},
        {"kamanda", 10081},
        {"amandaidx", 10082},
        {"amidxtape", 10083},
        {"isdnlog", 20011},
        {"vboxd", 20012},
        {"binkp", 24554},
        {"asp", 27374},
        {"tfido", 60177},
        {"fido", 60179},
        {"linuxconf", 98},
        {"swat", 901},
    };
