/* Copyright (C) 2003-2015 LiveCode Ltd.
 
 This file is part of LiveCode.
 
 LiveCode is free software; you can redistribute it and/or modify it under
 the terms of the GNU General Public License v3 as published by the Free
 Software Foundation.
 
 LiveCode is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or
 FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 for more details.
 
 You should have received a copy of the GNU General Public License
 along with LiveCode.  If not see <http://www.gnu.org/licenses/>.  */

#include <Cocoa/Cocoa.h>

#include "globdefs.h"
#include "region.h"
#include "graphics.h"

#include "platform.h"
#include "platform-internal.h"

#include "mac-internal.h"

#include <Carbon/Carbon.h>

////////////////////////////////////////////////////////////////////////////////

// NOTE:
// At the moment we implement the menu directly for cocoa as Mac is the only
// platform that uses native menus - we will probably want to abstract in a
// similar way to the MCPlatformWindow at a later date though.

static uint32_t s_menu_select_lock = 0;
// SN-2014-11-06: [[ Bug 13836 ]] Stores whether a quit item got selected
static bool s_quit_selected = false;
// SN-2014-11-10: [[ Bug 13836 ]] Keeps the track about the open items in the menu bar.
static uint32_t s_open_menubar_items = 0;

// SN-2015-11-02: [[ Bug 16218 ]] We can't trust popUpMenuPositioningItem on
//  returning whether an item has been selected.
static bool s_menu_item_selected = false;

/* Contains the menuitem 'diamond' image */
static NSImage *s_diamond_image = nullptr;

////////////////////////////////////////////////////////////////////////////////

// The diamond check mark image is not available through an API. However, it can
// be fetched from a shell Cocoa app run through Xcode, when the main window is
// minimized using:
//    (int)[[[(NSMenuItem*)[[(NSMenuItem*)[(NSMenu*)[NSApp mainMenu]
//               itemAtIndex: 5] submenu]
//               itemAtIndex: 14] onStateImage] TIFFRepresentation]
//               writeToFile: @"/Users/mark/Desktop/diamond.tff" atomically:0]
// Or similar (exact indicies may vary) on a 10.12 retina Mac. The TIFF data
// is encoded into a c-string and the c-string is used on init of the menu
// module to create the s_diamond_image NSImage.

static const char kDiamondTiffImage[] =
"\x4d\x4d\x00\x2a\x00\x00\x01\x94\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x24\x00\x00\x00\x99\x00\x00\x00\x23"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x0d\x00\x00\x00\xd7\x00\x00\x00\xff"
"\x00\x00\x00\xd7\x00\x00\x00\x0d\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\xae\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xae\x00\x00\x00\x01"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7a\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\x7a\x00\x00\x00\x00\x00\x00\x00\x46\x00\x00\x00\xfd"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xfd\x00\x00\x00\x46\x00\x00\x00\xb6"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xb6"
"\x00\x00\x00\x46\x00\x00\x00\xfd\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xfd"
"\x00\x00\x00\x46\x00\x00\x00\x00\x00\x00\x00\x7a\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\x79\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01"
"\x00\x00\x00\xae\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xae\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x0d\x00\x00\x00\xd7\x00\x00\x00\xff"
"\x00\x00\x00\xd7\x00\x00\x00\x0d\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x24"
"\x00\x00\x00\x99\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x10\x01\x00\x00\x03\x00\x00\x00\x01\x00\x09"
"\x00\x00\x01\x01\x00\x03\x00\x00\x00\x01\x00\x0b\x00\x00\x01\x02"
"\x00\x03\x00\x00\x00\x04\x00\x00\x02\x5a\x01\x03\x00\x03\x00\x00"
"\x00\x01\x00\x01\x00\x00\x01\x06\x00\x03\x00\x00\x00\x01\x00\x02"
"\x00\x00\x01\x0a\x00\x03\x00\x00\x00\x01\x00\x01\x00\x00\x01\x11"
"\x00\x04\x00\x00\x00\x01\x00\x00\x00\x08\x01\x12\x00\x03\x00\x00"
"\x00\x01\x00\x01\x00\x00\x01\x15\x00\x03\x00\x00\x00\x01\x00\x04"
"\x00\x00\x01\x16\x00\x03\x00\x00\x00\x01\x00\x0b\x00\x00\x01\x17"
"\x00\x04\x00\x00\x00\x01\x00\x00\x01\x8c\x01\x1c\x00\x03\x00\x00"
"\x00\x01\x00\x01\x00\x00\x01\x28\x00\x03\x00\x00\x00\x01\x00\x02"
"\x00\x00\x01\x52\x00\x03\x00\x00\x00\x01\x00\x01\x00\x00\x01\x53"
"\x00\x03\x00\x00\x00\x04\x00\x00\x02\x62\x87\x73\x00\x07\x00\x00"
"\x0c\x48\x00\x00\x02\x6a\x00\x00\x14\xe2\x00\x08\x00\x08\x00\x08"
"\x00\x08\x00\x01\x00\x01\x00\x01\x00\x01\x00\x00\x0c\x48\x4c\x69"
"\x6e\x6f\x02\x10\x00\x00\x6d\x6e\x74\x72\x52\x47\x42\x20\x58\x59"
"\x5a\x20\x07\xce\x00\x02\x00\x09\x00\x06\x00\x31\x00\x00\x61\x63"
"\x73\x70\x4d\x53\x46\x54\x00\x00\x00\x00\x49\x45\x43\x20\x73\x52"
"\x47\x42\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\xf6\xd6\x00\x01\x00\x00\x00\x00\xd3\x2d\x48\x50\x20\x20\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x11\x63\x70"
"\x72\x74\x00\x00\x01\x50\x00\x00\x00\x33\x64\x65\x73\x63\x00\x00"
"\x01\x84\x00\x00\x00\x6c\x77\x74\x70\x74\x00\x00\x01\xf0\x00\x00"
"\x00\x14\x62\x6b\x70\x74\x00\x00\x02\x04\x00\x00\x00\x14\x72\x58"
"\x59\x5a\x00\x00\x02\x18\x00\x00\x00\x14\x67\x58\x59\x5a\x00\x00"
"\x02\x2c\x00\x00\x00\x14\x62\x58\x59\x5a\x00\x00\x02\x40\x00\x00"
"\x00\x14\x64\x6d\x6e\x64\x00\x00\x02\x54\x00\x00\x00\x70\x64\x6d"
"\x64\x64\x00\x00\x02\xc4\x00\x00\x00\x88\x76\x75\x65\x64\x00\x00"
"\x03\x4c\x00\x00\x00\x86\x76\x69\x65\x77\x00\x00\x03\xd4\x00\x00"
"\x00\x24\x6c\x75\x6d\x69\x00\x00\x03\xf8\x00\x00\x00\x14\x6d\x65"
"\x61\x73\x00\x00\x04\x0c\x00\x00\x00\x24\x74\x65\x63\x68\x00\x00"
"\x04\x30\x00\x00\x00\x0c\x72\x54\x52\x43\x00\x00\x04\x3c\x00\x00"
"\x08\x0c\x67\x54\x52\x43\x00\x00\x04\x3c\x00\x00\x08\x0c\x62\x54"
"\x52\x43\x00\x00\x04\x3c\x00\x00\x08\x0c\x74\x65\x78\x74\x00\x00"
"\x00\x00\x43\x6f\x70\x79\x72\x69\x67\x68\x74\x20\x28\x63\x29\x20"
"\x31\x39\x39\x38\x20\x48\x65\x77\x6c\x65\x74\x74\x2d\x50\x61\x63"
"\x6b\x61\x72\x64\x20\x43\x6f\x6d\x70\x61\x6e\x79\x00\x00\x64\x65"
"\x73\x63\x00\x00\x00\x00\x00\x00\x00\x12\x73\x52\x47\x42\x20\x49"
"\x45\x43\x36\x31\x39\x36\x36\x2d\x32\x2e\x31\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x12\x73\x52\x47\x42\x20\x49\x45\x43\x36"
"\x31\x39\x36\x36\x2d\x32\x2e\x31\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x58\x59\x5a\x20\x00\x00"
"\x00\x00\x00\x00\xf3\x51\x00\x01\x00\x00\x00\x01\x16\xcc\x58\x59"
"\x5a\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x58\x59\x5a\x20\x00\x00\x00\x00\x00\x00\x6f\xa2\x00\x00"
"\x38\xf5\x00\x00\x03\x90\x58\x59\x5a\x20\x00\x00\x00\x00\x00\x00"
"\x62\x99\x00\x00\xb7\x85\x00\x00\x18\xda\x58\x59\x5a\x20\x00\x00"
"\x00\x00\x00\x00\x24\xa0\x00\x00\x0f\x84\x00\x00\xb6\xcf\x64\x65"
"\x73\x63\x00\x00\x00\x00\x00\x00\x00\x16\x49\x45\x43\x20\x68\x74"
"\x74\x70\x3a\x2f\x2f\x77\x77\x77\x2e\x69\x65\x63\x2e\x63\x68\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x16\x49\x45\x43\x20\x68"
"\x74\x74\x70\x3a\x2f\x2f\x77\x77\x77\x2e\x69\x65\x63\x2e\x63\x68"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x64\x65"
"\x73\x63\x00\x00\x00\x00\x00\x00\x00\x2e\x49\x45\x43\x20\x36\x31"
"\x39\x36\x36\x2d\x32\x2e\x31\x20\x44\x65\x66\x61\x75\x6c\x74\x20"
"\x52\x47\x42\x20\x63\x6f\x6c\x6f\x75\x72\x20\x73\x70\x61\x63\x65"
"\x20\x2d\x20\x73\x52\x47\x42\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x2e\x49\x45\x43\x20\x36\x31\x39\x36\x36\x2d\x32\x2e\x31"
"\x20\x44\x65\x66\x61\x75\x6c\x74\x20\x52\x47\x42\x20\x63\x6f\x6c"
"\x6f\x75\x72\x20\x73\x70\x61\x63\x65\x20\x2d\x20\x73\x52\x47\x42"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x64\x65\x73\x63\x00\x00\x00\x00\x00\x00"
"\x00\x2c\x52\x65\x66\x65\x72\x65\x6e\x63\x65\x20\x56\x69\x65\x77"
"\x69\x6e\x67\x20\x43\x6f\x6e\x64\x69\x74\x69\x6f\x6e\x20\x69\x6e"
"\x20\x49\x45\x43\x36\x31\x39\x36\x36\x2d\x32\x2e\x31\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x52\x65\x66\x65\x72\x65\x6e"
"\x63\x65\x20\x56\x69\x65\x77\x69\x6e\x67\x20\x43\x6f\x6e\x64\x69"
"\x74\x69\x6f\x6e\x20\x69\x6e\x20\x49\x45\x43\x36\x31\x39\x36\x36"
"\x2d\x32\x2e\x31\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x76\x69"
"\x65\x77\x00\x00\x00\x00\x00\x13\xa4\xfe\x00\x14\x5f\x2e\x00\x10"
"\xcf\x14\x00\x03\xed\xcc\x00\x04\x13\x0b\x00\x03\x5c\x9e\x00\x00"
"\x00\x01\x58\x59\x5a\x20\x00\x00\x00\x00\x00\x4c\x09\x56\x00\x50"
"\x00\x00\x00\x57\x1f\xe7\x6d\x65\x61\x73\x00\x00\x00\x00\x00\x00"
"\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x02\x8f\x00\x00\x00\x02\x73\x69\x67\x20\x00\x00"
"\x00\x00\x43\x52\x54\x20\x63\x75\x72\x76\x00\x00\x00\x00\x00\x00"
"\x04\x00\x00\x00\x00\x05\x00\x0a\x00\x0f\x00\x14\x00\x19\x00\x1e"
"\x00\x23\x00\x28\x00\x2d\x00\x32\x00\x37\x00\x3b\x00\x40\x00\x45"
"\x00\x4a\x00\x4f\x00\x54\x00\x59\x00\x5e\x00\x63\x00\x68\x00\x6d"
"\x00\x72\x00\x77\x00\x7c\x00\x81\x00\x86\x00\x8b\x00\x90\x00\x95"
"\x00\x9a\x00\x9f\x00\xa4\x00\xa9\x00\xae\x00\xb2\x00\xb7\x00\xbc"
"\x00\xc1\x00\xc6\x00\xcb\x00\xd0\x00\xd5\x00\xdb\x00\xe0\x00\xe5"
"\x00\xeb\x00\xf0\x00\xf6\x00\xfb\x01\x01\x01\x07\x01\x0d\x01\x13"
"\x01\x19\x01\x1f\x01\x25\x01\x2b\x01\x32\x01\x38\x01\x3e\x01\x45"
"\x01\x4c\x01\x52\x01\x59\x01\x60\x01\x67\x01\x6e\x01\x75\x01\x7c"
"\x01\x83\x01\x8b\x01\x92\x01\x9a\x01\xa1\x01\xa9\x01\xb1\x01\xb9"
"\x01\xc1\x01\xc9\x01\xd1\x01\xd9\x01\xe1\x01\xe9\x01\xf2\x01\xfa"
"\x02\x03\x02\x0c\x02\x14\x02\x1d\x02\x26\x02\x2f\x02\x38\x02\x41"
"\x02\x4b\x02\x54\x02\x5d\x02\x67\x02\x71\x02\x7a\x02\x84\x02\x8e"
"\x02\x98\x02\xa2\x02\xac\x02\xb6\x02\xc1\x02\xcb\x02\xd5\x02\xe0"
"\x02\xeb\x02\xf5\x03\x00\x03\x0b\x03\x16\x03\x21\x03\x2d\x03\x38"
"\x03\x43\x03\x4f\x03\x5a\x03\x66\x03\x72\x03\x7e\x03\x8a\x03\x96"
"\x03\xa2\x03\xae\x03\xba\x03\xc7\x03\xd3\x03\xe0\x03\xec\x03\xf9"
"\x04\x06\x04\x13\x04\x20\x04\x2d\x04\x3b\x04\x48\x04\x55\x04\x63"
"\x04\x71\x04\x7e\x04\x8c\x04\x9a\x04\xa8\x04\xb6\x04\xc4\x04\xd3"
"\x04\xe1\x04\xf0\x04\xfe\x05\x0d\x05\x1c\x05\x2b\x05\x3a\x05\x49"
"\x05\x58\x05\x67\x05\x77\x05\x86\x05\x96\x05\xa6\x05\xb5\x05\xc5"
"\x05\xd5\x05\xe5\x05\xf6\x06\x06\x06\x16\x06\x27\x06\x37\x06\x48"
"\x06\x59\x06\x6a\x06\x7b\x06\x8c\x06\x9d\x06\xaf\x06\xc0\x06\xd1"
"\x06\xe3\x06\xf5\x07\x07\x07\x19\x07\x2b\x07\x3d\x07\x4f\x07\x61"
"\x07\x74\x07\x86\x07\x99\x07\xac\x07\xbf\x07\xd2\x07\xe5\x07\xf8"
"\x08\x0b\x08\x1f\x08\x32\x08\x46\x08\x5a\x08\x6e\x08\x82\x08\x96"
"\x08\xaa\x08\xbe\x08\xd2\x08\xe7\x08\xfb\x09\x10\x09\x25\x09\x3a"
"\x09\x4f\x09\x64\x09\x79\x09\x8f\x09\xa4\x09\xba\x09\xcf\x09\xe5"
"\x09\xfb\x0a\x11\x0a\x27\x0a\x3d\x0a\x54\x0a\x6a\x0a\x81\x0a\x98"
"\x0a\xae\x0a\xc5\x0a\xdc\x0a\xf3\x0b\x0b\x0b\x22\x0b\x39\x0b\x51"
"\x0b\x69\x0b\x80\x0b\x98\x0b\xb0\x0b\xc8\x0b\xe1\x0b\xf9\x0c\x12"
"\x0c\x2a\x0c\x43\x0c\x5c\x0c\x75\x0c\x8e\x0c\xa7\x0c\xc0\x0c\xd9"
"\x0c\xf3\x0d\x0d\x0d\x26\x0d\x40\x0d\x5a\x0d\x74\x0d\x8e\x0d\xa9"
"\x0d\xc3\x0d\xde\x0d\xf8\x0e\x13\x0e\x2e\x0e\x49\x0e\x64\x0e\x7f"
"\x0e\x9b\x0e\xb6\x0e\xd2\x0e\xee\x0f\x09\x0f\x25\x0f\x41\x0f\x5e"
"\x0f\x7a\x0f\x96\x0f\xb3\x0f\xcf\x0f\xec\x10\x09\x10\x26\x10\x43"
"\x10\x61\x10\x7e\x10\x9b\x10\xb9\x10\xd7\x10\xf5\x11\x13\x11\x31"
"\x11\x4f\x11\x6d\x11\x8c\x11\xaa\x11\xc9\x11\xe8\x12\x07\x12\x26"
"\x12\x45\x12\x64\x12\x84\x12\xa3\x12\xc3\x12\xe3\x13\x03\x13\x23"
"\x13\x43\x13\x63\x13\x83\x13\xa4\x13\xc5\x13\xe5\x14\x06\x14\x27"
"\x14\x49\x14\x6a\x14\x8b\x14\xad\x14\xce\x14\xf0\x15\x12\x15\x34"
"\x15\x56\x15\x78\x15\x9b\x15\xbd\x15\xe0\x16\x03\x16\x26\x16\x49"
"\x16\x6c\x16\x8f\x16\xb2\x16\xd6\x16\xfa\x17\x1d\x17\x41\x17\x65"
"\x17\x89\x17\xae\x17\xd2\x17\xf7\x18\x1b\x18\x40\x18\x65\x18\x8a"
"\x18\xaf\x18\xd5\x18\xfa\x19\x20\x19\x45\x19\x6b\x19\x91\x19\xb7"
"\x19\xdd\x1a\x04\x1a\x2a\x1a\x51\x1a\x77\x1a\x9e\x1a\xc5\x1a\xec"
"\x1b\x14\x1b\x3b\x1b\x63\x1b\x8a\x1b\xb2\x1b\xda\x1c\x02\x1c\x2a"
"\x1c\x52\x1c\x7b\x1c\xa3\x1c\xcc\x1c\xf5\x1d\x1e\x1d\x47\x1d\x70"
"\x1d\x99\x1d\xc3\x1d\xec\x1e\x16\x1e\x40\x1e\x6a\x1e\x94\x1e\xbe"
"\x1e\xe9\x1f\x13\x1f\x3e\x1f\x69\x1f\x94\x1f\xbf\x1f\xea\x20\x15"
"\x20\x41\x20\x6c\x20\x98\x20\xc4\x20\xf0\x21\x1c\x21\x48\x21\x75"
"\x21\xa1\x21\xce\x21\xfb\x22\x27\x22\x55\x22\x82\x22\xaf\x22\xdd"
"\x23\x0a\x23\x38\x23\x66\x23\x94\x23\xc2\x23\xf0\x24\x1f\x24\x4d"
"\x24\x7c\x24\xab\x24\xda\x25\x09\x25\x38\x25\x68\x25\x97\x25\xc7"
"\x25\xf7\x26\x27\x26\x57\x26\x87\x26\xb7\x26\xe8\x27\x18\x27\x49"
"\x27\x7a\x27\xab\x27\xdc\x28\x0d\x28\x3f\x28\x71\x28\xa2\x28\xd4"
"\x29\x06\x29\x38\x29\x6b\x29\x9d\x29\xd0\x2a\x02\x2a\x35\x2a\x68"
"\x2a\x9b\x2a\xcf\x2b\x02\x2b\x36\x2b\x69\x2b\x9d\x2b\xd1\x2c\x05"
"\x2c\x39\x2c\x6e\x2c\xa2\x2c\xd7\x2d\x0c\x2d\x41\x2d\x76\x2d\xab"
"\x2d\xe1\x2e\x16\x2e\x4c\x2e\x82\x2e\xb7\x2e\xee\x2f\x24\x2f\x5a"
"\x2f\x91\x2f\xc7\x2f\xfe\x30\x35\x30\x6c\x30\xa4\x30\xdb\x31\x12"
"\x31\x4a\x31\x82\x31\xba\x31\xf2\x32\x2a\x32\x63\x32\x9b\x32\xd4"
"\x33\x0d\x33\x46\x33\x7f\x33\xb8\x33\xf1\x34\x2b\x34\x65\x34\x9e"
"\x34\xd8\x35\x13\x35\x4d\x35\x87\x35\xc2\x35\xfd\x36\x37\x36\x72"
"\x36\xae\x36\xe9\x37\x24\x37\x60\x37\x9c\x37\xd7\x38\x14\x38\x50"
"\x38\x8c\x38\xc8\x39\x05\x39\x42\x39\x7f\x39\xbc\x39\xf9\x3a\x36"
"\x3a\x74\x3a\xb2\x3a\xef\x3b\x2d\x3b\x6b\x3b\xaa\x3b\xe8\x3c\x27"
"\x3c\x65\x3c\xa4\x3c\xe3\x3d\x22\x3d\x61\x3d\xa1\x3d\xe0\x3e\x20"
"\x3e\x60\x3e\xa0\x3e\xe0\x3f\x21\x3f\x61\x3f\xa2\x3f\xe2\x40\x23"
"\x40\x64\x40\xa6\x40\xe7\x41\x29\x41\x6a\x41\xac\x41\xee\x42\x30"
"\x42\x72\x42\xb5\x42\xf7\x43\x3a\x43\x7d\x43\xc0\x44\x03\x44\x47"
"\x44\x8a\x44\xce\x45\x12\x45\x55\x45\x9a\x45\xde\x46\x22\x46\x67"
"\x46\xab\x46\xf0\x47\x35\x47\x7b\x47\xc0\x48\x05\x48\x4b\x48\x91"
"\x48\xd7\x49\x1d\x49\x63\x49\xa9\x49\xf0\x4a\x37\x4a\x7d\x4a\xc4"
"\x4b\x0c\x4b\x53\x4b\x9a\x4b\xe2\x4c\x2a\x4c\x72\x4c\xba\x4d\x02"
"\x4d\x4a\x4d\x93\x4d\xdc\x4e\x25\x4e\x6e\x4e\xb7\x4f\x00\x4f\x49"
"\x4f\x93\x4f\xdd\x50\x27\x50\x71\x50\xbb\x51\x06\x51\x50\x51\x9b"
"\x51\xe6\x52\x31\x52\x7c\x52\xc7\x53\x13\x53\x5f\x53\xaa\x53\xf6"
"\x54\x42\x54\x8f\x54\xdb\x55\x28\x55\x75\x55\xc2\x56\x0f\x56\x5c"
"\x56\xa9\x56\xf7\x57\x44\x57\x92\x57\xe0\x58\x2f\x58\x7d\x58\xcb"
"\x59\x1a\x59\x69\x59\xb8\x5a\x07\x5a\x56\x5a\xa6\x5a\xf5\x5b\x45"
"\x5b\x95\x5b\xe5\x5c\x35\x5c\x86\x5c\xd6\x5d\x27\x5d\x78\x5d\xc9"
"\x5e\x1a\x5e\x6c\x5e\xbd\x5f\x0f\x5f\x61\x5f\xb3\x60\x05\x60\x57"
"\x60\xaa\x60\xfc\x61\x4f\x61\xa2\x61\xf5\x62\x49\x62\x9c\x62\xf0"
"\x63\x43\x63\x97\x63\xeb\x64\x40\x64\x94\x64\xe9\x65\x3d\x65\x92"
"\x65\xe7\x66\x3d\x66\x92\x66\xe8\x67\x3d\x67\x93\x67\xe9\x68\x3f"
"\x68\x96\x68\xec\x69\x43\x69\x9a\x69\xf1\x6a\x48\x6a\x9f\x6a\xf7"
"\x6b\x4f\x6b\xa7\x6b\xff\x6c\x57\x6c\xaf\x6d\x08\x6d\x60\x6d\xb9"
"\x6e\x12\x6e\x6b\x6e\xc4\x6f\x1e\x6f\x78\x6f\xd1\x70\x2b\x70\x86"
"\x70\xe0\x71\x3a\x71\x95\x71\xf0\x72\x4b\x72\xa6\x73\x01\x73\x5d"
"\x73\xb8\x74\x14\x74\x70\x74\xcc\x75\x28\x75\x85\x75\xe1\x76\x3e"
"\x76\x9b\x76\xf8\x77\x56\x77\xb3\x78\x11\x78\x6e\x78\xcc\x79\x2a"
"\x79\x89\x79\xe7\x7a\x46\x7a\xa5\x7b\x04\x7b\x63\x7b\xc2\x7c\x21"
"\x7c\x81\x7c\xe1\x7d\x41\x7d\xa1\x7e\x01\x7e\x62\x7e\xc2\x7f\x23"
"\x7f\x84\x7f\xe5\x80\x47\x80\xa8\x81\x0a\x81\x6b\x81\xcd\x82\x30"
"\x82\x92\x82\xf4\x83\x57\x83\xba\x84\x1d\x84\x80\x84\xe3\x85\x47"
"\x85\xab\x86\x0e\x86\x72\x86\xd7\x87\x3b\x87\x9f\x88\x04\x88\x69"
"\x88\xce\x89\x33\x89\x99\x89\xfe\x8a\x64\x8a\xca\x8b\x30\x8b\x96"
"\x8b\xfc\x8c\x63\x8c\xca\x8d\x31\x8d\x98\x8d\xff\x8e\x66\x8e\xce"
"\x8f\x36\x8f\x9e\x90\x06\x90\x6e\x90\xd6\x91\x3f\x91\xa8\x92\x11"
"\x92\x7a\x92\xe3\x93\x4d\x93\xb6\x94\x20\x94\x8a\x94\xf4\x95\x5f"
"\x95\xc9\x96\x34\x96\x9f\x97\x0a\x97\x75\x97\xe0\x98\x4c\x98\xb8"
"\x99\x24\x99\x90\x99\xfc\x9a\x68\x9a\xd5\x9b\x42\x9b\xaf\x9c\x1c"
"\x9c\x89\x9c\xf7\x9d\x64\x9d\xd2\x9e\x40\x9e\xae\x9f\x1d\x9f\x8b"
"\x9f\xfa\xa0\x69\xa0\xd8\xa1\x47\xa1\xb6\xa2\x26\xa2\x96\xa3\x06"
"\xa3\x76\xa3\xe6\xa4\x56\xa4\xc7\xa5\x38\xa5\xa9\xa6\x1a\xa6\x8b"
"\xa6\xfd\xa7\x6e\xa7\xe0\xa8\x52\xa8\xc4\xa9\x37\xa9\xa9\xaa\x1c"
"\xaa\x8f\xab\x02\xab\x75\xab\xe9\xac\x5c\xac\xd0\xad\x44\xad\xb8"
"\xae\x2d\xae\xa1\xaf\x16\xaf\x8b\xb0\x00\xb0\x75\xb0\xea\xb1\x60"
"\xb1\xd6\xb2\x4b\xb2\xc2\xb3\x38\xb3\xae\xb4\x25\xb4\x9c\xb5\x13"
"\xb5\x8a\xb6\x01\xb6\x79\xb6\xf0\xb7\x68\xb7\xe0\xb8\x59\xb8\xd1"
"\xb9\x4a\xb9\xc2\xba\x3b\xba\xb5\xbb\x2e\xbb\xa7\xbc\x21\xbc\x9b"
"\xbd\x15\xbd\x8f\xbe\x0a\xbe\x84\xbe\xff\xbf\x7a\xbf\xf5\xc0\x70"
"\xc0\xec\xc1\x67\xc1\xe3\xc2\x5f\xc2\xdb\xc3\x58\xc3\xd4\xc4\x51"
"\xc4\xce\xc5\x4b\xc5\xc8\xc6\x46\xc6\xc3\xc7\x41\xc7\xbf\xc8\x3d"
"\xc8\xbc\xc9\x3a\xc9\xb9\xca\x38\xca\xb7\xcb\x36\xcb\xb6\xcc\x35"
"\xcc\xb5\xcd\x35\xcd\xb5\xce\x36\xce\xb6\xcf\x37\xcf\xb8\xd0\x39"
"\xd0\xba\xd1\x3c\xd1\xbe\xd2\x3f\xd2\xc1\xd3\x44\xd3\xc6\xd4\x49"
"\xd4\xcb\xd5\x4e\xd5\xd1\xd6\x55\xd6\xd8\xd7\x5c\xd7\xe0\xd8\x64"
"\xd8\xe8\xd9\x6c\xd9\xf1\xda\x76\xda\xfb\xdb\x80\xdc\x05\xdc\x8a"
"\xdd\x10\xdd\x96\xde\x1c\xde\xa2\xdf\x29\xdf\xaf\xe0\x36\xe0\xbd"
"\xe1\x44\xe1\xcc\xe2\x53\xe2\xdb\xe3\x63\xe3\xeb\xe4\x73\xe4\xfc"
"\xe5\x84\xe6\x0d\xe6\x96\xe7\x1f\xe7\xa9\xe8\x32\xe8\xbc\xe9\x46"
"\xe9\xd0\xea\x5b\xea\xe5\xeb\x70\xeb\xfb\xec\x86\xed\x11\xed\x9c"
"\xee\x28\xee\xb4\xef\x40\xef\xcc\xf0\x58\xf0\xe5\xf1\x72\xf1\xff"
"\xf2\x8c\xf3\x19\xf3\xa7\xf4\x34\xf4\xc2\xf5\x50\xf5\xde\xf6\x6d"
"\xf6\xfb\xf7\x8a\xf8\x19\xf8\xa8\xf9\x38\xf9\xc7\xfa\x57\xfa\xe7"
"\xfb\x77\xfc\x07\xfc\x98\xfd\x29\xfd\xba\xfe\x4b\xfe\xdc\xff\x6d"
"\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x33\x00\x00\x00\x33\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x90\x00\x00\x00\xff\x00\x00"
"\x00\xff\x00\x00\x00\x8f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x66\x00\x00"
"\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00"
"\x00\x66\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x37\x00\x00\x00\xf9\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00"
"\x00\xff\x00\x00\x00\xff\x00\x00\x00\xf9\x00\x00\x00\x37\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x16\x00\x00\x00\xe4\x00\x00\x00\xff\x00\x00"
"\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00"
"\x00\xff\x00\x00\x00\xe3\x00\x00\x00\x16\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\xc0\x00\x00"
"\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00"
"\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00"
"\x00\xc0\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x8f\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00"
"\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00"
"\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\x8f\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x5a\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00"
"\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00"
"\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00"
"\x00\xff\x00\x00\x00\xff\x00\x00\x00\x59\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2e\x00\x00\x00\xf5\x00\x00"
"\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00"
"\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00"
"\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00"
"\x00\xf5\x00\x00\x00\x2e\x00\x00\x00\x00\x00\x00\x00\x0d\x00\x00"
"\x00\xdd\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00"
"\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00"
"\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00"
"\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xdd\x00\x00"
"\x00\x0d\x00\x00\x00\x6d\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00"
"\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00"
"\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00"
"\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00"
"\x00\xff\x00\x00\x00\xff\x00\x00\x00\x6d\x00\x00\x00\x6d\x00\x00"
"\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00"
"\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00"
"\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00"
"\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00"
"\x00\x6c\x00\x00\x00\x0d\x00\x00\x00\xdc\x00\x00\x00\xff\x00\x00"
"\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00"
"\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00"
"\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00"
"\x00\xff\x00\x00\x00\xdc\x00\x00\x00\x0d\x00\x00\x00\x00\x00\x00"
"\x00\x2e\x00\x00\x00\xf5\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00"
"\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00"
"\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00"
"\x00\xff\x00\x00\x00\xff\x00\x00\x00\xf5\x00\x00\x00\x2e\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x59\x00\x00"
"\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00"
"\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00"
"\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00"
"\x00\x59\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8f\x00\x00\x00\xff\x00\x00"
"\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00"
"\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00"
"\x00\xff\x00\x00\x00\x8e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x04\x00\x00\x00\xc0\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00"
"\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00"
"\x00\xff\x00\x00\x00\xff\x00\x00\x00\xc0\x00\x00\x00\x04\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x16\x00\x00"
"\x00\xe3\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00"
"\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xe3\x00\x00"
"\x00\x16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x37\x00\x00\x00\xf9\x00\x00"
"\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00"
"\x00\xf9\x00\x00\x00\x37\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x66\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00"
"\x00\xff\x00\x00\x00\xff\x00\x00\x00\x65\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x90\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\x8f\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x33\x00\x00"
"\x00\x33\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x12\x01\x00\x00\x03\x00\x00\x00\x01\x00\x12\x00\x00"
"\x01\x01\x00\x03\x00\x00\x00\x01\x00\x16\x00\x00\x01\x02\x00\x03"
"\x00\x00\x00\x04\x00\x00\x15\xd0\x01\x03\x00\x03\x00\x00\x00\x01"
"\x00\x01\x00\x00\x01\x06\x00\x03\x00\x00\x00\x01\x00\x02\x00\x00"
"\x01\x0a\x00\x03\x00\x00\x00\x01\x00\x01\x00\x00\x01\x11\x00\x04"
"\x00\x00\x00\x01\x00\x00\x0e\xb2\x01\x12\x00\x03\x00\x00\x00\x01"
"\x00\x01\x00\x00\x01\x15\x00\x03\x00\x00\x00\x01\x00\x04\x00\x00"
"\x01\x16\x00\x03\x00\x00\x00\x01\x00\x16\x00\x00\x01\x17\x00\x04"
"\x00\x00\x00\x01\x00\x00\x06\x30\x01\x1a\x00\x05\x00\x00\x00\x01"
"\x00\x00\x15\xc0\x01\x1b\x00\x05\x00\x00\x00\x01\x00\x00\x15\xc8"
"\x01\x1c\x00\x03\x00\x00\x00\x01\x00\x01\x00\x00\x01\x28\x00\x03"
"\x00\x00\x00\x01\x00\x02\x00\x00\x01\x52\x00\x03\x00\x00\x00\x01"
"\x00\x01\x00\x00\x01\x53\x00\x03\x00\x00\x00\x04\x00\x00\x15\xd8"
"\x87\x73\x00\x07\x00\x00\x0c\x48\x00\x00\x15\xe0\x00\x00\x30\x14"
"\x00\x00\x00\x90\x00\x00\x00\x01\x00\x00\x00\x90\x00\x00\x00\x01"
"\x00\x08\x00\x08\x00\x08\x00\x08\x00\x01\x00\x01\x00\x01\x00\x01"
"\x00\x00\x0c\x48\x4c\x69\x6e\x6f\x02\x10\x00\x00\x6d\x6e\x74\x72"
"\x52\x47\x42\x20\x58\x59\x5a\x20\x07\xce\x00\x02\x00\x09\x00\x06"
"\x00\x31\x00\x00\x61\x63\x73\x70\x4d\x53\x46\x54\x00\x00\x00\x00"
"\x49\x45\x43\x20\x73\x52\x47\x42\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\xf6\xd6\x00\x01\x00\x00\x00\x00\xd3\x2d"
"\x48\x50\x20\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x11\x63\x70\x72\x74\x00\x00\x01\x50\x00\x00\x00\x33"
"\x64\x65\x73\x63\x00\x00\x01\x84\x00\x00\x00\x6c\x77\x74\x70\x74"
"\x00\x00\x01\xf0\x00\x00\x00\x14\x62\x6b\x70\x74\x00\x00\x02\x04"
"\x00\x00\x00\x14\x72\x58\x59\x5a\x00\x00\x02\x18\x00\x00\x00\x14"
"\x67\x58\x59\x5a\x00\x00\x02\x2c\x00\x00\x00\x14\x62\x58\x59\x5a"
"\x00\x00\x02\x40\x00\x00\x00\x14\x64\x6d\x6e\x64\x00\x00\x02\x54"
"\x00\x00\x00\x70\x64\x6d\x64\x64\x00\x00\x02\xc4\x00\x00\x00\x88"
"\x76\x75\x65\x64\x00\x00\x03\x4c\x00\x00\x00\x86\x76\x69\x65\x77"
"\x00\x00\x03\xd4\x00\x00\x00\x24\x6c\x75\x6d\x69\x00\x00\x03\xf8"
"\x00\x00\x00\x14\x6d\x65\x61\x73\x00\x00\x04\x0c\x00\x00\x00\x24"
"\x74\x65\x63\x68\x00\x00\x04\x30\x00\x00\x00\x0c\x72\x54\x52\x43"
"\x00\x00\x04\x3c\x00\x00\x08\x0c\x67\x54\x52\x43\x00\x00\x04\x3c"
"\x00\x00\x08\x0c\x62\x54\x52\x43\x00\x00\x04\x3c\x00\x00\x08\x0c"
"\x74\x65\x78\x74\x00\x00\x00\x00\x43\x6f\x70\x79\x72\x69\x67\x68"
"\x74\x20\x28\x63\x29\x20\x31\x39\x39\x38\x20\x48\x65\x77\x6c\x65"
"\x74\x74\x2d\x50\x61\x63\x6b\x61\x72\x64\x20\x43\x6f\x6d\x70\x61"
"\x6e\x79\x00\x00\x64\x65\x73\x63\x00\x00\x00\x00\x00\x00\x00\x12"
"\x73\x52\x47\x42\x20\x49\x45\x43\x36\x31\x39\x36\x36\x2d\x32\x2e"
"\x31\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x12\x73\x52\x47"
"\x42\x20\x49\x45\x43\x36\x31\x39\x36\x36\x2d\x32\x2e\x31\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x58\x59\x5a\x20\x00\x00\x00\x00\x00\x00\xf3\x51\x00\x01\x00\x00"
"\x00\x01\x16\xcc\x58\x59\x5a\x20\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x58\x59\x5a\x20\x00\x00\x00\x00"
"\x00\x00\x6f\xa2\x00\x00\x38\xf5\x00\x00\x03\x90\x58\x59\x5a\x20"
"\x00\x00\x00\x00\x00\x00\x62\x99\x00\x00\xb7\x85\x00\x00\x18\xda"
"\x58\x59\x5a\x20\x00\x00\x00\x00\x00\x00\x24\xa0\x00\x00\x0f\x84"
"\x00\x00\xb6\xcf\x64\x65\x73\x63\x00\x00\x00\x00\x00\x00\x00\x16"
"\x49\x45\x43\x20\x68\x74\x74\x70\x3a\x2f\x2f\x77\x77\x77\x2e\x69"
"\x65\x63\x2e\x63\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x16\x49\x45\x43\x20\x68\x74\x74\x70\x3a\x2f\x2f\x77\x77\x77\x2e"
"\x69\x65\x63\x2e\x63\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x64\x65\x73\x63\x00\x00\x00\x00\x00\x00\x00\x2e"
"\x49\x45\x43\x20\x36\x31\x39\x36\x36\x2d\x32\x2e\x31\x20\x44\x65"
"\x66\x61\x75\x6c\x74\x20\x52\x47\x42\x20\x63\x6f\x6c\x6f\x75\x72"
"\x20\x73\x70\x61\x63\x65\x20\x2d\x20\x73\x52\x47\x42\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x2e\x49\x45\x43\x20\x36\x31\x39"
"\x36\x36\x2d\x32\x2e\x31\x20\x44\x65\x66\x61\x75\x6c\x74\x20\x52"
"\x47\x42\x20\x63\x6f\x6c\x6f\x75\x72\x20\x73\x70\x61\x63\x65\x20"
"\x2d\x20\x73\x52\x47\x42\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x64\x65\x73\x63"
"\x00\x00\x00\x00\x00\x00\x00\x2c\x52\x65\x66\x65\x72\x65\x6e\x63"
"\x65\x20\x56\x69\x65\x77\x69\x6e\x67\x20\x43\x6f\x6e\x64\x69\x74"
"\x69\x6f\x6e\x20\x69\x6e\x20\x49\x45\x43\x36\x31\x39\x36\x36\x2d"
"\x32\x2e\x31\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x52"
"\x65\x66\x65\x72\x65\x6e\x63\x65\x20\x56\x69\x65\x77\x69\x6e\x67"
"\x20\x43\x6f\x6e\x64\x69\x74\x69\x6f\x6e\x20\x69\x6e\x20\x49\x45"
"\x43\x36\x31\x39\x36\x36\x2d\x32\x2e\x31\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x76\x69\x65\x77\x00\x00\x00\x00\x00\x13\xa4\xfe"
"\x00\x14\x5f\x2e\x00\x10\xcf\x14\x00\x03\xed\xcc\x00\x04\x13\x0b"
"\x00\x03\x5c\x9e\x00\x00\x00\x01\x58\x59\x5a\x20\x00\x00\x00\x00"
"\x00\x4c\x09\x56\x00\x50\x00\x00\x00\x57\x1f\xe7\x6d\x65\x61\x73"
"\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x8f\x00\x00\x00\x02"
"\x73\x69\x67\x20\x00\x00\x00\x00\x43\x52\x54\x20\x63\x75\x72\x76"
"\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x05\x00\x0a\x00\x0f"
"\x00\x14\x00\x19\x00\x1e\x00\x23\x00\x28\x00\x2d\x00\x32\x00\x37"
"\x00\x3b\x00\x40\x00\x45\x00\x4a\x00\x4f\x00\x54\x00\x59\x00\x5e"
"\x00\x63\x00\x68\x00\x6d\x00\x72\x00\x77\x00\x7c\x00\x81\x00\x86"
"\x00\x8b\x00\x90\x00\x95\x00\x9a\x00\x9f\x00\xa4\x00\xa9\x00\xae"
"\x00\xb2\x00\xb7\x00\xbc\x00\xc1\x00\xc6\x00\xcb\x00\xd0\x00\xd5"
"\x00\xdb\x00\xe0\x00\xe5\x00\xeb\x00\xf0\x00\xf6\x00\xfb\x01\x01"
"\x01\x07\x01\x0d\x01\x13\x01\x19\x01\x1f\x01\x25\x01\x2b\x01\x32"
"\x01\x38\x01\x3e\x01\x45\x01\x4c\x01\x52\x01\x59\x01\x60\x01\x67"
"\x01\x6e\x01\x75\x01\x7c\x01\x83\x01\x8b\x01\x92\x01\x9a\x01\xa1"
"\x01\xa9\x01\xb1\x01\xb9\x01\xc1\x01\xc9\x01\xd1\x01\xd9\x01\xe1"
"\x01\xe9\x01\xf2\x01\xfa\x02\x03\x02\x0c\x02\x14\x02\x1d\x02\x26"
"\x02\x2f\x02\x38\x02\x41\x02\x4b\x02\x54\x02\x5d\x02\x67\x02\x71"
"\x02\x7a\x02\x84\x02\x8e\x02\x98\x02\xa2\x02\xac\x02\xb6\x02\xc1"
"\x02\xcb\x02\xd5\x02\xe0\x02\xeb\x02\xf5\x03\x00\x03\x0b\x03\x16"
"\x03\x21\x03\x2d\x03\x38\x03\x43\x03\x4f\x03\x5a\x03\x66\x03\x72"
"\x03\x7e\x03\x8a\x03\x96\x03\xa2\x03\xae\x03\xba\x03\xc7\x03\xd3"
"\x03\xe0\x03\xec\x03\xf9\x04\x06\x04\x13\x04\x20\x04\x2d\x04\x3b"
"\x04\x48\x04\x55\x04\x63\x04\x71\x04\x7e\x04\x8c\x04\x9a\x04\xa8"
"\x04\xb6\x04\xc4\x04\xd3\x04\xe1\x04\xf0\x04\xfe\x05\x0d\x05\x1c"
"\x05\x2b\x05\x3a\x05\x49\x05\x58\x05\x67\x05\x77\x05\x86\x05\x96"
"\x05\xa6\x05\xb5\x05\xc5\x05\xd5\x05\xe5\x05\xf6\x06\x06\x06\x16"
"\x06\x27\x06\x37\x06\x48\x06\x59\x06\x6a\x06\x7b\x06\x8c\x06\x9d"
"\x06\xaf\x06\xc0\x06\xd1\x06\xe3\x06\xf5\x07\x07\x07\x19\x07\x2b"
"\x07\x3d\x07\x4f\x07\x61\x07\x74\x07\x86\x07\x99\x07\xac\x07\xbf"
"\x07\xd2\x07\xe5\x07\xf8\x08\x0b\x08\x1f\x08\x32\x08\x46\x08\x5a"
"\x08\x6e\x08\x82\x08\x96\x08\xaa\x08\xbe\x08\xd2\x08\xe7\x08\xfb"
"\x09\x10\x09\x25\x09\x3a\x09\x4f\x09\x64\x09\x79\x09\x8f\x09\xa4"
"\x09\xba\x09\xcf\x09\xe5\x09\xfb\x0a\x11\x0a\x27\x0a\x3d\x0a\x54"
"\x0a\x6a\x0a\x81\x0a\x98\x0a\xae\x0a\xc5\x0a\xdc\x0a\xf3\x0b\x0b"
"\x0b\x22\x0b\x39\x0b\x51\x0b\x69\x0b\x80\x0b\x98\x0b\xb0\x0b\xc8"
"\x0b\xe1\x0b\xf9\x0c\x12\x0c\x2a\x0c\x43\x0c\x5c\x0c\x75\x0c\x8e"
"\x0c\xa7\x0c\xc0\x0c\xd9\x0c\xf3\x0d\x0d\x0d\x26\x0d\x40\x0d\x5a"
"\x0d\x74\x0d\x8e\x0d\xa9\x0d\xc3\x0d\xde\x0d\xf8\x0e\x13\x0e\x2e"
"\x0e\x49\x0e\x64\x0e\x7f\x0e\x9b\x0e\xb6\x0e\xd2\x0e\xee\x0f\x09"
"\x0f\x25\x0f\x41\x0f\x5e\x0f\x7a\x0f\x96\x0f\xb3\x0f\xcf\x0f\xec"
"\x10\x09\x10\x26\x10\x43\x10\x61\x10\x7e\x10\x9b\x10\xb9\x10\xd7"
"\x10\xf5\x11\x13\x11\x31\x11\x4f\x11\x6d\x11\x8c\x11\xaa\x11\xc9"
"\x11\xe8\x12\x07\x12\x26\x12\x45\x12\x64\x12\x84\x12\xa3\x12\xc3"
"\x12\xe3\x13\x03\x13\x23\x13\x43\x13\x63\x13\x83\x13\xa4\x13\xc5"
"\x13\xe5\x14\x06\x14\x27\x14\x49\x14\x6a\x14\x8b\x14\xad\x14\xce"
"\x14\xf0\x15\x12\x15\x34\x15\x56\x15\x78\x15\x9b\x15\xbd\x15\xe0"
"\x16\x03\x16\x26\x16\x49\x16\x6c\x16\x8f\x16\xb2\x16\xd6\x16\xfa"
"\x17\x1d\x17\x41\x17\x65\x17\x89\x17\xae\x17\xd2\x17\xf7\x18\x1b"
"\x18\x40\x18\x65\x18\x8a\x18\xaf\x18\xd5\x18\xfa\x19\x20\x19\x45"
"\x19\x6b\x19\x91\x19\xb7\x19\xdd\x1a\x04\x1a\x2a\x1a\x51\x1a\x77"
"\x1a\x9e\x1a\xc5\x1a\xec\x1b\x14\x1b\x3b\x1b\x63\x1b\x8a\x1b\xb2"
"\x1b\xda\x1c\x02\x1c\x2a\x1c\x52\x1c\x7b\x1c\xa3\x1c\xcc\x1c\xf5"
"\x1d\x1e\x1d\x47\x1d\x70\x1d\x99\x1d\xc3\x1d\xec\x1e\x16\x1e\x40"
"\x1e\x6a\x1e\x94\x1e\xbe\x1e\xe9\x1f\x13\x1f\x3e\x1f\x69\x1f\x94"
"\x1f\xbf\x1f\xea\x20\x15\x20\x41\x20\x6c\x20\x98\x20\xc4\x20\xf0"
"\x21\x1c\x21\x48\x21\x75\x21\xa1\x21\xce\x21\xfb\x22\x27\x22\x55"
"\x22\x82\x22\xaf\x22\xdd\x23\x0a\x23\x38\x23\x66\x23\x94\x23\xc2"
"\x23\xf0\x24\x1f\x24\x4d\x24\x7c\x24\xab\x24\xda\x25\x09\x25\x38"
"\x25\x68\x25\x97\x25\xc7\x25\xf7\x26\x27\x26\x57\x26\x87\x26\xb7"
"\x26\xe8\x27\x18\x27\x49\x27\x7a\x27\xab\x27\xdc\x28\x0d\x28\x3f"
"\x28\x71\x28\xa2\x28\xd4\x29\x06\x29\x38\x29\x6b\x29\x9d\x29\xd0"
"\x2a\x02\x2a\x35\x2a\x68\x2a\x9b\x2a\xcf\x2b\x02\x2b\x36\x2b\x69"
"\x2b\x9d\x2b\xd1\x2c\x05\x2c\x39\x2c\x6e\x2c\xa2\x2c\xd7\x2d\x0c"
"\x2d\x41\x2d\x76\x2d\xab\x2d\xe1\x2e\x16\x2e\x4c\x2e\x82\x2e\xb7"
"\x2e\xee\x2f\x24\x2f\x5a\x2f\x91\x2f\xc7\x2f\xfe\x30\x35\x30\x6c"
"\x30\xa4\x30\xdb\x31\x12\x31\x4a\x31\x82\x31\xba\x31\xf2\x32\x2a"
"\x32\x63\x32\x9b\x32\xd4\x33\x0d\x33\x46\x33\x7f\x33\xb8\x33\xf1"
"\x34\x2b\x34\x65\x34\x9e\x34\xd8\x35\x13\x35\x4d\x35\x87\x35\xc2"
"\x35\xfd\x36\x37\x36\x72\x36\xae\x36\xe9\x37\x24\x37\x60\x37\x9c"
"\x37\xd7\x38\x14\x38\x50\x38\x8c\x38\xc8\x39\x05\x39\x42\x39\x7f"
"\x39\xbc\x39\xf9\x3a\x36\x3a\x74\x3a\xb2\x3a\xef\x3b\x2d\x3b\x6b"
"\x3b\xaa\x3b\xe8\x3c\x27\x3c\x65\x3c\xa4\x3c\xe3\x3d\x22\x3d\x61"
"\x3d\xa1\x3d\xe0\x3e\x20\x3e\x60\x3e\xa0\x3e\xe0\x3f\x21\x3f\x61"
"\x3f\xa2\x3f\xe2\x40\x23\x40\x64\x40\xa6\x40\xe7\x41\x29\x41\x6a"
"\x41\xac\x41\xee\x42\x30\x42\x72\x42\xb5\x42\xf7\x43\x3a\x43\x7d"
"\x43\xc0\x44\x03\x44\x47\x44\x8a\x44\xce\x45\x12\x45\x55\x45\x9a"
"\x45\xde\x46\x22\x46\x67\x46\xab\x46\xf0\x47\x35\x47\x7b\x47\xc0"
"\x48\x05\x48\x4b\x48\x91\x48\xd7\x49\x1d\x49\x63\x49\xa9\x49\xf0"
"\x4a\x37\x4a\x7d\x4a\xc4\x4b\x0c\x4b\x53\x4b\x9a\x4b\xe2\x4c\x2a"
"\x4c\x72\x4c\xba\x4d\x02\x4d\x4a\x4d\x93\x4d\xdc\x4e\x25\x4e\x6e"
"\x4e\xb7\x4f\x00\x4f\x49\x4f\x93\x4f\xdd\x50\x27\x50\x71\x50\xbb"
"\x51\x06\x51\x50\x51\x9b\x51\xe6\x52\x31\x52\x7c\x52\xc7\x53\x13"
"\x53\x5f\x53\xaa\x53\xf6\x54\x42\x54\x8f\x54\xdb\x55\x28\x55\x75"
"\x55\xc2\x56\x0f\x56\x5c\x56\xa9\x56\xf7\x57\x44\x57\x92\x57\xe0"
"\x58\x2f\x58\x7d\x58\xcb\x59\x1a\x59\x69\x59\xb8\x5a\x07\x5a\x56"
"\x5a\xa6\x5a\xf5\x5b\x45\x5b\x95\x5b\xe5\x5c\x35\x5c\x86\x5c\xd6"
"\x5d\x27\x5d\x78\x5d\xc9\x5e\x1a\x5e\x6c\x5e\xbd\x5f\x0f\x5f\x61"
"\x5f\xb3\x60\x05\x60\x57\x60\xaa\x60\xfc\x61\x4f\x61\xa2\x61\xf5"
"\x62\x49\x62\x9c\x62\xf0\x63\x43\x63\x97\x63\xeb\x64\x40\x64\x94"
"\x64\xe9\x65\x3d\x65\x92\x65\xe7\x66\x3d\x66\x92\x66\xe8\x67\x3d"
"\x67\x93\x67\xe9\x68\x3f\x68\x96\x68\xec\x69\x43\x69\x9a\x69\xf1"
"\x6a\x48\x6a\x9f\x6a\xf7\x6b\x4f\x6b\xa7\x6b\xff\x6c\x57\x6c\xaf"
"\x6d\x08\x6d\x60\x6d\xb9\x6e\x12\x6e\x6b\x6e\xc4\x6f\x1e\x6f\x78"
"\x6f\xd1\x70\x2b\x70\x86\x70\xe0\x71\x3a\x71\x95\x71\xf0\x72\x4b"
"\x72\xa6\x73\x01\x73\x5d\x73\xb8\x74\x14\x74\x70\x74\xcc\x75\x28"
"\x75\x85\x75\xe1\x76\x3e\x76\x9b\x76\xf8\x77\x56\x77\xb3\x78\x11"
"\x78\x6e\x78\xcc\x79\x2a\x79\x89\x79\xe7\x7a\x46\x7a\xa5\x7b\x04"
"\x7b\x63\x7b\xc2\x7c\x21\x7c\x81\x7c\xe1\x7d\x41\x7d\xa1\x7e\x01"
"\x7e\x62\x7e\xc2\x7f\x23\x7f\x84\x7f\xe5\x80\x47\x80\xa8\x81\x0a"
"\x81\x6b\x81\xcd\x82\x30\x82\x92\x82\xf4\x83\x57\x83\xba\x84\x1d"
"\x84\x80\x84\xe3\x85\x47\x85\xab\x86\x0e\x86\x72\x86\xd7\x87\x3b"
"\x87\x9f\x88\x04\x88\x69\x88\xce\x89\x33\x89\x99\x89\xfe\x8a\x64"
"\x8a\xca\x8b\x30\x8b\x96\x8b\xfc\x8c\x63\x8c\xca\x8d\x31\x8d\x98"
"\x8d\xff\x8e\x66\x8e\xce\x8f\x36\x8f\x9e\x90\x06\x90\x6e\x90\xd6"
"\x91\x3f\x91\xa8\x92\x11\x92\x7a\x92\xe3\x93\x4d\x93\xb6\x94\x20"
"\x94\x8a\x94\xf4\x95\x5f\x95\xc9\x96\x34\x96\x9f\x97\x0a\x97\x75"
"\x97\xe0\x98\x4c\x98\xb8\x99\x24\x99\x90\x99\xfc\x9a\x68\x9a\xd5"
"\x9b\x42\x9b\xaf\x9c\x1c\x9c\x89\x9c\xf7\x9d\x64\x9d\xd2\x9e\x40"
"\x9e\xae\x9f\x1d\x9f\x8b\x9f\xfa\xa0\x69\xa0\xd8\xa1\x47\xa1\xb6"
"\xa2\x26\xa2\x96\xa3\x06\xa3\x76\xa3\xe6\xa4\x56\xa4\xc7\xa5\x38"
"\xa5\xa9\xa6\x1a\xa6\x8b\xa6\xfd\xa7\x6e\xa7\xe0\xa8\x52\xa8\xc4"
"\xa9\x37\xa9\xa9\xaa\x1c\xaa\x8f\xab\x02\xab\x75\xab\xe9\xac\x5c"
"\xac\xd0\xad\x44\xad\xb8\xae\x2d\xae\xa1\xaf\x16\xaf\x8b\xb0\x00"
"\xb0\x75\xb0\xea\xb1\x60\xb1\xd6\xb2\x4b\xb2\xc2\xb3\x38\xb3\xae"
"\xb4\x25\xb4\x9c\xb5\x13\xb5\x8a\xb6\x01\xb6\x79\xb6\xf0\xb7\x68"
"\xb7\xe0\xb8\x59\xb8\xd1\xb9\x4a\xb9\xc2\xba\x3b\xba\xb5\xbb\x2e"
"\xbb\xa7\xbc\x21\xbc\x9b\xbd\x15\xbd\x8f\xbe\x0a\xbe\x84\xbe\xff"
"\xbf\x7a\xbf\xf5\xc0\x70\xc0\xec\xc1\x67\xc1\xe3\xc2\x5f\xc2\xdb"
"\xc3\x58\xc3\xd4\xc4\x51\xc4\xce\xc5\x4b\xc5\xc8\xc6\x46\xc6\xc3"
"\xc7\x41\xc7\xbf\xc8\x3d\xc8\xbc\xc9\x3a\xc9\xb9\xca\x38\xca\xb7"
"\xcb\x36\xcb\xb6\xcc\x35\xcc\xb5\xcd\x35\xcd\xb5\xce\x36\xce\xb6"
"\xcf\x37\xcf\xb8\xd0\x39\xd0\xba\xd1\x3c\xd1\xbe\xd2\x3f\xd2\xc1"
"\xd3\x44\xd3\xc6\xd4\x49\xd4\xcb\xd5\x4e\xd5\xd1\xd6\x55\xd6\xd8"
"\xd7\x5c\xd7\xe0\xd8\x64\xd8\xe8\xd9\x6c\xd9\xf1\xda\x76\xda\xfb"
"\xdb\x80\xdc\x05\xdc\x8a\xdd\x10\xdd\x96\xde\x1c\xde\xa2\xdf\x29"
"\xdf\xaf\xe0\x36\xe0\xbd\xe1\x44\xe1\xcc\xe2\x53\xe2\xdb\xe3\x63"
"\xe3\xeb\xe4\x73\xe4\xfc\xe5\x84\xe6\x0d\xe6\x96\xe7\x1f\xe7\xa9"
"\xe8\x32\xe8\xbc\xe9\x46\xe9\xd0\xea\x5b\xea\xe5\xeb\x70\xeb\xfb"
"\xec\x86\xed\x11\xed\x9c\xee\x28\xee\xb4\xef\x40\xef\xcc\xf0\x58"
"\xf0\xe5\xf1\x72\xf1\xff\xf2\x8c\xf3\x19\xf3\xa7\xf4\x34\xf4\xc2"
"\xf5\x50\xf5\xde\xf6\x6d\xf6\xfb\xf7\x8a\xf8\x19\xf8\xa8\xf9\x38"
"\xf9\xc7\xfa\x57\xfa\xe7\xfb\x77\xfc\x07\xfc\x98\xfd\x29\xfd\xba"
"\xfe\x4b\xfe\xdc\xff\x6d\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x35\x00\x00\x00\xc7\x00\x00\x00\xf4\x00\x00\x00\xc7"
"\x00\x00\x00\x35\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x00\x00\x00\xf2"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xf1"
"\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x0e\x00\x00\x00\xd8\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xd8"
"\x00\x00\x00\x0d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\xaf"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xaf"
"\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x7b\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\x7b"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x47"
"\x00\x00\x00\xfd\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xfd\x00\x00\x00\x47"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x21\x00\x00\x00\xed\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xed\x00\x00\x00\x21"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x09"
"\x00\x00\x00\xd0\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xd0\x00\x00\x00\x09"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa4\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xa3\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x6f\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\x6e\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3d\x00\x00\x00\xfb"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xfb\x00\x00\x00\x3d\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x1b\x00\x00\x00\xe8\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xe8\x00\x00\x00\x1a\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x06\x00\x00\x00\xc7"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xc7\x00\x00\x00\x06\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x90\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\x90\x00\x00\x00\x00\x00\x00\x00\x19"
"\x00\x00\x00\xfb\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xfb\x00\x00\x00\x19\x00\x00\x00\x3f\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\x3f\x00\x00\x00\x19\x00\x00\x00\xfb\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xfb\x00\x00\x00\x19"
"\x00\x00\x00\x00\x00\x00\x00\x90\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\x8f\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x06\x00\x00\x00\xc7\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xc6"
"\x00\x00\x00\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x1a\x00\x00\x00\xe8\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xe8\x00\x00\x00\x1a\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x3d\x00\x00\x00\xfb\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xfb"
"\x00\x00\x00\x3d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x6e\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\x6d\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\xa3\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xa3\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x09"
"\x00\x00\x00\xd0\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xcf\x00\x00\x00\x09"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x21"
"\x00\x00\x00\xed\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xed\x00\x00\x00\x21\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x47"
"\x00\x00\x00\xfd\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xfd\x00\x00\x00\x47"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7a"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\x7a\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\xaf"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xaf"
"\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0e\x00\x00\x00\xd8"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff"
"\x00\x00\x00\xff\x00\x00\x00\xd8\x00\x00\x00\x0e\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x00\x00\x00\xf2"
"\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xff\x00\x00\x00\xf1"
"\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x35\x00\x00\x00\xc7"
"\x00\x00\x00\xf4\x00\x00\x00\xc7\x00\x00\x00\x35\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x12\x01\x00\x00\x03\x00\x00\x00\x01\x00\x1b"
"\x00\x00\x01\x01\x00\x03\x00\x00\x00\x01\x00\x21\x00\x00\x01\x02"
"\x00\x03\x00\x00\x00\x04\x00\x00\x31\x02\x01\x03\x00\x03\x00\x00"
"\x00\x01\x00\x01\x00\x00\x01\x06\x00\x03\x00\x00\x00\x01\x00\x02"
"\x00\x00\x01\x0a\x00\x03\x00\x00\x00\x01\x00\x01\x00\x00\x01\x11"
"\x00\x04\x00\x00\x00\x01\x00\x00\x22\x28\x01\x12\x00\x03\x00\x00"
"\x00\x01\x00\x01\x00\x00\x01\x15\x00\x03\x00\x00\x00\x01\x00\x04"
"\x00\x00\x01\x16\x00\x03\x00\x00\x00\x01\x00\x21\x00\x00\x01\x17"
"\x00\x04\x00\x00\x00\x01\x00\x00\x0d\xec\x01\x1a\x00\x05\x00\x00"
"\x00\x01\x00\x00\x30\xf2\x01\x1b\x00\x05\x00\x00\x00\x01\x00\x00"
"\x30\xfa\x01\x1c\x00\x03\x00\x00\x00\x01\x00\x01\x00\x00\x01\x28"
"\x00\x03\x00\x00\x00\x01\x00\x02\x00\x00\x01\x52\x00\x03\x00\x00"
"\x00\x01\x00\x01\x00\x00\x01\x53\x00\x03\x00\x00\x00\x04\x00\x00"
"\x31\x0a\x87\x73\x00\x07\x00\x00\x0c\x48\x00\x00\x31\x12\x00\x00"
"\x00\x00\x00\x00\x00\xd8\x00\x00\x00\x01\x00\x00\x00\xd8\x00\x00"
"\x00\x01\x00\x08\x00\x08\x00\x08\x00\x08\x00\x01\x00\x01\x00\x01"
"\x00\x01\x00\x00\x0c\x48\x4c\x69\x6e\x6f\x02\x10\x00\x00\x6d\x6e"
"\x74\x72\x52\x47\x42\x20\x58\x59\x5a\x20\x07\xce\x00\x02\x00\x09"
"\x00\x06\x00\x31\x00\x00\x61\x63\x73\x70\x4d\x53\x46\x54\x00\x00"
"\x00\x00\x49\x45\x43\x20\x73\x52\x47\x42\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\xf6\xd6\x00\x01\x00\x00\x00\x00"
"\xd3\x2d\x48\x50\x20\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x11\x63\x70\x72\x74\x00\x00\x01\x50\x00\x00"
"\x00\x33\x64\x65\x73\x63\x00\x00\x01\x84\x00\x00\x00\x6c\x77\x74"
"\x70\x74\x00\x00\x01\xf0\x00\x00\x00\x14\x62\x6b\x70\x74\x00\x00"
"\x02\x04\x00\x00\x00\x14\x72\x58\x59\x5a\x00\x00\x02\x18\x00\x00"
"\x00\x14\x67\x58\x59\x5a\x00\x00\x02\x2c\x00\x00\x00\x14\x62\x58"
"\x59\x5a\x00\x00\x02\x40\x00\x00\x00\x14\x64\x6d\x6e\x64\x00\x00"
"\x02\x54\x00\x00\x00\x70\x64\x6d\x64\x64\x00\x00\x02\xc4\x00\x00"
"\x00\x88\x76\x75\x65\x64\x00\x00\x03\x4c\x00\x00\x00\x86\x76\x69"
"\x65\x77\x00\x00\x03\xd4\x00\x00\x00\x24\x6c\x75\x6d\x69\x00\x00"
"\x03\xf8\x00\x00\x00\x14\x6d\x65\x61\x73\x00\x00\x04\x0c\x00\x00"
"\x00\x24\x74\x65\x63\x68\x00\x00\x04\x30\x00\x00\x00\x0c\x72\x54"
"\x52\x43\x00\x00\x04\x3c\x00\x00\x08\x0c\x67\x54\x52\x43\x00\x00"
"\x04\x3c\x00\x00\x08\x0c\x62\x54\x52\x43\x00\x00\x04\x3c\x00\x00"
"\x08\x0c\x74\x65\x78\x74\x00\x00\x00\x00\x43\x6f\x70\x79\x72\x69"
"\x67\x68\x74\x20\x28\x63\x29\x20\x31\x39\x39\x38\x20\x48\x65\x77"
"\x6c\x65\x74\x74\x2d\x50\x61\x63\x6b\x61\x72\x64\x20\x43\x6f\x6d"
"\x70\x61\x6e\x79\x00\x00\x64\x65\x73\x63\x00\x00\x00\x00\x00\x00"
"\x00\x12\x73\x52\x47\x42\x20\x49\x45\x43\x36\x31\x39\x36\x36\x2d"
"\x32\x2e\x31\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x12\x73"
"\x52\x47\x42\x20\x49\x45\x43\x36\x31\x39\x36\x36\x2d\x32\x2e\x31"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x58\x59\x5a\x20\x00\x00\x00\x00\x00\x00\xf3\x51\x00\x01"
"\x00\x00\x00\x01\x16\xcc\x58\x59\x5a\x20\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x58\x59\x5a\x20\x00\x00"
"\x00\x00\x00\x00\x6f\xa2\x00\x00\x38\xf5\x00\x00\x03\x90\x58\x59"
"\x5a\x20\x00\x00\x00\x00\x00\x00\x62\x99\x00\x00\xb7\x85\x00\x00"
"\x18\xda\x58\x59\x5a\x20\x00\x00\x00\x00\x00\x00\x24\xa0\x00\x00"
"\x0f\x84\x00\x00\xb6\xcf\x64\x65\x73\x63\x00\x00\x00\x00\x00\x00"
"\x00\x16\x49\x45\x43\x20\x68\x74\x74\x70\x3a\x2f\x2f\x77\x77\x77"
"\x2e\x69\x65\x63\x2e\x63\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x16\x49\x45\x43\x20\x68\x74\x74\x70\x3a\x2f\x2f\x77\x77"
"\x77\x2e\x69\x65\x63\x2e\x63\x68\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x64\x65\x73\x63\x00\x00\x00\x00\x00\x00"
"\x00\x2e\x49\x45\x43\x20\x36\x31\x39\x36\x36\x2d\x32\x2e\x31\x20"
"\x44\x65\x66\x61\x75\x6c\x74\x20\x52\x47\x42\x20\x63\x6f\x6c\x6f"
"\x75\x72\x20\x73\x70\x61\x63\x65\x20\x2d\x20\x73\x52\x47\x42\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2e\x49\x45\x43\x20\x36"
"\x31\x39\x36\x36\x2d\x32\x2e\x31\x20\x44\x65\x66\x61\x75\x6c\x74"
"\x20\x52\x47\x42\x20\x63\x6f\x6c\x6f\x75\x72\x20\x73\x70\x61\x63"
"\x65\x20\x2d\x20\x73\x52\x47\x42\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x64\x65"
"\x73\x63\x00\x00\x00\x00\x00\x00\x00\x2c\x52\x65\x66\x65\x72\x65"
"\x6e\x63\x65\x20\x56\x69\x65\x77\x69\x6e\x67\x20\x43\x6f\x6e\x64"
"\x69\x74\x69\x6f\x6e\x20\x69\x6e\x20\x49\x45\x43\x36\x31\x39\x36"
"\x36\x2d\x32\x2e\x31\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x2c\x52\x65\x66\x65\x72\x65\x6e\x63\x65\x20\x56\x69\x65\x77\x69"
"\x6e\x67\x20\x43\x6f\x6e\x64\x69\x74\x69\x6f\x6e\x20\x69\x6e\x20"
"\x49\x45\x43\x36\x31\x39\x36\x36\x2d\x32\x2e\x31\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x76\x69\x65\x77\x00\x00\x00\x00\x00\x13"
"\xa4\xfe\x00\x14\x5f\x2e\x00\x10\xcf\x14\x00\x03\xed\xcc\x00\x04"
"\x13\x0b\x00\x03\x5c\x9e\x00\x00\x00\x01\x58\x59\x5a\x20\x00\x00"
"\x00\x00\x00\x4c\x09\x56\x00\x50\x00\x00\x00\x57\x1f\xe7\x6d\x65"
"\x61\x73\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x8f\x00\x00"
"\x00\x02\x73\x69\x67\x20\x00\x00\x00\x00\x43\x52\x54\x20\x63\x75"
"\x72\x76\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x05\x00\x0a"
"\x00\x0f\x00\x14\x00\x19\x00\x1e\x00\x23\x00\x28\x00\x2d\x00\x32"
"\x00\x37\x00\x3b\x00\x40\x00\x45\x00\x4a\x00\x4f\x00\x54\x00\x59"
"\x00\x5e\x00\x63\x00\x68\x00\x6d\x00\x72\x00\x77\x00\x7c\x00\x81"
"\x00\x86\x00\x8b\x00\x90\x00\x95\x00\x9a\x00\x9f\x00\xa4\x00\xa9"
"\x00\xae\x00\xb2\x00\xb7\x00\xbc\x00\xc1\x00\xc6\x00\xcb\x00\xd0"
"\x00\xd5\x00\xdb\x00\xe0\x00\xe5\x00\xeb\x00\xf0\x00\xf6\x00\xfb"
"\x01\x01\x01\x07\x01\x0d\x01\x13\x01\x19\x01\x1f\x01\x25\x01\x2b"
"\x01\x32\x01\x38\x01\x3e\x01\x45\x01\x4c\x01\x52\x01\x59\x01\x60"
"\x01\x67\x01\x6e\x01\x75\x01\x7c\x01\x83\x01\x8b\x01\x92\x01\x9a"
"\x01\xa1\x01\xa9\x01\xb1\x01\xb9\x01\xc1\x01\xc9\x01\xd1\x01\xd9"
"\x01\xe1\x01\xe9\x01\xf2\x01\xfa\x02\x03\x02\x0c\x02\x14\x02\x1d"
"\x02\x26\x02\x2f\x02\x38\x02\x41\x02\x4b\x02\x54\x02\x5d\x02\x67"
"\x02\x71\x02\x7a\x02\x84\x02\x8e\x02\x98\x02\xa2\x02\xac\x02\xb6"
"\x02\xc1\x02\xcb\x02\xd5\x02\xe0\x02\xeb\x02\xf5\x03\x00\x03\x0b"
"\x03\x16\x03\x21\x03\x2d\x03\x38\x03\x43\x03\x4f\x03\x5a\x03\x66"
"\x03\x72\x03\x7e\x03\x8a\x03\x96\x03\xa2\x03\xae\x03\xba\x03\xc7"
"\x03\xd3\x03\xe0\x03\xec\x03\xf9\x04\x06\x04\x13\x04\x20\x04\x2d"
"\x04\x3b\x04\x48\x04\x55\x04\x63\x04\x71\x04\x7e\x04\x8c\x04\x9a"
"\x04\xa8\x04\xb6\x04\xc4\x04\xd3\x04\xe1\x04\xf0\x04\xfe\x05\x0d"
"\x05\x1c\x05\x2b\x05\x3a\x05\x49\x05\x58\x05\x67\x05\x77\x05\x86"
"\x05\x96\x05\xa6\x05\xb5\x05\xc5\x05\xd5\x05\xe5\x05\xf6\x06\x06"
"\x06\x16\x06\x27\x06\x37\x06\x48\x06\x59\x06\x6a\x06\x7b\x06\x8c"
"\x06\x9d\x06\xaf\x06\xc0\x06\xd1\x06\xe3\x06\xf5\x07\x07\x07\x19"
"\x07\x2b\x07\x3d\x07\x4f\x07\x61\x07\x74\x07\x86\x07\x99\x07\xac"
"\x07\xbf\x07\xd2\x07\xe5\x07\xf8\x08\x0b\x08\x1f\x08\x32\x08\x46"
"\x08\x5a\x08\x6e\x08\x82\x08\x96\x08\xaa\x08\xbe\x08\xd2\x08\xe7"
"\x08\xfb\x09\x10\x09\x25\x09\x3a\x09\x4f\x09\x64\x09\x79\x09\x8f"
"\x09\xa4\x09\xba\x09\xcf\x09\xe5\x09\xfb\x0a\x11\x0a\x27\x0a\x3d"
"\x0a\x54\x0a\x6a\x0a\x81\x0a\x98\x0a\xae\x0a\xc5\x0a\xdc\x0a\xf3"
"\x0b\x0b\x0b\x22\x0b\x39\x0b\x51\x0b\x69\x0b\x80\x0b\x98\x0b\xb0"
"\x0b\xc8\x0b\xe1\x0b\xf9\x0c\x12\x0c\x2a\x0c\x43\x0c\x5c\x0c\x75"
"\x0c\x8e\x0c\xa7\x0c\xc0\x0c\xd9\x0c\xf3\x0d\x0d\x0d\x26\x0d\x40"
"\x0d\x5a\x0d\x74\x0d\x8e\x0d\xa9\x0d\xc3\x0d\xde\x0d\xf8\x0e\x13"
"\x0e\x2e\x0e\x49\x0e\x64\x0e\x7f\x0e\x9b\x0e\xb6\x0e\xd2\x0e\xee"
"\x0f\x09\x0f\x25\x0f\x41\x0f\x5e\x0f\x7a\x0f\x96\x0f\xb3\x0f\xcf"
"\x0f\xec\x10\x09\x10\x26\x10\x43\x10\x61\x10\x7e\x10\x9b\x10\xb9"
"\x10\xd7\x10\xf5\x11\x13\x11\x31\x11\x4f\x11\x6d\x11\x8c\x11\xaa"
"\x11\xc9\x11\xe8\x12\x07\x12\x26\x12\x45\x12\x64\x12\x84\x12\xa3"
"\x12\xc3\x12\xe3\x13\x03\x13\x23\x13\x43\x13\x63\x13\x83\x13\xa4"
"\x13\xc5\x13\xe5\x14\x06\x14\x27\x14\x49\x14\x6a\x14\x8b\x14\xad"
"\x14\xce\x14\xf0\x15\x12\x15\x34\x15\x56\x15\x78\x15\x9b\x15\xbd"
"\x15\xe0\x16\x03\x16\x26\x16\x49\x16\x6c\x16\x8f\x16\xb2\x16\xd6"
"\x16\xfa\x17\x1d\x17\x41\x17\x65\x17\x89\x17\xae\x17\xd2\x17\xf7"
"\x18\x1b\x18\x40\x18\x65\x18\x8a\x18\xaf\x18\xd5\x18\xfa\x19\x20"
"\x19\x45\x19\x6b\x19\x91\x19\xb7\x19\xdd\x1a\x04\x1a\x2a\x1a\x51"
"\x1a\x77\x1a\x9e\x1a\xc5\x1a\xec\x1b\x14\x1b\x3b\x1b\x63\x1b\x8a"
"\x1b\xb2\x1b\xda\x1c\x02\x1c\x2a\x1c\x52\x1c\x7b\x1c\xa3\x1c\xcc"
"\x1c\xf5\x1d\x1e\x1d\x47\x1d\x70\x1d\x99\x1d\xc3\x1d\xec\x1e\x16"
"\x1e\x40\x1e\x6a\x1e\x94\x1e\xbe\x1e\xe9\x1f\x13\x1f\x3e\x1f\x69"
"\x1f\x94\x1f\xbf\x1f\xea\x20\x15\x20\x41\x20\x6c\x20\x98\x20\xc4"
"\x20\xf0\x21\x1c\x21\x48\x21\x75\x21\xa1\x21\xce\x21\xfb\x22\x27"
"\x22\x55\x22\x82\x22\xaf\x22\xdd\x23\x0a\x23\x38\x23\x66\x23\x94"
"\x23\xc2\x23\xf0\x24\x1f\x24\x4d\x24\x7c\x24\xab\x24\xda\x25\x09"
"\x25\x38\x25\x68\x25\x97\x25\xc7\x25\xf7\x26\x27\x26\x57\x26\x87"
"\x26\xb7\x26\xe8\x27\x18\x27\x49\x27\x7a\x27\xab\x27\xdc\x28\x0d"
"\x28\x3f\x28\x71\x28\xa2\x28\xd4\x29\x06\x29\x38\x29\x6b\x29\x9d"
"\x29\xd0\x2a\x02\x2a\x35\x2a\x68\x2a\x9b\x2a\xcf\x2b\x02\x2b\x36"
"\x2b\x69\x2b\x9d\x2b\xd1\x2c\x05\x2c\x39\x2c\x6e\x2c\xa2\x2c\xd7"
"\x2d\x0c\x2d\x41\x2d\x76\x2d\xab\x2d\xe1\x2e\x16\x2e\x4c\x2e\x82"
"\x2e\xb7\x2e\xee\x2f\x24\x2f\x5a\x2f\x91\x2f\xc7\x2f\xfe\x30\x35"
"\x30\x6c\x30\xa4\x30\xdb\x31\x12\x31\x4a\x31\x82\x31\xba\x31\xf2"
"\x32\x2a\x32\x63\x32\x9b\x32\xd4\x33\x0d\x33\x46\x33\x7f\x33\xb8"
"\x33\xf1\x34\x2b\x34\x65\x34\x9e\x34\xd8\x35\x13\x35\x4d\x35\x87"
"\x35\xc2\x35\xfd\x36\x37\x36\x72\x36\xae\x36\xe9\x37\x24\x37\x60"
"\x37\x9c\x37\xd7\x38\x14\x38\x50\x38\x8c\x38\xc8\x39\x05\x39\x42"
"\x39\x7f\x39\xbc\x39\xf9\x3a\x36\x3a\x74\x3a\xb2\x3a\xef\x3b\x2d"
"\x3b\x6b\x3b\xaa\x3b\xe8\x3c\x27\x3c\x65\x3c\xa4\x3c\xe3\x3d\x22"
"\x3d\x61\x3d\xa1\x3d\xe0\x3e\x20\x3e\x60\x3e\xa0\x3e\xe0\x3f\x21"
"\x3f\x61\x3f\xa2\x3f\xe2\x40\x23\x40\x64\x40\xa6\x40\xe7\x41\x29"
"\x41\x6a\x41\xac\x41\xee\x42\x30\x42\x72\x42\xb5\x42\xf7\x43\x3a"
"\x43\x7d\x43\xc0\x44\x03\x44\x47\x44\x8a\x44\xce\x45\x12\x45\x55"
"\x45\x9a\x45\xde\x46\x22\x46\x67\x46\xab\x46\xf0\x47\x35\x47\x7b"
"\x47\xc0\x48\x05\x48\x4b\x48\x91\x48\xd7\x49\x1d\x49\x63\x49\xa9"
"\x49\xf0\x4a\x37\x4a\x7d\x4a\xc4\x4b\x0c\x4b\x53\x4b\x9a\x4b\xe2"
"\x4c\x2a\x4c\x72\x4c\xba\x4d\x02\x4d\x4a\x4d\x93\x4d\xdc\x4e\x25"
"\x4e\x6e\x4e\xb7\x4f\x00\x4f\x49\x4f\x93\x4f\xdd\x50\x27\x50\x71"
"\x50\xbb\x51\x06\x51\x50\x51\x9b\x51\xe6\x52\x31\x52\x7c\x52\xc7"
"\x53\x13\x53\x5f\x53\xaa\x53\xf6\x54\x42\x54\x8f\x54\xdb\x55\x28"
"\x55\x75\x55\xc2\x56\x0f\x56\x5c\x56\xa9\x56\xf7\x57\x44\x57\x92"
"\x57\xe0\x58\x2f\x58\x7d\x58\xcb\x59\x1a\x59\x69\x59\xb8\x5a\x07"
"\x5a\x56\x5a\xa6\x5a\xf5\x5b\x45\x5b\x95\x5b\xe5\x5c\x35\x5c\x86"
"\x5c\xd6\x5d\x27\x5d\x78\x5d\xc9\x5e\x1a\x5e\x6c\x5e\xbd\x5f\x0f"
"\x5f\x61\x5f\xb3\x60\x05\x60\x57\x60\xaa\x60\xfc\x61\x4f\x61\xa2"
"\x61\xf5\x62\x49\x62\x9c\x62\xf0\x63\x43\x63\x97\x63\xeb\x64\x40"
"\x64\x94\x64\xe9\x65\x3d\x65\x92\x65\xe7\x66\x3d\x66\x92\x66\xe8"
"\x67\x3d\x67\x93\x67\xe9\x68\x3f\x68\x96\x68\xec\x69\x43\x69\x9a"
"\x69\xf1\x6a\x48\x6a\x9f\x6a\xf7\x6b\x4f\x6b\xa7\x6b\xff\x6c\x57"
"\x6c\xaf\x6d\x08\x6d\x60\x6d\xb9\x6e\x12\x6e\x6b\x6e\xc4\x6f\x1e"
"\x6f\x78\x6f\xd1\x70\x2b\x70\x86\x70\xe0\x71\x3a\x71\x95\x71\xf0"
"\x72\x4b\x72\xa6\x73\x01\x73\x5d\x73\xb8\x74\x14\x74\x70\x74\xcc"
"\x75\x28\x75\x85\x75\xe1\x76\x3e\x76\x9b\x76\xf8\x77\x56\x77\xb3"
"\x78\x11\x78\x6e\x78\xcc\x79\x2a\x79\x89\x79\xe7\x7a\x46\x7a\xa5"
"\x7b\x04\x7b\x63\x7b\xc2\x7c\x21\x7c\x81\x7c\xe1\x7d\x41\x7d\xa1"
"\x7e\x01\x7e\x62\x7e\xc2\x7f\x23\x7f\x84\x7f\xe5\x80\x47\x80\xa8"
"\x81\x0a\x81\x6b\x81\xcd\x82\x30\x82\x92\x82\xf4\x83\x57\x83\xba"
"\x84\x1d\x84\x80\x84\xe3\x85\x47\x85\xab\x86\x0e\x86\x72\x86\xd7"
"\x87\x3b\x87\x9f\x88\x04\x88\x69\x88\xce\x89\x33\x89\x99\x89\xfe"
"\x8a\x64\x8a\xca\x8b\x30\x8b\x96\x8b\xfc\x8c\x63\x8c\xca\x8d\x31"
"\x8d\x98\x8d\xff\x8e\x66\x8e\xce\x8f\x36\x8f\x9e\x90\x06\x90\x6e"
"\x90\xd6\x91\x3f\x91\xa8\x92\x11\x92\x7a\x92\xe3\x93\x4d\x93\xb6"
"\x94\x20\x94\x8a\x94\xf4\x95\x5f\x95\xc9\x96\x34\x96\x9f\x97\x0a"
"\x97\x75\x97\xe0\x98\x4c\x98\xb8\x99\x24\x99\x90\x99\xfc\x9a\x68"
"\x9a\xd5\x9b\x42\x9b\xaf\x9c\x1c\x9c\x89\x9c\xf7\x9d\x64\x9d\xd2"
"\x9e\x40\x9e\xae\x9f\x1d\x9f\x8b\x9f\xfa\xa0\x69\xa0\xd8\xa1\x47"
"\xa1\xb6\xa2\x26\xa2\x96\xa3\x06\xa3\x76\xa3\xe6\xa4\x56\xa4\xc7"
"\xa5\x38\xa5\xa9\xa6\x1a\xa6\x8b\xa6\xfd\xa7\x6e\xa7\xe0\xa8\x52"
"\xa8\xc4\xa9\x37\xa9\xa9\xaa\x1c\xaa\x8f\xab\x02\xab\x75\xab\xe9"
"\xac\x5c\xac\xd0\xad\x44\xad\xb8\xae\x2d\xae\xa1\xaf\x16\xaf\x8b"
"\xb0\x00\xb0\x75\xb0\xea\xb1\x60\xb1\xd6\xb2\x4b\xb2\xc2\xb3\x38"
"\xb3\xae\xb4\x25\xb4\x9c\xb5\x13\xb5\x8a\xb6\x01\xb6\x79\xb6\xf0"
"\xb7\x68\xb7\xe0\xb8\x59\xb8\xd1\xb9\x4a\xb9\xc2\xba\x3b\xba\xb5"
"\xbb\x2e\xbb\xa7\xbc\x21\xbc\x9b\xbd\x15\xbd\x8f\xbe\x0a\xbe\x84"
"\xbe\xff\xbf\x7a\xbf\xf5\xc0\x70\xc0\xec\xc1\x67\xc1\xe3\xc2\x5f"
"\xc2\xdb\xc3\x58\xc3\xd4\xc4\x51\xc4\xce\xc5\x4b\xc5\xc8\xc6\x46"
"\xc6\xc3\xc7\x41\xc7\xbf\xc8\x3d\xc8\xbc\xc9\x3a\xc9\xb9\xca\x38"
"\xca\xb7\xcb\x36\xcb\xb6\xcc\x35\xcc\xb5\xcd\x35\xcd\xb5\xce\x36"
"\xce\xb6\xcf\x37\xcf\xb8\xd0\x39\xd0\xba\xd1\x3c\xd1\xbe\xd2\x3f"
"\xd2\xc1\xd3\x44\xd3\xc6\xd4\x49\xd4\xcb\xd5\x4e\xd5\xd1\xd6\x55"
"\xd6\xd8\xd7\x5c\xd7\xe0\xd8\x64\xd8\xe8\xd9\x6c\xd9\xf1\xda\x76"
"\xda\xfb\xdb\x80\xdc\x05\xdc\x8a\xdd\x10\xdd\x96\xde\x1c\xde\xa2"
"\xdf\x29\xdf\xaf\xe0\x36\xe0\xbd\xe1\x44\xe1\xcc\xe2\x53\xe2\xdb"
"\xe3\x63\xe3\xeb\xe4\x73\xe4\xfc\xe5\x84\xe6\x0d\xe6\x96\xe7\x1f"
"\xe7\xa9\xe8\x32\xe8\xbc\xe9\x46\xe9\xd0\xea\x5b\xea\xe5\xeb\x70"
"\xeb\xfb\xec\x86\xed\x11\xed\x9c\xee\x28\xee\xb4\xef\x40\xef\xcc"
"\xf0\x58\xf0\xe5\xf1\x72\xf1\xff\xf2\x8c\xf3\x19\xf3\xa7\xf4\x34"
"\xf4\xc2\xf5\x50\xf5\xde\xf6\x6d\xf6\xfb\xf7\x8a\xf8\x19\xf8\xa8"
"\xf9\x38\xf9\xc7\xfa\x57\xfa\xe7\xfb\x77\xfc\x07\xfc\x98\xfd\x29"
"\xfd\xba\xfe\x4b\xfe\xdc\xff\x6d\xff\xff";
static const int kDiamondTiffImageLength = sizeof(kDiamondTiffImage);

////////////////////////////////////////////////////////////////////////////////

// At the moment, we only do menus for Mac so we implement directly without a
// 'derived' class idea. Indeed, a platform menu is nothing more than a wrapper
// around NSMenu.
struct MCPlatformMenu
{
	uint32_t references;
	NSMenu *menu;
	MCMenuDelegate *menu_delegate;
    
    // Hold the references to any submenus which are in this menu's items;
    // otherwise false-positives occur when looking for leaks.
    MCPlatformMenuRef *submenus;
    uindex_t submenu_count;
	
	// If the menu is being used as a menubar then this is true. When this
	// is the case, some items will be hidden and a (API-wise) invisible
	// menu will be inserted at the front (the application menu).
	bool is_menubar : 1;
    
    // If the quit item in this menu has an accelerator, this is true.
    // (Cocoa seems to 'hide' the quit menu item accelerator for some inexplicable
    // reason - it returns 'empty').
    NSMenuItem* quit_item;
    
    // SN-2014-11-06: [[ Bu 13940 ]] Add a flag for the presence of a Preferences shortcut
    //  to allow the menu item to be disabled.
    NSMenuItem* preferences_item;
    
    NSMenuItem* about_item;
};

////////////////////////////////////////////////////////////////////////////////

// The menuref currently set as the menubar.
static MCPlatformMenuRef s_menubar = nil;

// The delegate for the app menu.
static com_runrev_livecode_MCAppMenuDelegate *s_app_menu_delegate = nil;

////////////////////////////////////////////////////////////////////////////////

enum MCShadowedItemTags
{
    kMCShadowedItemAbout = 'abou',
    kMCShadowedItemPreferences = 'pref',
    kMCShadowedItemQuit = 'quit'
};

////////////////////////////////////////////////////////////////////////////////

@implementation com_runrev_livecode_MCMenuDelegate

- (id)initWithPlatformMenuRef: (MCPlatformMenuRef)p_menu_ref
{
	self = [super init];
	if (self == nil)
		return nil;
	
	m_menu = p_menu_ref;
	
	return self;
}

- (void)dealloc
{
	[super dealloc];
}

//////////

- (MCPlatformMenuRef)platformMenuRef
{
	return m_menu;
}

//////////

- (void)hideShadowedMenuItem:(NSInteger)tag menu:(NSMenu *)menu
{
	NSInteger t_index;
	t_index = [menu indexOfItemWithTag: tag];
	if (t_index == -1)
		return;
	
	NSMenuItem *t_item;
	t_item = [menu itemAtIndex: t_index];
	[t_item setHidden: YES];
	
	NSUInteger t_item_count;
	t_item_count = [menu numberOfItems];
	
	// If there is only this item in the menu, do no more.
	if (t_item_count == 1)
		return;
	
	// If we are the first item, then remove the separator after
	// us - if any.
	if (t_index == 0 &&
		[[menu itemAtIndex: 1] isSeparatorItem])
	{
		[[menu itemAtIndex: 1] setHidden: YES];
		return;
	}
	
	// If we are the last item, then remove the separator before
	// us - if any.
	if (t_index == t_item_count - 1 &&
		[[menu itemAtIndex: t_index - 1] isSeparatorItem])
	{
		[[menu itemAtIndex: t_index - 1] setHidden: YES];
		return;
	}
	
	// If we have a separated before and after, then remove the
	// separator before us.
	if ([[menu itemAtIndex: t_index - 1] isSeparatorItem] &&
		[[menu itemAtIndex: t_index + 1] isSeparatorItem])
		[[menu itemAtIndex: t_index - 1] setHidden: YES];
}

- (void)menuNeedsUpdate: (NSMenu *)menu
{
    // SN-2014-11-10: [[ Bug 13836 ]] Only allow the menu to refresh the whole menubar if
    //  it is the first click on the menubar (otherwise, clicking and sliding would refresh
    //  the menubar each the item hovered changes)...
    // SN-2014-11-06: [[ Bug 13849 ]] ...since rebuilding a menubar sends mouseDown to the menubar
    if ([menu supermenu] == nil || !s_open_menubar_items)
    {
        MCPlatformCallbackSendMenuUpdate(m_menu);
    }
    
    // MW-2014-10-29: [[ Bug 13848 ]] Only do the item hiding if this is part of a menubar
    //   (not a popup menu).
    if ([menu supermenu] != nil)
    {
        [self hideShadowedMenuItem: kMCShadowedItemAbout menu: menu];
        [self hideShadowedMenuItem: kMCShadowedItemPreferences menu: menu];
        [self hideShadowedMenuItem: kMCShadowedItemQuit menu: menu];
    }
}

- (void)menuItemSelected: (id)sender
{
    if (MCMacPlatformApplicationPseudoModalFor() != nil)
        return;
    
    NSMenuItem *t_item;
    t_item = (NSMenuItem *)sender;
    
    // MW-2014-10-22: [[ Bug 13510 ]] As Cocoa hides Cmd-Q for some reason as a key equivalent
    //   we mark the menu as having an accelerator for quit if one was specified. If no accelerator
    //   was specified, we handle Cmd-Q as if it weren't an accelerator but was a select.
    //   (This is for the case where the 'Exit' menu item has no accelerator, but Cocoa requires
    //    said accelerator for conformance).
    bool t_quit_accelerator_present;
    t_quit_accelerator_present = false;
    if ([[t_item keyEquivalent] isEqualToString: @"q"])
        t_quit_accelerator_present = [(com_runrev_livecode_MCMenuDelegate *)[[t_item menu] delegate] platformMenuRef] -> quit_item != nil;
    
	if (s_menu_select_lock == 0 || t_quit_accelerator_present)
    {
		MCPlatformCallbackSendMenuSelect(m_menu, [[t_item menu] indexOfItem: t_item]);
        s_menu_item_selected = true;
    }
    
    // SN-2014-11-06: [[ Bug 13836 ]] s_menu_select_occurred was not used.
}

- (BOOL)validateMenuItem: (NSMenuItem *)item
{
	return [item isEnabled];
}

// MW-2014-04-30: [[ Bug 12329 ]] We want our menu items to still be activatible in modal dialogs.
- (BOOL)worksWhenModal
{
    return YES;
}

//////////

- (BOOL)menuHasKeyEquivalent:(NSMenu *)menu forEvent:(NSEvent *)event target:(id *)target action:(SEL *)action
{
    // SN-2014-11-06: [[ Bug 13836 ]] We don't update the menubar everytime an accelerator is used
	return NO;
}

//////////

// SN-2014-11-10: [[ Bug 13836 ]] We want to know how many items are open in the menubar,
//  When sliding after having clicked in the menubar, the new item receives menuWillOpen
//  before the other one receives menuWillClose.
- (void)menuWillOpen:(NSMenu *)menu
{
    if ([s_menubar -> menu isEqualTo: [menu supermenu]])
        s_open_menubar_items++;
}

- (void)menuDidClose:(NSMenu *)menu
{
    if ([s_menubar -> menu isEqualTo: [menu supermenu]])
        s_open_menubar_items--;
}

@end

@implementation com_runrev_livecode_MCAppMenuDelegate

- (id)init
{
	self = [super init];
	if (self == nil)
		return nil;
	
	return self;
}

- (void)dealloc
{
	[super dealloc];
}

- (void)shadowedMenuItemSelected:(NSString*)tag
{
	NSMenuItem *t_shadow;
	t_shadow = [self findShadowedMenuItem: tag];
	if (t_shadow != nil)
    {
        // MW-2014-10-29: [[ Bug 13847 ]] Dispatch default accelerators from app menu.
        uint32_t t_old_menu_select_lock;
        t_old_menu_select_lock = s_menu_select_lock;
        s_menu_select_lock = 0;
		[(MCMenuDelegate *)[[t_shadow menu] delegate] menuItemSelected: t_shadow];
        s_menu_select_lock = t_old_menu_select_lock;
    }
}

- (NSMenuItem *)findShadowedMenuItem: (NSString *)tag
{
	NSMenu *t_menubar;
	t_menubar = s_menubar -> menu;
	for(uindex_t i = 1; i < [t_menubar numberOfItems]; i++)
	{
		NSMenu *t_menu;
		t_menu = [[t_menubar itemAtIndex: i] submenu];
		
		NSInteger t_index;
		t_index = [t_menu indexOfItemWithRepresentedObject: tag];
		if (t_index != -1)
			return [t_menu itemAtIndex: t_index];
	}
	
	return nil;
}

- (void)aboutMenuItemSelected: (id)sender
{
	[self shadowedMenuItemSelected: @"About"];
}

- (void)preferencesMenuItemSelected: (id)sender
{
	[self shadowedMenuItemSelected: @"Preferences"];
}

- (void)quitMenuItemSelected: (id)sender
{
    // SN-2014-12-16: [[ Bug 14185 ]] Only flag the the quitting state (that's the only state
    //  which causes issues.
    s_quit_selected = true;
	[self shadowedMenuItemSelected: @"Quit"];
}

// SN-2014-11-06: [[ Bug 13940 ]] The user asked to quit - and no accelerator was added for this,
//  so we quit!
- (void)quitApplicationSelected: (id)sender
{
    if (MCMacPlatformApplicationPseudoModalFor() != nil)
        return;
    
    // IM-2015-11-13: [[ Bug 16288 ]] Send shutdown request rather than terminating immediately
	//    to allow shutdown in orderly fashion.
	bool t_shutdown;
	MCPlatformCallbackSendApplicationShutdownRequest(t_shutdown);
}

// SN-2014-11-10: [[ Bug 13836 ]] The menubar should be updated if left item is clicked
- (void)menuNeedsUpdate: (NSMenu *)menu
{
    if (!s_open_menubar_items)
        MCPlatformCallbackSendMenuUpdate(s_menubar);
}

- (BOOL)validateMenuItem: (NSMenuItem *)item
{
	return [item isEnabled];
}

//////////

// Putting this method here means we don't get an excessive amount of
// menuUpdate messages after each key-press...
- (BOOL)menuHasKeyEquivalent:(NSMenu *)menu forEvent:(NSEvent *)event target:(id *)target action:(SEL *)action
{
    // SN-2014-11-06: [[ Bug 13836 ]] menuHasKeyEquivalent is called for each submenu/item of the menubar.
    //  We don't want to rebuild all of this each time an accelerator is used.
//    [self menuNeedsUpdate: menu];
    return NO;
}

//////////

- (void)menuWillOpen:(NSMenu *)menu
{
    s_open_menubar_items++;
}

- (void)menuDidClose:(NSMenu *)menu
{
    s_open_menubar_items--;
}

@end

////////////////////////////////////////////////////////////////////////////////

// We subclass NSMenu so that for any LiveCode menus, keyEquivalents don't
// result in 'menuSelect' messages, but instead propagate a keyDown/keyUp
// message which the engine handles.

@interface com_runrev_livecode_MCMenuHandlingKeys: NSMenu

- (BOOL)performKeyEquivalent: (NSEvent *)event;

@end

@compatibility_alias MCMenuHandlingKeys com_runrev_livecode_MCMenuHandlingKeys;

// SN-2014-12-16: [[ Bug 14185 ]] Functions to save and restore the selected quit state
uint32_t s_quitting_state_count = 0;
uint8_t *s_quitting_states;

void MCMacPlatformSaveQuittingState()
{
    MCMemoryReallocate(s_quitting_states, s_quitting_state_count + 1, s_quitting_states);
    s_quitting_states[s_quitting_state_count] = s_quit_selected;
    
    ++s_quitting_state_count;
    s_quit_selected = false;
}

void MCMacPlatformPopQuittingState()
{
    s_quit_selected = s_quitting_states[s_quitting_state_count - 1];
    
    --s_quitting_state_count;
    MCMemoryReallocate(s_quitting_states, s_quitting_state_count, s_quitting_states);
}

// SN-2014-11-06: [[ Bug 13836 ]] Returns whether the last item clicked was a shadowed item.
// SN-2014-12-16: [[ Bug 14185 ]] Name changed as it only returns whether a 'Quit' item
// has been selected.
bool MCMacPlatformIsInQuittingState(void)
{
	bool t_occurred;
	t_occurred = s_quit_selected;
	s_quit_selected = false;
	return t_occurred;
}

void MCMacPlatformLockMenuSelect(void)
{
	s_menu_select_lock += 1;
}

void MCMacPlatformUnlockMenuSelect(void)
{
	s_menu_select_lock -= 1;
}

@implementation com_runrev_livecode_MCMenuHandlingKeys

- (BOOL)performKeyEquivalent: (NSEvent *)event
{
	// If the event is not targetted at one of our windows, we just let things
	// flow as normal.
	if (![[[event window] delegate] isKindOfClass: [MCWindowDelegate class]])
        return [super performKeyEquivalent: event];
    
    // SN-2014-12-16; [[ Bug 14185 ]] We want to store the previous state, as when using answer
    //  for example, we still want the key event to be processed.
    MCMacPlatformSaveQuittingState();
    
	// Otherwise, we lock menuSelect firing, and propagate a keydown/keyup.
	BOOL t_key_equiv;
	MCMacPlatformLockMenuSelect();
	t_key_equiv = [super performKeyEquivalent: event];
	MCMacPlatformUnlockMenuSelect();

    BOOL t_force_keypress;
    t_force_keypress = NO;

    // AL-2014-09-16: [[ Bug 13372 ]]  Make sure tab + modifier and esc + modifier key combinations
    //  that are reserved by Cocoa trigger keypress events for the engine to handle.
    if (!t_key_equiv)
    {
        MCPlatformKeyCode t_keycode;
        MCMacPlatformMapKeyCode([event keyCode], [event modifierFlags], t_keycode);
        t_force_keypress = t_keycode == kMCPlatformKeyCodeTab || t_keycode == kMCPlatformKeyCodeEscape;
    }
    
    // SN-2014-11-06: [[ Bug 13510 ]] Ensure that we don't get further, if a shadow item was selected
    //  and that Cocoa will stop looking for key equivalent amongst the application's menus
    //  Calling MCMacPlatformWasShadowItemSelected here ensure that the state is reset for each event.
    // SN-2014-12-16; [[ Bug 14185 ]] Name changed as we only check whether a 'Quit' item was selected.
    if (MCMacPlatformIsInQuittingState())
    {
        MCMacPlatformPopQuittingState();
        return YES;
    }
    
    // SN-2014-12-16: [[ Bug 14185 ]] Pop the last state saved.
    MCMacPlatformPopQuittingState();
    
    // MW-2014-04-10: [[ Bug 12047 ]] If it was found as a key equivalent dispatch
    //   a keypress so the engine can handle it. Otherwise we return NO and the
    //   event is handled normally.
    if (t_key_equiv || t_force_keypress)
    {
        MCMacPlatformWindow *t_window = [(MCWindowDelegate *)[[event window] delegate] platformWindow];
        
        // MW-2014-04-24: [[ Bug 12284 ]] If we get here then it could have come from
        //   an 'external' view and thus the event will not have gone through any
        //   of our view code - so make sure modifiers are up to date (otherwise command
        //   key shortcuts don't work!).
        MCMacPlatformHandleModifiersChanged(MCMacPlatformMapNSModifiersToModifiers([event modifierFlags]));
        
        // SN-2014-11-06: [[ Bug 13836 ]] We don't want to recreate every menu existing for each keyEvent
        // MW-2014-10-29: [[ Bug 13847 ]] Make sure we only update menus once per accelerator.
//        if (s_update_menubar_menus)
//        {
//            s_update_menubar_menus = false;
//            for(int i = 1; i < [s_menubar -> menu numberOfItems]; i++)
//            {
//                NSMenu *t_submenu;
//                t_submenu = [[s_menubar -> menu itemAtIndex: i] submenu];
//                if (t_submenu != nil)
//                    MCPlatformCallbackSendMenuUpdate([(MCMenuDelegate *)[t_submenu delegate] platformMenuRef]);
//            }
//        }
        
        [t_window -> GetView() handleKeyPress: event isDown: YES];
        [t_window -> GetView() handleKeyPress: event isDown: NO];
        return YES;
    }
    
	return NO;
}

@end

////////////////////////////////////////////////////////////////////////////////

static void MCPlatformAddSubmenuToMenu(MCPlatformMenuRef p_menu, MCPlatformMenuRef p_submenu)
{
    uindex_t t_first_free = p_menu->submenu_count;
    for(uindex_t i = 0; i < p_menu->submenu_count; i++)
    {
        if (p_menu->submenus[i] == nullptr &&
            i < t_first_free)
        {
            t_first_free = i;
        }
        
        if (p_menu->submenus[i] == p_submenu)
        {
            return;
        }
    }
    
    if (t_first_free == p_menu->submenu_count)
    {
        /* UNCHECKED */ MCMemoryResizeArray(p_menu->submenu_count + 1,
                                            p_menu->submenus,
                                            p_menu->submenu_count);
    }
    
    p_menu->submenus[t_first_free] = p_submenu;
}

static void MCPlatformRemoveSubmenuFromMenu(MCPlatformMenuRef p_menu, MCPlatformMenuRef p_submenu)
{
    for(uindex_t i = 0; i < p_menu->submenu_count; i++)
    {
        if (p_menu->submenus[i] == p_submenu)
        {
            p_menu->submenus[i] = nullptr;
            return;
        }
    }
}

// Helper method that frees anything associated with an NSMenuItem in an NSMenu
// (at the moment, this is the submenu).
static void MCPlatformDestroyMenuItem(MCPlatformMenuRef p_menu, uindex_t p_index)
{
	NSMenuItem *t_item;
	t_item = [p_menu -> menu itemAtIndex: p_index];
	
	NSMenu *t_submenu;
	t_submenu = [t_item submenu];
	if (t_submenu == nil)
		return;
	
	MCPlatformMenuRef t_submenu_ref;
	t_submenu_ref = [(MCMenuDelegate *)[t_submenu delegate] platformMenuRef];
	
	// Update the submenu pointer (so we don't have any dangling
	// refs).
    [t_item setSubmenu: nil];
    
    MCPlatformRemoveSubmenuFromMenu(p_menu, t_submenu_ref);
	
	// Now release the platform menu.
	MCPlatformReleaseMenu(t_submenu_ref);
}

// Map the incoming index to the internal menu item index (taking into account
// whether the menu is the menubar).
static void MCPlatformMapMenuItemIndex(MCPlatformMenuRef p_menu, uindex_t& x_index)
{
	// If the menu is the menubar, adjust for the application menu (always first).
	if (p_menu -> is_menubar)
		x_index += 1;
}

// Clamp the incoming index to an internal menu item insertion index (taking into
// account whether the menu is the menubar).
static void MCPlatformClampMenuItemIndex(MCPlatformMenuRef p_menu, uindex_t& x_index)
{
	if (x_index < UINDEX_MAX && p_menu -> is_menubar)
		x_index += 1;
	x_index = MCMin((unsigned)[p_menu -> menu numberOfItems], x_index);
}

void MCPlatformCreateMenu(MCPlatformMenuRef& r_menu)
{
	MCPlatformMenuRef t_menu;
	/* UNCHECKED */ MCMemoryNew(t_menu);
	
	t_menu -> references = 1;
	
	t_menu -> menu = [[MCMenuHandlingKeys alloc] initWithTitle: @""];
	t_menu -> menu_delegate = [[MCMenuDelegate alloc] initWithPlatformMenuRef: t_menu];
	[t_menu -> menu setDelegate: t_menu -> menu_delegate];
    t_menu -> is_menubar = false;
	
	// Turn on auto-enablement - this allows dialogs to control the enablement
	// of items with appropriate tag.
	[t_menu -> menu setAutoenablesItems: YES];
    
    // SN-2014-11-06: [[ Bug 13940 ]] Initialises the accelerator presence flag.
    t_menu -> quit_item = nil;
    t_menu -> preferences_item = nil;
    t_menu -> about_item = nil;
    
    t_menu->submenus = nil;
    t_menu->submenu_count = 0;
	
	r_menu = t_menu;
}

void MCPlatformRetainMenu(MCPlatformMenuRef p_menu)
{
	p_menu -> references += 1;
}

void MCPlatformReleaseMenu(MCPlatformMenuRef p_menu)
{
	p_menu -> references -= 1;
	if (p_menu -> references != 0)
		return;
	
	// Release any submenus.
	for(uindex_t i = 0; i < [p_menu -> menu numberOfItems]; i++)
		MCPlatformDestroyMenuItem(p_menu, i);
	
	[p_menu -> menu release];
	[p_menu -> menu_delegate release];
    [p_menu -> about_item release];
    [p_menu -> preferences_item release];
    [p_menu -> quit_item release];
    MCMemoryDeleteArray(p_menu->submenus);
	MCMemoryDelete(p_menu);
}

void MCPlatformSetMenuTitle(MCPlatformMenuRef p_menu, MCStringRef p_title)
{
    MCAutoStringRefAsCFString t_cf_string;
    /* UNCHECKED */ t_cf_string . Lock(p_title);
    [p_menu -> menu setTitle: (NSString*)*t_cf_string];
}

void MCPlatformCountMenuItems(MCPlatformMenuRef p_menu, uindex_t& r_count)
{
	r_count = [p_menu -> menu numberOfItems];
	
	// If the menu is the menubar, then we've inserted the application menu.
	if (p_menu -> is_menubar)
		r_count -= 1;
}

void MCPlatformAddMenuItem(MCPlatformMenuRef p_menu, uindex_t p_where)
{
	MCPlatformClampMenuItemIndex(p_menu, p_where);
	
	NSMenuItem *t_item;
	t_item = [[NSMenuItem alloc] initWithTitle: @"" action: @selector(menuItemSelected:) keyEquivalent: @""];
	
	// Make sure we set the target of the action (to the delegate).
	[t_item setTarget: p_menu -> menu_delegate];
	
	// Insert the item in the menu.
	[p_menu -> menu insertItem: t_item atIndex: p_where];
	
	[t_item release];
}

void MCPlatformAddMenuSeparatorItem(MCPlatformMenuRef p_menu, uindex_t p_where)
{
	MCPlatformClampMenuItemIndex(p_menu, p_where);
	
    [p_menu -> menu insertItem: [NSMenuItem separatorItem] atIndex: p_where];
}
 
void MCPlatformRemoveMenuItem(MCPlatformMenuRef p_menu, uindex_t p_where)
{
	MCPlatformMapMenuItemIndex(p_menu, p_where);
	
	MCPlatformDestroyMenuItem(p_menu, p_where);
	[p_menu -> menu removeItemAtIndex: p_where];
}

void MCPlatformRemoveAllMenuItems(MCPlatformMenuRef p_menu)
{
	for(uindex_t i = 0; i < [p_menu -> menu numberOfItems]; i++)
		MCPlatformDestroyMenuItem(p_menu, i);
	[p_menu -> menu removeAllItems];
}

void MCPlatformGetMenuParent(MCPlatformMenuRef p_menu, MCPlatformMenuRef& r_parent, uindex_t& r_index)
{
	NSMenu *t_parent;
	t_parent = [p_menu -> menu supermenu];
	if (t_parent == nil)
	{
		r_parent = nil;
		r_index = 0;
		return;
	}
	
	r_index = [t_parent indexOfItemWithSubmenu: p_menu -> menu];
	r_parent = [(MCMenuDelegate *)[t_parent delegate] platformMenuRef];
	if (r_parent -> is_menubar)
		r_index -= 1;
}

void MCPlatformGetMenuItemProperty(MCPlatformMenuRef p_menu, uindex_t p_index, MCPlatformMenuItemProperty p_property, MCPlatformPropertyType p_type, void *r_value)
{
	MCPlatformMapMenuItemIndex(p_menu, p_index);
	
	NSMenuItem *t_item;
	t_item = [p_menu -> menu itemAtIndex: p_index];
    
	switch(p_property)
	{
		case kMCPlatformMenuItemPropertyTitle:
			/* UNCHECKED */ MCStringCreateWithCFStringRef((CFStringRef)[t_item title], *(MCStringRef*)r_value);
			break;
		case kMCPlatformMenuItemPropertyTag:
			/* UNCHECKED */ MCStringCreateWithCFStringRef((CFStringRef)[t_item representedObject], *(MCStringRef*)r_value);
			break;
        case kMCPlatformMenuItemPropertySubmenu:
        {
            NSMenu *t_current_submenu = [t_item submenu];
            
            MCPlatformMenuRef t_current_submenu_ref = nil;
            if (t_current_submenu != nil)
            {
                t_current_submenu_ref = [(MCMenuDelegate *)[t_current_submenu delegate] platformMenuRef];
            }
            *(MCPlatformMenuRef *)r_value = t_current_submenu_ref;
        }
        break;
            
		default:
			assert(false);
			break;
	}
}

void MCPlatformSetMenuItemProperty(MCPlatformMenuRef p_menu, uindex_t p_index, MCPlatformMenuItemProperty p_property, MCPlatformPropertyType p_type, const void *p_value)
{
	MCPlatformMapMenuItemIndex(p_menu, p_index);
	
	NSMenuItem *t_item;
    t_item = [p_menu -> menu itemAtIndex: p_index];
    
    MCAutoStringRefAsCFString t_cf_string;
	
	switch(p_property)
	{
		case kMCPlatformMenuItemPropertyTitle:
            /* UNCHECKED */ t_cf_string . Lock(*(MCStringRef*)p_value);
			[t_item setTitle: (NSString*)*t_cf_string];
			break;	
		case kMCPlatformMenuItemPropertyTag:
            /* UNCHECKED */ t_cf_string . Lock(*(MCStringRef*)p_value);
			[t_item setRepresentedObject: (NSString*)*t_cf_string];
			break;
		case kMCPlatformMenuItemPropertyAction:
		{
			MCPlatformMenuItemAction t_action;
			t_action = *(MCPlatformMenuItemAction *)p_value;
			
			if (t_action == kMCPlatformMenuItemActionNone)
			{
				[t_item setAction: @selector(menuItemSelected:)];
				[t_item setTarget: p_menu -> menu_delegate];
			}
			else
            {
                // SN-2014-11-06: [[ Bug 13940 ]] Update the parent - if any - to know that his submenu has
                //  a Quit or a Preferences accelerator
                NSMenu *t_supermenu;
                t_supermenu = [p_menu -> menu supermenu];
                
                if (t_supermenu != nil)
                {
                    MCPlatformMenuRef t_supermenu_ref;
                    t_supermenu_ref = [(MCMenuDelegate *)[t_supermenu delegate] platformMenuRef];
                    if (t_action == kMCPlatformMenuItemActionQuit)
                    {
                        [t_item setTag:kMCShadowedItemQuit];
                        
                        if (t_supermenu_ref->quit_item != nil)
                        {
                            [t_supermenu_ref->quit_item release];
                        }
                        t_supermenu_ref -> quit_item = [t_item retain];
                    }
                    else if (t_action == kMCPlatformMenuItemActionPreferences)
                    {
                        [t_item setTag:kMCShadowedItemPreferences];
                        
                        if (t_supermenu_ref->preferences_item != nil)
                        {
                            [t_supermenu_ref->preferences_item release];
                        }
                        t_supermenu_ref -> preferences_item = [t_item retain];
                    }
                    else if (t_action == kMCPlatformMenuItemActionAbout)
                    {
                        [t_item setTag: kMCShadowedItemAbout];
                        
                        if (t_supermenu_ref->about_item != nil)
                        {
                            [t_supermenu_ref->about_item release];
                        }
                        t_supermenu_ref -> about_item = [t_item retain];
                    }
                }
                
				SEL t_selector;
				if (MCMacPlatformMapMenuItemActionToSelector(t_action, t_selector))
				{
					[t_item setAction: t_selector];
					[t_item setTarget: nil];
				}
			}
		}
		break;
		case kMCPlatformMenuItemPropertyAccelerator:
		{
			MCPlatformAccelerator t_accelerator;
			t_accelerator = *(MCPlatformAccelerator *)p_value;
			if (t_accelerator != 0)
            {
				NSUInteger t_modifiers;
				t_modifiers = 0;
				if ((t_accelerator & kMCPlatformAcceleratorWithShift) != 0)
					t_modifiers |= NSShiftKeyMask;
				if ((t_accelerator & kMCPlatformAcceleratorWithAlt) != 0)
					t_modifiers |= NSAlternateKeyMask;
				
				// COCOA-TODO: Abstract Command/Control switching.
				if ((t_accelerator & kMCPlatformAcceleratorWithCommand) != 0)
					t_modifiers |= NSControlKeyMask;
				if ((t_accelerator & kMCPlatformAcceleratorWithControl) != 0)
					t_modifiers |= NSCommandKeyMask;
				
				NSString *t_char;
				if (MCMacMapCodepointToNSString(t_accelerator & kMCPlatformAcceleratorKeyMask, t_char))
				{
					[t_item setKeyEquivalent: t_char];
					[t_item setKeyEquivalentModifierMask: t_modifiers];
					[t_char release];
				}
			}
			else
			{
				[t_item setKeyEquivalent: @""];
				[t_item setKeyEquivalentModifierMask: 0];
			}
		}
		break;
		case kMCPlatformMenuItemPropertyEnabled:
			[t_item setEnabled: *(bool *)p_value];
			break;
		case kMCPlatformMenuItemPropertySubmenu:
		{
			// Make sure we decrement the associated platformmenuref's count, and
			// increment the new one's (but the other way around, in case they are
			// the same).
			MCPlatformMenuRef t_submenu_ref;
			t_submenu_ref = *(MCPlatformMenuRef *)p_value;
			
			MCPlatformRetainMenu(t_submenu_ref);
			
			NSMenu *t_current_submenu;
			t_current_submenu = [t_item submenu];
			if (t_current_submenu != nil)
			{
				MCPlatformMenuRef t_current_submenu_ref;
				t_current_submenu_ref = [(MCMenuDelegate *)[t_current_submenu delegate] platformMenuRef];
                
                MCPlatformRemoveSubmenuFromMenu(p_menu, t_current_submenu_ref);
				MCPlatformReleaseMenu(t_current_submenu_ref);
			}
			
            // PM-2015-02-09: [[ Bug 14521 ]] No action since menu item has submenus
            // SN-2015-01-12: [[ Bug 14346 ]] Menu items with a submenu should not be selectable
            [t_item setAction: nil];
            [t_item setTarget: nil];
            
			[t_item setSubmenu: (*(MCPlatformMenuRef *)p_value) -> menu];
            MCPlatformAddSubmenuToMenu(p_menu, t_submenu_ref);
		}
		break;
		case kMCPlatformMenuItemPropertyHighlight:
		{
			MCPlatformMenuItemHighlight t_highlight;
			t_highlight = *(MCPlatformMenuItemHighlight *)p_value;
			switch(t_highlight)
			{
			case kMCPlatformMenuItemHighlightNone:
				[t_item setState: NSOffState];
				break;
			case kMCPlatformMenuItemHighlightTick:
				[t_item setState: NSOnState];
				break;
			case kMCPlatformMenuItemHighlightDiamond:
                [t_item setOnStateImage: s_diamond_image];
				[t_item setState: NSOnState];
				break;
			case kMCPlatformMenuItemHighlightBar:
				[t_item setState: NSMixedState];
				break;
			}
		}
		break;
			
		case kMCPlatformMenuItemPropertyUnknown:
			MCUnreachable();
	}
}

//////////

bool MCPlatformPopUpMenu(MCPlatformMenuRef p_menu, MCPlatformWindowRef p_window, MCPoint p_location, uindex_t p_item)
{
	NSMenu *t_menu;
	t_menu = p_menu -> menu;
	
	NSView *t_view;
	if (p_window != nil)
		t_view = ((MCMacPlatformWindow *)p_window) -> GetView();
	else
		t_view = nil;
	
	NSPoint t_location;
	if (t_view != nil)
	{
		MCPlatformMapPointFromScreenToWindow(p_window, p_location, p_location);
		((MCMacPlatformWindow *)p_window) -> MapMCPointToNSPoint(p_location, t_location);
	}
	else
		MCMacPlatformMapScreenMCPointToNSPoint(p_location, t_location);
    
    // MW-2014-07-29: [[ Bug 12990 ]] If item is UINDEX_MAX then don't specify an item, thus preventing
    //   one from being highlighted.
    
    // SN-2015-11-02: [[ Bug 16218 ]] popUpMenuPositioningItem always returns
    // true if the menu is open by keeping the mouse down, even if the mouse is
    // released outside of the menu list.
    // We will set s_menu_item_selected in menuItemSelected if selection occurs.
    s_menu_item_selected = false;
	[t_menu popUpMenuPositioningItem: p_item == UINDEX_MAX ? nil : [t_menu itemAtIndex: p_item] atLocation: t_location inView: t_view];
	
	MCMacPlatformSyncMouseAfterTracking();
	
	return s_menu_item_selected;
}

//////////

static void MCPlatformStartUsingMenuAsMenubar(MCPlatformMenuRef p_menu)
{
	if (p_menu -> is_menubar)
		return;
	
	if (s_app_menu_delegate == nil)
		s_app_menu_delegate = [[com_runrev_livecode_MCAppMenuDelegate alloc] init];
	
	// Initialize the application menu (which is always index 0). The application
	// menu has structure:
	//
	//     About <app name>
	//     ----
	//     Preferences... / Apple-,
	//     ----
	//     Services
	//     ----
	//     Hide <app name> / Apple-H
	//     Hide Others     / Opt-Apple-H
	//     Show All
	//     ----
	//     Quit <app name> / Apple-Q
	//
	NSString *t_app_name;
	t_app_name = (NSString *)[[[NSBundle mainBundle] infoDictionary] objectForKey: (NSString *)kCFBundleNameKey];
    
    // SN-2014-10-14: [[ Bug 13662 ]] We use the process name if the app is not in a bundle
    if (t_app_name == nil)
        t_app_name = [[NSProcessInfo processInfo] processName];
	
    
    // SN-2014-12-09: [[ Bug 14168 ]] Update to use actually localised strings as menu items
    // for the Application menu.
    // The menu items Preferences, About and Quit are again auto-translated.
    
	NSMenu *t_services_menu;
	t_services_menu = [[NSMenu alloc] initWithTitle: NSLocalizedStringFromTable(@"appMenu.services", @"Localisation", @"Services")];
	[NSApp setServicesMenu: t_services_menu];
						   
	NSMenu *t_app_menu;
	t_app_menu = [[NSMenu alloc] initWithTitle: t_app_name];
	
    NSString *t_about_string;
    t_about_string = [NSString stringWithFormat: NSLocalizedStringFromTable(@"appMenu.about", @"Localisation", @"Format string such as About %@"), t_app_name];
    
	[t_app_menu addItemWithTitle: t_about_string
						  action: @selector(aboutMenuItemSelected:)
				   keyEquivalent: @""];
    if (p_menu -> about_item == nil)
        [[t_app_menu itemAtIndex: 0] setEnabled:NO];
    [[t_app_menu itemAtIndex: 0] setTarget: s_app_menu_delegate];
    [[t_app_menu itemAtIndex: 0] setTag: kMCShadowedItemAbout];
        
    [t_app_menu addItem: [NSMenuItem separatorItem]];
    
    NSString *t_preferences_string;
    t_preferences_string = NSLocalizedStringFromTable(@"appMenu.preferences", @"Localisation", @"Preferences");
    
	[t_app_menu addItemWithTitle: t_preferences_string
						  action: @selector(preferencesMenuItemSelected:)
				   keyEquivalent: @","];
    // SN-2014-11-06: [[ Bug 13940 ]] Only enable the Preference menu if the shortcut exists in the menubar
    [[t_app_menu itemAtIndex: 2] setTarget: s_app_menu_delegate];
    if (p_menu -> preferences_item == nil)
        [[t_app_menu itemAtIndex: 2] setEnabled: NO];
    
    [[t_app_menu itemAtIndex: 2] setTag: kMCShadowedItemPreferences];
    
    [t_app_menu addItem: [NSMenuItem separatorItem]];
    [t_app_menu addItemWithTitle: NSLocalizedStringFromTable(@"appMenu.services", @"Localisation", @"Services")
						  action: nil
				   keyEquivalent: @""];
	[[t_app_menu itemAtIndex: 4] setSubmenu: t_services_menu];
	[t_services_menu release];
    [t_app_menu addItem: [NSMenuItem separatorItem]];
	[t_app_menu addItemWithTitle: [NSString stringWithFormat: NSLocalizedStringFromTable(@"appMenu.hide", @"Localisation", @"Format string such as Hide %@"), t_app_name]
						  action: @selector(hide:)
                   keyEquivalent: @"h"];
    [t_app_menu addItemWithTitle: NSLocalizedStringFromTable(@"appMenu.hideOthers", @"Localisation", @"Hide Others")
						  action: @selector(hideOtherApplications:)
				   keyEquivalent: @"h"];
	[[t_app_menu itemAtIndex: 7] setKeyEquivalentModifierMask: (NSAlternateKeyMask | NSCommandKeyMask)];
	[t_app_menu addItemWithTitle: NSLocalizedStringFromTable(@"appMenu.showAll", @"Localisation", @"Show All")
						  action: @selector(unhideAllApplications:)
				   keyEquivalent: @""];
	[t_app_menu addItem: [NSMenuItem separatorItem]];
    
    NSString *t_quit_string;
    t_quit_string = [NSString stringWithFormat: NSLocalizedStringFromTable(@"appMenu.quit", @"Localisation", @"Format string such as Quit %@"), t_app_name];
    
	[t_app_menu addItemWithTitle: t_quit_string
						  action: @selector(quitMenuItemSelected:)
				   keyEquivalent:@"q"];
    // SN-2014-11-06: [[ Bug 13940 ]] In case there is no Quit shortcut in this menubar,
    //  the action will simply be to close the application.
    if (p_menu -> quit_item != nil)
        [[t_app_menu itemAtIndex: 10] setAction:@selector(quitMenuItemSelected:)];
    else
        [[t_app_menu itemAtIndex: 10] setAction:@selector(quitApplicationSelected:)];
    
    [[t_app_menu itemAtIndex: 10] setTarget: s_app_menu_delegate];
    [[t_app_menu itemAtIndex: 10] setTag: kMCShadowedItemQuit];
	[t_app_menu setDelegate: s_app_menu_delegate];
	
	NSMenuItem *t_app_menu_item;
	t_app_menu_item = [[NSMenuItem alloc] initWithTitle: t_app_name action: nil keyEquivalent: @""];
	[t_app_menu_item setSubmenu: t_app_menu];
	[t_app_menu release];
	
	[p_menu -> menu insertItem: t_app_menu_item atIndex: 0];
	[t_app_menu_item release];
	
	p_menu -> is_menubar = true;
}

static void MCPlatformStopUsingMenuAsMenubar(MCPlatformMenuRef p_menu)
{
	if (!p_menu -> is_menubar)
		return;
	
	[p_menu -> menu removeItemAtIndex: 0];
	
	p_menu -> is_menubar = false;
}

void MCPlatformShowMenubar(void)
{
    [NSMenu setMenuBarVisible:YES];
}

void MCPlatformHideMenubar(void)
{
    [NSMenu setMenuBarVisible:NO];
}

void MCPlatformSetMenubar(MCPlatformMenuRef p_menu)
{
	if (p_menu == s_menubar)
		return;
	
	MCPlatformMenuRef t_old_menubar;
	t_old_menubar = s_menubar;
	s_menubar = nil;
	
	if (p_menu != nil)
	{
		MCPlatformStartUsingMenuAsMenubar(p_menu);
		[NSApp setMainMenu: p_menu -> menu];
		MCPlatformRetainMenu(p_menu);
		s_menubar = p_menu;
	}
	else
		[NSApp setMainMenu: nil];
	
	if (t_old_menubar != nil)
	{
		MCPlatformStopUsingMenuAsMenubar(t_old_menubar);
		MCPlatformReleaseMenu(t_old_menubar);
	}
}

void MCPlatformGetMenubar(MCPlatformMenuRef& r_menu)
{
	r_menu = s_menubar;
}

//////////

static MCPlatformMenuRef s_icon_menu = nil;

NSMenu *MCMacPlatformGetIconMenu(void)
{
	if (s_icon_menu != nil)
		MCPlatformCallbackSendMenuUpdate(s_icon_menu);
	
	if (s_icon_menu != nil)
		return s_icon_menu -> menu;
	
	return nil;
}

void MCPlatformSetIconMenu(MCPlatformMenuRef p_menu)
{
	if (s_icon_menu != nil)
		MCPlatformReleaseMenu(s_icon_menu);
	s_icon_menu = p_menu;
	if (s_icon_menu != nil)
		MCPlatformRetainMenu(s_icon_menu);
}

////////////////////////////////////////////////////////////////////////////////

static struct { MCPlatformMenuItemAction action; SEL selector; } s_menu_item_action_map[] =
{
	{ kMCPlatformMenuItemActionNone, nil },
	{ kMCPlatformMenuItemActionUndo, @selector(undo:) },
	{ kMCPlatformMenuItemActionRedo, @selector(redo:) },
	{ kMCPlatformMenuItemActionCut, @selector(cut:) },
	{ kMCPlatformMenuItemActionCopy, @selector(copy:) },
	{ kMCPlatformMenuItemActionPaste, @selector(paste:) },
	{ kMCPlatformMenuItemActionClear, @selector(delete:) },
	{ kMCPlatformMenuItemActionSelectAll, @selector(selectAll:) },
};

bool MCMacPlatformMapMenuItemActionToSelector(MCPlatformMenuItemAction action, SEL& r_selector)
{
	for(uindex_t i = 0; i < sizeof(s_menu_item_action_map) / sizeof(s_menu_item_action_map[0]); i++)
		if (action == s_menu_item_action_map[i] . action)
		{
			r_selector = s_menu_item_action_map[i] . selector;
			return true;
		}
	
	return false;
}

////////////////////////////////////////////////////////////////////////////////

// MW-2014-04-11: [[ Bug 12068 ]] On startup setup an empty default menubar
//   so that all apps get Quit / About items.
bool MCPlatformInitializeMenu(void)
{
    MCPlatformMenuRef t_menubar;
    MCPlatformCreateMenu(t_menubar);
    MCPlatformSetMenubar(t_menubar);
    MCPlatformReleaseMenu(t_menubar);
    
    /* Initialize the diamond NSImage */
    s_diamond_image = [[NSImage alloc] initWithData:
                            [NSData dataWithBytesNoCopy: (void *)kDiamondTiffImage
                                                 length: kDiamondTiffImageLength
                                           freeWhenDone: NO]];
    
    if (![NSApp windowsMenu])
    {
        // prepend an up to date "Window" list to the Dock menu
        NSMenu* t_windows_menu = [[NSMenu alloc] initWithTitle:@"Window"];
        [NSApp setWindowsMenu:t_windows_menu];
        [t_windows_menu release];
    }
    
    return true;
}

void MCPlatformFinalizeMenu(void)
{
    [s_diamond_image release];
    s_diamond_image = nullptr;
}

////////////////////////////////////////////////////////////////////////////////
