# Real boolean constants
The constants `true` and `false` have been changed so that
they are represented internally by values of boolean type,
where previously they were strings.

This should have no effect on LiveCode applications other than
in two cases:
- use of the `is strictly` operator: expressions like
  `true is strictly a string` now evaluate to false `true is
  strictly a boolean` to true.
- passing boolean constants as elements of arrays to LCB
  handlers.

In the latter case, LCB handlers should already be written to accept
varying types of values coming in as elements of arrays as they
could be generated by boolean expressions. Since a user may well
do any of the following in LiveCode:

    put true into tArray["enabled"]
    put "true" into tArray["enabled"]
    put (tVar is not "enabled") into tArray["enabled"]

any LCB handler to which `tArray` is passed should be doing something like:

    variable tEnabled as Boolean
    if tArray["enabled"] is a boolean then
        put tAction["enabled"] into tEnabled
    else
        put tAction["enabled"] parsed as boolean into tEnabled
    end if
