# LiveCode Builder Language
## Variables

* Handler local variables are now have lexical scope. This means
  variables are accessible from the point of definition to the end of
  the block they are defined in.  Note that:

  * each `repeat` control structure is considered a single block.

  * each separate block in an `if`/`else if`/`else` control structure
    is considered a single block.

* Variables are now reset (either to their default value, or
  unassigned) at the point of the variable definition. In particular,
  any variables defined within a `repeat` block are reset on each
  iteration:

      repeat 5 times
         variable tVar as optional String
         -- tVar is reset to "nothing" every time the loop runs
      end repeat

* Variables in an inner block can now shadow those in an outer
  block. For example, the following is valid:

      variable tX as Array
      repeat 5 times
         variable tX as Number
         repeat 4 times
            variable tX as String
         end repeat
      end repeat

# [17526] Make variables lexically scoped in statement blocks.
