# Compiling LiveCode for Linux

![LiveCode Community Logo](http://livecode.com/wp-content/uploads/2015/02/livecode-logo.png)

Copyright © 2015 LiveCode Ltd., Edinburgh, UK

## Dependencies

LiveCode has several dependencies that are needed in order to build it on Linux.  In general, it is enough to install the tools and libraries that would be typically used to compile a GNOME application written in C++.

Obviously, the exact packages required vary depending on which Linux distribution you use, and how recent it is.  For examples of the packages you may need, please see the "Standard build environments" section later in this document.

## Build environment

The LiveCode build obeys all of the standard make environment variables, including:

* `CC`: C compiler command
* `CXX`: C++ compiler command

There are some additional environment variables that it understands:

* `CXX_STD`: which version of the C++ standard to use (`c++11` is recommended)

## Configuring LiveCode

To configure LiveCode, simply run:

    make config-linux

This will generate make control files in the `build-linux-<arch>` directory.  For example, if you are compiling on an x86-64 system, this will create a `build-linux-x86_64` directory.

To provide detailed configuration options, you can use the `config.sh` script.  For more information, run:

    ./config.sh --help

## Compiling LiveCode

Usually, you can just run:

    make -k

However, if you wish to compile something more specific than "everything", you'll need to run the top level Makefile generated by gyp.  For example:

    make -C build-linux-x86_64/livecode development

## Standard build environments

**Note:** The following information is provided for reference purposes.  It should be possible to build and run LiveCode on any modern Linux desktop distribution.

The x86-64 and x86 Linux build environments used for compiling
LiveCode are based on Debian Wheezy.

The following additional packages should be installed before building:

* build-essential
* automake
* libtool
* gawk
* git
* curl
* flex
* bison
* libx11-dev
* libxext-dev
* libxrender-dev
* libxft-dev
* libxinerama-dev
* libxv-dev
* libxcursor-dev
* libfreetype6-dev
* libpopt-dev
* libesd0-dev
* liblcms-dev
* pkg-config
* libgtk2.0-dev
* zip


Use 

    sudo apt-get install build-essential automake libtool gawk git curl flex &&
    sudo apt-get install bison libx11-dev libxext-dev libxrender-dev libxft-dev &&
    sudo apt-get install libxinerama-dev libxv-dev libxcursor-dev libfreetype6-dev && 
    sudo apt-get install libpopt-dev libesd0-dev liblcms2-dev pkg-config libgtk2.0-dev zip

or equivalent in order to assure all the necessary dependencies are installed on your machine.