# Contribution Guidelines

When contributing to this repository, please first discuss the changes you wish to make via an issue, email, or any other method, with the owners of this repository before issuing a pull request.

## How to contribute

### Reporting bugs or making feature requests

To report a bug or suggest a new feature, please go to the [linkml/linkml-store issue tracker](https://github.com/linkml/linkml-store/issues), as we are
consolidating issues there.

Please supply enough details to the developers to enable them to verify and troubleshoot your issue:

* Provide a clear and descriptive title as well as a concise summary of the issue to identify the problem.
* Describe the exact steps which reproduce the problem in as many details as possible.
* Describe the behavior you observed after following the steps and point out what exactly is the problem with that behavior.
* Explain which behavior you expected to see instead and why.
* Provide screenshots of the expected or actual behaviour where applicable.


### The development lifecycle

1. Create a bug fix or feature development branch, based off the `main` branch of the upstream repo, and not your fork. Name the branch appropriately, briefly summarizing the bug fix or feature request. If none come to mind, you can include the issue number in the branch name. Some examples of branch names are, `bugfix/breaking-pipfile-error` or `feature/add-click-cli-layer`, or `bugfix/issue-414`
2. Make sure your development branch has all the latest commits from the `main` branch.
3. After completing work and testing locally, push the code to the appropriate branch on your fork.
4. Create a pull request from the bug/feature branch of your fork to the `main` branch of the upstream repository.

Note: All the development must be done on a branch on your fork.

ALSO NOTE: github.com lets you create a pull request from the main branch, automating the steps above.

> A code review (which happens with both the contributor and the reviewer present) is required for contributing.

### How to write a great issue

Please review GitHub's overview article,
["Tracking Your Work with Issues"][about-issues].

<a id="great-pulls"></a>

### How to create a great pull/merge request

Please review GitHub's article, ["About Pull Requests"][about-pulls],
and make your changes on a [new branch][about-branches].

[about-branches]: https://docs.github.com/en/pull-requests/collaborating-with-pull-requests/proposing-changes-to-your-work-with-pull-requests/about-branches
[about-issues]: https://docs.github.com/en/issues/tracking-your-work-with-issues/about-issues
[about-pulls]: https://docs.github.com/en/pull-requests/collaborating-with-pull-requests/proposing-changes-to-your-work-with-pull-requests/about-pull-requests
[issues]: https://github.com/linkml/linkml-store/issues/
[pulls]: https://github.com/linkml/linkml-store/pulls/

We recommend also reading [GitHub Pull Requests: 10 Tips to Know](https://blog.mergify.com/github-pull-requests-10-tips-to-know/)
