---
title: Community and Contributing
description: Learn how to connect with the Lingui community and contribute to the project
---

For any open-source project, the community is the backbone of success. It's the community that drives growth, provides valuable feedback, and contributes to the project in countless ways.

## Community

Lingui has a significant number of developers as a part of its community.

On this page, you'll find links to various Lingui-related communities you can join, as well as additional resources for learning and collaboration. Be sure to explore the other pages in this section for more learning opportunities.

Before participating, please take a moment to review our [Code of Conduct](https://github.com/lingui/js-lingui/blob/main/CODE_OF_CONDUCT.md). We expect all members to follow these guidelines to ensure a positive and welcoming environment for everyone.

### Discussion Forums

The [Lingui Discord Server](https://discord.gg/gFWwAYnMtA) is a place where you can learn, share, and collaborate about anything and everything Lingui.

![Join the community on Discord](https://img.shields.io/discord/974702239358783608.svg?label=Discord&logo=Discord&colorB=7289da&style=flat-square)

- Connect with users in the community.
- Get your questions answered and learn cool new tips and tricks.
- Get notifications about new content from Lingui and the community.
- Share your knowledge and experience with others.

### Stack Overflow

Stack Overflow is a popular forum to ask code-level questions or if you're stuck with a specific error. Read through the [existing questions](https://stackoverflow.com/questions/tagged/linguijs) tagged with `linguijs` or [ask your own](https://stackoverflow.com/questions/ask?tags=linguijs)!

### News

For the latest news about Lingui, follow [@LinguiJS](https://x.com/LinguiJS) on X.

## Contributing

If you're interested in contributing to Lingui, hopefully, this document makes the process for contributing clear.

![Lingui Contributors](https://img.shields.io/github/contributors/lingui/js-lingui?logo=github&style=flat-square)

The [Open Source Guides](https://opensource.guide/) website has a collection of resources for individuals, communities, and companies who want to learn how to run and contribute to an open source project. Contributors and people new to open source alike will find the following guides especially useful:

- [How to Contribute to Open Source](https://opensource.guide/how-to-contribute/)
- [Building Welcoming Communities](https://opensource.guide/building-community/)

For more details on how can you contribute visit our [Contributing Guidelines](https://github.com/lingui/js-lingui/blob/main/CONTRIBUTING.md).
