---
title: Lingui hits 4k Stars on GitHub ⭐
authors: andrii-bodnar
tags: [news, community]
image: ./img/social-card.png
---

![social-card image](./img/social-card.png)

We're thrilled to announce that the [Lingui repository](https://github.com/lingui/js-lingui) has reached an important milestone - **4,000** stars! This achievement is a testament to the growing popularity of Lingui as a powerful and flexible internationalization solution for global products.

<!--truncate-->

### Lingui has been gaining traction in the JS community due to its several key advantages {#advantages}

- **Universal** - use it everywhere: Vanilla JS, React, Vue.js, Next.js, Node.js, etc.

- **Full rich-text support** - use React components within localized messages without restriction. Writing rich-text messages is as easy as writing JSX.

- **Powerful tooling** - manage the entire intl workflow with the [Lingui CLI](https://lingui.dev/ref/cli). It extracts messages from source code, validates messages coming from translators, and many more. Use the [ESLint plugin](https://lingui.dev/ref/eslint-plugin) to find common Lingui usage errors in your code. In addition, for Vite users, we have the [Vite plugin](https://lingui.dev/ref/vite-plugin) which compiles Lingui catalogs on the fly and provides additional configuration needed for Vite.

- **Customization** - integrate Lingui with your existing workflow. It supports both message keys and auto-generated messages. Translations can be stored in a [variety of file formats](https://lingui.dev/ref/catalog-formats) including PO, JSON, and CSV. For more advanced usage, there is a possibility to create a [Custom Extractor](https://lingui.dev/guides/custom-extractor) or [Custom Formatter](https://lingui.dev/guides/custom-formatter) for your project.

### Here are some of the ways that Lingui is being used by companies around the world {#use-cases}

- [Ansible](https://github.com/ansible/awx) - an open source community project sponsored by Red Hat, it's the simplest way to automate IT.
- [Metamask](https://github.com/MetaMask/snaps-directory) - a crypto wallet & gateway to blockchain apps.
- [Uniswap](https://github.com/Uniswap/interface) - an open source interfaces for the Uniswap protocol.

These are just a few examples of the many companies that use Lingui to power their internationalization efforts. We're confident that Lingui will continue to grow in popularity as more and more companies recognize its value.

### Thanks to the community {#thanks}

This milestone wouldn't have happened without all of you, so we want to thank the awesome community for being with Lingui all the way along. Join the [Lingui community](https://lingui.dev/misc/community) and help us make Lingui even better!
