/**
 * Simple query string parser.
 *
 * @param {String} query The query string that needs to be parsed.
 * @returns {Object}
 */
export function parse(query) {
  const parser = /([^=?#&]+)=?([^&]*)/g
  const result = {}
  let part

  while ((part = parser.exec(query))) {
    const key = decode(part[1])
    const value = decode(part[2])

    //
    // Prevent overriding of existing properties. This ensures that build-in
    // methods like `toString` or __proto__ are not overriden by malicious
    // querystrings.
    //
    // In the case if failed decoding, we want to omit the key/value pairs
    // from the result.
    //
    if (key === null || value === null || key in result) continue
    result[key] = value
  }

  return result
}

function decode(input) {
  try {
    return decodeURIComponent(input.replace(/\+/g, " "))
  } catch (e) {
    return null
  }
}
