# NexTemp | A Next.js Personal Web App

![NexTemp - A Next.js Personal Web App](https://github.com/lilxyzz/nextemp/blob/main/public/NexTemp-cover.png)

NexTemp - A bespoke **template** for your **next** web project. NexTemp is a personal portfolio and blog theme built around Next.js. It features a modern, clean, and responsive design, perfect for developers or anyone looking to showcase their work and ideas. For more themes and updates, stay tuned.

## 📚 Tech Stack
Next.js 14+
React 18+
Tailwind CSS 3+
Framer Motion 11+

## ✨ Features
- Dark and light color mode 
- Reusable Components
- Blog post creation
- Animations with Framer Motion
- Tailwind CSS integration
- Mobile-first responsive layout
- Sitemap support
- 95+ Lighthouse

## 🚀 NexTemp Pro Coming Soon
**Features**
- SEO optimised 
- Post tags and categories
- Integration with Hashnode CMS for easy post publishing
- PWA support
  

### 🛠️ Requirements

- Node 18+
  - https://nodejs.org/en
- Yarn
  - https://classic.yarnpkg.com/en/docs/getting-started



## 🎬 Getting Started

1. Clone the repository:
    ```bash
    git clone https://github.com/lilxyzz/nextemp.git
    ```

2. Navigate into the repository:
    ```bash
    cd NexTemp
    ```

3. Install the dependencies:
    ```bash
    yarn
    ```

4. Run the development server:
    ```bash
    yarn dev
    ```
5. Open [http://localhost:3000](http://localhost:3000) with your browser to see the result.


#### 🙏 Thanks
If you like this theme, don't forget to give it a ⭐.

#### 🤝 Contributing
Got enhancements you envision? Contributions are welcome! Fork the repo, push your changes, and submit a pull request. Let's make this theme better, together.

#### 👾 Issues
For any challenges encountered, please feel free to report issues through our issue tracker.

#### 📝 License
This project is open source and available under the MIT License.