import { useSearchParams } from "next/navigation";
import { signIn } from "next-auth/react";

import { Button } from "../button";
import { EventAction, EventCategory, EventLabel, track } from "../tracking";

interface Props {
  mode: "login" | "register";
}
export const SocialLogin: React.VFC<Props> = ({ mode }) => {
  const params = useSearchParams();
  const onClick = async (e: React.MouseEvent, type: "google" | "github") => {
    e.preventDefault();
    track({
      eventAction: EventAction.Click,
      eventCategory: EventCategory.Auth,
      eventLabel:
        type === "google" ? EventLabel.GoogleLogin : EventLabel.GitHubLogin,
    });
    if (params.get("source") && params.get("serviceUrl")) {
      const source = params.get("source");
      const serviceUrl = params.get("serviceUrl");
      await signIn(type, {
        callbackUrl: `${document.location.origin}/api/identity/login?source=${source}&serviceUrl=${serviceUrl}`,
      });
      return;
    }
    const cbUrl = params.get("callbackUrl");
    const callback = typeof cbUrl === "string" ? cbUrl : "/posts";
    await signIn(type, { callbackUrl: callback });
  };
  return (
    <>
      <Button onClick={(e) => onClick(e, "google")} className="relative">
        <div className="px-4 py-2 absolute left-0">
          <svg className="h-6 w-6 fill-slate-700" viewBox="0 0 40 40">
            <path
              d="M36.3425 16.7358H35V16.6667H20V23.3333H29.4192C28.045 27.2142 24.3525 30 20 30C14.4775 30 10 25.5225 10 20C10 14.4775 14.4775 9.99999 20 9.99999C22.5492 9.99999 24.8683 10.9617 26.6342 12.5325L31.3483 7.81833C28.3717 5.04416 24.39 3.33333 20 3.33333C10.7958 3.33333 3.33335 10.7958 3.33335 20C3.33335 29.2042 10.7958 36.6667 20 36.6667C29.2042 36.6667 36.6667 29.2042 36.6667 20C36.6667 18.8825 36.5517 17.7917 36.3425 16.7358Z"
              fill="#FFC107"
            />
            <path
              d="M5.25497 12.2425L10.7308 16.2583C12.2125 12.59 15.8008 9.99999 20 9.99999C22.5491 9.99999 24.8683 10.9617 26.6341 12.5325L31.3483 7.81833C28.3716 5.04416 24.39 3.33333 20 3.33333C13.5983 3.33333 8.04663 6.94749 5.25497 12.2425Z"
              fill="#FF3D00"
            />
            <path
              d="M20 36.6667C24.305 36.6667 28.2167 35.0192 31.1742 32.34L26.0159 27.975C24.3425 29.2425 22.2625 30 20 30C15.665 30 11.9842 27.2359 10.5975 23.3784L5.16254 27.5659C7.92087 32.9634 13.5225 36.6667 20 36.6667Z"
              fill="#4CAF50"
            />
            <path
              d="M36.3425 16.7358H35V16.6667H20V23.3333H29.4192C28.7592 25.1975 27.56 26.805 26.0133 27.9758C26.0142 27.975 26.015 27.975 26.0158 27.9742L31.1742 32.3392C30.8092 32.6708 36.6667 28.3333 36.6667 20C36.6667 18.8825 36.5517 17.7917 36.3425 16.7358Z"
              fill="#1976D2"
            />
          </svg>
        </div>
        <h1 className="w-5/6 px-4 py-2 text-center">
          Sign {mode === "login" ? "in" : "up"} with Google
        </h1>
      </Button>
      <Button onClick={(e) => onClick(e, "github")} className="relative">
        <div className="px-4 py-2 absolute left-0">
          <svg
            role="img"
            className="h-5 w-5 dark:fill-slate-700 fill-slate-50"
            viewBox="0 0 24 24"
            xmlns="http://www.w3.org/2000/svg"
          >
            <title>GitHub</title>
            <path d="M12 .297c-6.63 0-12 5.373-12 12 0 5.303 3.438 9.8 8.205 11.385.6.113.82-.258.82-.577 0-.285-.01-1.04-.015-2.04-3.338.724-4.042-1.61-4.042-1.61C4.422 18.07 3.633 17.7 3.633 17.7c-1.087-.744.084-.729.084-.729 1.205.084 1.838 1.236 1.838 1.236 1.07 1.835 2.809 1.305 3.495.998.108-.776.417-1.305.76-1.605-2.665-.3-5.466-1.332-5.466-5.93 0-1.31.465-2.38 1.235-3.22-.135-.303-.54-1.523.105-3.176 0 0 1.005-.322 3.3 1.23.96-.267 1.98-.399 3-.405 1.02.006 2.04.138 3 .405 2.28-1.552 3.285-1.23 3.285-1.23.645 1.653.24 2.873.12 3.176.765.84 1.23 1.91 1.23 3.22 0 4.61-2.805 5.625-5.475 5.92.42.36.81 1.096.81 2.22 0 1.606-.015 2.896-.015 3.286 0 .315.21.69.825.57C20.565 22.092 24 17.592 24 12.297c0-6.627-5.373-12-12-12" />
          </svg>
        </div>
        <h1 className="w-5/6 px-4 py-2 text-center">
          Sign {mode === "login" ? "in" : "up"} with Github
        </h1>
      </Button>
    </>
  );
};
