/* eslint-disable react/no-unescaped-entities */
const Terms = () => {
  return (
    <>
      <div className="flex items-center flex-col py-32 bg-zinc-800 shadow">
        <h1 className="font-bold text-3xl">Terms Of Use Agreement</h1>
        <time>
          Updated on January 17, 2021 · Effective from January 17, 2021
        </time>
      </div>
      <div className="prose max-w-3xl mx-auto dark:prose-dark mt-10">
        <p>Welcome to Letterpad ("Letterpad," "we," or "our").</p>

        <p>
          By using the website located at Letterpad.app, any other URL provided
          by Letterpad, and any related mobile website(s) (collectively, the
          “Websites”), you agree to be bound by these Terms of Use (this “Terms
          of Use” or “Agreement”). If you wish to use the Websites (in which
          instance you will be deemed a “User”), and/or make use of the
          Letterpad service (the “Service”), please read this Agreement.
        </p>
        <p>
          PLEASE READ THIS AGREEMENT CAREFULLY AS IT CONTAINS IMPORTANT
          INFORMATION REGARDING YOUR LEGAL RIGHTS, REMEDIES AND OBLIGATIONS,
          INCLUDING VARIOUS LIMITATIONS AND EXCLUSIONS, AND A DISPUTE RESOLUTION
          CLAUSE THAT GOVERNS HOW DISPUTES WILL BE RESOLVED.
        </p>
        <h2>1. Electronic Agreement.</h2>
        <p>
          This Terms of Use is an electronic contract that sets out the legally
          binding terms of your use of the Service. By accessing and/or using
          the Service or becoming a User, you accept and agree to be bound and
          abide by the Terms of Use and our Privacy Policy, found at{" "}
          <a href="https://letterpad.app/privacy">
            https://letterpad.app/privacy
          </a>
          , incorporated herein by reference. If you do not want to agree to
          these Terms of Use or the Privacy Policy, you must not access or use
          the Websites or the Service.
        </p>
        <p>
          This Terms of Use and the Privacy Policy is subject to change by
          Letterpad at any time, effective upon posting on the Letterpad
          Websites. Your continued use of the Websites and Service following
          Letterpads posting of revised terms of any section of the Terms of Use
          will constitute your express and binding acceptance of and consent to
          the revised Terms of Use. While we will endeavor to update you on
          changes, you are expected to check this page from time to time so you
          are aware of any changes, as they are binding on you.
        </p>
        <h2>2. Eligibility.</h2>
        <p>
          You must be at least thirteen (13) years of age to use the Service. By
          using the Service, you represent and warrant that you have the right,
          authority and capacity to enter into this Agreement, or have parental
          or guardian consent to do so, and will abide by all of the terms and
          conditions of this Agreement. If you are accepting these Terms of Use
          and using the Service on behalf of a minor of at least thirteen (13),
          you represent that you have authorization to do so, and the words
          “you” or “your” in these Terms of Use include that such minor.
        </p>
        <p>
          The Service is also not available to any users who have been
          previously removed or suspended from the Service.
        </p>
        <h2>3. Access and Registration.</h2>
        <p>
          We reserve the right to withdraw or amend the Websites or the Service
          in our sole discretion without notice. We will not be liable if for
          any reason all or any part of the Websites or Service is unavailable
          at any time or for any period. From time to time, we may restrict
          access to some parts of the Websites, or an entire Website(s), to
          Users.
        </p>
        <p>You are responsible for both:</p>
        <p>
          Making all arrangements necessary for you to have access to the
          Websites and Service. Ensuring that all persons who access the
          Websites and Services through your internet connection are aware of
          these Terms of Use and comply with them.
        </p>
        <p>
          To access the Websites or the Service, you may be asked to provide
          certain registration details or other information. It is a condition
          of your use of the Websites and Service that all the information you
          provide is correct, current, and complete. You agree that all
          information you provide to register with the Websites or Service,
          including, but not limited to, through the use of any interactive
          features on the Website, is governed by our Privacy Policy [LINK TO
          PRIVACY POLICY], and you consent to all actions we take with respect
          to your information consistent with our Privacy Policy.
        </p>
        <p>
          You may delete your account in the “Account Settings” of the Websites
          and/or Service. Please note that if you delete your account, you will
          lose any sub-domain provided by Letterpad and profile you created on
          Letterpad.
        </p>
        <h2>4. Account Security.</h2>
        <p>
          You are responsible for maintaining the confidentiality of the
          username and password that you designate during the registration
          process, and you are fully responsible for all activities that occur
          under your username and password. You agree to (a) immediately notify
          Letterpad of any unauthorized use of your username or password or any
          other breach of security, and (b) ensure that you exit from your
          account at the end of each session. Letterpad will not be liable for
          any loss or damage arising from your failure to comply with this
          provision.
        </p>
        <p>
          You should use particular caution when accessing your account from a
          public or shared computer so that others are not able to view or
          record your password or other personal information. If you share your
          computer with others, you may wish to consider disabling your
          auto-sign in feature if you have it linked to your Letterpad account.
        </p>
        <p>
          We have the right to disable any username, password, or other
          identifier, whether chosen by you or provided by us, if, in our
          opinion, you have violated any provision of these Terms of Use.
        </p>
        <h2>5. Commercial Use of Service.</h2>
        <p>
          If you are using and/or accessing the Service on behalf of a company,
          entity, or organization (collectively, a “Subscribing Entity”), you
          represent and warrant that:
        </p>
        <p>
          You are an authorized representative of the Subscribing Entity, and
          that you have the authority to bind the Subscribing Entity to this
          Terms of Use;
          <br />
          You have read and understand this Terms of Use;
          <br />
          You agree to this Terms of Use on behalf of the Subscribing Entity.
        </p>
        <p>
          Further, the Service may allow the capability for individuals or
          entities (“Sponsors”) to sponsor articles (a “Sponsorship”) authored
          by users of the Service (“Creators”) with a monetary payment conducted
          via integration with a third-party payment platform, such as Stripe or
          PayPal. Sponsorships are not endorsements by the Service nor by
          Letterpad about the Creator or the underlying article(s). Any disputes
          related to the Sponsorship, including monetary issues are between the
          Sponsor and the Creator, and/or the applicable third-party payment
          platform, are between those applicable parties only, and not
          Letterpad. The Service and Letterpad does not review the
          identification or origination of any Sponsor or Creator.
        </p>
        <p>
          The Service may charge convenience fees to process Sponsorships and
          any such fees shall be set forth separately and acknowledged by such
          applicable Creator. Letterpad does not handle any applicable tax
          payments or filings for the Creators and Creators acknowledge they
          must file all appropriate tax forms and make all applicable tax
          payments for received Sponsorships.
        </p>
        <p>
          Sponsorships are non-refundable. Letterpad is under no obligations to
          commence or continue any Sponsorship program on the Service.
        </p>
        <h2>6. Your Use of the Service</h2>
        <p>
          You must not copy or capture, or attempt to copy or capture, any
          content from the Websites or Service, unless given express permission
          by Letterpad.
        </p>
        <p>
          Other than Your Content (as defined below in Section 8), You must not
          copy, republish, adapt, make available or otherwise communicate to the
          public, display, perform, transfer, share, distribute or otherwise use
          or exploit any content on or from the Websites and/or Service. You
          must not use any content in any way that is designed to create a
          separate service or that replicates any part of the offering of the
          Service.
        </p>
        <p>
          You must not use the Sponsorship process in a manner that games the
          results or in any deceitful manner, and that payments for Sponsorships
          relate only to articles on the Service. You must not employ scraping
          or similar techniques to aggregate, repurpose, republish or otherwise
          make use of any content.
        </p>
        <p>
          You must not employ any techniques or make use of any services,
          automated or otherwise, designed to misrepresent your activity on the
          Service, including without limitation by the use of bots, botnets,
          scripts, apps, plugins, extensions or other automated means to send
          messages, post comments, or otherwise to act on your behalf,
          particularly where such activity occurs in a multiple or repetitive
          fashion. You must not offer or promote the availability of any such
          techniques or services to any other users of the Service.
        </p>
        <p>
          You must not alter or remove, or attempt to alter or remove, any
          trademark, copyright or other proprietary or legal notices contained
          in, or appearing on, the Websites or any Content appearing on the
          Websites.
        </p>
        <p>
          You must not, and must not permit any third party to, copy or adapt
          the object code of the Websites, or reverse engineer, reverse
          assemble, decompile, modify or attempt to discover any source or
          object code of any part of the Websites, or circumvent or attempt to
          circumvent or copy any copy protection mechanism or access any rights
          management information pertaining to content on the Websites.
        </p>
        <p>
          You must not use the Websites to upload, post, store, transmit,
          display, copy, distribute, promote, make available or otherwise
          communicate to the public:
        </p>
        <p>
          any content that is offensive, abusive, libelous, defamatory, obscene,
          racist, sexually explicit, ethnically or culturally offensive,
          indecent, that promotes violence, terrorism, or illegal acts, incites
          hatred on grounds of race, gender, religion or sexual orientation, or
          is otherwise objectionable in Letterpads sole and reasonable
          discretion;
        </p>
        <p>
          any information, content or other material that violates, plagiarizes,
          misappropriates or infringes the rights of third parties including,
          without limitation, copyright, trademark rights, rights of privacy or
          publicity, confidential information or any other right;
        </p>
        <p>
          any private communications between individuals with explicit consent
          of all parties to the communication, doxing, and posting of other
          content that violates others\’ privacy rights;
        </p>
        <p>
          any information promoting harmful conspiracies, or the facilitation of
          gambling, betting, illegal activities or copyright violation;
        </p>
        <p>
          any content that is duplicate content, whether from the same account
          or multiple accounts on Letterpad;
        </p>
        <p>
          any content or conduct that is deceptive, including impersonating
          individuals or entities, using the Letterpad Service for phishing or
          fraud, not disclosing you have received compensation of any variety in
          connection with the topic of your submissions or content (i.e., goods
          and services) including affiliate links; or
        </p>
        <p>
          any content that violates, breaches or is contrary to any law, rule,
          regulation, court order or is otherwise is illegal or unlawful in
          Letterpads sole and reasonable opinion;
        </p>
        <p>
          any material of any kind that contains any virus, Trojan horse,
          spyware, adware, malware, bot, time bomb, worm, or other harmful or
          malicious component, which will or might overburden, impair or disrupt
          the Service or servers or networks forming part of, or connected to,
          the Service, or which does or might restrict or inhibit any other
          user's use and enjoyment of the Service; or
        </p>
        <p>
          any unsolicited or unauthorized advertising, promotional messages,
          spam or any other form of solicitation.
        </p>
        <p>
          You must not commit or engage in, or encourage, induce, solicit or
          promote, any conduct that would constitute a criminal offense, give
          rise to civil liability or otherwise violate any law or regulation.
        </p>
        <p>
          You must not rent, sell or lease access to the Service, or any content
          on the Websites.
        </p>
        <p>
          You must not deliberately impersonate any person or entity or
          otherwise misrepresent your affiliation with a person or entity,
          including creating parody accounts.
        </p>
        <p>
          You must not stalk, exploit, threaten, abuse or otherwise harass
          another user, or any Letterpad personnel or Letterpad User. If
          Letterpad determines that any User has threatened, stalked, harassed,
          or verbally abused any Letterpad employee or another Letterpad User,
          Letterpad reserves the right to immediately terminate that User\’s use
          of the Service and suspend access to the Service.
        </p>
        <p>
          You must not sell or transfer, or offer to sell or transfer, access to
          the Websites without the prior written approval of Letterpad.
        </p>
        <p>
          You must not collect or attempt to collect personal data, or any other
          kind of information about other users, including without limitation,
          through spidering or any form of scraping.
        </p>
        <p>
          You must not violate, circumvent or attempt to violate or circumvent
          any data security measures employed by Letterpad; access or attempt to
          access data or materials which are not intended for your use; log
          into, or attempt to log into, a server which you are not authorized to
          access; attempt to scan or test the vulnerability of Letterpads
          servers, system or network or attempt to breach Letterpads data
          security or authentication procedures; attempt to interfere with the
          Websites or the Services by any means including, without limitation,
          hacking Letterpads servers or systems, submitting a virus,
          overloading, mail-bombing or crashing. Without limitation to any other
          rights or remedies of Letterpad under these Terms of Use, Letterpad
          reserves the right to investigate any situation that appears to
          involve any of the above, and may report such matters to, and
          cooperate with, appropriate law enforcement authorities in prosecuting
          any users who have participated in any such violations.
        </p>
        <p>
          You agree to comply with the above conditions, and acknowledge and
          agree that Letterpad has the right, in its sole discretion, to
          terminate your access to the Websites or take such other action as we
          see fit if you breach any of the above conditions or any of the other
          terms of these Terms of Use. This may include taking court action
          and/or reporting offending users to the relevant authorities.
        </p>
        <p>
          Further, illegal and/or unauthorized uses of the Service include, but
          are not limited to, collecting email addresses of Users by electronic
          or other means for the purpose of sending unsolicited email,
          unauthorized framing of or linking to the Websites attempting to
          impersonate another user or person, use of the Service in any
          fraudulent or misleading manner, any automated use of the system, such
          as scraping the Websites, automated scripts, spiders, robots,
          crawlers, harvesting or data mining tools or the like, interfering
          with, disrupting, or creating an undue burden on the Service or the
          networks or services connected to the Service, and using the Service
          in a manner inconsistent with any and all applicable laws and
          regulations. Illegal and/or unauthorized use of the Service may be
          investigated, and appropriate legal action may be taken, including
          without limitation, civil, criminal, and injunctive redress. Use of
          the Service is with the permission of Letterpad, which may be revoked
          at any time, for any reason, in Letterpads sole discretion.
        </p>
        <p>
          If you violate these rules, we reserve the right to review posts or
          accounts at any time and remove content that violates these Terms of
          Use rules. In deciding whether something has violated these Terms of
          Use. Repeated violations of the Terms of Use will result in permanent
          ineligibility to use the Services.
        </p>
        <p>
          If you find content or a Letterpad account that violates these rules,
          please let us know by sending an email to{" "}
          <a
            href="mailto:hello@Letterpad.app"
            target="_blank"
            rel="noopener noreferrer"
          >
            hello@Letterpad.app
          </a>
          .
        </p>
        <h2>7. Interactions; Limitation of Liability</h2>
        <p>
          It is up to you whether you want to connect with a certain User, and
          you alone bear the risk of any communication, meeting, or other
          connection with a User. You acknowledge and agree that Letterpad is
          not a party to any communication, meeting or agreement between you and
          another User, and that we are not liable to you for any loss incurred
          as the result of a User\’s acts or omissions, including without
          limitation fraud, failure to communicate, conversion, physical injury,
          mental distress, breach of contract, negligence, and intellectual
          property violations.
        </p>
        <p>
          You acknowledge and agree that Letterpad does not necessarily have
          control over the quality, safety, morality or legality of any User or
          any service(s) they offer you, the truth or accuracy of any User
          statements, or the ability of Users to fulfill their obligations under
          an agreement with you. Letterpad cannot ensure that a User will
          actually complete a transaction or follow through on their promises.
        </p>
        <p>
          Letterpad cannot guarantee the true identity, age, and nationality of
          a User. Letterpad encourages you to communicate directly with Users
          through the tools available on the application.
        </p>
        <p>
          Further, Letterpad cannot guarantee the articles posted by any User is
          valid, accurate, reliable, current, or error-free.
        </p>
        <h2>8. You Bear Risk of Upload.</h2>
        <p>
          Letterpad uses reasonable security measures in order to attempt to
          protect any content or information that you upload or otherwise make
          available to the Websites and/or the Service, including without
          limitation any information, photographs or other images, or
          intellectual property, including the articles you distribute and
          publish on the Service (collectively, “Your Content”). However,
          Letterpad cannot guarantee that there will be no unauthorized copying
          or distribution of Your Content nor will Letterpad be liable for any
          copying or usage of Your Content not authorized by Letterpad. You
          hereby release and forever waive any claims you may have against
          Letterpad for any such unauthorized copying or usage of Your Content,
          under any theory of liability. THE SECURITY MEASURES TO PROTECT YOUR
          CONTENT USED BY Letterpad HEREIN ARE PROVIDED AND USED "AS-IS" AND
          WITH NO WARRANTIES OR ASSURANCES THAT SUCH SECURITY MEASURES WILL
          WITHSTAND ATTEMPTS TO EVADE SECURITY MECHANISMS OR THAT THERE WILL BE
          NO CRACKS, DISABLEMENTS OR OTHER CIRCUMVENTION OF SUCH SECURITY
          MEASURES.
        </p>
        <h2>10. Modifications to Service.</h2>
        <p>
          Letterpad reserves the right at any time to modify or discontinue,
          temporarily or permanently, the Service (or any part thereof) with or
          without notice. You agree that Letterpad shall not be liable to you or
          to any third party for any modification, suspension or discontinuance
          of the Service.
        </p>
        <h2>11. Blocking of IP Addresses.</h2>
        <p>
          In order to protect the integrity of the Services, Letterpad reserves
          the right at any time in its sole discretion to block Users from
          certain IP addresses from accessing the Websites and/or Service.
        </p>
        <h2>12. Term.</h2>
        <p>
          This Terms of Use will remain in full force and effect while you use
          the Websites and/or Service.
        </p>
        <p>
          Letterpad may terminate your use of the Websites for any reason by
          sending notice to you at the email address you provide when signing up
          for the Service, or such other email address as you may later provide
          to Letterpad. All decisions regarding the termination of use of the
          Websites shall be made in the sole discretion of Letterpad. Letterpad
          is not required to provide you notice prior to terminating your use of
          the Websites and/or the Service. Letterpad is not required, and may be
          prohibited, from disclosing a reason for the termination of your
          access to the Websites. Even after your use of the Websites is
          terminated, this Terms of Use will remain in effect. All terms that by
          their nature may survive termination of this Terms of Use shall be
          deemed to survive such termination.
        </p>
        <h2>13. Third Party Content.</h2>
        <p>
          Letterpad may provide third party content on the Websites and/or
          Service and may provide links to webpages and content of third parties
          (collectively, the “Third-Party Content”) as a service to those
          interested in this information. Letterpad does not control, endorse or
          adopt any Third-Party Content and makes no representation or
          warranties of any kind regarding the Third-Party Content, including
          without limitation regarding its accuracy or completeness. Please be
          aware that Letterpad does not create Third-Party Content, nor does
          Letterpad update or monitor it. Letterpad is therefore not responsible
          for any Third-Party Content on the Service. Users use such Third-Party
          Content at their own risk.
        </p>
        <p>
          The Service may include links or references to other web sites or
          services solely as a convenience to Letterpad users (collectively, the
          “Reference Sites”). Letterpad does not endorse any Reference Sites or
          the information, materials, products, or services contained on or
          accessible through Reference Sites. In addition, your correspondence
          or business dealings with, or participation in promotions of,
          advertisers found on or through the Service are solely between you and
          the relevant advertiser. Access and use of Reference Sites, including
          the information, materials, products, and services on or available
          through Reference Sites is solely at your own risk.
        </p>
        <h2>14. Intellectual Property.</h2>
        <p>
          Letterpad, the Letterpad logos and any other product or service name
          or slogan contained in the Service are trademarks of Letterpad or our
          suppliers or licensors and may not be copied, imitated or used, in
          whole or in part, without the prior written permission of Letterpad or
          the applicable trademark holder. Any authorized use of these
          trademarks must be in accordance with any guidelines that Letterpad
          may provide you from time to time.
        </p>
        <p>
          Letterpad retains all proprietary rights in the Websites and the
          Service, except where otherwise noted. The Websites contain the
          copyrighted material, trademarks, and other proprietary information of
          Letterpad, and its licensors. Except where we have given you express
          written permission, you may not copy, modify, publish, transmit,
          distribute, perform, display, or sell any such proprietary
          information. All content on Letterpad is proprietary. Except where
          otherwise specified in this Agreement, all Content is copyrighted
          material of Letterpad and for Letterpad Users\’ use only. Distribution
          of Content to others is strictly prohibited. You agree that Letterpad
          would be irreparably harmed by any violation or threatened violation
          of this section and that, therefore, Letterpad shall be entitled to an
          injunction prohibiting you from any violation or threatened violation
          of this section, without posting bond, in addition to any other right
          or remedy it may have.
        </p>
        <p>
          We may provide links to third party websites, and some of the content
          appearing on Letterpad may be supplied by third parties. Letterpad has
          no responsibility for these third party websites nor for their
          content, which is subject to and governed by the terms of use and/or
          privacy policies, if any, of the applicable third party content
          providers.
        </p>
        <p>
          You may not use any metatags or any other hidden text utilizing
          “Letterpad” or any other name, trademark or product or service name of
          Letterpad without our prior written permission. In addition, the look
          and feel of the Letterpad Service, including all page headers, custom
          graphics, button icons and scripts, is the service mark, trademark
          and/or trade dress of Letterpad and may not be copied, imitated or
          used, in whole or in part, without our prior written permission. All
          other trademarks, registered trademarks, product names and company
          names or logos mentioned in the Service are the property of their
          respective owners. Reference to any products, services, processes or
          other information, by trade name, trademark, manufacturer, supplier or
          otherwise does not constitute or imply endorsement, sponsorship or
          recommendation thereof by us or any other affiliation.
        </p>
        <p>
          The Service is owned and operated by Letterpad. Unless otherwise
          indicated, all content and other materials on the Service, including,
          without limitation, Letterpads logos, the visual interfaces, graphics,
          design, compilation, information, software, computer code (including
          source code or object code), services, text, pictures, information,
          data, sound files, other files and the selection and arrangement
          thereof (collectively, the “Materials”) are protected by United States
          copyright, trade dress, patent, and trademark laws, international
          conventions, and all other relevant intellectual property and
          proprietary rights, and applicable laws (including in your country of
          residence).
        </p>
        <h2>15. Your Content; Licenses.</h2>
        <p>
          Letterpad does not claim ownership of Your Content, whether you use
          your own domain or a Letterpad sub-domain for Your Content. However,
          with respect to Your Content, you grant Letterpad a perpetual,
          worldwide, royalty-free and non-exclusive license(s) to use,
          distribute, reproduce, modify, adapt, publicly perform and publicly
          display Your Content on the Websites and/or Service, regardless of
          your termination or deletion of your account.
        </p>
        <p>
          If you use the Service without your own sub-domain, the sub-domain
          provided by Letterpad is not your property.
        </p>
        <p>
          Letterpad does not guarantee any amount of interaction with Your
          Content, including results, search engine optimization, clicks, views,
          likes, claps, emojis, or any other type of interaction.
        </p>
        <p>
          Letterpad reserves the right to change the category of Your Content
          based in its sole discretion or hide Your Content if it feels it
          violates these Terms of Use.
        </p>
        <p>
          Letterpad may, from time to time, provide you with the ability to
          import or export Your Content to or from other websites or services.
          If you choose to import or export any of Your Content, you acknowledge
          that doing so does not violate the terms of the other such website
          and/or service.
        </p>
        <h2>16. Copyright Policy.</h2>
        <p>
          Letterpad prohibits the submission or posting of any information that
          infringes or violates the copyright rights and/or other intellectual
          property rights (including rights of privacy and publicity) of any
          person or entity.
        </p>
        <p>
          Pursuant to Title 17, United States Code, Section 512(c)(2) or for any
          other claim of copyright infringement, you hereby agree that
          notifications of claimed copyright infringement be sent by certified
          mail to:
        </p>
        <p>
          124 Broadkill Rd #483
          <br />
          Milton, DE 19968-1008
        </p>
        <p>
          When contacting us, please make sure that you include the following
          information:
        </p>
        <p>
          a statement that you have identified Content on Letterpad that
          infringes your copyright or the copyright of a third party on whose
          behalf you are entitled to act;
          <br />a description of the copyright work(s) that you claim have been
          infringed;
          <br />a description of the Content that you claim is infringing and
          the Letterpad URL(s) where such Content can be located;
          <br />
          your full name, address and telephone number, a valid email address on
          which you can be contacted, and your Letterpad user name if you have
          one;
          <br />a statement by you that you have a good faith belief that the
          disputed use of the material is not authorized by the copyright owner,
          its agent, or the law; and
          <br />a statement by you that the information in your notice is
          accurate and that you are authorized to act on behalf of the owner of
          the exclusive right that is allegedly infringed. In addition, if you
          wish for your notice to be considered as a notice pursuant to the
          United States Digital Millennium Copyright Act 17 U.S.C. ¤512(c),
          please also include the following: with respect to your statement that
          you are authorized to act on behalf of the owner of the exclusive
          right that is allegedly infringed, confirmation that such statement is
          made under penalty of perjury;
          <br />
          and your electronic or physical signature (which may be a scanned
          copy).
        </p>
        <p>
          The foregoing process applies to copyright only. If you discover any
          Content that you believe to be in violation of your trademark rights,
          please report this to us by mail or email at 124 Broadkill Rd #483,
          Milton, DE 19968-1008 or{" "}
          <a
            target="_blank"
            href="mailto:hello@Letterpad.app"
            rel="noopener noreferrer"
          >
            hello@Letterpad.app
          </a>
          . In all other cases, if you discover Content that infringes any or
          violates any of your other rights, which you believe is defamatory,
          pornographic, obscene, racist or otherwise liable to cause widespread
          offence, or which constitutes impersonation, harassment, spam or
          otherwise violates these Terms of Use or applicable law, please report
          this to us at 124 Broadkill Rd #483, Milton, DE 19968-1008 or
          hello@Letterpad.app.
        </p>
        <h2>17. Repeat Infringer Policy.</h2>
        <p>
          In accordance with the DMCA and other applicable laws around the
          world, Letterpad has adopted a policy that it will promptly terminate
          without notice any user's access to the Service if that user is
          determined by Letterpad to be a "repeat infringer." A repeat infringer
          includes, without limitation a user who has been notified by Letterpad
          of infringing activity violations more than twice and/or who has had
          any user-submitted content removed from the Service more than twice.
          Letterpad may also at our sole discretion limit access to the Service
          and/or terminate the access of any users who infringe any intellectual
          property rights of others, whether or not there is any repeat
          infringement.
        </p>
        <p>
          In addition, Letterpad accommodates and does not interfere with
          standard technical measures used by intellectual property rights
          owners to protect their materials.
        </p>
        <p>
          Please note that we do not offer refunds to Users whose access is
          terminated as a result of repeated infringement of these Terms of Use.
        </p>
        <h2>18. Limitation of Liability.</h2>
        <p>
          In no event shall Letterpad be liable for any damages whatsoever,
          whether direct, indirect, general, special, compensatory,
          consequential, and/or incidental, arising out of or relating to the
          Websites or Service, or use thereof. Nothing contained in the Websites
          or Service or in any written or oral communications from Letterpad or
          its employees or agents shall be construed to make any promise,
          covenant, warranty, or guaranty, all of which are explicitly
          disclaimed hereby, contrary to the statements and disclaimers
          contained in this paragraph.
        </p>
        <p>
          The content and functionality on the Websites and Service, along with
          the services provided by employees of the Websites and Service, are
          offered "as is" without warranty of any kind, either express or
          implied, including, without limitation, implied warranties of
          merchantability, fitness for a particular purpose, title and
          non-infringement. Letterpad makes no warranties, express or implied,
          as to the ownership, accuracy, completeness or adequacy of the
          Websites\’ content or that the functionality of the Websites or
          Service will be uninterrupted or error-free or free from virus or
          third party attack. You hereby acknowledge that your use of the
          Websites and the Service is at your sole risk. UNDER NO CIRCUMSTANCES
          SHALL Letterpad, ITS OFFICERS, OWNERS, EMPLOYEES OR AGENTS AND THEIR
          RESPECTIVE HEIRS, SUCCESSORS AND ASSIGNS BE LIABLE FOR ANY DAMAGES,
          INCLUDING DIRECT, INCIDENTAL, PUNITIVE, SPECIAL, CONSEQUENTIAL OR
          EXEMPLARY DAMAGES THAT DIRECTLY OR INDIRECTLY RESULT FROM USE OF, OR
          INABILITY TO USE, THE WEBSITES OR SERVICE OR THE INFORMATION CONTAINED
          THEREIN, INCLUDING WITHOUT LIMITATION FOR VIRUSES ALLEGED TO HAVE BEEN
          OBTAINED FROM THE WEBSITES OR SERVICE, EVEN IF Letterpad HAS BEEN
          NOTIFIED OF THE POSSIBILITY OF SUCH DAMAGES OR LOSSES AND REGARDLESS
          OF THE THEORY OF LIABILITY.
        </p>
        <p>
          TO THE GREATEST EXTENT PERMITTED BY LAW, YOU AGREE THAT IN NO EVENT
          WILL Letterpad HAVE ANY LIABILITY, CONTINGENT OR OTHERWISE, FOR ANY
          INDIRECT, SPECIAL, INCIDENTAL, CONSEQUENTIAL, OR EXEMPLARY DAMAGES IN
          ANY WAY ARISING OUT OF OR RELATING TO THE AGREEMENT, WEBSITES OR THE
          SERVICE, AND ANY CONTENT INCLUDED ON THE WEBSITES OR THE SERVICE,
          INCLUDING, BUT NOT LIMITED TO: LOST PROFITS; LOST DATA; LOSS OF
          GOODWILL; INFRINGEMENT OF COPYRIGHT, TRADEMARK, OR OTHER INTELLECTUAL
          PROPERTY RIGHT; WORK STOPPAGE; EQUIPMENT FAILURE OR MALFUNCTION;
          PERSONAL INJURY; PROPERTY DAMAGE; OR ANY OTHER DAMAGES OR LOSSES, EVEN
          IF Letterpad HAS BEEN ADVISED OF THE POSSIBILITY THEREOF, AND
          REGARDLESS OF THE LEGAL OR EQUITABLE THEORY (CONTRACT, TORT, STATUTE,
          INDEMNITY OR OTHERWISE) UPON WHICH SUCH LIABILITY IS BASED.
        </p>
        <p>
          In the event that any of the foregoing limitations are deemed to be
          unenforceable, to the greatest extent permitted by law, you agree that
          the entire aggregate liability of Letterpad and sole remedy available
          to any User in any case in any way arising out of or relating to the
          Agreement, Websites or the Service shall be limited to monetary
          damages that in the aggregate may not exceed the greater of $100.00 or
          the sum of any amount paid by the User to Letterpad during the six
          months prior to notice to Letterpad of the dispute for which the
          remedy is sought.
        </p>
        <h2>19. Indemnity by You.</h2>
        <p>
          You agree to indemnify and hold Letterpad, its subsidiaries,
          affiliates, officers, agents, and other partners and employees,
          harmless from any loss, liability, claim, or demand, including
          reasonable attorneys' fees, arising out of or related to:
        </p>
        <p>
          your use of the Service and/or Websites in violation of this Terms of
          Use and/or arising from a breach of this Terms of Use including
          without limitation your representations and warranties set forth
          above;
          <br />
          any third party claim of infringement of copyright or other
          intellectual property rights or invasion of privacy arising from the
          hosting of Your Content on the Websites, and/or your making available
          thereof to other users of the Websites, and/or the actual use of Your
          Content by other users of the Websites or related services in
          accordance with these Terms of Use and the parameters set by you with
          respect to the distribution and sharing of Your Content;
          <br />
          any activity related to your use of the Websites, be it by you or by
          any other person accessing your device with or without your consent
          unless such activity was caused by the act or default of Letterpad.
        </p>
        <h2>20. Attorney Fees.</h2>
        <p>
          In the event that Letterpad is successful in whole or in part in any
          action or proceeding related to or arising from this Terms of Use, you
          shall be responsible for Letterpads attorneys' fees and costs.
        </p>
        <h2>21. Parental or Guardian Permission.</h2>
        <p>
          Some of the Content on the Websites may not be appropriate for
          children. CHILDREN UNDER THE AGE OF 13 ARE NOT PERMITTED TO USE THE
          WEBSITES AND/OR SERVICE UNLESS A SUPERVISING PARENT OR GUARDIAN IS
          PRESENT. INDIVIDUALS UNDER THE AGE OF 13 ARE NOT PERMITTED TO
          SUBSCRIBE TO OUR FEE-BASED SERVICES OR GIVE Letterpad THEIR EMAIL
          ADDRESS OR ANY OTHER PERSONALLY IDENTIFIABLE INFORMATION.
        </p>
        <h2>22. Privacy.</h2>
        <p>
          Use of the Websites and/or the Service is also governed by our Privacy
          Policy.
        </p>
        <h2>23. Jurisdiction and Choice of Law; Dispute Resolution.</h2>
        <p>
          If there is any dispute arising out of the Websites and/or the
          Service, by using the Websites and/or Service, you expressly agree
          that any such dispute shall be governed by the laws of the State of
          Delaware, without regard to its conflict of law provisions, and you
          expressly agree and consent to the exclusive jurisdiction and venue of
          the state and federal courts of the State of Delaware, for the
          resolution of any such dispute. Acceptance of the terms and conditions
          of this Agreement constitutes your consent to be sued in such courts
          and to accept service of process outside the State of Delaware with
          the same force and effect as if such service had been made within the
          State of Delaware. You hereby agree to accept service of process for
          any action hereunder by certified mail return receipt requested which
          service shall have the same force and effect as though service had
          been effected by personal service in the applicable jurisdiction. Any
          dispute must be filed within one year after the relevant claim arose;
          otherwise, the dispute is permanently barred, which means that you and
          Letterpad will not have the right to assert the claim. If any part of
          these terms is unlawful, void, or unenforceable, that part will be
          deemed severable and will not affect the validity and enforceability
          of the remaining provisions.
        </p>
        <h2>24. Arbitration Provision/No Class Action.</h2>
        <p>
          Except where prohibited by law, as a condition of using the Websites
          and/or Service, you agree that any and all disputes, claims and causes
          of action (collectively, "Claim") arising out of or connected with the
          Websites and/or Service, shall be resolved individually, without
          resort to any form of class action, exclusively by binding arbitration
          for full and final settlement of such Claim, and judgment on the award
          rendered in the arbitration may be entered in any court having
          jurisdiction thereof. The parties shall split the arbitration and/or
          mediator costs. An award rendered by the arbitrator(s) may be entered
          and confirmed by the courts of the State of Delaware, County of
          Sussex, or the United States District Court for the District of
          Delaware. The parties agree that any post-arbitration action seeking
          to enforce an arbitration award or action seeking equitable or
          injunctive relief shall be brought exclusively in the courts of the
          State of Delaware, County of Sussex, or the United States District
          Court for the District of Delaware.
        </p>
        <h2>25. No Third Party Beneficiaries.</h2>
        <p>
          You agree that, except as otherwise expressly provided in this Terms
          of Use, there shall be no third party beneficiaries to this Terms of
          Use.
        </p>
        <h2>26. Availability Outside the U.S.</h2>
        <p>
          If you access Letterpad from outside of the United States, you do so
          at your own risk and are responsible for compliance with the laws of
          your jurisdiction. If you access the Websites or Service from outside
          of the United States, you acknowledge that any personal information
          you provide will be processed in the United States and other
          geographies as selected by us in our sole discretion, and you hereby
          consent to the collection and processing of your personal information
          in a manner consistent with this Agreement and the Privacy Policy.
        </p>
        <h2>27. Entire Agreement.</h2>
        <p>
          This Terms of Use, along with the Privacy Policy, contains the entire
          agreement between you and Letterpad regarding the use of the Websites
          and/or the Service.
        </p>
        <h2>28. Severability; Waiver.</h2>
        <p>
          If any provision of this Terms of Use is found to be invalid by any
          court having competent jurisdiction, the invalidity of such provision
          shall not affect the validity of the remaining provisions of this
          Terms of Use, which shall remain in full force and effect. No waiver
          of any term of this Terms of Use shall be deemed a further or
          continuing waiver of such term or any other term. In addition,
          Letterpads failure to enforce any term of this Terms of Use shall not
          be deemed as a waiver of such term or otherwise affect Letterpads
          ability to enforce such term at any point in the future.
        </p>
        <h2>29. Headings.</h2>
        <p>
          The section headings contained in this Terms of Use are for reference
          purposes only and shall not in any way affect the meaning or
          interpretation of this Terms of Use.
        </p>
        <p>
          Please contact us with any questions regarding this agreement.
          Letterpad is a trademark of LinearBytes Inc.
        </p>
        <p>
          Letterpad reserves all rights not expressly granted in these Terms of
          Use.
        </p>
        <p>
          Our AI and PRO related terms can be found <a href="/terms/ai">here</a>{" "}
          and <a href="/terms/pro">here</a>.
        </p>
      </div>
    </>
  );
};

export default Terms;
