/* eslint-disable react/no-unescaped-entities */
const Privacy = () => {
  return (
    <>
      <div className="flex items-center flex-col py-32 bg-zinc-800 shadow">
        <h1 className="font-bold text-3xl">Privacy Policy</h1>
        <time>
          Updated on January 17, 2021 · Effective from January 17, 2021
        </time>
      </div>
      <div className="prose dark:prose-dark max-w-3xl mx-auto mt-10">
        <p>
          Letterpad ("Letterpad," "we," or "our"), recognizes the importance of
          your personal privacy. Therefore, we have created this Privacy Policy
          so that you know how we use, maintain, and disclose your information
          when you make it available to us. The Privacy Policy below discloses
          our practices regarding information collection and usage for the
          website located at letterpad.app, any other URL provided by Letterpad,
          and the related mobile website (collectively, the "Websites"), and the
          Letterpad service provided thereon (the "Service").
        </p>
        <p>
          By using or accessing the Websites and the Service, you signify your
          agreement to be bound by this Privacy Policy. IF YOU DO NOT AGREE TO
          THIS PRIVACY POLICY YOU MAY NOT ACCESS OR OTHERWISE USE OUR SERVICE OR
          PARTICIPATE IN OUR SERVICES.
        </p>
        <p>
          Key aspects of our privacy practices described in this Privacy Policy
          include the following explanations:
        </p>
        <p>
          The information we collect and why we collect it; How we use that
          information;
          <br />
          How we share information; and
          <br />
          The choices we offer.
        </p>
        <h2>1. Scope of this Privacy Policy</h2>
        <p>
          This Privacy Policy only applies to your use of the Websites and/or
          the Service and does not extend to any websites or services that are
          referenced by to linked to from the Websites, whether by Us or another
          user. Your use of any other websites or service is subject to that
          website’s or service’s privacy policy and we have no control over how
          your data is collected, used, or stored by other websites or services.
          You are advised to check the privacy policies of any such websites or
          services before providing data to them.
        </p>
        <h2>2. Information You Provide To Us:</h2>
        <p>
          The information we collect on or through the Websites and/or Service
          may include:
        </p>
        <ul>
          <li>
            Information that you provide by filling in forms on the Website
            and/or Service. This includes information provided at the time of
            registering to use the Service, subscribing to the Services, posting
            material on the Service, or requesting further services. We may also
            ask you for information when you enter a contest or promotion
            sponsored by us, and when you report a problem with the Websites
            and/or Service.
          </li>
          <li>
            Records and copies of your correspondence (including email
            addresses), if you contact us.
          </li>
          <li>
            Your responses to surveys that we might ask you to complete for
            research purposes.
          </li>
          <li>
            Details of transactions you carry out through our Website and of the
            fulfillment of your orders. You may be required to provide financial
            information before placing an order through the Websites
          </li>
          <li>Your search queries on the Websites or via the Service</li>
          <li>
            Your name, contact information (including, without limitation,
            address and email address), photograph, and information for your
            public profile.
          </li>
        </ul>
        <p>
          You also may provide information to be published or displayed
          (hereinafter, "posted") on public areas of the Websites or via the
          Service, or transmitted to other users of the Websites or third
          parties (collectively, "User Contributions"). Your User Contributions
          are posted on and transmitted to others at your own risk. Although we
          limit access to certain pages, please be aware that no security
          measures are perfect or impenetrable. Additionally, we cannot control
          the actions of other users of the Websites or Service.
        </p>
        <h2>
          3. Information We Collect Through Automatic Data Collection
          Technologies:
        </h2>
        <p>
          As you navigate through and interact with the Websites and/or the
          Service, we may use automatic data collection technologies to collect
          certain information about your equipment, browsing actions, and
          patterns, including:
        </p>
        <ul>
          <li>
            Details of your visits to the Websites and the Service, including
            traffic data, location data, logs, and other communication data and
            the resources that you access and use on the Websites and Service.
          </li>
          <li>
            Information about your computer and internet connection, including
            your IP address, operating system, and browser type.
          </li>
        </ul>
        <p>
          The information we collect automatically is only statistical data and
          does not include personal information, but we may maintain it or
          associate it with personal information we collect in other ways or
          receive from third parties. It helps us to improve the Websites and
          Service and to deliver a better and more personalized service,
          including by enabling us to:
        </p>
        <ul>
          <li>Estimate our audience size and usage patterns.</li>
          <li>
            Store information about your preferences, allowing us to customize
            the Websites and Service according to your individual interests.
          </li>
          <li>Speed up your searches.</li>
          <li>Recognize you when you return to the Websites or Service.</li>
        </ul>
        <p>
          The technologies we use for this automatic data collection may include
          cookies, flash cookies, and web beacons.
        </p>
        <ul>
          <li>
            Cookies (or browser cookies) Cookies are a small file placed on the
            hard drive of your device. You may refuse to accept browser cookies
            by activating the appropriate setting on your browser. However, if
            you select this setting you may be unable to access certain parts of
            the Websites or Service. Unless you have adjusted your browser
            setting so that it will refuse cookies, our system will issue
            cookies when you direct your browser to the Websites and/or Service.
          </li>
          <li>
            Flash Cookies. Certain features of the Websites or Service may use
            local stored objects (or Flash cookies) to collect and store
            information about your preferences and navigation to, from, and on
            the Websites or Service. Flash cookies are not managed by the same
            browser settings as are used for browser cookies.
          </li>
          <li>
            Web Beacons. Pages of the Websites and our e-mails may contain small
            electronic files known as web beacons (also referred to as clear
            gifs, pixel tags, and single-pixel gifs) that permit the Company,
            for example, to count users who have visited those pages or opened
            an email and for other related website statistics (for example,
            recording the popularity of certain website content and verifying
            system and server integrity).{" "}
          </li>
        </ul>
        <p>
          If you delete your cookies, change browsers or use a different cookie,
          our cookie (or an opt-out cookie) may no longer work and you will have
          to reinput (or opt-out) again.
        </p>
        <p>
          We use cookies on the Websites for Google Analytics (the "Analytics
          Service"). The Analytics Service is a web analytics tool that helps
          website owners understand how visitors engage with their website. The
          Analytics Service customers can view a variety of reports about how
          visitors interact with their website so that they can improve it.
        </p>
        <p>
          Like many services, the Analytics Service uses first-party cookies to
          track visitor interactions as in our case, where they are used to
          collect information about how visitors use the Websites. We then use
          the information to compile reports and to help us improve the
          Websites.
        </p>
        <p>
          Cookies contain information that is transferred to your computer’s
          hard drive. These cookies are used to store information, such as the
          time that the current visit occurred, whether the visitor has been to
          the site before and what site referred the visitor to the web page.
        </p>
        <p>
          The Analytics Service collects information anonymously. It reports
          website trends without identifying individual visitors. You can opt
          out of the Analytics Service without affecting how you visit the
          Websites. For more information on opting out of being tracked by
          Google Analytics across all websites you use, visit{" "}
          <a
            href="https://tools.google.com/dlpage/gaoptout"
            target="_blank"
            rel="noopener noreferrer"
          >
            https://tools.google.com/dlpage/gaoptout
          </a>
          .
        </p>
        <p>
          We also use Google conversion tracking and/or similar services to help
          us understand your and other users’ use of the Service.
        </p>
        <p>
          Please see{" "}
          <a
            target="_blank"
            href="https://support.google.com/adwords/answer/1722022?hl=en"
            rel="noopener noreferrer"
          >
            https://support.google.com/adwords/answer/1722022?hl=en
          </a>{" "}
          for more information about conversion tracking provided by Google.
        </p>
        <p>
          It is possible at times when collecting non-personally identifiable
          information through automatic means that we may unintentionally
          collect or receive personally identifiable information that is mixed
          in with the non-personally identifiable information. While we will
          make reasonable efforts to prevent such incidental data collection,
          the possibility still exists. If you believe that we have
          inadvertently collected your personal information, please notify us at{" "}
          <a
            target="_blank"
            href="mailto:admin@letterpad.app"
            rel="noopener noreferrer"
          >
            admin@letterpad.app
          </a>
          .
        </p>
        <h2>4. How We Use Your Information:</h2>
        <p>
          We use information that we collect about you or that you provide to
          us, including any personal information:
        </p>
        <ul>
          <li>To present the Websites and their contents to you.</li>
          <li>To provide the Service to you.</li>
          <li>To create and maintain your Letterpad account.</li>
          <li>
            To provide you with information, products, or services that you
            request from us.
          </li>
          <li>To fulfill any other purpose for which you provide it.</li>
          <li>To provide you with notices about your account.</li>
          <li>
            To carry out our obligations and enforce our rights arising from any
            contracts entered into between you and us, including for billing and
            collection.
          </li>
          <li>
            To notify you about changes to the Websites, the Service, or any
            products or services we offer or provide though it.
          </li>
          <li>
            To allow you to participate in interactive features on the Websites.
          </li>
          <li>
            In any other way we may describe when you provide the information.
          </li>
          <li>For any other purpose with your consent.</li>
        </ul>
        <p>
          By uploading your name and/or photograph to the Websites, you agree
          that this information will be posted publicly on the Websites.
        </p>
        <p>
          [We may use the information we have collected from you to enable us to
          display advertisements to our advertisers' target audiences. Even
          though we do not disclose your personal information for these purposes
          without your consent, if you click on or otherwise interact with an
          advertisement, the advertiser may assume that you meet its target
          criteria.]
        </p>
        <h2>5. Disclosure of Your Information:</h2>
        <p>
          We may disclose aggregated information about our users, and
          information that does not identify any individual, without
          restriction.
        </p>
        <p>
          We may disclose personal information that we collect or you provide as
          described in this privacy policy:
        </p>
        <ul>
          <li>To our subsidiaries and affiliates.</li>
          <li>
            To contractors, service providers, and other third parties we use to
            support our business and who are bound by contractual obligations to
            keep personal information confidential and use it only for the
            purposes for which we disclose it to them.
          </li>
          <li>
            To a buyer or other successor in the event of a merger, divestiture,
            restructuring, reorganization, dissolution, or other sale or
            transfer of some or all of Letterpad's assets, whether as a going
            concern or as part of bankruptcy, liquidation, or similar
            proceeding, in which personal information held by Letterpad about
            our Websites’ users is among the assets transferred.
          </li>
          <li>
            To third parties (collectively, the "Third Party Vendors") to
            further the purpose for which you provided such information to us.
            For example, we may share your information our email platform, for
            the purpose of sending emails or with other vendors for the purposes
            of payment processing, delivery of goods, search engine facilities,
            advertising and marketing.
          </li>
          <li>To fulfill the purpose for which you provide it.</li>
          <li>
            For any other purpose disclosed by us when you provide the
            information.
          </li>
          <li>With your consent.</li>
        </ul>
        <p>We may also disclose your personal information:</p>
        <ul>
          <li>
            To comply with any court order, law, or legal process, including to
            respond to any government or regulatory request.
          </li>
          <li>
            To enforce or apply our Terms of Use and other agreements, including
            for billing and collection purposes.
          </li>
          <li>
            If we believe disclosure is necessary or appropriate to protect the
            rights, property, or safety of Letterpad, our customers, or others.
            This includes exchanging information with other companies and
            organizations for the purposes of fraud protection and credit risk
            reduction.
          </li>
        </ul>
        <p>
          Where any of your data is required by a Third Party Vendor, We will
          take all reasonable steps to ensure that your data will be handled
          safely, securely, and in accordance with your rights, Our obligations,
          and the obligations of the third party under the law. We urge you to
          read the privacy practices of all of our Third Party Vendors before
          submitting any information through the Service.
        </p>
        <p>
          For example, the Service may allow the capability for individuals or
          entities (“Sponsors”) to sponsor articles (a “Sponsorship”) authored
          by users of the Service (“Creators”) with a monetary payment conducted
          via integration with third-party payment platform, such as Stripe or
          PayPal. Such third-party payment platforms have their own terms of
          service and privacy policies which you as either a Sponsor or a
          Creator will need to accept in order to conduct a Sponsorship, and you
          will need to provide such applicable information to the third-party
          payment platform. Letterpad does not access nor retain any such
          payment information, for Sponsorships.
        </p>
        <h2>6. How You Can Control Your Data</h2>
        <p>
          When you submit information via the Websites, you may be given options
          to restrict Our use of your data. We aim to give you control on Our
          use of your data (including the ability to opt-out of receiving emails
          from Us which you may do by unsubscribing using the links provided in
          Our emails).
        </p>
        <h2 id="delete-account">7. Accessing Your Data</h2>
        <p>
          You can review and change your personal information by logging into
          the Websites and visiting your account profile page.
        </p>
        <p>
          You may also send us an email at{" "}
          <a
            target="_blank"
            href="mailto:admin@letterpad.app"
            rel="noopener noreferrer"
          >
            admin@letterpad.app
          </a>{" "}
          to request access to, correct or delete any personal information that
          you have provided to us. Sometimes, we may not be able to delete your
          personal information except by also deleting your user account. We may
          not accommodate a request to change information if we believe the
          change would violate any law or legal requirement or cause the
          information to be incorrect.
        </p>
        <p>
          Proper access and use of information provided on the Websites,
          including your contributions, is governed by our{" "}
          <a href="/terms">Terms of Use</a>.
        </p>
        <p>
          You have the legal right to ask for a copy of any of your personal
          data held by Us (where such data is held). Please contact Us for more
          details at using the information in the Contact section below.
        </p>
        <p>
          Right to Withhold Information and Your Right to Withdraw Information
          After You Have Given It
        </p>
        <p>
          For European users subject to GDPR, you may access certain areas of
          the Websites without providing any data at all. However, to use all
          features and functions available on The Websites you may be required
          to submit or allow for the collection of certain data.
        </p>
        <p>
          You may restrict your internet browser’s use of Cookies and clear
          Cookies from your browser at any time.
        </p>
        <p>
          You may withdraw your consent for Us to use your personal data as set
          out in this privacy policy at any time by contacting Us using the
          information in the Contact section below, and We will delete Your data
          from Our systems. However, you acknowledge that this may limit our
          ability to provide the best possible product and services to you.
        </p>
        <h2>8. Your Disclosures In Blogs And Other Social Media:</h2>
        <p>
          You should be aware that information which you voluntarily include and
          transmit online on the Service or in a publicly accessible blog, chat
          room, social media platform or otherwise online, or that you share in
          an open forum such as an in-person panel or survey, may be viewed and
          used by others without any restrictions. We are unable to control such
          uses of your information, and by using the Service or any other online
          services you assume the risk that the information provided by you may
          be viewed and used by third parties for any number of purposes.
        </p>
        <p>
          If you login to the Websites and/or Service through your Facebook
          account, connect to a third party service such as Facebook or Twitter
          through an icon or link on the Service or otherwise link your
          Letterpad account with a third party service, we may share the
          contents of your post and associated information (such as your user
          name, the fact that your connection originated from the Service, and
          other relevant usage and diagnostic information) with such third
          party. With your one-time consent, we may also send information about
          the content you watch and your activities on the Service to such third
          parties. Once such information is shared, the use of your information
          will be subject to that service's privacy policy and this Privacy
          Policy will not apply.
        </p>
        <h2>9. Security:</h2>
        <p>
          The security of your information is very important to us. We have
          implemented measures designed to secure your personal information from
          accidental loss and from unauthorized access, use, alteration, and
          disclosure. However, due to the inherent open nature of the Internet,
          we cannot guarantee that your information will be completely free from
          unauthorized access by third parties such as hackers and your use of
          our Service demonstrates your assumption of this risk. Only those
          employees who need access to your information in order to perform
          their duties are authorized to have access to your information. For
          more information on protecting your privacy, please visit{" "}
          <a
            href="https://www.ftc.gov/privacy"
            target="_blank"
            rel="noopener noreferrer"
          >
            www.ftc.gov/privacy
          </a>
          .
        </p>
        <p>
          Specific steps we take to secure and protect your data include, but
          are not limited to:
        </p>
        <p>
          Encrypting the connection between our website and your computer;{" "}
          <br />
          Ensuring the physical and digital security of the servers holding your
          data;
          <br />
          Controlling the access Our staff and contractors have to the data to
          ensure that only authorised personnel are able to access the data.
          <br />
          Notwithstanding the security measures that We take, it is important to
          remember that the transmission of data via the internet may not be
          completely secure and that you are advised to take suitable
          precautions when transmitting to Us data via the internet.
        </p>
        <p>
          The safety and security of your information also depends on you. Where
          we have given you (or where you have chosen) a password for access to
          certain parts of the Websites or Service, you are responsible for
          keeping this password confidential. We ask you not to share your
          password with anyone
        </p>
        <p>
          Unfortunately, the transmission of information via the internet is not
          completely secure. Although we do our best to protect your personal
          information, we cannot guarantee the security of your personal
          information transmitted to the Websites or Service. Any transmission
          of personal information is at your own risk. We are not responsible
          for circumvention of any privacy settings or security measures
          contained on the Websites or Service.
        </p>
        <p>
          We only keep your data for as long as We need to in order to use it as
          described above, or for as long as We have your permission to keep it.
          In any event, We will conduct an annual review to ascertain whether we
          need to keep your data. Your data will be deleted if we no longer need
          it in accordance with the terms of our Data Retention Policy.
        </p>
        <p>
          Some or all of your data may be stored or transferred outside of the
          European Economic Area (“the EEA”) (The EEA consists of all EU member
          states, plus Norway, Iceland and Liechtenstein). You are deemed to
          accept and agree to this by using The Websites and submitting
          information to Us. If We do store or transfer data outside the EEA, We
          will take all reasonable steps to ensure that your data is treated as
          safely and securely as it would be within the EEA and under the GDPR.
          Such steps may include, but not be limited to, the use of legally
          binding contractual terms between Us and any third parties We engage
          and the use of the EU-approved Model Contractual Arrangements.
        </p>
        <h2>10. Protection for Children:</h2>
        <p>
          We do not collect personally identifiable information from children
          under the age of 13. If at any time in the future we plan to collect
          personally identifiable information from children under 13, such
          collection and use, to the extent applicable, shall, when required, be
          done in compliance with the Children’s Online Privacy Protection Act
          ("COPPA") and appropriate consent from the child’s parent or guardian
          will be sought where required by COPPA. When we become aware that
          personally identifiable information from a child under 13 has been
          collected without such child’s parent or guardian’s consent, we will
          use all reasonable efforts to delete such information from our
          database. If you believe your child or minor guardian has provided us
          information without your consent, please contact us at{" "}
          <a
            target="_blank"
            href="mailto:admin@letterpad.app"
            rel="noopener noreferrer"
          >
            admin@letterpad.app
          </a>
          .
        </p>
        <h2>11. Other Services:</h2>
        <p>
          As a convenience to you, we may provide links to third-party services
          from within our Service. We are not responsible for the privacy
          practices or content of these third-party sites. When you link away
          from our Service, you do so at your own risk.
        </p>
        <h2>12. Changes to this Privacy Policy:</h2>
        <p>
          We reserve the right, at our discretion, to change, modify, add, or
          remove portions from this Privacy Policy at any time. However, if at
          any time in the future we plan to use information in a way that
          materially differs from this Privacy Policy, including sharing such
          information with more third parties, we will post such changes here
          and provide you the opportunity to opt-out of such differing uses.
          Your continued use of the Service and our services following the
          posting of any changes to this Privacy Policy means you accept such
          changes.
        </p>
        <h2>13. Opt-Out Process:</h2>
        <p>
          All unsubscribe or opt-out requests may be made by clicking the
          "unsubscribe" link at the bottom of the email or by changing the email
          preferences in your account settings. We will process your request
          within a reasonable time after receipt. However, we are not
          responsible for, and in some cases we are incapable of, removing your
          personally identifiable information from the lists of any third party
          who has previously been provided your information in accordance with
          this Privacy Policy or your consent. You should contact such third
          parties directly. If you would like to update or correct any
          personally identifiable information that you have provided to us,
          please email us at Letterpad and once we confirm your information, we
          will update such information within a reasonable amount of time.
        </p>
        <h2>14. Communications with Letterpad:</h2>
        <p>
          By providing your email address, phone number, and/or social media
          information (collectively the "Channels") to us, you expressly consent
          to receive communications from us. We may use the Channels to
          communicate with you, to send information that you have requested or
          to send information about other products or services developed or
          provided by us or our business partners, provided that, we will not
          give your contact information to another party to promote their
          products or services directly to you without your consent or as set
          forth in this Privacy Policy.
        </p>
        <p>
          By providing your phone number to us, you expressly consent to receive
          phone calls and/or text messages from us. We will not give your phone
          number to another party to promote their products or services directly
          to you without your consent or as set forth in this Privacy Policy.
        </p>
        <p>
          Any phone calls and/or text messages delivered to your phone or device
          may cause you to incur extra data, text messaging, or other charges
          from your wireless carrier. MESSAGE AND DATA RATES MAY APPLY. You are
          solely responsible for any carrier charges incurred as a result of
          phone and/or text communications from Letterpad.
        </p>
        <p>
          Any communication or material you transmit to us by email or
          otherwise, including any data, questions, comments, suggestions, or
          the like is, and will be treated as, non-confidential and
          nonproprietary. Except to the extent expressly covered by this Privacy
          Policy, anything you transmit or post may be used by us for any
          purpose, including but not limited to, reproduction, disclosure,
          transmission, publication, broadcast and posting. Furthermore, you
          expressly agree that we are free to use any ideas, concepts, know-how,
          or techniques contained in any communication you send to us, as well
          as any data developed using the content of such communication, without
          compensation and for any purpose whatsoever, including but not limited
          to, developing, manufacturing and marketing products and services
          using such information.
        </p>
        <h2>15. No Rights of Third Parties:</h2>
        <p>
          This Privacy Policy does not create rights enforceable by third
          parties, nor does it require disclosure of any personal information
          relating to users of the Service.
        </p>
        <h2>16. Site Terms of Use:</h2>
        <p>
          Use of this Service is governed by, and subject to, the Terms of Use
          located at the "Terms". This Privacy Policy is incorporated into the
          Terms. Your use, or access, of the Service constitutes your agreement
          to be bound by these provisions. IF YOU DO NOT AGREE TO THE TERMS AND
          THIS PRIVACY POLICY YOU MAY NOT ACCESS OR OTHERWISE USE THE SERVICE.
        </p>
        <h2>17. Servers:</h2>
        <p>
          Our servers are maintained in the United States. By using the Service,
          you freely and specifically give us your consent to export your
          personally identifiable information to the United States and to store
          and use it in the United States as specified in this Privacy Policy.
          You understand that data stored in the United States may be subject to
          lawful requests by the courts or law enforcement authorities in the
          United States.
        </p>
        <h2>18. European Citizens – Your Rights Under GDPR:</h2>
        <p>
          All personal data is stored securely in accordance with the EU General
          Data Protection Regulation (Regulation (EU) 2016/679) (GDPR). For more
          details on security see section 9 (Security) above.
        </p>
        <p>
          In some cases, the collection of data may be a statutory or
          contractual requirement, and We will be limited in the products and
          services We can provide you without your consent for Us to be able to
          use such data.
        </p>
        <p>
          Under GDPR we will ensure that your personal data is processed
          lawfully, fairly, and transparently, without adversely affecting your
          rights. We will only process your personal data if at least one of the
          following basis applies:
        </p>
        <p>
          you have given consent to the processing of your personal data for one
          or more specific purposes;
          <br />
          processing is necessary for the performance of a contract to which you
          are a party or in order to take steps at the request of you prior to
          entering into a contract;
          <br />
          processing is necessary for compliance with a legal obligation to
          which we are subject;
          <br />
          processing is necessary to protect the vital interests of you or of
          another natural person; <br />
          processing is necessary for the performance of a task carried out in
          the public interest or in the exercise of official authority vested in
          the controller; and/or
          <br />
          processing is necessary for the purposes of the legitimate interests
          pursued by us or by a third party, except where such interests are
          overridden by the fundamental rights and freedoms of the data subject
          which require protection of personal data, in particular where the
          data subject is a child.
        </p>
        <p>Under the GDPR, you have:</p>
        <p>
          the right to request access to, deletion of or correction of, your
          personal data held by Us; the right to complain to a supervisory
          authority;
          <br />
          be informed of what data processing is taking place;
          <br />
          the right to restrict processing;
          <br />
          the right to data portability;
          <br />
          object to processing of your personal data;
          <br />
          rights with respect to automated decision-making and profiling.
          <br />
          To enforce any of the foregoing rights or if you have any other
          questions about The Websites or this Privacy Policy, please contact Us
          using the details set out in the Contact section below.
        </p>
        <p>
          Non-personally identifiable or aggregate information may be used by us
          for any purposes permitted by law and may be shared with any number of
          parties, provided that such information shall not specifically
          identify you.
        </p>
        <h2>19. Governing Law:</h2>
        <p>
          This Privacy Policy and our legal obligations hereunder are subject to
          the laws of Delaware regardless of your location. You hereby consent
          to the exclusive jurisdiction of and venue in the courts located in
          Sussex County, Delaware, in all disputes arising out of or relating to
          the Services.
        </p>
        <h2>20. Contact:</h2>
        <p>
          For questions or concerns relating to privacy, we can be contacted at{" "}
          <a
            target="_blank"
            href="mailto:admin@letterpad.app"
            rel="noopener noreferrer"
          >
            admin@letterpad.app
          </a>
          .
        </p>
        <p>
          Our data protection officer is Abhishek Saha who can be contacted at{" "}
          <a
            target="_blank"
            href="mailto:admin@letterpad.app"
            rel="noopener noreferrer"
          >
            admin@letterpad.app
          </a>
          .
        </p>
      </div>
    </>
  );
};

export default Privacy;
