-- RedefineTables
PRAGMA foreign_keys=OFF;
CREATE TABLE "new_Post" (
    "id" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
    "title" TEXT NOT NULL DEFAULT '',
    "sub_title" TEXT NOT NULL DEFAULT '',
    "html" TEXT NOT NULL DEFAULT '',
    "html_draft" TEXT NOT NULL DEFAULT '',
    "excerpt" TEXT NOT NULL DEFAULT '',
    "cover_image" TEXT NOT NULL DEFAULT '',
    "cover_image_width" INTEGER NOT NULL DEFAULT 0,
    "cover_image_height" INTEGER NOT NULL DEFAULT 0,
    "type" TEXT NOT NULL DEFAULT 'post',
    "featured" BOOLEAN NOT NULL DEFAULT false,
    "status" TEXT NOT NULL DEFAULT 'draft',
    "slug" TEXT NOT NULL DEFAULT '',
    "reading_time" TEXT NOT NULL DEFAULT '',
    "publishedAt" DATETIME,
    "scheduledAt" DATETIME,
    "updatedAt" DATETIME,
    "createdAt" DATETIME DEFAULT CURRENT_TIMESTAMP,
    "author_id" INTEGER NOT NULL,
    "page_type" TEXT NOT NULL DEFAULT 'default',
    "page_data" TEXT NOT NULL DEFAULT '',
    "stats" TEXT NOT NULL DEFAULT '{}',
    "mail_status" TEXT NOT NULL DEFAULT 'INACTIVE'
);
INSERT INTO "new_Post" ("author_id", "cover_image", "cover_image_height", "cover_image_width", "createdAt", "excerpt", "featured", "html", "html_draft", "id", "page_data", "page_type", "publishedAt", "reading_time", "scheduledAt", "slug", "stats", "status", "sub_title", "title", "type", "updatedAt") SELECT "author_id", "cover_image", "cover_image_height", "cover_image_width", "createdAt", "excerpt", "featured", "html", "html_draft", "id", "page_data", "page_type", "publishedAt", "reading_time", "scheduledAt", "slug", "stats", "status", "sub_title", "title", "type", "updatedAt" FROM "Post";
DROP TABLE "Post";
ALTER TABLE "new_Post" RENAME TO "Post";
CREATE INDEX "Post_author_id_idx" ON "Post"("author_id");
CREATE INDEX "Post_status_mail_status_idx" ON "Post"("status", "mail_status");
CREATE INDEX "Post_author_id_status_slug_idx" ON "Post"("author_id", "status", "slug");
PRAGMA foreign_key_check;
PRAGMA foreign_keys=ON;
