-- net_open
-- @short: Make an outbound connection to a data source.
-- @inargs: str:host, function:handler(source:vid, strtbl:status)
-- @inargs: str:host, str:dst, function:handler(source:vid, strtbl:status)
-- @outargs: vid or BADID
-- @longdescr: This creates an outbound connection to a network resource
-- speaking the a12 protocol. If *host* starts with an @ sign and matches a
-- known tag in the keystore, the connection information and authentication
-- credentials will be picked from there. If *hosts* starts with a ? sign
-- it works as with '@' but the connection will only probe which roles the
-- target supports (source, sink or directory) and return that as a message
-- event before terminating.
--
-- If the *host* is a tag, the optional *dst* argument can be used to override
-- the hosts assigned to the tag but still use the keymaterial. This is mainly
-- to work with discovery modes such as 'passive' where the tag was found, but
-- using a dynamic address.
--
-- The connection behaves just as if it had been initiated through
-- ref:launch_target or or ref:target_alloc but the primary segment will be a
-- network type referencing the connection itself and the actual resource will
-- come as a segment_request.
--
-- If *host* starts with the reserved identifier @stdin it will try and
-- connect to an attached monitor and communicate through it with an external
-- directory server and the associated appl- group of others running the same
-- appl through the same directory.
--
-- The restricted short (alnum _) identifier used server side is determined
-- first by the arcan-net --ident argument (or when opening the directory
-- through ref:net_discover) and, on collision, generated by the directory
-- server. The one actually used will be provided in a 'message' event as
-- 'a12:join=XXXXXX' where the Xs are substituted with the actual identity.
--
-- Any higher level 'nickname' system is expected to be implemented as a nested
-- application specific protocol within the appl- message group.
--
-- Should the connection be severed, an a12:disconnected will be issued, and
-- when if/it can be resumed, a12:reconnected.
--
-- Message events received in this format must follow the argument packing in
-- builtin/string.lua:strings.unpack_shmif_argstr(src) (key=value with ':' as
-- separator, \t being substituted to ':'). They have quite short restrictions
-- (78b) and are not intended for large datastream serialisation since they can
-- have large amplification and trigger throttling in the processing chain. For
-- large transfers we have ref:open_nonblock or using the directory to create a
-- direct channel to a specific user. The server end will enforce a prefix of
-- from=name and reserve the use of an 'a12' key anywhere. It will reject
-- messages which attempts to use that.
--
-- @note: with @stdin:user expect deliveries to have multipart, meaning they
-- need to be concatenated until a terminating multipart=false arrives.
--
-- @group: network
-- @cfunction: net_open
-- @related: net_discover, launch_target
function main()
#ifdef MAIN
	net_open("laptop",
	function(source, status)
		if status.kind == "segment_request" then
			accept_target(0, 0,
				function(source, status)
					if status.kind == "resized" then
						show_image(source)
						resize_image(source, status.width, status.height)
					end
				end
			)
		end
		if status.kind == "terminated" then
			print("died", status.last_words)
			delete_image(source)
			return shutdown()
	end)
#endif

#ifdef MAIN2
	local vid = net_open("@stdin:me",
		function(source, status)
			if status.kind == "message" then

			end
		end
	)
	if not valid_vid(vid) then
		print("not connected to a directory server")
	end
#endif

#ifdef ERROR1
#endif
end
