/* Copyright (C) 2019, Nikolai Wuttke. All rights reserved.
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#pragma once

#include "data/high_score_list.hpp"
#include "frontend/game_mode.hpp"
#include "ui/text_entry_widget.hpp"


namespace rigel::ui
{

void setupHighScoreListDisplay(GameMode::Context& context, int episode);

void drawHighScoreList(GameMode::Context& context, int episode);

ui::TextEntryWidget setupHighScoreNameEntry(GameMode::Context& context);
} // namespace rigel::ui
