/* Copyright (C) 2022, Nikolai Wuttke. All rights reserved.
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef SOUNDS_H
#define SOUNDS_H

/* List of sound effect ids/numbers
 *
 * This file was most likely generated by the Muse tool in the original code.
 */

typedef enum
{
  SND_NORMAL_SHOT = 0,
  SND_BIG_EXPLOSION = 1,
  SND_DUKE_PAIN = 2,
  SND_DUKE_DEATH = 3,
  SND_EXPLOSION = 4,
  SND_MENU_SELECT = 5,
  SND_GLASS_BREAKING = 6,
  SND_DUKE_LASER_SHOT = 7,
  SND_ITEM_PICKUP = 8,
  SND_WEAPON_PICKUP = 9,
  SND_ENEMY_HIT = 10,
  SND_SWOOSH = 11,
  SND_FLAMETHROWER_SHOT = 12,
  SND_DUKE_JUMPING = 13,
  SND_LAVA_FOUNTAIN = 14,
  SND_DUKE_LANDING = 15,
  SND_ATTACH_CLIMBABLE = 16,
  SND_MESSAGE_TYPING = 17,
  SND_HAMMER_SMASH = 18,
  SND_ROCK_LANDING = 19,
  SND_ALTERNATE_EXPLOSION = 20,
  SND_WATER_DROP = 21,
  SND_FORCE_FIELD_FIZZLE = 22,
  SND_UNKNOWN1 = 23,
  SND_SLIDING_DOOR = 24,
  SND_MENU_TOGGLE = 25,
  SND_FALLING_ROCK = 26,
  SND_ENEMY_LASER_SHOT = 27,
  SND_EARTHQUAKE = 28,
  SND_BIOLOGICAL_ENEMY_DESTROYED = 29,
  SND_TELEPORT = 30,
  SND_UNKNOWN2 = 31,
  SND_HEALTH_PICKUP = 32,
  SND_LETTERS_COLLECTED_CORRECTLY = 33,
} SoundId;

// Muse would have called the enum 'soundnames'.


typedef enum
{
  SND_INTRO_GUNSHOT1 = 42,
  SND_INTRO_GUNSHOT2 = 43,
  SND_INTRO_SHELLS_CLATTER = 44,
  SND_INTRO_REEL_IN_TARGET = 45,
  SND_INTRO_TARGET_STOPS = 46,
  SND_INTRO_DUKE_SPEAKS_1 = 47,
  SND_INTRO_DUKE_SPEAKS_2 = 48
} IntroSoundId;

#define NUM_SOUNDS 34

#define STARTPCSOUNDS 0
#define STARTADLIBSOUNDS 34

// This constant was most likely not generated by Muse,
// but it fits here thematically.
#define LAST_DIGITIZED_SOUND_ID 29

#endif
