/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.fast;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseScrollBarUI;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.fast.FastScrollButton;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class FastScrollBarUI
extends BaseScrollBarUI {
    public static ComponentUI createUI(JComponent c) {
        return new FastScrollBarUI();
    }

    @Override
    protected JButton createDecreaseButton(int orientation) {
        if (AbstractLookAndFeel.getTheme().isMacStyleScrollBarOn()) {
            return super.createDecreaseButton(orientation);
        }
        return new FastScrollButton(orientation, this.scrollBarWidth);
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        if (AbstractLookAndFeel.getTheme().isMacStyleScrollBarOn()) {
            return super.createDecreaseButton(orientation);
        }
        return new FastScrollButton(orientation, this.scrollBarWidth);
    }

    @Override
    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        g.setColor(AbstractLookAndFeel.getControlColorLight());
        g.fillRect(trackBounds.x, trackBounds.y, trackBounds.width, trackBounds.height);
    }

    @Override
    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        if (!c.isEnabled()) {
            return;
        }
        g.translate(thumbBounds.x, thumbBounds.y);
        Color backColor = AbstractLookAndFeel.getTheme().getControlBackgroundColor();
        if (!JTattooUtilities.isActive(c)) {
            backColor = ColorHelper.brighter(backColor, 50.0);
        }
        Color frameColorHi = ColorHelper.brighter(backColor, 40.0);
        Color frameColorLo = ColorHelper.darker(backColor, 30.0);
        g.setColor(backColor);
        g.fillRect(1, 1, thumbBounds.width - 1, thumbBounds.height - 1);
        g.setColor(frameColorLo);
        g.drawRect(0, 0, thumbBounds.width - 1, thumbBounds.height - 1);
        g.setColor(frameColorHi);
        g.drawLine(1, 1, thumbBounds.width - 2, 1);
        g.drawLine(1, 1, 1, thumbBounds.height - 2);
        g.translate(-thumbBounds.x, -thumbBounds.y);
    }
}

