// This file is part of dpdk. It is subject to the license terms in the COPYRIGHT file found in the top-level directory of this distribution and at https://raw.githubusercontent.com/lemonrock/dpdk/master/COPYRIGHT. No part of dpdk, including this file, may be copied, modified, propagated, or distributed except according to the terms contained in the COPYRIGHT file.
// Copyright © 2016 The developers of dpdk. See the COPYRIGHT file in the top-level directory of this distribution and at https://raw.githubusercontent.com/lemonrock/dpdk/master/COPYRIGHT.


#[repr(C)]
#[repr(align(64))]
pub struct rte_mempool_ops_table
{
	pub sl: rte_spinlock_t,
	pub num_ops: u32,
	pub __bindgen_padding_0: [u64; 7usize],
	pub ops: [rte_mempool_ops; 16usize],
	pub __bindgen_align: [u8; 0usize],
}

impl Default for rte_mempool_ops_table
{
	#[inline(always)]
	fn default() -> Self
	{
		unsafe { zeroed() }
	}
}

impl Debug for rte_mempool_ops_table
{
	#[inline(always)]
	fn fmt(&self, f: &mut Formatter) -> Result
	{
		write!(f, "rte_mempool_ops_table {{ sl: {:?}, ops: {:?} }}", self.sl, self.ops)
	}
}
