// This file is part of dpdk. It is subject to the license terms in the COPYRIGHT file found in the top-level directory of this distribution and at https://raw.githubusercontent.com/lemonrock/dpdk/master/COPYRIGHT. No part of dpdk, including this file, may be copied, modified, propagated, or distributed except according to the terms contained in the COPYRIGHT file.
// Copyright © 2016 The developers of dpdk. See the COPYRIGHT file in the top-level directory of this distribution and at https://raw.githubusercontent.com/lemonrock/dpdk/master/COPYRIGHT.


extern "C"
{
	pub fn rust_rte_atomic16_cmpset(dst: *mut u16, exp: u16, src: u16) -> c_int;
	pub fn rust_rte_atomic16_dec(v: *mut rte_atomic16_t);
	pub fn rust_rte_atomic16_dec_and_test(v: *mut rte_atomic16_t) -> c_int;
	pub fn rust_rte_atomic16_exchange(dst: *mut u16, val: u16) -> u16;
	pub fn rust_rte_atomic16_inc(v: *mut rte_atomic16_t);
	pub fn rust_rte_atomic16_inc_and_test(v: *mut rte_atomic16_t) -> c_int;
	pub fn rust_rte_atomic16_test_and_set(v: *mut rte_atomic16_t) -> c_int;
	pub fn rust_rte_atomic32_cmpset(dst: *mut u32, exp: u32, src: u32) -> c_int;
	pub fn rust_rte_atomic32_dec(v: *mut rte_atomic32_t);
	pub fn rust_rte_atomic32_dec_and_test(v: *mut rte_atomic32_t) -> c_int;
	pub fn rust_rte_atomic32_exchange(dst: *mut u32, val: u32) -> u32;
	pub fn rust_rte_atomic32_inc(v: *mut rte_atomic32_t);
	pub fn rust_rte_atomic32_inc_and_test(v: *mut rte_atomic32_t) -> c_int;
	pub fn rust_rte_atomic32_test_and_set(v: *mut rte_atomic32_t) -> c_int;
	pub fn rust_rte_delay_ms(ms: c_uint);
	pub fn rust_rte_errno() -> c_int;
	pub fn rust_rte_eth_rx_burst(port_id: u16, queue_id: u16, rx_pkts: *mut *mut rte_mbuf, nb_pkts: u16) -> u16;
	pub fn rust_rte_eth_rx_descriptor_done(port_id: u16, queue_id: u16, offset: u16) -> c_int;
	pub fn rust_rte_eth_rx_descriptor_status(port_id: u16, queue_id: u16, offset: u16) -> c_int;
	pub fn rust_rte_eth_rx_queue_count(port_id: u16, queue_id: u16) -> c_int;
	pub fn rust_rte_eth_tx_buffer(port_id: u16, queue_id: u16, buffer: *mut rte_eth_dev_tx_buffer, tx_pkt: *mut rte_mbuf) -> u16;
	pub fn rust_rte_eth_tx_buffer_flush(port_id: u16, queue_id: u16, buffer: *mut rte_eth_dev_tx_buffer) -> u16;
	pub fn rust_rte_eth_tx_burst(port_id: u16, queue_id: u16, tx_pkts: *mut *mut rte_mbuf, nb_pkts: u16) -> u16;
	pub fn rust_rte_eth_tx_descriptor_status(port_id: u16, queue_id: u16, offset: u16) -> c_int;
	pub fn rust_rte_eth_tx_prepare(port_id: u16, queue_id: u16, tx_pkts: *mut *mut rte_mbuf, nb_pkts: u16) -> u16;
	pub fn rust_rte_event_dequeue_burst(dev_id: u8, port_id: u8, ev: *mut rte_event, nb_events: u16, timeout_ticks: u64) -> u16;
	pub fn rust_rte_event_enqueue_burst(dev_id: u8, port_id: u8, ev: *const rte_event, nb_events: u16) -> u16;
	pub fn rust_rte_event_enqueue_forward_burst(dev_id: u8, port_id: u8, ev: *const rte_event, nb_events: u16) -> u16;
	pub fn rust_rte_event_enqueue_new_burst(dev_id: u8, port_id: u8, ev: *const rte_event, nb_events: u16) -> u16;
	pub fn rust_rte_event_ring_count(r: *const rte_event_ring) -> c_uint;
	pub fn rust_rte_event_ring_dequeue_burst(r: *mut rte_event_ring, events: *mut rte_event, n: c_uint, available: *mut u16) -> c_uint;
	pub fn rust_rte_event_ring_enqueue_burst(r: *mut rte_event_ring, events: *const rte_event, n: c_uint, free_space: *mut u16) -> c_uint;
	pub fn rust_rte_event_ring_free_count(r: *const rte_event_ring) -> c_uint;
	pub fn rust_rte_event_ring_get_capacity(r: *const rte_event_ring) -> c_uint;
	pub fn rust_rte_event_ring_get_size(r: *const rte_event_ring) -> c_uint;
	pub fn rust_rte_get_master_lcore() -> c_uint;
	pub fn rust_rte_get_next_lcore(i: c_uint, skip_master: c_int, wrap: c_int) -> c_uint;
	pub fn rust_rte_get_timer_cycles() -> u64;
	pub fn rust_rte_get_timer_hz() -> u64;
	pub fn rust_rte_get_tsc_cycles() -> u64;
	pub fn rust_rte_ipv4_cksum(ipv4_hdr: *const ipv4_hdr) -> u16;
	pub fn rust_rte_ipv4_frag_pkt_is_fragmented(hdr: *const ipv4_hdr) -> c_int;
	pub fn rust_rte_ipv4_phdr_cksum(ipv4_hdr: *const ipv4_hdr, ol_flags: u64) -> u16;
	pub fn rust_rte_ipv4_udptcp_cksum(ipv4_hdr: *const ipv4_hdr, l4_hdr: *const c_void) -> u16;
	pub fn rust_rte_ipv6_frag_get_ipv6_fragment_header(hdr: *mut ipv6_hdr) -> *mut ipv6_extension_fragment;
	pub fn rust_rte_ipv6_phdr_cksum(ipv6_hdr: *const ipv6_hdr, ol_flags: u64) -> u16;
	pub fn rust_rte_ipv6_udptcp_cksum(ipv6_hdr: *const ipv6_hdr, l4_hdr: *const c_void) -> u16;
	pub fn rust_rte_lcore_count() -> c_uint;
	pub fn rust_rte_lcore_id() -> c_uint;
	pub fn rust_rte_lcore_index(lcore_id: c_int) -> c_int;
	pub fn rust_rte_lcore_is_enabled(lcore_id: c_uint) -> c_int;
	pub fn rust_rte_lcore_to_socket_id(lcore_id: c_uint) -> c_uint;
	pub fn rust_rte_lpm_lookup(lpm: *mut rte_lpm, ip: u32, next_hop: *mut u32) -> c_int;
	pub fn rust_rte_lpm_lookup_bulk_func(lpm: *const rte_lpm, ips: *const u32, next_hops: *mut u32, n: c_uint) -> c_int;
	pub fn rust_rte_lpm_lookupx4(lpm: *const rte_lpm, ip: *mut c_longlong, hop: *mut u32, defv: u32);
	pub fn rust_rte_mbuf_data_iova(mb: *const rte_mbuf) -> rte_iova_t;
	pub fn rust_rte_mbuf_data_iova_default(mb: *const rte_mbuf) -> rte_iova_t;
	pub fn rust_rte_mbuf_ext_refcnt_read(shinfo: *const rte_mbuf_ext_shared_info) -> u16;
	pub fn rust_rte_mbuf_ext_refcnt_set(shinfo: *mut rte_mbuf_ext_shared_info, new_value: u16);
	pub fn rust_rte_mbuf_ext_refcnt_update(shinfo: *mut rte_mbuf_ext_shared_info, value: i16) -> u16;
	pub fn rust_rte_mbuf_from_indirect(mi: *mut rte_mbuf) -> *mut rte_mbuf;
	pub fn rust_rte_mbuf_prefetch_part1(m: *mut rte_mbuf);
	pub fn rust_rte_mbuf_prefetch_part2(m: *mut rte_mbuf);
	pub fn rust_rte_mbuf_raw_alloc(mp: *mut rte_mempool) -> *mut rte_mbuf;
	pub fn rust_rte_mbuf_raw_free(m: *mut rte_mbuf);
	pub fn rust_rte_mbuf_refcnt_read(m: *const rte_mbuf) -> u16;
	pub fn rust_rte_mbuf_refcnt_set(m: *mut rte_mbuf, new_value: u16);
	pub fn rust_rte_mbuf_refcnt_update(m: *mut rte_mbuf, value: i16) -> u16;
	pub fn rust_rte_mbuf_to_baddr(md: *mut rte_mbuf) -> *mut c_char;
	pub fn rust_rte_memcpy(dst: *mut c_void, src: *const c_void, n: usize) -> *mut c_void;
	pub fn rust_rte_mempool_cache_flush(cache: *mut rte_mempool_cache, mp: *mut rte_mempool);
	pub fn rust_rte_mempool_default_cache(mp: *mut rte_mempool, lcore_id: c_uint) -> *mut rte_mempool_cache;
	pub fn rust_rte_mempool_empty(mp: *const rte_mempool) -> c_int;
	pub fn rust_rte_mempool_from_obj(obj: *mut c_void) -> *mut rte_mempool;
	pub fn rust_rte_mempool_full(mp: *const rte_mempool) -> c_int;
	pub fn rust_rte_mempool_generic_get(mp: *mut rte_mempool, obj_table: *mut *mut c_void, n: c_uint, cache: *mut rte_mempool_cache) -> c_int;
	pub fn rust_rte_mempool_generic_put(mp: *mut rte_mempool, obj_table: *const *mut c_void, n: c_uint, cache: *mut rte_mempool_cache);
	pub fn rust_rte_mempool_get(mp: *mut rte_mempool, obj_p: *mut *mut c_void) -> c_int;
	pub fn rust_rte_mempool_get_bulk(mp: *mut rte_mempool, obj_table: *mut *mut c_void, n: c_uint) -> c_int;
	pub fn rust_rte_mempool_get_contig_blocks(mp: *mut rte_mempool, first_obj_table: *mut *mut c_void, n: c_uint) -> c_int;
	pub fn rust_rte_mempool_get_ops(ops_index: c_int) -> *mut rte_mempool_ops;
	pub fn rust_rte_mempool_get_priv(mp: *mut rte_mempool) -> *mut c_void;
	pub fn rust_rte_mempool_ops_dequeue_bulk(mp: *mut rte_mempool, obj_table: *mut *mut c_void, n: c_uint) -> c_int;
	pub fn rust_rte_mempool_ops_dequeue_contig_blocks(mp: *mut rte_mempool, first_obj_table: *mut *mut c_void, n: c_uint) -> c_int;
	pub fn rust_rte_mempool_ops_enqueue_bulk(mp: *mut rte_mempool, obj_table: *const *mut c_void, n: c_uint) -> c_int;
	pub fn rust_rte_mempool_put(mp: *mut rte_mempool, obj: *mut c_void);
	pub fn rust_rte_mempool_put_bulk(mp: *mut rte_mempool, obj_table: *const *mut c_void, n: c_uint);
	pub fn rust_rte_mempool_virt2iova(elt: *const c_void) -> rte_iova_t;
	pub fn rust_rte_mov128(dst: *mut u8, src: *const u8);
	pub fn rust_rte_mov16(dst: *mut u8, src: *const u8);
	pub fn rust_rte_mov32(dst: *mut u8, src: *const u8);
	pub fn rust_rte_mov64(dst: *mut u8, src: *const u8);
	pub fn rust_rte_net_intel_cksum_flags_prepare(m: *mut rte_mbuf, ol_flags: u64) -> c_int;
	pub fn rust_rte_net_intel_cksum_prepare(m: *mut rte_mbuf) -> c_int;
	pub fn rust_rte_ns_to_timespec(nsec: u64) -> timespec;
	pub fn rust_rte_pktmbuf_adj(m: *mut rte_mbuf, len: u16) -> *mut c_char;
	pub fn rust_rte_pktmbuf_alloc(mp: *mut rte_mempool) -> *mut rte_mbuf;
	pub fn rust_rte_pktmbuf_alloc_bulk(pool: *mut rte_mempool, mbufs: *mut *mut rte_mbuf, count: c_uint) -> c_int;
	pub fn rust_rte_pktmbuf_append(m: *mut rte_mbuf, len: u16) -> *mut c_char;
	pub fn rust_rte_pktmbuf_attach(mi: *mut rte_mbuf, m: *mut rte_mbuf);
	pub fn rust_rte_pktmbuf_attach_extbuf(m: *mut rte_mbuf, buf_addr: *mut c_void, buf_iova: rte_iova_t, buf_len: u16, shinfo: *mut rte_mbuf_ext_shared_info);
	pub fn rust_rte_pktmbuf_chain(head: *mut rte_mbuf, tail: *mut rte_mbuf) -> c_int;
	pub fn rust_rte_pktmbuf_clone(md: *mut rte_mbuf, mp: *mut rte_mempool) -> *mut rte_mbuf;
	pub fn rust_rte_pktmbuf_data_room_size(mp: *mut rte_mempool) -> u16;
	pub fn rust_rte_pktmbuf_detach(m: *mut rte_mbuf);
	pub fn rust_rte_pktmbuf_ext_shinfo_init_helper(buf_addr: *mut c_void, buf_len: *mut u16, free_cb: rte_mbuf_extbuf_free_callback_t, fcb_opaque: *mut c_void) -> *mut rte_mbuf_ext_shared_info;
	pub fn rust_rte_pktmbuf_free(m: *mut rte_mbuf);
	pub fn rust_rte_pktmbuf_free_seg(m: *mut rte_mbuf);
	pub fn rust_rte_pktmbuf_headroom(m: *const rte_mbuf) -> u16;
	pub fn rust_rte_pktmbuf_is_contiguous(m: *const rte_mbuf) -> c_int;
	pub fn rust_rte_pktmbuf_lastseg(m: *mut rte_mbuf) -> *mut rte_mbuf;
	pub fn rust_rte_pktmbuf_linearize(mbuf: *mut rte_mbuf) -> c_int;
	pub fn rust_rte_pktmbuf_mtod(m: *mut rte_mbuf) -> *mut c_void;
	pub fn rust_rte_pktmbuf_mtod_offset(m: *mut rte_mbuf, o: u16) -> *mut c_void;
	pub fn rust_rte_pktmbuf_prefree_seg(m: *mut rte_mbuf) -> *mut rte_mbuf;
	pub fn rust_rte_pktmbuf_prepend(m: *mut rte_mbuf, len: u16) -> *mut c_char;
	pub fn rust_rte_pktmbuf_priv_size(mp: *mut rte_mempool) -> u16;
	pub fn rust_rte_pktmbuf_read(m: *const rte_mbuf, off: u32, len: u32, buf: *mut c_void) -> *const c_void;
	pub fn rust_rte_pktmbuf_refcnt_update(m: *mut rte_mbuf, v: i16);
	pub fn rust_rte_pktmbuf_reset(m: *mut rte_mbuf);
	pub fn rust_rte_pktmbuf_reset_headroom(m: *mut rte_mbuf);
	pub fn rust_rte_pktmbuf_tailroom(m: *const rte_mbuf) -> u16;
	pub fn rust_rte_pktmbuf_trim(m: *mut rte_mbuf, len: u16) -> c_int;
	pub fn rust_rte_pktmbuf_write(m: *const rte_mbuf, off: u32, len: u32, buf: *const c_void) -> c_int;
	pub fn rust_rte_raw_cksum(buf: *const c_void, len: usize) -> u16;
	pub fn rust_rte_raw_cksum_mbuf(m: *const rte_mbuf, off: u32, len: u32, cksum: *mut u16) -> c_int;
	pub fn rust_rte_rdtsc() -> u64;
	pub fn rust_rte_rdtsc_precise() -> u64;
	pub fn rust_rte_reset_errno();
	pub fn rust_rte_ring_count(r: *const rte_ring) -> c_uint;
	pub fn rust_rte_ring_dequeue(r: *mut rte_ring, obj_p: *mut *mut c_void) -> c_int;
	pub fn rust_rte_ring_dequeue_bulk(r: *mut rte_ring, obj_table: *mut *mut c_void, n: c_uint, available: *mut c_uint) -> c_uint;
	pub fn rust_rte_ring_dequeue_burst(r: *mut rte_ring, obj_table: *mut *mut c_void, n: c_uint, available: *mut c_uint) -> c_uint;
	pub fn rust_rte_ring_empty(r: *const rte_ring) -> c_int;
	pub fn rust_rte_ring_enqueue(r: *mut rte_ring, obj: *mut c_void) -> c_int;
	pub fn rust_rte_ring_enqueue_bulk(r: *mut rte_ring, obj_table: *const *mut c_void, n: c_uint, free_space: *mut c_uint) -> c_uint;
	pub fn rust_rte_ring_enqueue_burst(r: *mut rte_ring, obj_table: *const *mut c_void, n: c_uint, free_space: *mut c_uint) -> c_uint;
	pub fn rust_rte_ring_free_count(r: *const rte_ring) -> c_uint;
	pub fn rust_rte_ring_full(r: *const rte_ring) -> c_int;
	pub fn rust_rte_ring_get_capacity(r: *const rte_ring) -> c_uint;
	pub fn rust_rte_ring_get_size(r: *const rte_ring) -> c_uint;
	pub fn rust_rte_ring_mc_dequeue(r: *mut rte_ring, obj_p: *mut *mut c_void) -> c_int;
	pub fn rust_rte_ring_mc_dequeue_bulk(r: *mut rte_ring, obj_table: *mut *mut c_void, n: c_uint, available: *mut c_uint) -> c_uint;
	pub fn rust_rte_ring_mc_dequeue_burst(r: *mut rte_ring, obj_table: *mut *mut c_void, n: c_uint, available: *mut c_uint) -> c_uint;
	pub fn rust_rte_ring_mp_enqueue(r: *mut rte_ring, obj: *mut c_void) -> c_int;
	pub fn rust_rte_ring_mp_enqueue_bulk(r: *mut rte_ring, obj_table: *const *mut c_void, n: c_uint, free_space: *mut c_uint) -> c_uint;
	pub fn rust_rte_ring_mp_enqueue_burst(r: *mut rte_ring, obj_table: *const *mut c_void, n: c_uint, free_space: *mut c_uint) -> c_uint;
	pub fn rust_rte_ring_sc_dequeue(r: *mut rte_ring, obj_p: *mut *mut c_void) -> c_int;
	pub fn rust_rte_ring_sc_dequeue_bulk(r: *mut rte_ring, obj_table: *mut *mut c_void, n: c_uint, available: *mut c_uint) -> c_uint;
	pub fn rust_rte_ring_sc_dequeue_burst(r: *mut rte_ring, obj_table: *mut *mut c_void, n: c_uint, available: *mut c_uint) -> c_uint;
	pub fn rust_rte_ring_sp_enqueue(r: *mut rte_ring, obj: *mut c_void) -> c_int;
	pub fn rust_rte_ring_sp_enqueue_bulk(r: *mut rte_ring, obj_table: *const *mut c_void, n: c_uint, free_space: *mut c_uint) -> c_uint;
	pub fn rust_rte_ring_sp_enqueue_burst(r: *mut rte_ring, obj_table: *const *mut c_void, n: c_uint, free_space: *mut c_uint) -> c_uint;
	pub fn rust_rte_smp_mb();
	pub fn rust_rte_timespec_to_ns(ts: *const timespec) -> u64;
	pub fn rust_rte_validate_tx_offload(m: *const rte_mbuf) -> c_int;
	pub fn rust_rte_vdev_device_args(dev: *const rte_vdev_device) -> *const c_char;
	pub fn rust_rte_vdev_device_name(dev: *const rte_vdev_device) -> *const c_char;
	pub fn rust_rte_vhost_va_from_guest_pa(mem: *mut rte_vhost_memory, gpa: u64, len: *mut u64) -> u64;
	pub fn rust_rte_vlan_insert(m: *mut *mut rte_mbuf) -> c_int;
	pub fn rust_rte_vlan_strip(m: *mut rte_mbuf) -> c_int;
}
