// This file is part of dpdk. It is subject to the license terms in the COPYRIGHT file found in the top-level directory of this distribution and at https://raw.githubusercontent.com/lemonrock/dpdk/master/COPYRIGHT. No part of dpdk, including this file, may be copied, modified, propagated, or distributed except according to the terms contained in the COPYRIGHT file.
// Copyright © 2016 The developers of dpdk. See the COPYRIGHT file in the top-level directory of this distribution and at https://raw.githubusercontent.com/lemonrock/dpdk/master/COPYRIGHT.


#[repr(u32)]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum rte_cpu_flag_t
{
	RTE_CPUFLAG_SSE3 = 0,
	RTE_CPUFLAG_PCLMULQDQ = 1,
	RTE_CPUFLAG_DTES64 = 2,
	RTE_CPUFLAG_MONITOR = 3,
	RTE_CPUFLAG_DS_CPL = 4,
	RTE_CPUFLAG_VMX = 5,
	RTE_CPUFLAG_SMX = 6,
	RTE_CPUFLAG_EIST = 7,
	RTE_CPUFLAG_TM2 = 8,
	RTE_CPUFLAG_SSSE3 = 9,
	RTE_CPUFLAG_CNXT_ID = 10,
	RTE_CPUFLAG_FMA = 11,
	RTE_CPUFLAG_CMPXCHG16B = 12,
	RTE_CPUFLAG_XTPR = 13,
	RTE_CPUFLAG_PDCM = 14,
	RTE_CPUFLAG_PCID = 15,
	RTE_CPUFLAG_DCA = 16,
	RTE_CPUFLAG_SSE4_1 = 17,
	RTE_CPUFLAG_SSE4_2 = 18,
	RTE_CPUFLAG_X2APIC = 19,
	RTE_CPUFLAG_MOVBE = 20,
	RTE_CPUFLAG_POPCNT = 21,
	RTE_CPUFLAG_TSC_DEADLINE = 22,
	RTE_CPUFLAG_AES = 23,
	RTE_CPUFLAG_XSAVE = 24,
	RTE_CPUFLAG_OSXSAVE = 25,
	RTE_CPUFLAG_AVX = 26,
	RTE_CPUFLAG_F16C = 27,
	RTE_CPUFLAG_RDRAND = 28,
	RTE_CPUFLAG_HYPERVISOR = 29,
	RTE_CPUFLAG_FPU = 30,
	RTE_CPUFLAG_VME = 31,
	RTE_CPUFLAG_DE = 32,
	RTE_CPUFLAG_PSE = 33,
	RTE_CPUFLAG_TSC = 34,
	RTE_CPUFLAG_MSR = 35,
	RTE_CPUFLAG_PAE = 36,
	RTE_CPUFLAG_MCE = 37,
	RTE_CPUFLAG_CX8 = 38,
	RTE_CPUFLAG_APIC = 39,
	RTE_CPUFLAG_SEP = 40,
	RTE_CPUFLAG_MTRR = 41,
	RTE_CPUFLAG_PGE = 42,
	RTE_CPUFLAG_MCA = 43,
	RTE_CPUFLAG_CMOV = 44,
	RTE_CPUFLAG_PAT = 45,
	RTE_CPUFLAG_PSE36 = 46,
	RTE_CPUFLAG_PSN = 47,
	RTE_CPUFLAG_CLFSH = 48,
	RTE_CPUFLAG_DS = 49,
	RTE_CPUFLAG_ACPI = 50,
	RTE_CPUFLAG_MMX = 51,
	RTE_CPUFLAG_FXSR = 52,
	RTE_CPUFLAG_SSE = 53,
	RTE_CPUFLAG_SSE2 = 54,
	RTE_CPUFLAG_SS = 55,
	RTE_CPUFLAG_HTT = 56,
	RTE_CPUFLAG_TM = 57,
	RTE_CPUFLAG_PBE = 58,
	RTE_CPUFLAG_DIGTEMP = 59,
	RTE_CPUFLAG_TRBOBST = 60,
	RTE_CPUFLAG_ARAT = 61,
	RTE_CPUFLAG_PLN = 62,
	RTE_CPUFLAG_ECMD = 63,
	RTE_CPUFLAG_PTM = 64,
	RTE_CPUFLAG_MPERF_APERF_MSR = 65,
	RTE_CPUFLAG_ACNT2 = 66,
	RTE_CPUFLAG_ENERGY_EFF = 67,
	RTE_CPUFLAG_FSGSBASE = 68,
	RTE_CPUFLAG_BMI1 = 69,
	RTE_CPUFLAG_HLE = 70,
	RTE_CPUFLAG_AVX2 = 71,
	RTE_CPUFLAG_SMEP = 72,
	RTE_CPUFLAG_BMI2 = 73,
	RTE_CPUFLAG_ERMS = 74,
	RTE_CPUFLAG_INVPCID = 75,
	RTE_CPUFLAG_RTM = 76,
	RTE_CPUFLAG_AVX512F = 77,
	RTE_CPUFLAG_LAHF_SAHF = 78,
	RTE_CPUFLAG_LZCNT = 79,
	RTE_CPUFLAG_SYSCALL = 80,
	RTE_CPUFLAG_XD = 81,
	RTE_CPUFLAG_1GB_PG = 82,
	RTE_CPUFLAG_RDTSCP = 83,
	RTE_CPUFLAG_EM64T = 84,
	RTE_CPUFLAG_INVTSC = 85,
	RTE_CPUFLAG_NUMFLAGS = 86,
}
