// This file is part of dpdk. It is subject to the license terms in the COPYRIGHT file found in the top-level directory of this distribution and at https://raw.githubusercontent.com/lemonrock/dpdk/master/COPYRIGHT. No part of dpdk, including this file, may be copied, modified, propagated, or distributed except according to the terms contained in the COPYRIGHT file.
// Copyright © 2016 The developers of dpdk. See the COPYRIGHT file in the top-level directory of this distribution and at https://raw.githubusercontent.com/lemonrock/dpdk/master/COPYRIGHT.


pub const VFIO_API_VERSION: u32 = 0;
pub const VFIO_BASE: u32 = 100;
pub const VFIO_CONTAINER_PATH: &'static [u8; 15usize] = b"/dev/vfio/vfio\0";
pub const VFIO_DEVICE_FLAGS_AMBA: u32 = 8;
pub const VFIO_DEVICE_FLAGS_PCI: u32 = 2;
pub const VFIO_DEVICE_FLAGS_PLATFORM: u32 = 4;
pub const VFIO_DEVICE_FLAGS_RESET: u32 = 1;
pub const VFIO_DIR: &'static [u8; 10usize] = b"/dev/vfio\0";
pub const VFIO_DMA_CC_IOMMU: u32 = 4;
pub const VFIO_DMA_MAP_FLAG_READ: u32 = 1;
pub const VFIO_DMA_MAP_FLAG_WRITE: u32 = 2;
pub const VFIO_EEH: u32 = 5;
pub const VFIO_EEH_PE_CONFIGURE: u32 = 8;
pub const VFIO_EEH_PE_DISABLE: u32 = 0;
pub const VFIO_EEH_PE_ENABLE: u32 = 1;
pub const VFIO_EEH_PE_GET_STATE: u32 = 4;
pub const VFIO_EEH_PE_INJECT_ERR: u32 = 9;
pub const VFIO_EEH_PE_RESET_DEACTIVATE: u32 = 5;
pub const VFIO_EEH_PE_RESET_FUNDAMENTAL: u32 = 7;
pub const VFIO_EEH_PE_RESET_HOT: u32 = 6;
pub const VFIO_EEH_PE_STATE_NORMAL: u32 = 0;
pub const VFIO_EEH_PE_STATE_RESET: u32 = 1;
pub const VFIO_EEH_PE_STATE_STOPPED: u32 = 2;
pub const VFIO_EEH_PE_STATE_STOPPED_DMA: u32 = 4;
pub const VFIO_EEH_PE_STATE_UNAVAIL: u32 = 5;
pub const VFIO_EEH_PE_UNFREEZE_DMA: u32 = 3;
pub const VFIO_EEH_PE_UNFREEZE_IO: u32 = 2;
pub const VFIO_GROUP_FLAGS_CONTAINER_SET: u32 = 2;
pub const VFIO_GROUP_FLAGS_VIABLE: u32 = 1;
pub const VFIO_GROUP_FMT: &'static [u8; 13usize] = b"/dev/vfio/%u\0";
pub const VFIO_IOMMU_INFO_PGSIZES: u32 = 1;
pub const VFIO_IOMMU_SPAPR_INFO_DDW: u32 = 1;
pub const VFIO_IRQ_INFO_AUTOMASKED: u32 = 4;
pub const VFIO_IRQ_INFO_EVENTFD: u32 = 1;
pub const VFIO_IRQ_INFO_MASKABLE: u32 = 2;
pub const VFIO_IRQ_INFO_NORESIZE: u32 = 8;
pub const VFIO_IRQ_SET_ACTION_MASK: u32 = 8;
pub const VFIO_IRQ_SET_ACTION_TRIGGER: u32 = 32;
pub const VFIO_IRQ_SET_ACTION_TYPE_MASK: u32 = 56;
pub const VFIO_IRQ_SET_ACTION_UNMASK: u32 = 16;
pub const VFIO_IRQ_SET_DATA_BOOL: u32 = 2;
pub const VFIO_IRQ_SET_DATA_EVENTFD: u32 = 4;
pub const VFIO_IRQ_SET_DATA_NONE: u32 = 1;
pub const VFIO_IRQ_SET_DATA_TYPE_MASK: u32 = 7;
pub const VFIO_NOIOMMU_GROUP_FMT: &'static [u8; 21usize] = b"/dev/vfio/noiommu-%u\0";
pub const VFIO_NOIOMMU_MODE: &'static [u8; 55usize] = b"/sys/module/vfio/parameters/enable_unsafe_noiommu_mode\0";
pub const VFIO_PCI_BAR0_REGION_INDEX: _bindgen_ty_12 = 0;
pub const VFIO_PCI_BAR1_REGION_INDEX: _bindgen_ty_12 = 1;
pub const VFIO_PCI_BAR2_REGION_INDEX: _bindgen_ty_12 = 2;
pub const VFIO_PCI_BAR3_REGION_INDEX: _bindgen_ty_12 = 3;
pub const VFIO_PCI_BAR4_REGION_INDEX: _bindgen_ty_12 = 4;
pub const VFIO_PCI_BAR5_REGION_INDEX: _bindgen_ty_12 = 5;
pub const VFIO_PCI_CONFIG_REGION_INDEX: _bindgen_ty_12 = 7;
pub const VFIO_PCI_ERR_IRQ_INDEX: _bindgen_ty_13 = 3;
pub const VFIO_PCI_INTX_IRQ_INDEX: _bindgen_ty_13 = 0;
pub const VFIO_PCI_MSIX_IRQ_INDEX: _bindgen_ty_13 = 2;
pub const VFIO_PCI_MSI_IRQ_INDEX: _bindgen_ty_13 = 1;
pub const VFIO_PCI_NUM_IRQS: _bindgen_ty_13 = 5;
pub const VFIO_PCI_NUM_REGIONS: _bindgen_ty_12 = 9;
pub const VFIO_PCI_REQ_IRQ_INDEX: _bindgen_ty_13 = 4;
pub const VFIO_PCI_ROM_REGION_INDEX: _bindgen_ty_12 = 6;
pub const VFIO_PCI_VGA_REGION_INDEX: _bindgen_ty_12 = 8;
pub const VFIO_REGION_INFO_FLAG_MMAP: u32 = 4;
pub const VFIO_REGION_INFO_FLAG_READ: u32 = 1;
pub const VFIO_REGION_INFO_FLAG_WRITE: u32 = 2;
pub const VFIO_SPAPR_TCE_IOMMU: u32 = 2;
pub const VFIO_SPAPR_TCE_v2_IOMMU: u32 = 7;
pub const VFIO_TYPE1_IOMMU: u32 = 1;
pub const VFIO_TYPE1_NESTING_IOMMU: u32 = 6;
pub const VFIO_TYPE1v2_IOMMU: u32 = 3;
pub const VFIO_TYPE: u8 = 59u8;
