// This file is part of dpdk. It is subject to the license terms in the COPYRIGHT file found in the top-level directory of this distribution and at https://raw.githubusercontent.com/lemonrock/dpdk/master/COPYRIGHT. No part of predicator, including this file, may be copied, modified, propagated, or distributed except according to the terms contained in the COPYRIGHT file.
// Copyright © 2017 The developers of dpdk. See the COPYRIGHT file in the top-level directory of this distribution and at https://raw.githubusercontent.com/lemonrock/dpdk/master/COPYRIGHT.


/// Represents a number of queues for a particular ethernet device.
pub trait NumberOfQueues: Default + Debug + Copy + Clone + PartialEq + Eq + PartialOrd + Ord + Hash + Display + Into<u16> + Into<u32> + Into<usize>
{
	/// Zero.
	const Zero: Self;
	
	/// One.
	const One: Self;
	
	/// Two.
	const Two: Self;
	
	/// Is zero?
	#[inline(always)]
	fn is_zero(self) -> bool
	{
		&self == &Self::Zero
	}
}
