% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pow_sim.r
\name{compute_statistics}
\alias{compute_statistics}
\title{Compute Power, Type I Error, or Precision Statistics}
\usage{
compute_statistics(
  data,
  sim_args,
  power = TRUE,
  type_1_error = TRUE,
  precision = TRUE,
  alternative_power = FALSE,
  type_s_error = FALSE,
  type_m_error = FALSE
)
}
\arguments{
\item{data}{A list of model results generated by \code{\link{replicate_simulation}}
function.}

\item{sim_args}{A named list with special model formula syntax. See details and examples
for more information. The named list may contain the following:
\itemize{
  \item fixed: This is the fixed portion of the model (i.e. covariates)
  \item random: This is the random portion of the model (i.e. random effects)
  \item error: This is the error (i.e. residual term).
}}

\item{power}{TRUE/FALSE flag indicating whether power should be computed. 
Defaults to TRUE.}

\item{type_1_error}{TRUE/FALSE flag indicating whether type I error rate
should be computed. Defaults to TRUE.}

\item{precision}{TRUE/FALSE flag indicating whether precision should be 
computed. Defaults to TRUE.}

\item{alternative_power}{TRUE/FALSE flag indicating whether alternative 
power estimates should be computed. If TRUE, this must be accompanied by 
thresholds specified within the power simulation arguments. Defaults to FALSE.}

\item{type_s_error}{TRUE/FALSE flag indicating whether Type S error should
be computed. Defaults to FALSE.}

\item{type_m_error}{TRUE/FALSE flag indicating whether Type M error should
be computed. Defaults to FALSE.}
}
\description{
Compute Power, Type I Error, or Precision Statistics
}
