$ = window.$

import {is_mobile, template_settings} from "main/util"
import {_} from "main/global_libs"

export default $.fn.has_tooltips = ->
  return if is_mobile()

  tooltip_drop = ->
    drop = $(document.body).find ".tooltip_drop"
    unless drop.length
      drop = $ '<div class="tooltip_drop"></div>'
      $(document.body).append drop

    tooltip_drop = -> drop
    drop

  tooltip_template = _.template """
  <div class="tooltip">{{ label }}</div>
  """, template_settings

  show_tooltip = (tooltip_target, instant=false) ->
    el = tooltip_target.data "tooltip_el"
    unless el
      el = $ tooltip_template label: tooltip_target.attr "data-tooltip"
      tooltip_target.data "tooltip_el", el

    el.removeClass "visible"
    tooltip_drop().empty().append el
    offset = tooltip_target.offset()

    height = el.outerHeight()
    width = el.outerWidth()

    el.css {
      position: "absolute"
      top: offset.top - height - 10
      left: Math.floor offset.left + (tooltip_target.outerWidth() - width) / 2
    }

    if instant
      el.addClass "visible"
    else
      setTimeout (=> el.addClass "visible"), 10

  @on "i:refresh_tooltip", "[data-tooltip]", (e) =>
    if e.originalEvent
      return if e.originalEvent.tooltip_handled
      e.originalEvent.tooltip_handled = true

    tooltip_target = $(e.currentTarget)
    el = tooltip_target.data "tooltip_el"
    tooltip_target.removeData "tooltip_el"

    if el?.is ":visible"
      show_tooltip tooltip_target, true

  @on "mouseenter", "[data-tooltip]", (e) =>
    return if e.originalEvent.tooltip_handled
    e.originalEvent.tooltip_handled = true

    tooltip_target = $(e.currentTarget)
    show_tooltip tooltip_target

  @on "mouseleave i:hide_tooltip", "[data-tooltip]", (e) =>
    return if e.originalEvent.tooltip_handled
    e.originalEvent.tooltip_handled = true

    tooltip_target = $(e.currentTarget)
    if el = tooltip_target.data "tooltip_el"
      el.remove()

  @

