# 问题解决记录

## libui、libplatform、libapp 互相依赖，如何解耦？

解决方案：

- libui:
  - 提供一个函数用于被动处理事件，不再主动调用 libapp 的事件绑定方法。
  - 将 textview、button、anchor、scrollbar 等基础组件拆分为独立库。
- libplatform:
- libapp:

## 全局 settings 数据如何解耦？

## 图片加载器与组件如何解耦？

现存问题：

- 图片加载器与组件存在耦合：图片缓存采用组件作为索引，图片加载函数依赖组件的样式表
- 图片加载任务依赖主循环提供的函数实现异步加载

解决方案：

- 图片加载器与组件之间采用事件进行通信，组件主动监听事件，图片加载器在图片加载完时触发事件
- 分配一个工作线程负责图片加载任务，任务完成后追加到图片加载器的事件队列中
- 图片加载器提供事件处理函数

## libui 是否需要在内部维护一个事件队列？

需要。由于线程安全问题，其它线程不能直接操作组件数据，所以需要一个事件队列来记录对组件的操作方法，交给 UI 线程统一执行。

## textview 如何在 css 解析器加载完字体时刷新？

旧代码是直接在 css 解析器代码里调用 textview 的函数，现在改用事件的方式。在加载字体后调用 `ui_events.c` 的 `ui_post_event()` 触发 `font_face_load` 事件，textview 只需在初始化时提那就 `font_face_load` 事件处理器即可。

## 如何设计 widget 与 window 的同步功能模块？

候选名称有：

- `ui-mapper`：widget 与 window 之间是映射关系，那么管理这些映射关系的功能模块就是 mapper，但该名称不足以联想到它的作用，容易被理解为其它功能模块。
- `ui-player`：如果将“widget 内容同步至 window 内”这一过程称为“播放”的话，那么可以将该功能模块命名为 player，但这名字更容易让其他人理解为媒体播放器组件。
- `ui-display`：原模块的名称就是 display，既是动词也是名词，在新的命名风格中可能会产生歧义，例如：`ui_display_map`，该理解为“将 map 显示出来”，还是“调用显示模块的 map 方法”？
- `ui-screen`：
- `ui-server`：

## widget 与 window 之间的绑定操作和实例该如何命名？

connection

## ui-server 是否需要负责窗口创建销毁？

有两种方案：

1. 不负责：由上层代码创建窗口和 widget，然后传给 ui-server 进行绑定。
    - 好处：上层代码可以更灵活的控制窗口，widget 创建多个窗口映射。
    - 坏处：需要多编写一些代码用于管理 window。
2. 负责：
    - 好处：
    - 坏处：不适合需要单独创建窗口然后在该窗口内渲染 widget 的场景。

可以看出，这是模块的拆分粒度问题：是沿用原 display 模块的设计，还是拆分成两个模块分别负责映射和管理？

## 如何处理 cursor 的重绘？

cursor 模块除了提供鼠标光标相关设置外，还提供鼠标光标的绘制功能，适用于无 UI 系统的环境，但如果在有 UI 系统的环境下也需要使用自绘的鼠标光标的话，该如何处理绘制问题？

考虑的问题：

- 光标区域刚好与多个窗口的区域重叠，如何让这些窗口都重绘光标？

候选方案：

- 记录所有窗口，在光标位置更新时向光标底下的窗口发送 `APP_EVENT_PAINT` 事件。
- 记录当前活动窗口，仅让该窗口绘制光标。该方案实现起来较为简单，只需要响应 `APP_EVENT_MOUSEMOVE` 事件然后给对应的窗口发送 `APP_EVENT_PAINT` 事件。

## cursor 应该由哪个库实现？

- app: cursor 依赖事件循环和窗口绘制接口，直接放 app 库里会增加耦合度。
- ui-server: 虽然 ui-server 负责窗口管理和绘制，正好方便绘制 cursor，但违背了单一职责原则，一般人都想不到 ui-server 会提供 cursor 的操作接口。
- ui-cursor：新搞个独立库，依赖 app 库，提供给 ui-server 调用。

## 主循环相关函数该如何设计？

在新的主循环设计方案中，帧率控制功能已经被改为仅针对 UI 渲染，不再影响整个主循环，这意味着主循环在没有休眠时间后循环次数会变多，CPU 占用率也会随之增加，那么如何解决这个问题？

可以用 `app_wait_event()` 解决这问题，让主循环在新事件到来之前一直处于阻塞状态，期间不占用 CPU 资源。但这引申出了几个问题：

- 如何让定时器尽量准时触发？
- 如何让 UI 动画流畅播放？

这几个问题有两种解决方法：

- 定时发送自定义事件以让 `app_wait_event()` 退出阻塞状态。复杂度较高，因为要建个线程，或利用系统自带的定时器功能实现。
- 添加 `app_wait_event_timeout()` 函数来实现有限时间的等待，根据定时器的时间精度和渲染帧数限制，等待一小段时间。这个方法复杂度较低，但为了减少时间浪费以将时间留给 UI 渲染，则需要将等待时间设置得非常小，例如：1 毫秒。

## yutil 的头文件依赖问题如何解决？

主要原因在于头文件路径，LCUI 的子库头文件都在 include/LCUI 目录内，包含时都是显式带上 `LCUI/` 路径，而 yutil 的头文件在 include 目录内，这导致用户在安装 LCUI 库后头文件目录内会增加两个库的头文件，用户还得花时间搞清楚 yutil 是什么、在时候装上的，增加了思想负担。

解决方法：在 xmake.lua 中添加脚本将 yutil 目录内的头文件复制到 include/LCUI/util/ 目录内，然后在 include/LCUI/util.h 中添加 yutil 依赖的一些宏定义。

## 鼠标拖动调整窗口尺寸时 GetMessage() 不会退出

`DefWindowProc()` 内部执行了消息循环，导致 GetMessage() 之后的 LCUI 相关的事件处理无法进行。

解决方法：`app_get_event()` 和 `app_process_event()` 合并为 `app_process_events()`，添加 `app_set_event_handler()` 用于设置事件处理函数，在每次处理系统窗口事件时调用它。

## 组件创建后尺寸被重置为 (0,0)

这问题的原因是组件创建完后使用它的初始尺寸 (0,0) 创建窗口，(0,0) 尺寸和 `WM_SIZE` 消息被添加到消息队列，当处理消息队列的时候，这之前设置的组件尺寸都会被重置为 (0,0)。

解决方法是：在组件完成更新前不同步窗口的尺寸。

## 如何解决窗口和组件之间的数据同步冲突？

系统窗口事件和 LCUI 的事件都是先于 UI 事件处理。

初始创建的窗口会发送 `WM_SIZE` 事件，该事件携带的尺寸是错误的，在主循环中处理该事件时应该忽略该事件，避免组件尺寸被重置。

解决方法：

- 加个 ready 标识，仅在第一次响应组件变化后才开始同步窗口尺寸。
- 保证窗口在更新位置和尺寸后计算出来的组件位置和尺寸不会变化，不会出现循环触发窗口和组件尺寸变化的问题。
- 直接处理系统窗口事件，不再转发到事件队列里等处理，以解决窗口和组件的数据同步顺序问题。

## 什么时候处理事件队列？

当 `app_process_native_events()` 的事件处理方式是 `APP_PROCESS_EVENTS_UNTIL_QUIT` 时，主循环在收到 `WM_QUIT` 前都不会退出，而事件队列是在 `app_process_native_events()` 调用完后处理的，这导致应用程序无法靠发送 `APP_EVENT_QUIT` 事件退出主循环。

解决方法是在每次处理系统事件时处理事件队列，不再分别控制系统事件循环和 app 事件队列。

## 如何退出主循环？

主循环是由系统抽象层负责的，只在收到系统特定事件（如 WM_QUIT）才会退出，所以靠发送 `APP_EVENT_QUIT` 是无法实现让主循环退出的，那么解决方法就是让平台抽象层应该提供 `app_exit()` 方法来退出主循环。

## 如何在有自定义事件时退出系统事件的等待？

有三种解决方法：

- 开个线程定时调用系统 API 发送自定义事件。这种有线程安全问题，X11 客户端库会报错：

    ```
    [xcb] Unknown sequence number while processing queue
    [xcb] Most likely this is a multi-threaded client and XInitThreads has not been called
    [xcb] Aborting, sorry about that.
    run-tests: ../../src/xcb_io.c:259: poll_for_event: Assertion `!xcb_xlib_threads_sequence_lost' failed.
    ```

- 封装系统自定义事件发送 API，每当添加新自定义事件时调用它。这方法需要研究各个系统的事件 API，比较费时间。
- 参考 SDL，不使用系统事件 API 等待事件，每次事件循环间隔 1 毫秒。这方法比较简单，不用折腾系统事件 API。

综上所述，第三种方法是最合适的。

## 自定义事件发到哪个事件队列？

有两个选择：

- 发到系统事件队列，将 App 自定义事件转换成系统自定义事件。
- 发到 App 事件队列，再发一个简单的 tick 事件用于退出系统事件等待。

第一个的事件数据转换有点复杂，所以选择第二个。

## 将 root 组件尺寸从 auto 改成固定值时不会触发子组件重新布局

## 关掉窗口后是否需要退出？

主窗口关闭后退出事件循环。

## window 和 widget 的位置同步功能怎么做？

**需求：**

- 窗口的初始位置居中
- 在执行主循环前，如果有设置组件的位置，则将它同步到对应的窗口

**问题：**

同步位置时，如何判断是使用初始位置还是自定义位置？

**解决方案：**

判断 left 和 top 属性值是否为 auto 或 none，是则居中。
