## Mock.valid

* Mock.valid( template, data )

校验真实数据 `data` 是否与数据模板 `template` 匹配。

### template `必选`

表示数据模板，可以是对象或字符串。例如 `{ 'list|1-10':[{}] }`、`'@EMAIL'`。

### data `必选`

表示真实数据。

```js
const template = {
  name: 'value1'
}
const data = {
  name: 'value2'
}
Mock.valid(template, data)
// =>
[
  {
    "path": [
      "data",
      "name"
    ],
    "type": "value",
    "actual": "value2",
    "expected": "value1",
    "action": "equal to",
    "message": "[VALUE] Expect ROOT.name'value is equal to value1, but is value2"
  }
]
```
