﻿using System;
using System.IO;
using System.IO.Ports;
using System.Linq;
using System.Threading;

namespace SpiEepromCon
{
    class Program
    {
        static SerialPort _s;
        static readonly object PortLock = new object();

        static void Main(string[] args)
        {
            _s = new SerialPort(args[0], 115200) { DtrEnable = true, NewLine = "\n" };
            _s.Open();
            Thread.Sleep(2000);
            _s.ReadExisting();

            var ofn = args[2];
            const int startOffset = 0;

            if (args[1] == "w")
            {
                var b_w = File.ReadAllBytes(ofn);
                var sz = b_w.Length;
                var need_to_add = 4096 - b_w.Length % 4096;
                b_w = b_w.Concat(Enumerable.Repeat((byte)0xff, need_to_add).ToArray()).ToArray();
                for (int i = 0; i < sz; )
                {
                    string ret;
                    lock (PortLock)
                    {
                        if (i % 4096 == 0)
                        {
                            _s.Write(string.Format("e{0}|", i + startOffset));
                            Console.Write("\rErase {0}", i);
                            if (!_s.ReadLine().StartsWith("OK"))
                            {
                                Console.WriteLine("Sect erase {0} error", i);
                                return;
                            }
                        }
                        _s.Write(string.Format("w{0}|", i + startOffset));
                        _s.Write(b_w, i, 128);
                        ret = _s.ReadLine();
                    }
                    if (!ret.StartsWith("OK"))
                    {
                        Console.WriteLine(ret);
                        Console.WriteLine("Write {0} error", i);
                        return;
                    }
                    Console.Write("\rWrite sector {2}, sz={0}, {1}: {3}", 128, (i * 1.0 / sz).ToString("p"),
                        (i + startOffset) / 128, ret);

                    i += 128;
                }

                Console.WriteLine("Готово!");
            }
            else if (args[1] == "r")
            {
                int length = int.Parse(args[3]);
                var f = File.Create(ofn);
                for (long i = 0; i < length; i += 4096)
                {
                    var buf = new byte[4096];
                    int readed;
                    lock (PortLock)
                    {
                        _s.Write(string.Format("r{0}|", i));
                        while (_s.BytesToRead != 4096) Thread.Sleep(10);
                        readed = _s.Read(buf, 0, 4096);
                    }

                    Console.Write("\rSector {2}, sz={0}, {1}", readed, (i*1.0/length).ToString("p"), i/4096);
                    f.Write(buf, 0, readed);
                }
                f.Close();
                Console.WriteLine("Готово!");
            }
            else
            {
                Console.WriteLine(@"
Записать на флешку SpiEepromCom.exe COM12 w file.bin
Прочитать с флешки SpiEepromCom.exe COM12 r fullflash.bin 4096
");
            }
            _s.Close();
        }
    }
}
